/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FileHistory;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyBindingsDialog;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.SearchManager2;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.export.ExpandEndnoteFilters;
import net.sf.jabref.export.ExportCustomizationDialog;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.external.PushToApplicationAction;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToWinEdt;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.gui.DatabasePropertiesDialog;
import net.sf.jabref.gui.EntryCustomizationDialog2;
import net.sf.jabref.gui.GenFieldsCustomizer;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.gui.SortTabsAction;
import net.sf.jabref.imports.CiteSeerFetcher;
import net.sf.jabref.imports.CiteSeerFetcherPanel;
import net.sf.jabref.imports.GeneralFetcher;
import net.sf.jabref.imports.IEEEXploreFetcher;
import net.sf.jabref.imports.ImportCustomizationDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.MedlineFetcher;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.journals.ManageJournalsAction;
import net.sf.jabref.label.ArticleLabelRule;
import net.sf.jabref.label.BookLabelRule;
import net.sf.jabref.label.IncollectionLabelRule;
import net.sf.jabref.label.InproceedingsLabelRule;
import net.sf.jabref.label.LabelMaker;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog;
import net.sf.jabref.wizard.integrity.gui.IntegrityWizard;

public class JabRefFrame
extends JFrame {
    JabRefFrame ths = this;
    UIFSplitPane contentPane = new UIFSplitPane();
    JabRefPreferences prefs = Globals.prefs;
    PrefsDialog3 prefsDialog = null;
    private int lastTabbedPanelSelectionIndex = -1;
    public SidePaneManager sidePaneManager;
    JTabbedPane tabbedPane = new JTabbedPane();
    final Insets marg = new Insets(1, 0, 2, 0);
    ToolBar tlb = new ToolBar();
    JMenuBar mb = new JMenuBar();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel statusLine = new JLabel("", 2);
    JLabel statusLabel = new JLabel(Globals.lang("Status") + ":", 2);
    private FileHistory fileHistory = new FileHistory(this.prefs, this);
    LabelMaker labelMaker;
    public HelpDialog helpDiag = new HelpDialog(this);
    public JToggleButton groupToggle;
    public JToggleButton searchToggle;
    public JToggleButton previewToggle;
    public JToggleButton highlightAny;
    public JToggleButton highlightAll;
    OpenDatabaseAction open = new OpenDatabaseAction(this, true);
    AbstractAction close = new CloseDatabaseAction();
    AbstractAction quit = new CloseAction();
    AbstractAction selectKeys = new SelectKeysAction();
    AbstractAction newDatabaseAction = new NewDatabaseAction();
    AbstractAction newSubDatabaseAction = new NewSubDatabaseAction();
    AbstractAction integrityCheckAction = new IntegrityCheckAction();
    AbstractAction help = new HelpAction("JabRef help", this.helpDiag, GUIGlobals.baseFrameHelp, "JabRef help", this.prefs.getKey("Help"));
    AbstractAction contents = new HelpAction("Help contents", this.helpDiag, GUIGlobals.helpContents, "Help contents", GUIGlobals.getIconUrl("helpContents"));
    AbstractAction about = new HelpAction("About JabRef", this.helpDiag, GUIGlobals.aboutPage, "About JabRef", GUIGlobals.getIconUrl("about"));
    AbstractAction editEntry = new GeneralAction("edit", "Edit entry", "Edit entry", this.prefs.getKey("Edit entry"));
    AbstractAction save = new GeneralAction("save", "Save database", "Save database", this.prefs.getKey("Save database"));
    AbstractAction saveAs = new GeneralAction("saveAs", "Save database as ...", "Save database as ...", this.prefs.getKey("Save database as ..."));
    AbstractAction saveSelectedAs = new GeneralAction("saveSelectedAs", "Save selected as ...", "Save selected as ...", GUIGlobals.getIconUrl("saveAs"));
    AbstractAction nextTab = new ChangeTabAction(true);
    AbstractAction prevTab = new ChangeTabAction(false);
    AbstractAction sortTabs = new SortTabsAction(this);
    AbstractAction undo = new GeneralAction("undo", "Undo", "Undo", this.prefs.getKey("Undo"));
    AbstractAction redo = new GeneralAction("redo", "Redo", "Redo", this.prefs.getKey("Redo"));
    AbstractAction delete = new GeneralAction("delete", "Delete", "Delete", this.prefs.getKey("Delete"));
    AbstractAction copy = new EditAction("copy", GUIGlobals.getIconUrl("copy"));
    AbstractAction paste = new EditAction("paste", GUIGlobals.getIconUrl("paste"));
    AbstractAction cut = new EditAction("cut", GUIGlobals.getIconUrl("cut"));
    AbstractAction mark = new GeneralAction("markEntries", "Mark entries", "Mark entries", this.prefs.getKey("Mark entries"));
    AbstractAction unmark = new GeneralAction("unmarkEntries", "Unmark entries", "Unmark entries", this.prefs.getKey("Unmark entries"));
    AbstractAction unmarkAll = new GeneralAction("unmarkAll", "Unmark all");
    AbstractAction manageSelectors = new GeneralAction("manageSelectors", "Manage content selectors");
    AbstractAction saveSessionAction = new SaveSessionAction();
    AbstractAction loadSessionAction = new LoadSessionAction();
    AbstractAction incrementalSearch = new GeneralAction("incSearch", "Incremental search", "Start incremental search", this.prefs.getKey("Incremental search"));
    AbstractAction normalSearch = new GeneralAction("search", "Search", "Search", this.prefs.getKey("Search"));
    AbstractAction toggleSearch = new GeneralAction("toggleSearch", "Search", "Toggle search panel");
    AbstractAction fetchCiteSeer = new FetchCiteSeerAction();
    AbstractAction importCiteSeer = new ImportCiteSeerAction();
    AbstractAction fetchMedline = new FetchMedlineAction();
    AbstractAction citeSeerPanelAction = new CiteSeerPanelAction();
    AbstractAction copyKey = new GeneralAction("copyKey", "Copy BibTeX key");
    AbstractAction copyCiteKey = new GeneralAction("copyCiteKey", "Copy \\cite{BibTeX key}", this.prefs.getKey("Copy \\cite{BibTeX key}"));
    AbstractAction mergeDatabaseAction = new GeneralAction("mergeDatabase", "Append database", "Append contents from a BibTeX database into the currently viewed database", GUIGlobals.getIconUrl("open"));
    AbstractAction selectAll = new GeneralAction("selectAll", "Select all", this.prefs.getKey("Select all"));
    AbstractAction replaceAll = new GeneralAction("replaceAll", "Replace string", this.prefs.getKey("Replace string"));
    AbstractAction editPreamble = new GeneralAction("editPreamble", "Edit preamble", "Edit preamble", this.prefs.getKey("Edit preamble"));
    AbstractAction editStrings = new GeneralAction("editStrings", "Edit strings", "Edit strings", this.prefs.getKey("Edit strings"));
    AbstractAction toggleGroups = new GeneralAction("toggleGroups", "Toggle groups interface", "Toggle groups interface", this.prefs.getKey("Toggle groups interface"));
    AbstractAction togglePreview = new GeneralAction("togglePreview", "Toggle entry preview", "Toggle entry preview", this.prefs.getKey("Toggle entry preview"));
    AbstractAction toggleHighlightAny = new GeneralAction("toggleHighlightGroupsMatchingAny", "Highlight groups matching any selected entry", "Highlight groups matching any selected entry", GUIGlobals.getIconUrl("groupsHighlightAny"));
    AbstractAction toggleHighlightAll = new GeneralAction("toggleHighlightGroupsMatchingAll", "Highlight groups matching all selected entries", "Highlight groups matching all selected entries", GUIGlobals.getIconUrl("groupsHighlightAll"));
    AbstractAction switchPreview = new GeneralAction("switchPreview", "Switch preview layout", this.prefs.getKey("Switch preview layout"));
    AbstractAction makeKeyAction = new GeneralAction("makeKey", "Autogenerate BibTeX keys", "Autogenerate BibTeX keys", this.prefs.getKey("Autogenerate BibTeX keys"));
    AbstractAction lyxPushAction = new PushToApplicationAction(this.ths, new PushToLyx());
    AbstractAction winEdtPushAction = new PushToApplicationAction(this.ths, new PushToWinEdt());
    AbstractAction latexEditorPushAction = new PushToApplicationAction(this.ths, new PushToLatexEditor());
    AbstractAction openFile = new GeneralAction("openFile", "Open PDF or PS", "Open PDF or PS", this.prefs.getKey("Open PDF or PS"));
    AbstractAction openUrl = new GeneralAction("openUrl", "Open URL or DOI", "Open URL or DOI", this.prefs.getKey("Open URL or DOI"));
    AbstractAction dupliCheck = new GeneralAction("dupliCheck", "Find duplicates");
    AbstractAction strictDupliCheck = new GeneralAction("strictDupliCheck", "Find and remove exact duplicates");
    AbstractAction plainTextImport = new GeneralAction("plainTextImport", "New entry from plain text", this.prefs.getKey("New from plain text"));
    AbstractAction customExpAction = new CustomizeExportsAction();
    AbstractAction customImpAction = new CustomizeImportsAction();
    AbstractAction exportCSV = new ExportCSV();
    AbstractAction exportToClipboard = new GeneralAction("exportToClipboard", "Export selected entries to clipboard");
    AbstractAction expandEndnoteZip = new ExpandEndnoteFilters(this);
    AbstractAction autoSetPdf = new GeneralAction("autoSetPdf", Globals.lang("Synchronize %0 links", "PDF"), Globals.prefs.getKey("Synchronize PDF"));
    AbstractAction autoSetPs = new GeneralAction("autoSetPs", Globals.lang("Synchronize %0 links", "PS"), Globals.prefs.getKey("Synchronize PS"));
    AbstractAction abbreviateMedline = new GeneralAction("abbreviateMedline", "Abbreviate journal names (MEDLINE)", "Abbreviate journal names of the selected entries (MEDLINE abbreviation)");
    AbstractAction abbreviateIso = new GeneralAction("abbreviateIso", "Abbreviate journal names (ISO)", "Abbreviate journal names of the selected entries (ISO abbreviation)", Globals.prefs.getKey("Abbreviate"));
    AbstractAction unabbreviate = new GeneralAction("unabbreviate", "Unabbreviate journal names", "Unabbreviate journal names of the selected entries", Globals.prefs.getKey("Unabbreviate"));
    AbstractAction manageJournals = new ManageJournalsAction(this);
    AbstractAction databaseProperties = new DatabasePropertiesAction();
    AbstractAction emacsPushAction = new PushToApplicationAction(this.ths, new PushToEmacs());
    AbstractAction errorConsole = Globals.errorConsole.getAction(this);
    AbstractAction test = new GeneralAction("test", "Test");
    MedlineFetcher medlineFetcher;
    CiteSeerFetcher citeSeerFetcher;
    CiteSeerFetcherPanel citeSeerFetcherPanel;
    IEEEXploreFetcher ieeexplorerFetcher;
    SearchManager2 searchManager;
    public GroupSelector groupSelector;
    JMenu importMenu = this.subMenu("Import into current database");
    JMenu importNewMenu = this.subMenu("Import into new database");
    JMenu exportMenu = this.subMenu("Export");
    JMenu customExportMenu = this.subMenu("Custom export");
    JMenu newDatabaseMenu = this.subMenu("New database");
    JMenu checkAndFix = this.subMenu("Scan database...");
    NewEntryAction newEntryAction = new NewEntryAction(this.prefs.getKey("New entry"));
    NewEntryAction[] newSpecificEntryAction = new NewEntryAction[]{new NewEntryAction("article", this.prefs.getKey("New article")), new NewEntryAction("book", this.prefs.getKey("New book")), new NewEntryAction("phdthesis", this.prefs.getKey("New phdthesis")), new NewEntryAction("inbook", this.prefs.getKey("New inbook")), new NewEntryAction("mastersthesis", this.prefs.getKey("New mastersthesis")), new NewEntryAction("proceedings", this.prefs.getKey("New proceedings")), new NewEntryAction("inproceedings"), new NewEntryAction("conference"), new NewEntryAction("incollection"), new NewEntryAction("booklet"), new NewEntryAction("manual"), new NewEntryAction("techreport"), new NewEntryAction("unpublished", this.prefs.getKey("New unpublished")), new NewEntryAction("misc"), new NewEntryAction("other")};
    AboutAction aboutAction = new AboutAction();
    CloseDatabaseAction closeDatabaseAction = new CloseDatabaseAction();
    AbstractAction showPrefs = new ShowPrefsAction();
    JMenuItem htmlItem = new JMenuItem(Globals.lang("HTML"));
    JMenuItem simpleHtmlItem = new JMenuItem(Globals.lang("Simple HTML"));
    JMenuItem docbookItem = new JMenuItem(Globals.lang("Docbook"));
    JMenuItem bibtexmlItem = new JMenuItem(Globals.lang("BibTeXML"));
    JMenuItem modsItem = new JMenuItem(Globals.lang("MODS"));
    JMenuItem rtfItem = new JMenuItem(Globals.lang("Harvard RTF"));
    JMenuItem endnoteItem = new JMenuItem(Globals.lang("Endnote"));
    JMenuItem openofficeItem = new JMenuItem("OpenOffice Calc");
    JMenuItem odsItem = new JMenuItem("OpenDocument Spreadsheet");

    public JabRefFrame() {
        this.init();
        this.setEmptyState();
    }

    private void init() {
        this.macOSXRegistration();
        MyGlassPane myGlassPane = new MyGlassPane();
        this.setGlassPane(myGlassPane);
        this.setTitle(GUIGlobals.frameTitle);
        this.setIconImage(GUIGlobals.getImage("jabrefIcon").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new CloseAction().actionPerformed(null);
            }
        });
        this.initLabelMaker();
        Globals.sidePaneManager = this.sidePaneManager = new SidePaneManager(this);
        Globals.helpDiag = this.helpDiag;
        this.medlineFetcher = new MedlineFetcher(this.sidePaneManager);
        this.citeSeerFetcher = new CiteSeerFetcher(this.sidePaneManager);
        this.citeSeerFetcherPanel = new CiteSeerFetcherPanel(this.sidePaneManager, this.citeSeerFetcher);
        this.ieeexplorerFetcher = new IEEEXploreFetcher();
        this.searchManager = new SearchManager2(this, this.sidePaneManager);
        this.groupSelector = new GroupSelector(this, this.sidePaneManager);
        this.sidePaneManager.register("groups", this.groupSelector);
        this.sidePaneManager.register("fetchMedline", this.medlineFetcher);
        this.sidePaneManager.register("search", this.searchManager);
        if (Globals.prefs.getBoolean("searchPanelVisible")) {
            this.sidePaneManager.ensureVisible("search");
        }
        this.sidePaneManager.register("CiteSeerPanel", this.citeSeerFetcherPanel);
        this.sidePaneManager.register("CiteSeerProgress", this.citeSeerFetcher);
        this.sidePaneManager.populatePanel();
        this.setupLayout();
        this.setSize(new Dimension(this.prefs.getInt("sizeX"), this.prefs.getInt("sizeY")));
        this.setLocation(new Point(this.prefs.getInt("posX"), this.prefs.getInt("posY")));
        this.tabbedPane.setBorder(null);
        this.tabbedPane.setForeground(GUIGlobals.inActiveTabbed);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JabRefFrame.this.markActiveBasePanel();
                BasePanel basePanel = JabRefFrame.this.basePanel();
                if (basePanel != null) {
                    JabRefFrame.this.groupToggle.setSelected(JabRefFrame.this.sidePaneManager.isPanelVisible("groups"));
                    JabRefFrame.this.searchToggle.setSelected(JabRefFrame.this.sidePaneManager.isPanelVisible("search"));
                    JabRefFrame.this.previewToggle.setSelected(Globals.prefs.getBoolean("previewEnabled"));
                    JabRefFrame.this.highlightAny.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAny"));
                    JabRefFrame.this.highlightAll.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAll"));
                    Globals.focusListener.setFocused(basePanel.mainTable);
                    new FocusRequester(basePanel.mainTable);
                }
            }
        });
    }

    public void about() {
        JDialog jDialog = new JDialog(this.ths, Globals.lang("About JabRef"), true);
        JEditorPane jEditorPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 31);
        jEditorPane.setEditable(false);
        try {
            jEditorPane.setPage(GUIGlobals.class.getResource("/help/About.html"));
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            ((JEditorPane)hyperlinkEvent.getSource()).setPage(hyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            jDialog.getContentPane().add(jScrollPane);
            jDialog.setSize(GUIGlobals.aboutSize);
            Util.placeDialog(jDialog, this.ths);
            jDialog.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.ths, "Could not load file 'About.html'", "Error", 0);
        }
    }

    public void preferences() {
        AbstractWorker abstractWorker = new AbstractWorker(){

            public void run() {
                JabRefFrame.this.output(Globals.lang("Opening preferences..."));
                if (JabRefFrame.this.prefsDialog == null) {
                    JabRefFrame.this.prefsDialog = new PrefsDialog3(JabRefFrame.this.ths, JabRefFrame.this.prefs);
                    Util.placeDialog(JabRefFrame.this.prefsDialog, JabRefFrame.this.ths);
                } else {
                    JabRefFrame.this.prefsDialog.setValues();
                }
            }

            public void update() {
                JabRefFrame.this.prefsDialog.setVisible(true);
                JabRefFrame.this.output("");
            }
        };
        abstractWorker.getWorker().run();
        abstractWorker.getCallBack().update();
    }

    public JabRefPreferences prefs() {
        return this.prefs;
    }

    public void quit() {
        int n;
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        if (this.tabbedPane.getTabCount() > 0) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (this.baseAt((int)i).baseChanged) {
                    this.tabbedPane.setSelectedIndex(i);
                    n = JOptionPane.showConfirmDialog(this.ths, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                    if (n == 2 || n == -1) {
                        bl = false;
                        return;
                    }
                    if (n == 0) {
                        try {
                            this.basePanel().runCommand("save");
                        }
                        catch (Throwable throwable) {
                            bl = false;
                            break;
                        }
                    }
                }
                if (this.baseAt((int)i).file == null) continue;
                vector.add(this.baseAt((int)i).file.getPath());
            }
        }
        if (bl) {
            this.dispose();
            this.prefs.putInt("posX", this.ths.getLocation().x);
            this.prefs.putInt("posY", this.ths.getLocation().y);
            this.prefs.putInt("sizeX", this.ths.getSize().width);
            this.prefs.putInt("sizeY", this.ths.getSize().height);
            this.prefs.putBoolean("searchPanelVisible", this.sidePaneManager.isPanelVisible("search"));
            if (this.prefs.getBoolean("openLastEdited")) {
                if (vector.size() == 0) {
                    this.prefs.remove("lastEdited");
                } else {
                    String[] stringArray = new String[vector.size()];
                    for (n = 0; n < vector.size(); ++n) {
                        stringArray[n] = (String)vector.elementAt(n);
                    }
                    this.prefs.putStringArray("lastEdited", stringArray);
                }
            }
            this.fileHistory.storeHistory();
            this.prefs.customExports.store();
            this.prefs.customImports.store();
            BibtexEntryType.saveCustomEntryTypes(this.prefs);
            if (this.basePanel() != null) {
                this.searchManager.updatePrefs();
            }
            System.exit(0);
        }
    }

    private void macOSXRegistration() {
        if (Globals.osName.equals("Mac OS X")) {
            try {
                Object object;
                Class<?> clazz = Class.forName("osxadapter.OSXAdapter");
                Class[] classArray = new Class[]{JabRefFrame.class};
                Method method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray);
                if (method != null) {
                    object = new Object[]{this};
                    method.invoke(clazz, object);
                }
                classArray[0] = Boolean.TYPE;
                object = clazz.getDeclaredMethod("enablePrefs", classArray);
                if (object != null) {
                    Object[] objectArray = new Object[]{Boolean.TRUE};
                    object.invoke(clazz, objectArray);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
    }

    private void setupLayout() {
        this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.fillMenu();
        this.createToolBar();
        this.getContentPane().setLayout(this.gbl);
        this.contentPane.setDividerSize(2);
        this.contentPane.setBorder(null);
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 0;
        this.setJMenuBar(this.mb);
        this.con.anchor = 11;
        this.gbl.setConstraints(this.tlb, this.con);
        this.getContentPane().add(this.tlb);
        Component component = Box.createGlue();
        this.gbl.setConstraints(component, this.con);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.fill = 1;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 0, 0, 0);
        component = Box.createGlue();
        this.gbl.setConstraints(component, this.con);
        this.getContentPane().add(component);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.contentPane, this.con);
        this.getContentPane().add(this.contentPane);
        this.contentPane.setRightComponent(this.tabbedPane);
        this.contentPane.setLeftComponent(this.sidePaneManager.getPanel());
        this.sidePaneManager.updateView();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(0, 2, 0, 0);
        this.gbl.setConstraints(this.statusLabel, this.con);
        jPanel.add(this.statusLabel);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 4, 0, 0);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.statusLine, this.con);
        jPanel.add(this.statusLine);
        this.con.gridwidth = 0;
        this.statusLabel.setForeground(GUIGlobals.validFieldColor.darker());
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(jPanel, this.con);
        this.getContentPane().add(jPanel);
        EntryTableTransferHandler entryTableTransferHandler = new EntryTableTransferHandler(null, this);
        this.tabbedPane.setTransferHandler(entryTableTransferHandler);
        this.tlb.setTransferHandler(entryTableTransferHandler);
        this.mb.setTransferHandler(entryTableTransferHandler);
        this.sidePaneManager.getPanel().setTransferHandler(entryTableTransferHandler);
    }

    private void initLabelMaker() {
        this.labelMaker = new LabelMaker();
        this.labelMaker.addRule(new ArticleLabelRule(), BibtexEntryType.ARTICLE);
        this.labelMaker.addRule(new BookLabelRule(), BibtexEntryType.BOOK);
        this.labelMaker.addRule(new IncollectionLabelRule(), BibtexEntryType.INCOLLECTION);
        this.labelMaker.addRule(new InproceedingsLabelRule(), BibtexEntryType.INPROCEEDINGS);
    }

    BasePanel baseAt(int n) {
        return (BasePanel)this.tabbedPane.getComponentAt(n);
    }

    public void showBaseAt(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public BasePanel basePanel() {
        return (BasePanel)this.tabbedPane.getSelectedComponent();
    }

    private void markActiveBasePanel() {
        int n = this.tabbedPane.getSelectedIndex();
        int n2 = this.tabbedPane.getTabCount();
        if (this.lastTabbedPanelSelectionIndex > -1 && this.lastTabbedPanelSelectionIndex < n2) {
            this.tabbedPane.setForegroundAt(this.lastTabbedPanelSelectionIndex, GUIGlobals.inActiveTabbed);
        }
        if (n > -1 && n < n2) {
            this.tabbedPane.setForegroundAt(n, GUIGlobals.activeTabbed);
        }
        this.lastTabbedPanelSelectionIndex = n;
    }

    private int getTabIndex(JComponent jComponent) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != jComponent) continue;
            return i;
        }
        return -1;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getTabTitle(JComponent jComponent) {
        return this.tabbedPane.getTitleAt(this.getTabIndex(jComponent));
    }

    public void setTabTitle(JComponent jComponent, String string) {
        this.tabbedPane.setTitleAt(this.getTabIndex(jComponent), string);
    }

    public void setUpImportMenus() {
        this.setUpImportMenu(this.importMenu, false);
        this.setUpImportMenu(this.importNewMenu, true);
    }

    private void fillMenu() {
        this.mb.setBorder(null);
        JMenu jMenu = this.subMenu("File");
        JMenu jMenu2 = this.subMenu("Edit");
        JMenu jMenu3 = this.subMenu("BibTeX");
        JMenu jMenu4 = this.subMenu("View");
        JMenu jMenu5 = this.subMenu("Tools");
        JMenu jMenu6 = this.subMenu("Web search");
        JMenu jMenu7 = this.subMenu("Options");
        JMenu jMenu8 = this.subMenu("New entry...");
        JMenu jMenu9 = this.subMenu("Help");
        this.setUpImportMenus();
        this.setUpExportMenu(this.exportMenu);
        this.setUpCustomExportMenu();
        this.newDatabaseMenu.add(this.newDatabaseAction);
        this.newDatabaseMenu.add(this.newSubDatabaseAction);
        jMenu.add(this.newDatabaseAction);
        jMenu.add(this.open);
        jMenu.add(this.mergeDatabaseAction);
        jMenu.add(this.importMenu);
        jMenu.add(this.importNewMenu);
        jMenu.add(this.save);
        jMenu.add(this.saveAs);
        jMenu.add(this.saveSelectedAs);
        jMenu.add(this.exportMenu);
        jMenu.add(this.customExportMenu);
        jMenu.addSeparator();
        jMenu.add(this.databaseProperties);
        jMenu.addSeparator();
        jMenu.add(this.fileHistory);
        jMenu.add(this.loadSessionAction);
        jMenu.add(this.saveSessionAction);
        jMenu.addSeparator();
        jMenu.add(this.close);
        jMenu.add(this.quit);
        this.mb.add(jMenu);
        jMenu2.add(this.undo);
        jMenu2.add(this.redo);
        jMenu2.addSeparator();
        jMenu2.add(this.cut);
        jMenu2.add(this.copy);
        jMenu2.add(this.paste);
        jMenu2.add(this.delete);
        jMenu2.add(this.copyKey);
        jMenu2.add(this.copyCiteKey);
        jMenu2.addSeparator();
        jMenu2.add(this.mark);
        jMenu2.add(this.unmark);
        jMenu2.add(this.unmarkAll);
        jMenu2.addSeparator();
        jMenu2.add(this.selectAll);
        this.mb.add(jMenu2);
        jMenu4.add(this.nextTab);
        jMenu4.add(this.prevTab);
        jMenu4.add(this.sortTabs);
        jMenu4.addSeparator();
        jMenu4.add(this.toggleGroups);
        jMenu4.add(this.togglePreview);
        jMenu4.add(this.switchPreview);
        jMenu4.addSeparator();
        jMenu4.add(this.toggleHighlightAny);
        jMenu4.add(this.toggleHighlightAll);
        this.mb.add(jMenu4);
        jMenu3.add(this.newEntryAction);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            jMenu8.add(this.newSpecificEntryAction[i]);
        }
        jMenu3.add(jMenu8);
        jMenu3.add(this.plainTextImport);
        jMenu3.addSeparator();
        jMenu3.add(this.editEntry);
        jMenu3.add(this.importCiteSeer);
        jMenu3.add(this.editPreamble);
        jMenu3.add(this.editStrings);
        this.mb.add(jMenu3);
        jMenu5.add(this.normalSearch);
        jMenu5.add(this.incrementalSearch);
        jMenu5.add(this.replaceAll);
        jMenu5.add(this.makeKeyAction);
        jMenu5.add(this.checkAndFix);
        this.checkAndFix.add(this.dupliCheck);
        this.checkAndFix.add(this.strictDupliCheck);
        this.checkAndFix.add(this.autoSetPdf);
        this.checkAndFix.add(this.autoSetPs);
        this.checkAndFix.add(this.integrityCheckAction);
        jMenu5.addSeparator();
        jMenu5.add(this.manageSelectors);
        jMenu5.add(this.emacsPushAction);
        jMenu5.add(this.lyxPushAction);
        jMenu5.add(this.winEdtPushAction);
        jMenu5.addSeparator();
        jMenu5.add(this.openFile);
        jMenu5.add(this.openUrl);
        jMenu5.addSeparator();
        jMenu5.add(this.newSubDatabaseAction);
        jMenu5.addSeparator();
        jMenu5.add(this.abbreviateIso);
        jMenu5.add(this.abbreviateMedline);
        jMenu5.add(this.unabbreviate);
        this.mb.add(jMenu5);
        jMenu6.add(this.fetchMedline);
        jMenu6.add(this.citeSeerPanelAction);
        jMenu6.add(this.fetchCiteSeer);
        GeneralFetcher generalFetcher = new GeneralFetcher(this.sidePaneManager, this, this.ieeexplorerFetcher);
        jMenu6.add(generalFetcher.getAction());
        this.mb.add(jMenu6);
        jMenu7.add(this.showPrefs);
        CustomizeEntryTypeAction customizeEntryTypeAction = new CustomizeEntryTypeAction();
        GenFieldsCustomizationAction genFieldsCustomizationAction = new GenFieldsCustomizationAction();
        jMenu7.add(customizeEntryTypeAction);
        jMenu7.add(genFieldsCustomizationAction);
        jMenu7.add(this.customExpAction);
        jMenu7.add(this.customImpAction);
        jMenu7.add(this.manageJournals);
        this.mb.add(jMenu7);
        jMenu9.add(this.help);
        jMenu9.add(this.contents);
        jMenu9.addSeparator();
        jMenu9.add(this.about);
        this.mb.add(jMenu9);
        jMenu9.addSeparator();
        jMenu9.add(this.errorConsole);
    }

    private JMenu subMenu(String string) {
        JMenu jMenu;
        int n = (string = Globals.menuTitle(string)).indexOf(38);
        if (n >= 0) {
            jMenu = new JMenu(string.substring(0, n) + string.substring(n + 1));
            char c = Character.toUpperCase(string.charAt(n + 1));
            jMenu.setMnemonic((int)c);
        } else {
            jMenu = new JMenu(string);
        }
        return jMenu;
    }

    private void createToolBar() {
        this.tlb.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.tlb.setBorder(null);
        this.tlb.setRollover(true);
        this.tlb.setFloatable(false);
        this.tlb.addAction(this.newDatabaseAction);
        this.tlb.addAction(this.open);
        this.tlb.addAction(this.save);
        this.tlb.addSeparator();
        this.tlb.addAction(this.cut);
        this.tlb.addAction(this.copy);
        this.tlb.addAction(this.paste);
        this.tlb.addAction(this.undo);
        this.tlb.addAction(this.redo);
        this.tlb.addSeparator();
        this.tlb.addAction(this.newEntryAction);
        this.tlb.addAction(this.editEntry);
        this.tlb.addAction(this.editPreamble);
        this.tlb.addAction(this.editStrings);
        this.tlb.addAction(this.makeKeyAction);
        this.tlb.addSeparator();
        this.tlb.addAction(this.mark);
        this.tlb.addAction(this.unmark);
        this.tlb.addSeparator();
        this.searchToggle = new JToggleButton(this.toggleSearch);
        this.searchToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.searchToggle.setMargin(this.marg);
        }
        this.tlb.add(this.searchToggle);
        this.previewToggle = new JToggleButton(this.togglePreview);
        this.previewToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.previewToggle.setMargin(this.marg);
        }
        this.tlb.add(this.previewToggle);
        this.tlb.addSeparator();
        this.groupToggle = new JToggleButton(this.toggleGroups);
        this.groupToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.groupToggle.setMargin(this.marg);
        }
        this.tlb.add(this.groupToggle);
        this.highlightAny = new JToggleButton(this.toggleHighlightAny);
        this.highlightAny.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAny.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAny);
        this.highlightAll = new JToggleButton(this.toggleHighlightAll);
        this.highlightAll.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAll.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAll);
        this.tlb.addSeparator();
        this.tlb.addAction(this.emacsPushAction);
        this.tlb.addAction(this.lyxPushAction);
        this.tlb.addAction(this.winEdtPushAction);
        this.tlb.addAction(this.openFile);
        this.tlb.addAction(this.openUrl);
        this.tlb.add(Box.createHorizontalGlue());
        this.tlb.addAction(this.closeDatabaseAction);
    }

    private JMenuItem mItem(AbstractAction abstractAction, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(abstractAction);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    public void output(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JabRefFrame.this.statusLine.setText(string);
                JabRefFrame.this.statusLine.repaint();
            }
        });
    }

    public void stopShowingSearchResults() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).stopShowingSearchResults();
        }
    }

    private void setEmptyState() {
        this.manageSelectors.setEnabled(false);
        this.mergeDatabaseAction.setEnabled(false);
        this.newSubDatabaseAction.setEnabled(false);
        this.close.setEnabled(false);
        this.save.setEnabled(false);
        this.saveAs.setEnabled(false);
        this.saveSelectedAs.setEnabled(false);
        this.nextTab.setEnabled(false);
        this.prevTab.setEnabled(false);
        this.sortTabs.setEnabled(false);
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.cut.setEnabled(false);
        this.delete.setEnabled(false);
        this.copy.setEnabled(false);
        this.paste.setEnabled(false);
        this.mark.setEnabled(false);
        this.unmark.setEnabled(false);
        this.unmarkAll.setEnabled(false);
        this.editEntry.setEnabled(false);
        this.importCiteSeer.setEnabled(false);
        this.selectAll.setEnabled(false);
        this.copyKey.setEnabled(false);
        this.copyCiteKey.setEnabled(false);
        this.editPreamble.setEnabled(false);
        this.editStrings.setEnabled(false);
        this.toggleGroups.setEnabled(false);
        this.toggleSearch.setEnabled(false);
        this.makeKeyAction.setEnabled(false);
        this.emacsPushAction.setEnabled(false);
        this.lyxPushAction.setEnabled(false);
        this.winEdtPushAction.setEnabled(false);
        this.normalSearch.setEnabled(false);
        this.incrementalSearch.setEnabled(false);
        this.replaceAll.setEnabled(false);
        this.importMenu.setEnabled(false);
        this.exportMenu.setEnabled(false);
        this.fetchMedline.setEnabled(false);
        this.fetchCiteSeer.setEnabled(false);
        this.openFile.setEnabled(false);
        this.openUrl.setEnabled(false);
        this.togglePreview.setEnabled(false);
        this.dupliCheck.setEnabled(false);
        this.strictDupliCheck.setEnabled(false);
        this.highlightAll.setEnabled(false);
        this.highlightAny.setEnabled(false);
        this.citeSeerPanelAction.setEnabled(false);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            this.newSpecificEntryAction[i].setEnabled(false);
        }
        this.newEntryAction.setEnabled(false);
        this.plainTextImport.setEnabled(false);
        this.closeDatabaseAction.setEnabled(false);
        this.switchPreview.setEnabled(false);
        this.integrityCheckAction.setEnabled(false);
        this.autoSetPdf.setEnabled(false);
        this.autoSetPs.setEnabled(false);
        this.toggleHighlightAny.setEnabled(false);
        this.toggleHighlightAll.setEnabled(false);
        this.databaseProperties.setEnabled(false);
        this.abbreviateIso.setEnabled(false);
        this.abbreviateMedline.setEnabled(false);
        this.unabbreviate.setEnabled(false);
    }

    private void setNonEmptyState() {
        this.manageSelectors.setEnabled(true);
        this.mergeDatabaseAction.setEnabled(true);
        this.newSubDatabaseAction.setEnabled(true);
        this.close.setEnabled(true);
        this.save.setEnabled(true);
        this.saveAs.setEnabled(true);
        this.saveSelectedAs.setEnabled(true);
        this.undo.setEnabled(true);
        this.redo.setEnabled(true);
        this.cut.setEnabled(true);
        this.delete.setEnabled(true);
        this.copy.setEnabled(true);
        this.paste.setEnabled(true);
        this.mark.setEnabled(true);
        this.unmark.setEnabled(true);
        this.unmarkAll.setEnabled(true);
        this.editEntry.setEnabled(true);
        this.importCiteSeer.setEnabled(true);
        this.selectAll.setEnabled(true);
        this.copyKey.setEnabled(true);
        this.copyCiteKey.setEnabled(true);
        this.editPreamble.setEnabled(true);
        this.editStrings.setEnabled(true);
        this.toggleGroups.setEnabled(true);
        this.toggleSearch.setEnabled(true);
        this.makeKeyAction.setEnabled(true);
        this.emacsPushAction.setEnabled(true);
        this.lyxPushAction.setEnabled(true);
        this.winEdtPushAction.setEnabled(true);
        this.normalSearch.setEnabled(true);
        this.incrementalSearch.setEnabled(true);
        this.replaceAll.setEnabled(true);
        this.importMenu.setEnabled(true);
        this.exportMenu.setEnabled(true);
        this.fetchMedline.setEnabled(true);
        this.fetchCiteSeer.setEnabled(true);
        this.openFile.setEnabled(true);
        this.openUrl.setEnabled(true);
        this.togglePreview.setEnabled(true);
        this.dupliCheck.setEnabled(true);
        this.strictDupliCheck.setEnabled(true);
        this.highlightAll.setEnabled(true);
        this.highlightAny.setEnabled(true);
        this.citeSeerPanelAction.setEnabled(true);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            this.newSpecificEntryAction[i].setEnabled(true);
        }
        this.newEntryAction.setEnabled(true);
        this.plainTextImport.setEnabled(true);
        this.closeDatabaseAction.setEnabled(true);
        this.switchPreview.setEnabled(true);
        this.integrityCheckAction.setEnabled(true);
        this.autoSetPdf.setEnabled(true);
        this.autoSetPs.setEnabled(true);
        this.toggleHighlightAny.setEnabled(true);
        this.toggleHighlightAll.setEnabled(true);
        this.databaseProperties.setEnabled(true);
        this.abbreviateIso.setEnabled(true);
        this.abbreviateMedline.setEnabled(true);
        this.unabbreviate.setEnabled(true);
    }

    private void setOnlyOne() {
        this.nextTab.setEnabled(false);
        this.prevTab.setEnabled(false);
        this.sortTabs.setEnabled(false);
    }

    private void setMultiple() {
        this.nextTab.setEnabled(true);
        this.prevTab.setEnabled(true);
        this.sortTabs.setEnabled(true);
    }

    public void setupAllTables() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel basePanel = this.baseAt(i);
            if (basePanel.database == null) continue;
            basePanel.setupMainPanel();
        }
    }

    public BasePanel addTab(BibtexDatabase bibtexDatabase, File file, HashMap hashMap, String string, boolean bl) {
        BasePanel basePanel = new BasePanel(this.ths, bibtexDatabase, file, hashMap, string);
        this.addTab(basePanel, file, bl);
        return basePanel;
    }

    public void addTab(BasePanel basePanel, File file, boolean bl) {
        this.tabbedPane.add(file != null ? file.getName() : Globals.lang(GUIGlobals.untitledTitle), basePanel);
        if (bl) {
            this.tabbedPane.setSelectedComponent(basePanel);
        }
        if (this.tabbedPane.getTabCount() == 1) {
            this.setNonEmptyState();
        } else if (this.tabbedPane.getTabCount() == 2) {
            this.setMultiple();
        }
    }

    public void addImportedEntries(final BasePanel basePanel, final List list, String string, boolean bl, ImportInspectionDialog.CallBack callBack) {
        if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || list.size() > 1)) {
            ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(this.ths, basePanel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), bl);
            importInspectionDialog.addEntries(list);
            importInspectionDialog.addCallBack(callBack);
            importInspectionDialog.entryListComplete();
            Util.placeDialog(importInspectionDialog, this.ths);
            importInspectionDialog.setVisible(true);
            importInspectionDialog.toFront();
        } else {
            this.ths.addBibEntries(list, string, bl);
            if (basePanel != null && list.size() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        basePanel.highlightEntry((BibtexEntry)list.get(0));
                    }
                });
            }
        }
    }

    public int addBibEntries(List list, String string, boolean bl) {
        if (list == null || list.size() == 0) {
            JOptionPane.showMessageDialog(this.ths, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            return 0;
        }
        int n = 0;
        Util.setAutomaticFields(list);
        if (bl || this.tabbedPane.getTabCount() == 0) {
            Object object;
            BibtexDatabase bibtexDatabase = new BibtexDatabase();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (BibtexEntry)iterator.next();
                try {
                    ((BibtexEntry)object).setId(Util.createNeutralId());
                    bibtexDatabase.insertEntry((BibtexEntry)object);
                }
                catch (KeyCollisionException keyCollisionException) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            object = new HashMap();
            BasePanel basePanel = new BasePanel(this.ths, bibtexDatabase, null, (HashMap)object, Globals.prefs.get("defaultEncoding"));
            n = bibtexDatabase.getEntryCount();
            this.tabbedPane.add(Globals.lang("untitled"), basePanel);
            basePanel.markBaseChanged();
            this.tabbedPane.setSelectedComponent(basePanel);
            if (this.tabbedPane.getTabCount() == 1) {
                this.setNonEmptyState();
            }
            if (string != null) {
                this.output(Globals.lang("Imported database") + " '" + string + "' " + Globals.lang("with") + " " + bibtexDatabase.getEntryCount() + " " + Globals.lang("entries into new database") + ".");
            }
        } else {
            boolean bl2 = true;
            BasePanel basePanel = this.basePanel();
            BibtexDatabase bibtexDatabase = basePanel.database;
            int n2 = bibtexDatabase.getEntryCount();
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Import entries"));
            Iterator iterator = list.iterator();
            block5: while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                boolean bl3 = false;
                if (bl2) {
                    Iterator iterator2 = bibtexDatabase.getKeySet().iterator();
                    while (iterator2.hasNext()) {
                        BibtexEntry bibtexEntry2 = bibtexDatabase.getEntryById((String)iterator2.next());
                        if (!Util.isDuplicate(bibtexEntry, bibtexEntry2, Globals.duplicateThreshold)) continue;
                        DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(this.ths, bibtexEntry2, bibtexEntry, 2);
                        duplicateResolverDialog.setVisible(true);
                        int n3 = duplicateResolverDialog.getSelected();
                        if (n3 == 2) {
                            bl3 = true;
                            break;
                        }
                        if (n3 == 1) {
                            bibtexDatabase.removeEntry(bibtexEntry2.getId());
                            namedCompound.addEdit(new UndoableRemoveEntry(bibtexDatabase, bibtexEntry2, basePanel));
                            break;
                        }
                        if (n3 == 5) break block5;
                    }
                }
                if (bl3) continue;
                try {
                    bibtexEntry.setId(Util.createNeutralId());
                    bibtexDatabase.insertEntry(bibtexEntry);
                    namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase, bibtexEntry, basePanel));
                    ++n;
                }
                catch (KeyCollisionException keyCollisionException) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            if (n > 0) {
                namedCompound.end();
                basePanel.undoManager.addEdit(namedCompound);
                basePanel.markBaseChanged();
                if (string != null) {
                    this.output(Globals.lang("Imported database") + " '" + string + "' " + Globals.lang("with") + " " + (bibtexDatabase.getEntryCount() - n2) + " " + Globals.lang("entries into new database") + ".");
                }
            }
        }
        return n;
    }

    private void setUpImportMenu(JMenu jMenu, boolean bl) {
        ImportFormat importFormat;
        Iterator iterator;
        boolean bl2 = bl;
        jMenu.removeAll();
        jMenu.add(new ImportMenuItem(this.ths, bl2));
        jMenu.addSeparator();
        SortedSet sortedSet = Globals.importFormatReader.getCustomImportFormats();
        JMenu jMenu2 = new JMenu(Globals.lang("Custom importers"));
        jMenu2.setMnemonic(83);
        if (sortedSet.size() == 0) {
            jMenu2.setEnabled(false);
            jMenu2.setToolTipText(Globals.lang("No custom imports registered yet."));
        } else {
            iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                importFormat = (ImportFormat)iterator.next();
                jMenu2.add(new ImportMenuItem(this.ths, bl2, importFormat));
            }
        }
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        iterator = Globals.importFormatReader.getBuiltInInputFormats().iterator();
        while (iterator.hasNext()) {
            importFormat = (ImportFormat)iterator.next();
            jMenu.add(new ImportMenuItem(this.ths, bl2, importFormat));
        }
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    private void setUpExportMenu(JMenu jMenu) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = null;
                String string2 = null;
                if (jMenuItem == JabRefFrame.this.htmlItem) {
                    string = "html";
                    string2 = ".html";
                } else if (jMenuItem == JabRefFrame.this.simpleHtmlItem) {
                    string = "simplehtml";
                    string2 = ".html";
                } else if (jMenuItem == JabRefFrame.this.docbookItem) {
                    string = "docbook";
                    string2 = ".xml";
                } else if (jMenuItem == JabRefFrame.this.bibtexmlItem) {
                    string = "bibtexml";
                    string2 = ".xml";
                } else if (jMenuItem == JabRefFrame.this.modsItem) {
                    string = "mods";
                    string2 = ".xml";
                } else if (jMenuItem == JabRefFrame.this.rtfItem) {
                    string = "harvard";
                    string2 = ".rtf";
                } else if (jMenuItem == JabRefFrame.this.endnoteItem) {
                    string = "endnote";
                    string2 = ".txt";
                } else if (jMenuItem == JabRefFrame.this.openofficeItem) {
                    string = "oocalc";
                    string2 = ".sxc";
                } else if (jMenuItem == JabRefFrame.this.odsItem) {
                    string = "ods";
                    string2 = ".ods";
                }
                final String string3 = Globals.getNewFile(JabRefFrame.this.ths, new File(JabRefFrame.this.prefs.get("workingDirectory")), string2, 1, false);
                final String string4 = string;
                if (string3 == null) {
                    return;
                }
                new Thread(){

                    public void run() {
                        try {
                            FileActions.performExport(JabRefFrame.this.basePanel().database(), string4, string3, JabRefFrame.this.basePanel().getEncoding());
                            JabRefFrame.this.output(Globals.lang("Exported database to file") + " '" + string3 + "'.");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }.start();
            }
        };
        this.htmlItem.addActionListener(actionListener);
        jMenu.add(this.htmlItem);
        this.simpleHtmlItem.addActionListener(actionListener);
        jMenu.add(this.simpleHtmlItem);
        this.bibtexmlItem.addActionListener(actionListener);
        jMenu.add(this.bibtexmlItem);
        this.docbookItem.addActionListener(actionListener);
        jMenu.add(this.docbookItem);
        this.modsItem.addActionListener(actionListener);
        jMenu.add(this.modsItem);
        this.rtfItem.addActionListener(actionListener);
        jMenu.add(this.rtfItem);
        this.endnoteItem.addActionListener(actionListener);
        jMenu.add(this.endnoteItem);
        this.openofficeItem.addActionListener(actionListener);
        this.odsItem.addActionListener(actionListener);
        jMenu.add(this.openofficeItem);
        jMenu.add(this.odsItem);
        jMenu.add(this.exportCSV);
        jMenu.addSeparator();
        jMenu.add(this.expandEndnoteZip);
    }

    public void setUpCustomExportMenu() {
        this.customExportMenu.removeAll();
        for (int i = 0; i < this.prefs.customExports.size(); ++i) {
            String[] stringArray = this.prefs.customExports.getElementAt(i);
            this.customExportMenu.add(new CustomExportAction(stringArray[0], stringArray[2], stringArray[1]));
        }
    }

    public void setPreviewActive(boolean bl) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).setPreviewActive(bl);
        }
    }

    public void removeCachedEntryEditors() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.tabbedPane.getComponentAt(i);
            basePanel.entryEditors.clear();
        }
    }

    public void block() {
        this.getGlassPane().setVisible(true);
    }

    public void unblock() {
        this.getGlassPane().setVisible(false);
    }

    private class MyGlassPane
    extends JPanel {
        public MyGlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }

        public boolean isOpaque() {
            return false;
        }
    }

    class DatabasePropertiesAction
    extends MnemonicAwareAction {
        DatabasePropertiesDialog propertiesDialog = null;

        public DatabasePropertiesAction() {
            this.putValue("Name", "Database properties");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.propertiesDialog == null) {
                this.propertiesDialog = new DatabasePropertiesDialog(JabRefFrame.this);
            }
            this.propertiesDialog.setPanel(JabRefFrame.this.basePanel());
            Util.placeDialog(this.propertiesDialog, JabRefFrame.this);
            this.propertiesDialog.setVisible(true);
        }
    }

    class GenFieldsCustomizationAction
    extends MnemonicAwareAction {
        public GenFieldsCustomizationAction() {
            this.putValue("Name", "Set up general fields");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenFieldsCustomizer genFieldsCustomizer = new GenFieldsCustomizer(JabRefFrame.this.ths);
            Util.placeDialog(genFieldsCustomizer, JabRefFrame.this.ths);
            genFieldsCustomizer.setVisible(true);
        }
    }

    class CustomizeEntryTypeAction
    extends MnemonicAwareAction {
        public CustomizeEntryTypeAction() {
            this.putValue("Name", "Customize entry types");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EntryCustomizationDialog2 entryCustomizationDialog2 = new EntryCustomizationDialog2(JabRefFrame.this.ths);
            Util.placeDialog(entryCustomizationDialog2, JabRefFrame.this.ths);
            entryCustomizationDialog2.setVisible(true);
        }
    }

    class ExportCSV
    extends MnemonicAwareAction {
        public ExportCSV() {
            this.putValue("Name", "Tab-separated file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Globals.getNewFile(JabRefFrame.this.ths, new File(JabRefFrame.this.prefs.get("workingDirectory")), ".csv", 1, true);
            if (string == null) {
                return;
            }
            try {
                FileActions.exportToCSV(JabRefFrame.this.basePanel().database(), new File(string), JabRefFrame.this.prefs);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class CustomizeImportsAction
    extends MnemonicAwareAction {
        public CustomizeImportsAction() {
            this.putValue("Name", "Manage custom imports");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportCustomizationDialog importCustomizationDialog = new ImportCustomizationDialog(JabRefFrame.this.ths);
            importCustomizationDialog.setVisible(true);
        }
    }

    class CustomizeExportsAction
    extends MnemonicAwareAction {
        public CustomizeExportsAction() {
            this.putValue("Name", "Manage custom exports");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportCustomizationDialog exportCustomizationDialog = new ExportCustomizationDialog(JabRefFrame.this.ths);
            exportCustomizationDialog.setVisible(true);
        }
    }

    class EditAction
    extends MnemonicAwareAction {
        private String command;

        public EditAction(String string, URL uRL) {
            super(new ImageIcon(uRL));
            this.command = string;
            String string2 = Util.nCase(string);
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey(string2));
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = Globals.focusListener.getFocused();
            try {
                jComponent.getActionMap().get(this.command).actionPerformed(new ActionEvent(jComponent, 0, this.command));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class ChangeTabAction
    extends MnemonicAwareAction {
        private boolean next;

        public ChangeTabAction(boolean bl) {
            this.putValue("Name", bl ? "Next tab" : "Previous tab");
            this.next = bl;
            this.putValue("AcceleratorKey", bl ? JabRefFrame.this.prefs.getKey("Next tab") : JabRefFrame.this.prefs.getKey("Previous tab"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = JabRefFrame.this.tabbedPane.getSelectedIndex();
            int n3 = n = this.next ? n2 + 1 : n2 - 1;
            if (n < 0) {
                n = JabRefFrame.this.tabbedPane.getTabCount() - 1;
            }
            if (n == JabRefFrame.this.tabbedPane.getTabCount()) {
                n = 0;
            }
            JabRefFrame.this.tabbedPane.setSelectedIndex(n);
        }
    }

    class LoadSessionAction
    extends MnemonicAwareAction {
        boolean running;

        public LoadSessionAction() {
            super(GUIGlobals.getImage("loadSession"));
            this.running = false;
            this.putValue("Name", "Load session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Load session"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.prefs.get("savedSession") == null) {
                JabRefFrame.this.output(Globals.lang("No saved session found."));
                return;
            }
            if (this.running) {
                return;
            }
            this.running = true;
            JabRefFrame.this.output(Globals.lang("Loading session..."));
            new Thread(){

                public void run() {
                    int n;
                    HashSet<String> hashSet = new HashSet<String>();
                    if (((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                        for (n = 0; n < ((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.tabbedPane.getTabCount(); ++n) {
                            if (((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.baseAt((int)n).file == null) continue;
                            hashSet.add(((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.baseAt((int)n).file.getPath());
                        }
                    }
                    n = ((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.tabbedPane.getTabCount();
                    String[] stringArray = ((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.prefs.getStringArray("savedSession");
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file;
                        if (hashSet.contains(stringArray[i]) || !(file = new File(stringArray[i])).exists()) continue;
                        ((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.open.openIt(file, i == 0);
                    }
                    JabRefFrame.this.output(Globals.lang("Files opened") + ": " + (((LoadSessionAction)LoadSessionAction.this).JabRefFrame.this.tabbedPane.getTabCount() - n));
                    LoadSessionAction.this.running = false;
                }
            }.start();
        }
    }

    class CustomExportAction
    extends AbstractAction {
        String extension;
        String lfFileName;
        String directory;

        public CustomExportAction(String string, String string2, String string3) {
            super(string);
            File file = new File(string3);
            this.extension = string2;
            String string4 = file.getName();
            this.lfFileName = string4.substring(0, string4.length() - 7);
            this.directory = file.getParent() + File.separator;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Globals.getNewFile(JabRefFrame.this.ths, new File(JabRefFrame.this.prefs.get("workingDirectory")), this.extension, 1, false);
            if (string == null) {
                return;
            }
            File file = new File(string);
            final String string2 = this.lfFileName;
            final File file2 = file;
            new Thread(){

                public void run() {
                    try {
                        FileActions.exportDatabase(((CustomExportAction)CustomExportAction.this).JabRefFrame.this.basePanel().database, CustomExportAction.this.directory, string2, file2, JabRefFrame.this.basePanel().getEncoding());
                        JabRefFrame.this.output(Globals.lang("Exported database to file") + " '" + file2.getPath() + "'.");
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(((CustomExportAction)CustomExportAction.this).JabRefFrame.this.ths, exception.getMessage(), Globals.lang("Error"), 0);
                    }
                }
            }.start();
        }
    }

    class SaveSessionAction
    extends MnemonicAwareAction {
        public SaveSessionAction() {
            super(GUIGlobals.getImage("save"));
            this.putValue("Name", "Save session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Save session"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Vector<String> vector = new Vector<String>();
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    if (JabRefFrame.this.tabbedPane.getTitleAt(i).equals(GUIGlobals.untitledTitle)) {
                        JabRefFrame.this.tabbedPane.setSelectedIndex(i);
                        n = JOptionPane.showConfirmDialog(JabRefFrame.this.ths, Globals.lang("This untitled database must be saved first to be included in the saved session. Save now?"), Globals.lang("Save database"), 0);
                        if (n == 0) {
                            try {
                                JabRefFrame.this.basePanel().runCommand("save");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (JabRefFrame.this.baseAt((int)i).file == null) continue;
                    vector.add(JabRefFrame.this.baseAt((int)i).file.getPath());
                }
            }
            if (vector.size() == 0) {
                JabRefFrame.this.output(Globals.lang("Not saved (empty session)") + ".");
                return;
            }
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
            JabRefFrame.this.prefs.putStringArray("savedSession", stringArray);
            JabRefFrame.this.output(Globals.lang("Saved session") + ".");
        }
    }

    class ShowPrefsAction
    extends MnemonicAwareAction {
        public ShowPrefsAction() {
            super(GUIGlobals.getImage("preferences"));
            this.putValue("Name", "Preferences");
            this.putValue("ShortDescription", Globals.lang("Preferences"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFrame.this.preferences();
        }
    }

    class CiteSeerPanelAction
    extends MnemonicAwareAction {
        public CiteSeerPanelAction() {
            super(GUIGlobals.getImage("medline"));
            this.putValue("Name", "Fetch CiteSeer");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Fetch CiteSeer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                JabRefFrame.this.sidePaneManager.togglePanel("CiteSeerPanel");
                if (JabRefFrame.this.sidePaneManager.isPanelVisible("CiteSeerPanel")) {
                    new FocusRequester(JabRefFrame.this.citeSeerFetcherPanel.getTextField());
                }
            }
        }
    }

    class FetchMedlineAction
    extends MnemonicAwareAction {
        public FetchMedlineAction() {
            super(GUIGlobals.getImage("medline"));
            this.putValue("Name", "Fetch Medline");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Fetch Medline"));
            this.putValue("ShortDescription", Globals.lang("Fetch Medline by ID"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                JabRefFrame.this.sidePaneManager.togglePanel("fetchMedline");
                if (JabRefFrame.this.sidePaneManager.isPanelVisible("fetchMedline")) {
                    new FocusRequester(JabRefFrame.this.medlineFetcher.getTextField());
                }
            }
        }
    }

    class IntegrityCheckAction
    extends AbstractAction {
        public IntegrityCheckAction() {
            super(Globals.menuTitle("Integrity check"), GUIGlobals.getImage("integrityCheck"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasePanel basePanel;
            BibtexDatabase bibtexDatabase;
            Component component = JabRefFrame.this.tabbedPane.getSelectedComponent();
            if (component != null && (bibtexDatabase = (basePanel = (BasePanel)component).getDatabase()) != null) {
                IntegrityWizard integrityWizard = new IntegrityWizard(JabRefFrame.this.ths, JabRefFrame.this.basePanel());
                Util.placeDialog(integrityWizard, JabRefFrame.this.ths);
                integrityWizard.setVisible(true);
            }
        }
    }

    class NewSubDatabaseAction
    extends MnemonicAwareAction {
        public NewSubDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New subdatabase based on AUX file");
            this.putValue("ShortDescription", Globals.lang("New BibTeX subdatabase"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FromAuxDialog fromAuxDialog = new FromAuxDialog(JabRefFrame.this.ths, "", true, JabRefFrame.this.ths.tabbedPane);
            Util.placeDialog(fromAuxDialog, JabRefFrame.this.ths);
            fromAuxDialog.setVisible(true);
            if (fromAuxDialog.okPressed()) {
                BasePanel basePanel = new BasePanel(JabRefFrame.this.ths, fromAuxDialog.getGenerateDB(), null, null, Globals.prefs.get("defaultEncoding"));
                JabRefFrame.this.tabbedPane.add(Globals.lang(GUIGlobals.untitledTitle), basePanel);
                JabRefFrame.this.tabbedPane.setSelectedComponent(basePanel);
                if (JabRefFrame.this.tabbedPane.getTabCount() == 1) {
                    JabRefFrame.this.setNonEmptyState();
                }
                JabRefFrame.this.output(Globals.lang("New database created."));
            }
        }
    }

    class FetchCiteSeerAction
    extends MnemonicAwareAction {
        public FetchCiteSeerAction() {
            super(GUIGlobals.getImage("citeseer"));
            this.putValue("Name", "Fetch citations from CiteSeer");
            this.putValue("ShortDescription", Globals.lang("Fetch Articles Citing your Database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Fetch citations from CiteSeer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.citeSeerFetcher.activateCitationFetcher()) {
                JabRefFrame.this.sidePaneManager.ensureVisible("CiteSeerProgress");
                new Thread(){
                    BasePanel newBp;
                    BasePanel targetBp;
                    BibtexDatabase newDatabase;
                    BibtexDatabase targetDatabase;
                    Runnable updateComponent = new Runnable(){

                        private void setSortingByCitationCount() {
                            newBp.sortingByCiteSeerResults = true;
                        }

                        public void run() {
                            this.setSortingByCitationCount();
                            ((FetchCiteSeerAction)(this).FetchCiteSeerAction.this).JabRefFrame.this.tabbedPane.add(Globals.lang(GUIGlobals.untitledTitle), newBp);
                            ((FetchCiteSeerAction)(this).FetchCiteSeerAction.this).JabRefFrame.this.tabbedPane.setSelectedComponent(newBp);
                            JabRefFrame.this.output(Globals.lang("Fetched all citations from target database."));
                            ((FetchCiteSeerAction)(this).FetchCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.deactivateCitationFetcher();
                        }
                    };

                    public void run() {
                        try {
                            this.newBp = new BasePanel(((FetchCiteSeerAction)FetchCiteSeerAction.this).JabRefFrame.this.ths);
                            this.targetBp = (BasePanel)((FetchCiteSeerAction)FetchCiteSeerAction.this).JabRefFrame.this.tabbedPane.getSelectedComponent();
                            this.newDatabase = this.newBp.getDatabase();
                            this.targetDatabase = this.targetBp.getDatabase();
                            int n = ((FetchCiteSeerAction)FetchCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.populate(this.newDatabase, this.targetDatabase);
                            if (this.newDatabase.getEntryCount() > 0) {
                                SwingUtilities.invokeLater(this.updateComponent);
                            } else if (n == 0) {
                                SwingUtilities.invokeLater(((FetchCiteSeerAction)FetchCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.getEmptyFetchSetDialog());
                            } else {
                                ((FetchCiteSeerAction)FetchCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.deactivateCitationFetcher();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(JabRefFrame.this.tabbedPane.getSelectedComponent(), Globals.lang("A CiteSeer fetch operation is currently in progress.") + "  " + Globals.lang("Please wait until it has finished."), Globals.lang("CiteSeer Fetch Error"), 2);
            }
        }
    }

    class ImportCiteSeerAction
    extends MnemonicAwareAction {
        public ImportCiteSeerAction() {
            super(GUIGlobals.getImage("citeseer"));
            this.putValue("Name", "Import Fields from CiteSeer");
            this.putValue("ShortDescription", Globals.lang("Import Fields from CiteSeer Database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Import Fields from CiteSeer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.citeSeerFetcher.activateImportFetcher()) {
                new Thread(){
                    BasePanel currentBp;
                    BibtexEntry toShow;
                    int[] clickedOn = null;

                    public void run() {
                        this.currentBp = (BasePanel)((ImportCiteSeerAction)ImportCiteSeerAction.this).JabRefFrame.this.tabbedPane.getSelectedComponent();
                        int n = this.currentBp.mainTable.getSelectedRowCount();
                        if (n >= 1) {
                            this.clickedOn = this.currentBp.mainTable.getSelectedRows();
                        } else {
                            JOptionPane.showMessageDialog(this.currentBp.frame(), Globals.lang("You must select at least one row to perform this operation."), Globals.lang("CiteSeer Import Error"), 2);
                        }
                        this.toShow = (BibtexEntry)this.currentBp.mainTable.getSelected().get(0);
                        if (this.clickedOn != null) {
                            ((ImportCiteSeerAction)ImportCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.beginImportCiteSeerProgress();
                            NamedCompound namedCompound = new NamedCompound(Globals.lang("CiteSeer Import Fields"));
                            boolean bl = ((ImportCiteSeerAction)ImportCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.importCiteSeerEntries(this.clickedOn, namedCompound);
                            if (bl) {
                                namedCompound.end();
                                this.currentBp.undoManager.addEdit(namedCompound);
                            }
                            UpdateComponent updateComponent = new UpdateComponent(bl);
                            SwingUtilities.invokeLater(updateComponent);
                        }
                        ((ImportCiteSeerAction)ImportCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.deactivateImportFetcher();
                    }

                    class UpdateComponent
                    implements Runnable {
                        boolean changesMade;

                        UpdateComponent(boolean bl) {
                            this.changesMade = bl;
                        }

                        public void run() {
                            ((ImportCiteSeerAction)(this).ImportCiteSeerAction.this).JabRefFrame.this.citeSeerFetcher.endImportCiteSeerProgress();
                            if (this.changesMade) {
                                currentBp.markBaseChanged();
                            }
                            JabRefFrame.this.output(Globals.lang("Completed Import Fields from CiteSeer."));
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(JabRefFrame.this.tabbedPane.getSelectedComponent(), Globals.lang("A CiteSeer import operation is currently in progress.") + "  " + Globals.lang("Please wait until it has finished."), Globals.lang("CiteSeer Import Error"), 2);
            }
        }
    }

    class NewDatabaseAction
    extends MnemonicAwareAction {
        public NewDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New database");
            this.putValue("ShortDescription", Globals.lang("New BibTeX database"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BibtexDatabase bibtexDatabase = new BibtexDatabase();
            JabRefFrame.this.addTab(bibtexDatabase, null, null, Globals.prefs.get("defaultEncoding"), true);
            JabRefFrame.this.output(Globals.lang("New database created."));
        }
    }

    class CloseDatabaseAction
    extends MnemonicAwareAction {
        public CloseDatabaseAction() {
            super(GUIGlobals.getImage("close"));
            this.putValue("Name", "Close database");
            this.putValue("ShortDescription", Globals.lang("Close the current database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Close database"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            if (JabRefFrame.this.basePanel() == null) {
                return;
            }
            if (JabRefFrame.this.basePanel().baseChanged) {
                int n = JOptionPane.showConfirmDialog(JabRefFrame.this.ths, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                if (n == 2 || n == -1) {
                    bl = false;
                }
                if (n == 0) {
                    try {
                        JabRefFrame.this.basePanel().runCommand("save");
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                JabRefFrame.this.basePanel().cleanUp();
                JabRefFrame.this.tabbedPane.remove(JabRefFrame.this.basePanel());
                if (JabRefFrame.this.tabbedPane.getTabCount() == 0) {
                    JabRefFrame.this.setEmptyState();
                } else {
                    JabRefFrame.this.sidePaneManager.stateChanged(new ChangeEvent(JabRefFrame.this.tabbedPane));
                    JabRefFrame.this.markActiveBasePanel();
                    if (JabRefFrame.this.tabbedPane.getTabCount() == 1) {
                        JabRefFrame.this.setOnlyOne();
                    }
                }
                JabRefFrame.this.output(Globals.lang("Closed database") + ".");
                System.gc();
            }
        }
    }

    class CloseAction
    extends MnemonicAwareAction {
        public CloseAction() {
            this.putValue("Name", "Quit");
            this.putValue("ShortDescription", Globals.lang("Quit JabRef"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Quit JabRef"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFrame.this.quit();
        }
    }

    class SelectKeysAction
    extends AbstractAction {
        public SelectKeysAction() {
            super(Globals.lang("Customize key bindings"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyBindingsDialog keyBindingsDialog = new KeyBindingsDialog((HashMap)JabRefFrame.this.prefs.getKeyBindings().clone(), JabRefFrame.this.prefs.getDefaultKeys());
            keyBindingsDialog.setDefaultCloseOperation(3);
            keyBindingsDialog.pack();
            Util.placeDialog(keyBindingsDialog, JabRefFrame.this.ths);
            keyBindingsDialog.setVisible(true);
            if (keyBindingsDialog.getAction()) {
                JabRefFrame.this.prefs.setNewKeyBindings(keyBindingsDialog.getNewKeyBindings());
                JOptionPane.showMessageDialog(JabRefFrame.this.ths, Globals.lang("Your new key bindings have been stored.") + "\n" + Globals.lang("You must restart JabRef for the new key bindings to work properly."), Globals.lang("Key bindings changed"), 1);
            }
        }
    }

    private class JabRefLabel
    extends JPanel {
        private String label;

        public JabRefLabel(String string) {
            this.label = string;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(GUIGlobals.nullFieldColor);
            graphics2D.setFont(GUIGlobals.jabRefFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(this.label);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawString(this.label, this.getWidth() - n - 7, this.getHeight() - 10);
        }
    }

    class NewEntryAction
    extends MnemonicAwareAction {
        String type;
        KeyStroke keyStroke;

        public NewEntryAction(KeyStroke keyStroke) {
            super(GUIGlobals.getImage("add"));
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", "New entry");
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang("New BibTeX entry"));
        }

        public NewEntryAction(String string) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", Util.nCase(string));
            this.type = string;
        }

        public NewEntryAction(String string, KeyStroke keyStroke) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", Util.nCase(string));
            this.putValue("AcceleratorKey", keyStroke);
            this.type = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.type;
            if (string == null) {
                EntryTypeDialog entryTypeDialog = new EntryTypeDialog(JabRefFrame.this.ths);
                Util.placeDialog(entryTypeDialog, JabRefFrame.this.ths);
                entryTypeDialog.setVisible(true);
                BibtexEntryType bibtexEntryType = entryTypeDialog.getChoice();
                if (bibtexEntryType == null) {
                    return;
                }
                string = bibtexEntryType.getName();
            }
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).newEntry(BibtexEntryType.getType(string));
            } else {
                Util.pr("Action 'New entry' must be disabled when no database is open.");
            }
        }
    }

    class GeneralAction
    extends MnemonicAwareAction {
        private String command;

        public GeneralAction(String string, String string2, String string3, URL uRL) {
            super(new ImageIcon(uRL));
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2, String string3, String string4, KeyStroke keyStroke) {
            super(GUIGlobals.getImage(string4));
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2) {
            this.putValue("Name", string2);
            this.command = string;
        }

        public GeneralAction(String string, String string2, KeyStroke keyStroke) {
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", keyStroke);
        }

        public GeneralAction(String string, String string2, String string3) {
            this.command = string;
            ImageIcon imageIcon = GUIGlobals.getImage(string);
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
            }
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2, String string3, KeyStroke keyStroke) {
            this.command = string;
            ImageIcon imageIcon = GUIGlobals.getImage(string);
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
            }
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                try {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).runCommand(this.command);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                Util.pr("Action '" + this.command + "' must be disabled when no " + "database is open.");
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(Globals.lang("About JabRef"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFrame.this.about();
        }
    }

    class ToolBar
    extends JToolBar {
        ToolBar() {
        }

        void addAction(Action action) {
            JButton jButton = new JButton(action);
            jButton.setText(null);
            if (!Globals.ON_MAC) {
                jButton.setMargin(JabRefFrame.this.marg);
            }
            this.add(jButton);
        }
    }
}

