/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import gnu.dtools.ritopt.BooleanOption;
import gnu.dtools.ritopt.StringOption;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.SplashScreen;
import net.sf.jabref.Util;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.remote.RemoteListener;
import net.sf.jabref.wizard.auximport.AuxCommandLine;

public class JabRef {
    public static JabRef ths;
    public static RemoteListener remoteListener;
    public JabRefFrame jrf;
    public gnu.dtools.ritopt.Options options;
    public Frame splashScreen = null;
    boolean graphicFailure = false;
    StringOption importFile;
    StringOption exportFile;
    StringOption exportPrefs;
    StringOption importPrefs;
    StringOption auxImExport;
    StringOption importToOpenBase;
    BooleanOption helpO;
    BooleanOption disableGui;
    BooleanOption blank;
    BooleanOption loadSess;
    BooleanOption showVersion;

    public static void main(String[] stringArray) {
        new JabRef(stringArray);
    }

    public JabRef(String[] stringArray) {
        String string;
        JabRefPreferences jabRefPreferences;
        ths = this;
        Globals.prefs = jabRefPreferences = JabRefPreferences.getInstance();
        Globals.setLanguage(jabRefPreferences.get("language"), "");
        Globals.importFormatReader.resetImportFormats();
        BibtexEntryType.loadCustomEntryTypes(jabRefPreferences);
        Globals.initializeJournalNames();
        if (Globals.prefs.getBoolean("useRemoteServer")) {
            remoteListener = RemoteListener.openRemoteListener(this);
            if (remoteListener != null) {
                remoteListener.start();
            }
            if (remoteListener == null && RemoteListener.sendToActiveJabRefInstance(stringArray)) {
                System.out.println(Globals.lang("Arguments passed on to running JabRef instance. Shutting down."));
                System.exit(0);
            }
        }
        if ((string = jabRefPreferences.get("personalJournalList")) != null) {
            try {
                Globals.journalAbbrev.readJournalList(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        System.runFinalizersOnExit((boolean)true);
        Vector vector = this.processArguments(stringArray, true);
        this.openWindow(vector);
    }

    private void setupOptions() {
        this.importFile = new StringOption("");
        this.exportFile = new StringOption("");
        this.helpO = new BooleanOption();
        this.disableGui = new BooleanOption();
        this.blank = new BooleanOption();
        this.loadSess = new BooleanOption();
        this.showVersion = new BooleanOption();
        this.exportPrefs = new StringOption("jabref_prefs.xml");
        this.importPrefs = new StringOption("jabref_prefs.xml");
        this.auxImExport = new StringOption("");
        this.importToOpenBase = new StringOption("");
        this.options = new gnu.dtools.ritopt.Options("JabRef ");
        this.options.setVersion(GUIGlobals.version);
        this.importFile.setDescription("imopoepuoeu");
        this.options.register("version", 'v', Globals.lang("Display version"), this.showVersion);
        this.options.register("nogui", 'n', Globals.lang("No GUI. Only process command line options."), this.disableGui);
        this.options.register("import", 'i', Globals.lang("Import file") + ": " + Globals.lang("filename") + "[,import format]", this.importFile);
        this.options.register("output", 'o', Globals.lang("Output or export file") + ": " + Globals.lang("filename") + "[,export format]", this.exportFile);
        this.options.register("help", 'h', Globals.lang("Display help on command line options"), this.helpO);
        this.options.register("loads", 'l', Globals.lang("Load session"), this.loadSess);
        this.options.register("prexp", 'x', Globals.lang("Export preferences to file"), this.exportPrefs);
        this.options.register("primp", 'p', Globals.lang("Import preferences from file"), this.importPrefs);
        this.options.register("aux", 'a', Globals.lang("Subdatabase from aux") + ": " + Globals.lang("file") + "[.aux]" + "," + Globals.lang("new") + "[.bib]", this.auxImExport);
        this.options.register("blank", 'b', Globals.lang("Do not open any files at startup"), this.blank);
        this.options.register("importToOpen", '\u0000', Globals.lang("Import to open tab"), this.importToOpenBase);
        this.options.setUseMenu(false);
    }

    public Vector processArguments(String[] stringArray, boolean bl) {
        ParserResult parserResult;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        int n2;
        Object object6;
        Object object7;
        this.setupOptions();
        String[] stringArray2 = this.options.process(stringArray);
        if (bl && this.showVersion.isInvoked()) {
            this.options.displayVersion();
            this.disableGui.setInvoked(true);
        }
        if (bl && this.helpO.isInvoked()) {
            System.out.println("jabref [options] [bibtex-file]\n");
            System.out.println(this.options.getHelp());
            object7 = Globals.importFormatReader.getImportFormatList();
            System.out.println(Globals.lang("Available import formats") + ":\n" + (String)object7);
            object6 = ": bibtexml, docbook, endnote, harvard, html, mods, ods, oocalc, simplehtml";
            n2 = ((String)object6).length();
            for (n = 0; n < Globals.prefs.customExports.size(); ++n) {
                object5 = Globals.prefs.customExports.getElementAt(n);
                if (n2 + object5[0].length() > 50) {
                    object6 = (String)object6 + ",\n\t" + object5[0];
                    n2 = ((String)object5[0]).length();
                    continue;
                }
                object6 = (String)object6 + ", " + object5[0];
                n2 += 1 + ((String)object5[0]).length();
            }
            System.out.println(Globals.lang("Available export formats") + (String)object6 + ".");
            System.exit(0);
        }
        if (bl && !this.disableGui.isInvoked()) {
            try {
                this.splashScreen = SplashScreen.splash();
            }
            catch (Throwable throwable) {
                this.graphicFailure = true;
                System.err.println(Globals.lang("Unable to create graphical interface") + ".");
            }
        }
        object7 = new Vector();
        object6 = new Vector<String>();
        if (!this.blank.isInvoked() && stringArray2.length > 0) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n = stringArray2[n2].toLowerCase().endsWith("bib");
                object5 = null;
                if (n != 0) {
                    object5 = JabRef.openBibFile(stringArray2[n2]);
                }
                if (object5 == null || object5 == ParserResult.INVALID_FORMAT) {
                    if (bl) {
                        ((Vector)object6).add(stringArray2[n2]);
                        continue;
                    }
                    object4 = JabRef.importToOpenBase(stringArray2[n2]);
                    if (object4 == null) continue;
                    ((Vector)object7).add(object4);
                    continue;
                }
                ((Vector)object7).add(object5);
            }
        }
        if (!this.blank.isInvoked() && this.importFile.isInvoked()) {
            ((Vector)object6).add(this.importFile.getStringValue());
        }
        if (((Vector)object6).size() > 0) {
            for (n2 = 0; n2 < ((Vector)object6).size(); ++n2) {
                String[] stringArray3 = ((String)((Vector)object6).elementAt(n2)).split(",");
                try {
                    if (stringArray3.length > 1 && !"*".equals(stringArray3[1])) {
                        System.out.println(Globals.lang("Importing") + ": " + stringArray3[0]);
                        object5 = Globals.importFormatReader.importFromFile(stringArray3[1], stringArray3[0].replaceAll("~", System.getProperty("user.home")));
                        object4 = ImportFormatReader.createDatabase((List)object5);
                        object3 = new ParserResult((BibtexDatabase)object4, null, new HashMap());
                        ((Vector)object7).add(object3);
                        continue;
                    }
                    System.out.println(Globals.lang("Importing in unknown format") + ": " + stringArray3[0]);
                    object5 = Globals.importFormatReader.importUnknownFormat(stringArray3[0].replaceAll("~", System.getProperty("user.home")));
                    object4 = (String)object5[0];
                    if (object4 == null) {
                        System.err.println(Globals.lang("Error opening file") + " '" + stringArray3[0] + "'");
                        continue;
                    }
                    if (((String)object4).equals(ImportFormatReader.BIBTEX_FORMAT)) {
                        object3 = (ParserResult)object5[1];
                        ((Vector)object7).add(object3);
                        continue;
                    }
                    object3 = (List)object5[1];
                    if (object3 != null) {
                        System.out.println(Globals.lang("Format used") + ": " + (String)object4);
                    } else {
                        System.out.println(Globals.lang("Could not find a suitable import format."));
                    }
                    if (object3 == null) continue;
                    object2 = ImportFormatReader.createDatabase((List)object3);
                    object = new ParserResult((BibtexDatabase)object2, null, new HashMap());
                    ((Vector)object7).add(object);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println(Globals.lang("Error opening file") + " '" + stringArray3[0] + "': " + iOException.getMessage());
                }
            }
        }
        if (!this.blank.isInvoked() && this.importToOpenBase.isInvoked() && (parserResult = JabRef.importToOpenBase(this.importToOpenBase.getStringValue())) != null) {
            ((Vector)object7).add(parserResult);
        }
        if (this.exportFile.isInvoked()) {
            if (((Vector)object7).size() > 0) {
                String[] stringArray4 = this.exportFile.getStringValue().split(",");
                if (stringArray4.length == 1) {
                    if (((Vector)object7).size() > 0) {
                        ParserResult parserResult2 = (ParserResult)((Vector)object7).elementAt(((Vector)object7).size() - 1);
                        try {
                            System.out.println(Globals.lang("Saving") + ": " + stringArray4[0]);
                            object5 = FileActions.saveDatabase(parserResult2.getDatabase(), new MetaData(parserResult2.getMetaData(), parserResult2.getDatabase()), new File(stringArray4[0]), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"));
                            if (!((SaveSession)object5).getWriter().couldEncodeAll()) {
                                System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", ((SaveSession)object5).getEncoding()) + ((SaveSession)object5).getWriter().getProblemCharacters());
                            }
                            ((SaveSession)object5).commit();
                        }
                        catch (SaveException saveException) {
                            System.err.println(Globals.lang("Could not save file") + " '" + stringArray4[0] + "': " + saveException.getMessage());
                        }
                    } else {
                        System.err.println(Globals.lang("The output option depends on a valid import option."));
                    }
                } else if (stringArray4.length == 2) {
                    ParserResult parserResult3 = (ParserResult)((Vector)object7).elementAt(((Vector)object7).size() - 1);
                    boolean bl2 = false;
                    for (int i = 0; i < Globals.prefs.customExports.size(); ++i) {
                        object3 = Globals.prefs.customExports.getElementAt(i);
                        if (!object3[0].equals(stringArray4[1])) continue;
                        try {
                            object2 = new File(object3[1]);
                            object = ((File)object2).getName().split("\\.")[0];
                            FileActions.exportDatabase(parserResult3.getDatabase(), ((File)object2).getParent() + File.separator, (String)object, new File(stringArray4[0]), parserResult3.getEncoding());
                            System.out.println(Globals.lang("Exporting") + ": " + stringArray4[0]);
                        }
                        catch (Exception exception) {
                            System.err.println(Globals.lang("Could not export file") + " '" + stringArray4[0] + "': " + exception.getMessage());
                        }
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        try {
                            System.out.println(Globals.lang("Exporting") + ": " + stringArray4[0]);
                            FileActions.performExport(parserResult3.getDatabase(), stringArray4[1], stringArray4[0], parserResult3.getEncoding());
                        }
                        catch (NullPointerException nullPointerException) {
                            System.err.println(Globals.lang("Unknown export format") + ": " + stringArray4[1]);
                        }
                        catch (Exception exception) {
                            System.err.println(Globals.lang("Could not export file") + " '" + stringArray4[0] + "': " + exception.getMessage());
                        }
                    }
                }
            } else {
                System.err.println(Globals.lang("The output option depends on a valid import option."));
            }
        }
        if (this.exportPrefs.isInvoked()) {
            try {
                Globals.prefs.exportPreferences(this.exportPrefs.getStringValue());
            }
            catch (IOException iOException) {
                Util.pr(iOException.getMessage());
            }
        }
        if (this.importPrefs.isInvoked()) {
            try {
                Globals.prefs.importPreferences(this.importPrefs.getStringValue());
                BibtexEntryType.loadCustomEntryTypes(Globals.prefs);
            }
            catch (IOException iOException) {
                Util.pr(iOException.getMessage());
            }
        }
        if (!this.blank.isInvoked() && this.auxImExport.isInvoked()) {
            boolean bl3 = false;
            if (((Vector)object7).size() > 0) {
                String[] stringArray5 = this.auxImExport.getStringValue().split(",");
                if (stringArray5.length == 2) {
                    ParserResult parserResult4 = (ParserResult)((Vector)object7).firstElement();
                    AuxCommandLine auxCommandLine = new AuxCommandLine(stringArray5[0], parserResult4.getDatabase());
                    object3 = auxCommandLine.perform();
                    boolean bl4 = false;
                    if (object3 != null && ((BibtexDatabase)object3).getEntryCount() > 0) {
                        object = Util.getCorrectFileName(stringArray5[1], "bib");
                        try {
                            System.out.println(Globals.lang("Saving") + ": " + (String)object);
                            SaveSession saveSession = FileActions.saveDatabase((BibtexDatabase)object3, new MetaData(), new File((String)object), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"));
                            if (!saveSession.getWriter().couldEncodeAll()) {
                                System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", saveSession.getEncoding()) + saveSession.getWriter().getProblemCharacters());
                            }
                            saveSession.commit();
                        }
                        catch (SaveException saveException) {
                            System.err.println(Globals.lang("Could not save file") + " '" + (String)object + "': " + saveException.getMessage());
                        }
                        bl4 = true;
                    }
                    if (!bl4) {
                        System.out.println(Globals.lang("no database generated"));
                    }
                } else {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                System.out.println(Globals.lang("no base-bibtex-file specified"));
                System.out.println(Globals.lang("usage") + " :");
                System.out.println("jabref --aux infile[.aux],outfile[.bib] base-bibtex-file");
            }
        }
        return object7;
    }

    ParserResult importFiletypeUnknown(String string) {
        Object[] objectArray = Globals.importFormatReader.importUnknownFormat(string.replaceAll("~", System.getProperty("user.home")));
        String string2 = (String)objectArray[0];
        if (string2 == null) {
            System.err.println(Globals.lang("Error opening file") + " '" + string + "'");
        } else {
            if (string2.equals(ImportFormatReader.BIBTEX_FORMAT)) {
                ParserResult parserResult = (ParserResult)objectArray[1];
                return parserResult;
            }
            List list = (List)objectArray[1];
            if (list != null) {
                System.out.println(Globals.lang("Format used") + ": " + string2);
            } else {
                System.out.println(Globals.lang("Could not find a suitable import format."));
            }
            if (list != null) {
                BibtexDatabase bibtexDatabase = ImportFormatReader.createDatabase(list);
                ParserResult parserResult = new ParserResult(bibtexDatabase, null, new HashMap());
                return parserResult;
            }
        }
        return null;
    }

    public void openWindow(Vector vector) {
        if (!this.graphicFailure && !this.disableGui.isInvoked()) {
            Object object;
            Object object2;
            int n;
            Util.performCompatibilityUpdate();
            GUIGlobals.setUpIconTheme();
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            if (!Globals.ON_MAC) {
                FontPolicy fontPolicy;
                FontSet fontSet;
                int n2 = Globals.prefs.getInt("menuFontSize");
                n = Globals.prefs.getBoolean("overrideDefaultFonts");
                object2 = Globals.ON_WIN ? GUIGlobals.windowsDefaultLookAndFeel : GUIGlobals.linuxDefaultLookAndFeel;
                Object object3 = null;
                object3 = !Globals.prefs.getBoolean("useDefaultLookAndFeel") ? Globals.prefs.get("lookAndFeel") : object2;
                object = null;
                Object var7_14 = null;
                try {
                    var7_14 = object3 != null ? Class.forName((String)object3).newInstance() : Class.forName((String)object2).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        var7_14 = Class.forName((String)object2).newInstance();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (var7_14 != null) {
                    object = var7_14;
                }
                if (object != null && object instanceof Plastic3DLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new SkyBluer());
                    int n3 = GUIGlobals.getImage("open").getIconWidth();
                    Options.setDefaultIconSize(new Dimension(n3, n3));
                    if (n != 0) {
                        fontSet = FontSets.createDefaultFontSet(new Font("Tahoma", 0, n2), new Font("Tahoma", 0, n2), new Font("Tahoma", 1, n2));
                        fontPolicy = FontPolicies.createFixedPolicy(fontSet);
                        Plastic3DLookAndFeel.setFontPolicy(fontPolicy);
                    }
                } else if (object != null && object instanceof WindowsLookAndFeel) {
                    int n4 = GUIGlobals.getImage("open").getIconWidth();
                    Options.setDefaultIconSize(new Dimension(n4, n4));
                    if (n != 0) {
                        fontSet = FontSets.createDefaultFontSet(new Font("Tahoma", 0, n2), new Font("Tahoma", 0, n2), new Font("Tahoma", 1, n2));
                        fontPolicy = FontPolicies.createFixedPolicy(fontSet);
                        WindowsLookAndFeel.setFontPolicy(fontPolicy);
                    }
                }
                if (object != null) {
                    try {
                        UIManager.setLookAndFeel((LookAndFeel)object);
                        if (!Globals.ON_WIN) {
                            UIManager.put("SimpleInternalFrame.activeTitleBackground", GUIGlobals.gradientBlue);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        System.err.println("Trying to set system default Look&Feel...");
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                        }
                    }
                }
            }
            if (!this.blank.isInvoked() && Globals.prefs.getBoolean("openLastEdited") && Globals.prefs.get("lastEdited") != null) {
                String[] stringArray = Globals.prefs.getStringArray("lastEdited");
                block8: for (n = 0; n < stringArray.length; ++n) {
                    ParserResult parserResult;
                    object2 = new File(stringArray[n]);
                    for (int i = 0; i < vector.size(); ++i) {
                        object = (ParserResult)vector.elementAt(i);
                        if (((ParserResult)object).getFile() != null && ((ParserResult)object).getFile().equals(object2)) continue block8;
                    }
                    if (!((File)object2).exists() || (parserResult = JabRef.openBibFile(stringArray[n])) == null) continue;
                    if (parserResult == ParserResult.INVALID_FORMAT) {
                        System.out.println(Globals.lang("Error opening file") + " '" + ((File)object2).getPath() + "'");
                        continue;
                    }
                    vector.add(parserResult);
                }
            }
            GUIGlobals.init();
            GUIGlobals.CURRENTFONT = new Font(Globals.prefs.get("fontFamily"), Globals.prefs.getInt("fontStyle"), Globals.prefs.getInt("fontSize"));
            this.jrf = new JabRefFrame();
            boolean bl = true;
            if (vector.size() > 0) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    object2 = (ParserResult)iterator.next();
                    this.jrf.addTab(((ParserResult)object2).getDatabase(), ((ParserResult)object2).getFile(), ((ParserResult)object2).getMetaData(), ((ParserResult)object2).getEncoding(), bl);
                    bl = false;
                }
            }
            if (this.loadSess.isInvoked()) {
                this.jrf.loadSessionAction.actionPerformed(new ActionEvent(this.jrf, 0, ""));
            }
            if (this.splashScreen != null) {
                this.splashScreen.dispose();
                this.splashScreen = null;
            }
            this.jrf.setVisible(true);
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (ParserResult)vector.elementAt(i);
                if (!Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !((ParserResult)object2).hasWarnings()) continue;
                String[] stringArray = ((ParserResult)object2).warnings();
                object = new StringBuffer();
                for (int j = 0; j < stringArray.length; ++j) {
                    ((StringBuffer)object).append(j + 1).append(". ").append(stringArray[j]).append("\n");
                }
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).deleteCharAt(((StringBuffer)object).length() - 1);
                }
                this.jrf.showBaseAt(i);
                JOptionPane.showMessageDialog(this.jrf, ((StringBuffer)object).toString(), Globals.lang("Warnings"), 2);
            }
            if (vector.size() > 0) {
                this.jrf.tabbedPane.setSelectedIndex(0);
                new FocusRequester(((BasePanel)this.jrf.tabbedPane.getComponentAt((int)0)).mainTable);
            }
        } else {
            System.exit(0);
        }
    }

    public static ParserResult openBibFile(String string) {
        System.out.println(Globals.lang("Opening") + ": " + string);
        try {
            File file = new File(string);
            String string2 = Globals.prefs.get("defaultEncoding");
            ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, string2);
            if (parserResult == null) {
                return ParserResult.INVALID_FORMAT;
            }
            parserResult.setFile(file);
            if (parserResult.hasWarnings()) {
                String[] stringArray = parserResult.warnings();
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(Globals.lang("Warning") + ": " + stringArray[i]);
                }
            }
            return parserResult;
        }
        catch (Throwable throwable) {
            System.err.println(Globals.lang("Error opening file") + ": " + throwable.getMessage());
            return null;
        }
    }

    public static ParserResult importToOpenBase(String string) {
        String[] stringArray = string.split(",");
        try {
            if (stringArray.length > 1 && !"*".equals(stringArray[1])) {
                System.out.println(Globals.lang("Importing") + ": " + stringArray[0]);
                List list = Globals.importFormatReader.importFromFile(stringArray[1], stringArray[0].replaceAll("~", System.getProperty("user.home")));
                BibtexDatabase bibtexDatabase = ImportFormatReader.createDatabase(list);
                ParserResult parserResult = new ParserResult(bibtexDatabase, null, new HashMap());
                parserResult.setToOpenTab(true);
                return parserResult;
            }
            System.out.println(Globals.lang("Importing in unknown format") + ": " + stringArray[0]);
            Object[] objectArray = Globals.importFormatReader.importUnknownFormat(stringArray[0].replaceAll("~", System.getProperty("user.home")));
            String string2 = (String)objectArray[0];
            if (string2.equals(ImportFormatReader.BIBTEX_FORMAT)) {
                ParserResult parserResult = (ParserResult)objectArray[1];
                parserResult.setToOpenTab(true);
                return parserResult;
            }
            List list = (List)objectArray[1];
            if (list != null) {
                System.out.println(Globals.lang("Format used") + ": " + string2);
            } else {
                System.out.println(Globals.lang("Could not find a suitable import format."));
            }
            if (list != null) {
                BibtexDatabase bibtexDatabase = ImportFormatReader.createDatabase(list);
                ParserResult parserResult = new ParserResult(bibtexDatabase, null, new HashMap());
                parserResult.setToOpenTab(true);
                return parserResult;
            }
        }
        catch (IOException iOException) {
            System.err.println(Globals.lang("Error opening file") + " '" + stringArray[0] + "': " + iOException.getMessage());
        }
        return null;
    }

    static {
        remoteListener = null;
    }
}

