/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRefPreferences;

public class IncrementalSearcher {
    JabRefPreferences prefs;
    private String hitInField;

    public IncrementalSearcher(JabRefPreferences jabRefPreferences) {
        this.prefs = jabRefPreferences;
    }

    public String getField() {
        return this.hitInField;
    }

    public boolean search(String string, BibtexEntry bibtexEntry) {
        this.hitInField = null;
        Object[] objectArray = bibtexEntry.getAllFields();
        return this.searchFields(objectArray, bibtexEntry, string);
    }

    protected boolean searchFields(Object[] objectArray, BibtexEntry bibtexEntry, String string) {
        boolean bl = false;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    if (bibtexEntry.getField(objectArray[i].toString()) == null) continue;
                    if (this.prefs.getBoolean("caseSensitiveSearch")) {
                        if (bibtexEntry.getField(objectArray[i].toString()).toString().indexOf(string) > -1) {
                            bl = true;
                        }
                    } else if (bibtexEntry.getField(objectArray[i].toString()).toString().toLowerCase().indexOf(string.toLowerCase()) > -1) {
                        bl = true;
                    }
                    if (!bl) continue;
                    this.hitInField = objectArray[i].toString();
                    return true;
                }
                catch (Throwable throwable) {
                    System.err.println("Searching error: " + throwable);
                }
            }
        }
        return false;
    }
}

