/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpContent;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private JabRefFrame frame;
    private HelpContent content;
    private BackAction back = new BackAction();
    private ForwardAction forward = new ForwardAction();
    private ContentsAction contents = new ContentsAction();

    public HelpDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("JabRef help"), false);
        this.frame = jabRefFrame;
        this.content = new HelpContent(jabRefFrame.prefs);
        this.content.addHyperlinkListener(this);
        this.setSize(GUIGlobals.helpSize);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.back);
        jToolBar.add(this.forward);
        jToolBar.addSeparator();
        jToolBar.add(this.contents);
        jToolBar.setFloatable(false);
        InputMap inputMap = jToolBar.getInputMap(2);
        ActionMap actionMap = jToolBar.getActionMap();
        inputMap.put(jabRefFrame.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", new CloseAction());
        inputMap.put(jabRefFrame.prefs.getKey("Back, help dialog"), "left");
        actionMap.put("left", this.back);
        inputMap.put(jabRefFrame.prefs.getKey("Forward, help dialog"), "right");
        actionMap.put("right", this.forward);
        inputMap = this.content.getInputMap(0);
        actionMap = this.content.getActionMap();
        inputMap.put(jabRefFrame.prefs.getKey("Back, help dialog"), "left");
        actionMap.put("left", this.back);
        inputMap.put(jabRefFrame.prefs.getKey("Forward, help dialog"), "right");
        actionMap.put("right", this.forward);
        this.getContentPane().add((Component)jToolBar, "North");
        this.getContentPane().add(this.content.getPane());
        this.forward.setEnabled(false);
        this.back.setEnabled(false);
    }

    public void showPage(String string) {
        if (!this.isVisible()) {
            Util.placeDialog(this, this.frame);
            this.setVisible(true);
            this.content.reset();
            this.forward.setEnabled(false);
            this.back.setEnabled(false);
        } else {
            this.setVisible(true);
            this.forward.setEnabled(false);
            this.back.setEnabled(true);
        }
        this.content.setPage(string);
        this.content.requestFocus();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.content.setPage(hyperlinkEvent.getURL());
            this.back.setEnabled(true);
            this.forward.setEnabled(false);
        }
    }

    class ContentsAction
    extends AbstractAction {
        public ContentsAction() {
            super("Contents", GUIGlobals.getImage("helpContents"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog.this.content.setPage(GUIGlobals.helpContents);
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward", GUIGlobals.getImage("right"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(HelpDialog.this.content.forward());
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back", GUIGlobals.getImage("left"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(HelpDialog.this.content.back());
            HelpDialog.this.forward.setEnabled(true);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close"));
            this.putValue("ShortDescription", Globals.lang("Close the help window"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog.this.dispose();
        }
    }
}

