/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;

public class HelpContent
extends JTextPane {
    JScrollPane pane = new JScrollPane(this, 20, 31);
    private Stack history;
    private Stack forw;
    JabRefPreferences prefs;

    public HelpContent(JabRefPreferences jabRefPreferences) {
        this.prefs = jabRefPreferences;
        this.history = new Stack();
        this.forw = new Stack();
        this.setEditorKitForContentType("text/html", new MyEditorKit());
        this.setContentType("text/html");
        this.setText("");
        this.setEditable(false);
    }

    public boolean back() {
        if (!this.history.empty()) {
            URL uRL = (URL)this.history.pop();
            this.forw.push(this.getPage());
            this.setPageOnly(uRL);
        }
        return !this.history.empty();
    }

    public boolean forward() {
        if (!this.forw.empty()) {
            URL uRL = (URL)this.forw.pop();
            this.history.push(this.getPage());
            this.setPageOnly(uRL);
        }
        return !this.forw.empty();
    }

    public void reset() {
        this.forw.removeAllElements();
        this.history.removeAllElements();
    }

    public void setPage(String string) {
        String string2 = this.prefs.get("language") + "/";
        if (string2.equals("en/")) {
            string2 = "";
        }
        URL uRL = this.getPage();
        URL uRL2 = JabRef.class.getResource(GUIGlobals.helpPre + string2 + string);
        try {
            super.setPage(uRL2);
        }
        catch (IOException iOException) {
            URL uRL3 = HelpContent.class.getResource(GUIGlobals.helpPre + string);
            this.setPageOnly(uRL3);
            this.forw.removeAllElements();
            if (uRL != null) {
                this.history.push(uRL);
            }
            return;
        }
        this.forw.removeAllElements();
        if (uRL != null) {
            this.history.push(uRL);
        }
    }

    public void setPage(URL uRL) {
        File file = new File(uRL.getPath());
        this.setPage(file.getName());
    }

    private void setPageOnly(URL uRL) {
        try {
            super.setPage(uRL);
        }
        catch (IOException iOException) {
            System.out.println("Error: could not read help file: '" + uRL.getFile() + "'");
        }
    }

    public JComponent getPane() {
        return this.pane;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(graphics2D);
    }

    public class MyEditorKit
    extends HTMLEditorKit {
        private Action[] myActions;

        public Action[] getActions() {
            if (this.myActions == null) {
                Action[] actionArray = super.getActions();
                Action[] actionArray2 = new Action[2];
                for (int i = 0; i < actionArray.length; ++i) {
                    Action action = actionArray[i];
                    String string = (String)action.getValue("Name");
                    if (string.equals("caret-up")) {
                        actionArray2[0] = new MyNextVisualPositionAction(actionArray[i], 1);
                        continue;
                    }
                    if (!string.equals("caret-down")) continue;
                    actionArray2[1] = new MyNextVisualPositionAction(actionArray[i], 5);
                }
                this.myActions = TextAction.augmentList(actionArray, actionArray2);
            }
            return this.myActions;
        }
    }

    public class MyNextVisualPositionAction
    extends TextAction {
        private Action textActn;
        private int direction;

        private MyNextVisualPositionAction(Action action, int n) {
            super((String)action.getValue("Name"));
            this.textActn = action;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)jTextComponent.getParent();
                Point point = jViewport.getViewPosition();
                if (this.direction == 1) {
                    jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
                } else {
                    point.y += jViewport.getExtentSize().height;
                    jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
                }
            }
            this.textActn.actionPerformed(actionEvent);
        }
    }
}

