/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class GeneralTab
extends JPanel
implements PrefsTab {
    private JCheckBox autoOpenForm;
    private JCheckBox backup;
    private JCheckBox openLast;
    private JCheckBox showSource;
    private JCheckBox defSource;
    private JCheckBox editSource;
    private JCheckBox defSort;
    private JCheckBox ctrlClick;
    private JCheckBox disableOnMultiple;
    private JCheckBox useOwner;
    private JCheckBox keyDuplicateWarningDialog;
    private JCheckBox keyEmptyWarningDialog;
    private JCheckBox autoDoubleBraces;
    private JCheckBox confirmDelete;
    private JCheckBox allowEditing;
    private JCheckBox useImportInspector;
    private JCheckBox useImportInspectorForSingle;
    private JCheckBox inspectionWarnDupli;
    private JCheckBox useTimeStamp;
    private JRadioButton saveOriginalOrder;
    private JRadioButton saveAuthorOrder;
    private JRadioButton saveTableOrder;
    private JTextField defOwnerField;
    private JTextField timeStampFormat;
    private JTextField timeStampField;
    private JTextField bracesAroundCapitalsFields;
    private JTextField nonWrappableFields;
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    private JComboBox language = new JComboBox<Object>(GUIGlobals.LANGUAGES.keySet().toArray());
    private JComboBox encodings = new JComboBox<String>(Globals.ENCODINGS);
    private HelpAction ownerHelp;
    private HelpAction timeStampHelp;

    public GeneralTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this._frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        this.autoOpenForm = new JCheckBox(Globals.lang("Open editor when a new entry is created"));
        this.openLast = new JCheckBox(Globals.lang("Open last edited databases at startup"));
        this.allowEditing = new JCheckBox(Globals.lang("Allow editing in table cells"));
        this.backup = new JCheckBox(Globals.lang("Backup old file when saving"));
        this.defSource = new JCheckBox(Globals.lang("Show BibTeX source by default"));
        this.showSource = new JCheckBox(Globals.lang("Show BibTeX source panel"));
        this.editSource = new JCheckBox(Globals.lang("Enable source editing"));
        this.defSort = new JCheckBox(Globals.lang("Sort Automatically"));
        this.ctrlClick = new JCheckBox(Globals.lang("Open right-click menu with Ctrl+left button"));
        this.disableOnMultiple = new JCheckBox(Globals.lang("Disable entry editor when multiple entries are selected"));
        this.useOwner = new JCheckBox(Globals.lang("Mark new entries with owner name") + ":");
        this.useTimeStamp = new JCheckBox(Globals.lang("Mark new entries with addition date") + ". " + Globals.lang("Date format") + ":");
        this.keyDuplicateWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when a duplicate BibTeX key is entered"));
        this.keyEmptyWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when an empty BibTeX key is entered"));
        this.confirmDelete = new JCheckBox(Globals.lang("Show confirmation dialog when deleting entries"));
        this.saveAuthorOrder = new JRadioButton(Globals.lang("Save ordered by author/editor/year"));
        this.saveOriginalOrder = new JRadioButton(Globals.lang("Save entries in their original order"));
        this.saveTableOrder = new JRadioButton(Globals.lang("Save in default table sort order"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.saveAuthorOrder);
        buttonGroup.add(this.saveOriginalOrder);
        buttonGroup.add(this.saveTableOrder);
        this.autoDoubleBraces = new JCheckBox(Globals.lang("Remove double braces around BibTeX fields when loading."));
        this.useImportInspector = new JCheckBox(Globals.lang("Display imported entries in an inspection window before they are added."));
        this.useImportInspectorForSingle = new JCheckBox(Globals.lang("Use inspection window also when a single entry is imported."));
        JPanel jPanel = new JPanel();
        this.defOwnerField = new JTextField();
        this.timeStampFormat = new JTextField();
        this.timeStampField = new JTextField();
        this.ownerHelp = new HelpAction(jabRefFrame.helpDiag, GUIGlobals.ownerHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.timeStampHelp = new HelpAction(jabRefFrame.helpDiag, GUIGlobals.timeStampHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.inspectionWarnDupli = new JCheckBox(Globals.lang("Warn about unresolved duplicates when closing inspection window"));
        Insets insets = new Insets(0, 12, 3, 0);
        this.useImportInspectorForSingle.setMargin(insets);
        this.editSource.setMargin(insets);
        this.defSource.setMargin(insets);
        this.inspectionWarnDupli.setMargin(insets);
        this.bracesAroundCapitalsFields = new JTextField(25);
        this.nonWrappableFields = new JTextField(25);
        this.showSource.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GeneralTab.this.defSource.setEnabled(GeneralTab.this.showSource.isSelected());
                GeneralTab.this.editSource.setEnabled(GeneralTab.this.showSource.isSelected());
            }
        });
        this.useImportInspector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GeneralTab.this.useImportInspectorForSingle.setEnabled(GeneralTab.this.useImportInspector.isSelected());
                GeneralTab.this.inspectionWarnDupli.setEnabled(GeneralTab.this.useImportInspector.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("8dlu, left:pref, 8dlu, fill:pref, 4dlu, fill:pref", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(Globals.lang("File"), cellConstraints.xyw(1, 1, 5));
        defaultFormBuilder.add((Component)this.openLast, cellConstraints.xy(2, 3));
        defaultFormBuilder.add((Component)this.backup, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.autoDoubleBraces, cellConstraints.xy(2, 7));
        defaultFormBuilder.add((Component)this.saveAuthorOrder, cellConstraints.xy(4, 3));
        defaultFormBuilder.add((Component)this.saveTableOrder, cellConstraints.xy(4, 5));
        defaultFormBuilder.add((Component)this.saveOriginalOrder, cellConstraints.xy(4, 7));
        JLabel jLabel = new JLabel(Globals.lang("Store the following fields with braces around capital letters") + ":");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.bracesAroundCapitalsFields);
        jLabel = new JLabel(Globals.lang("Do not wrap the following fields when saving") + ":");
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.nonWrappableFields);
        defaultFormBuilder.add((Component)defaultFormBuilder2.getPanel(), cellConstraints.xyw(2, 9, 3));
        defaultFormBuilder.addSeparator(Globals.lang("Entry editor"), cellConstraints.xyw(1, 11, 5));
        defaultFormBuilder.add((Component)this.autoOpenForm, cellConstraints.xy(2, 13));
        defaultFormBuilder.add((Component)this.disableOnMultiple, cellConstraints.xy(2, 15));
        defaultFormBuilder.add((Component)this.showSource, cellConstraints.xy(2, 17));
        defaultFormBuilder.add((Component)this.defSource, cellConstraints.xy(2, 19));
        defaultFormBuilder.addSeparator(Globals.lang("Miscellaneous"), cellConstraints.xyw(1, 21, 5));
        defaultFormBuilder.add((Component)this.useImportInspector, cellConstraints.xy(2, 23));
        defaultFormBuilder.add((Component)this.useImportInspectorForSingle, cellConstraints.xy(2, 25));
        defaultFormBuilder.add((Component)this.inspectionWarnDupli, cellConstraints.xy(2, 27));
        defaultFormBuilder.add((Component)this.ctrlClick, cellConstraints.xy(2, 29));
        defaultFormBuilder.add((Component)this.confirmDelete, cellConstraints.xy(2, 31));
        defaultFormBuilder.add((Component)this.keyDuplicateWarningDialog, cellConstraints.xy(2, 33));
        defaultFormBuilder.add((Component)this.keyEmptyWarningDialog, cellConstraints.xy(2, 35));
        FormLayout formLayout2 = new FormLayout("left:pref, 8dlu, fill:60dlu, 4dlu, left:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder3 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder3.append(this.useOwner);
        defaultFormBuilder3.append(this.defOwnerField);
        JButton jButton = new JButton(this.ownerHelp);
        jButton.setText(null);
        jButton.setPreferredSize(new Dimension(24, 24));
        defaultFormBuilder3.append(jButton);
        defaultFormBuilder3.nextLine();
        defaultFormBuilder3.append(this.useTimeStamp);
        defaultFormBuilder3.append(this.timeStampFormat);
        defaultFormBuilder3.append(Globals.lang("Field name") + ":");
        defaultFormBuilder3.append(this.timeStampField);
        jButton = new JButton(this.timeStampHelp);
        jButton.setText(null);
        jButton.setPreferredSize(new Dimension(24, 24));
        defaultFormBuilder3.append(jButton);
        defaultFormBuilder3.nextLine();
        JLabel jLabel2 = new JLabel(Globals.lang("Language") + ":");
        defaultFormBuilder3.append(jLabel2);
        defaultFormBuilder3.append(this.language);
        defaultFormBuilder3.nextLine();
        jLabel2 = new JLabel(Globals.lang("Default encoding") + ":");
        defaultFormBuilder3.append(jLabel2);
        defaultFormBuilder3.append(this.encodings);
        defaultFormBuilder.add((Component)defaultFormBuilder3.getPanel(), cellConstraints.xyw(2, 37, 3));
        JPanel jPanel2 = defaultFormBuilder.getPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel2, "Center");
    }

    public void setValues() {
        this.autoOpenForm.setSelected(this._prefs.getBoolean("autoOpenForm"));
        this.openLast.setSelected(this._prefs.getBoolean("openLastEdited"));
        this.allowEditing.setSelected(this._prefs.getBoolean("allowTableEditing"));
        this.backup.setSelected(this._prefs.getBoolean("backup"));
        this.defSource.setSelected(this._prefs.getBoolean("defaultShowSource"));
        this.showSource.setSelected(this._prefs.getBoolean("showSource"));
        this.editSource.setSelected(this._prefs.getBoolean("enableSourceEditing"));
        this.defSort.setSelected(this._prefs.getBoolean("defaultAutoSort"));
        this.ctrlClick.setSelected(this._prefs.getBoolean("ctrlClick"));
        this.disableOnMultiple.setSelected(this._prefs.getBoolean("disableOnMultipleSelection"));
        this.useOwner.setSelected(this._prefs.getBoolean("useOwner"));
        this.useTimeStamp.setSelected(this._prefs.getBoolean("useTimeStamp"));
        this.keyDuplicateWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForDuplicateKey"));
        this.keyEmptyWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForEmptyKey"));
        this.confirmDelete.setSelected(this._prefs.getBoolean("confirmDelete"));
        if (this._prefs.getBoolean("saveInStandardOrder")) {
            this.saveAuthorOrder.setSelected(true);
        } else if (this._prefs.getBoolean("saveInOriginalOrder")) {
            this.saveOriginalOrder.setSelected(true);
        } else {
            this.saveTableOrder.setSelected(true);
        }
        this.autoDoubleBraces.setSelected(this._prefs.getBoolean("autoDoubleBraces"));
        this.defOwnerField.setText(this._prefs.get("defaultOwner"));
        this.timeStampFormat.setText(this._prefs.get("timeStampFormat"));
        this.timeStampField.setText(this._prefs.get("timeStampField"));
        this.useImportInspector.setSelected(this._prefs.getBoolean("useImportInspectionDialog"));
        this.useImportInspectorForSingle.setSelected(this._prefs.getBoolean("useImportInspectionDialogForSingle"));
        this.inspectionWarnDupli.setSelected(this._prefs.getBoolean("warnAboutDuplicatesInInspection"));
        this.defSource.setEnabled(this.showSource.isSelected());
        this.editSource.setEnabled(this.showSource.isSelected());
        this.useImportInspectorForSingle.setEnabled(this.useImportInspector.isSelected());
        this.inspectionWarnDupli.setEnabled(this.useImportInspector.isSelected());
        this.bracesAroundCapitalsFields.setText(this._prefs.get("putBracesAroundCapitals"));
        this.nonWrappableFields.setText(this._prefs.get("nonWrappableFields"));
        String string = this._prefs.get("defaultEncoding");
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            if (!Globals.ENCODINGS[i].equalsIgnoreCase(string)) continue;
            this.encodings.setSelectedIndex(i);
            break;
        }
        String string2 = this._prefs.get("language");
        int n = 0;
        Iterator iterator = GUIGlobals.LANGUAGES.keySet().iterator();
        while (iterator.hasNext()) {
            if (GUIGlobals.LANGUAGES.get(iterator.next()).equals(string2)) {
                this.language.setSelectedIndex(n);
            }
            ++n;
        }
    }

    public void storeSettings() {
        this._prefs.putBoolean("autoOpenForm", this.autoOpenForm.isSelected());
        this._prefs.putBoolean("backup", this.backup.isSelected());
        this._prefs.putBoolean("openLastEdited", this.openLast.isSelected());
        this._prefs.putBoolean("defaultShowSource", this.defSource.isSelected());
        this._prefs.putBoolean("enableSourceEditing", this.editSource.isSelected());
        this._prefs.putBoolean("disableOnMultipleSelection", this.disableOnMultiple.isSelected());
        this._prefs.putBoolean("useOwner", this.useOwner.isSelected());
        this._prefs.putBoolean("useTimeStamp", this.useTimeStamp.isSelected());
        this._prefs.putBoolean("dialogWarningForDuplicateKey", this.keyDuplicateWarningDialog.isSelected());
        this._prefs.putBoolean("dialogWarningForEmptyKey", this.keyEmptyWarningDialog.isSelected());
        this._prefs.putBoolean("confirmDelete", this.confirmDelete.isSelected());
        this._prefs.putBoolean("saveInStandardOrder", this.saveAuthorOrder.isSelected());
        this._prefs.putBoolean("saveInOriginalOrder", this.saveOriginalOrder.isSelected());
        this._prefs.putBoolean("allowTableEditing", this.allowEditing.isSelected());
        this._prefs.putBoolean("ctrlClick", this.ctrlClick.isSelected());
        this._prefs.putBoolean("autoDoubleBraces", this.autoDoubleBraces.isSelected());
        this._prefs.putBoolean("useImportInspectionDialog", this.useImportInspector.isSelected());
        this._prefs.putBoolean("useImportInspectionDialogForSingle", this.useImportInspectorForSingle.isSelected());
        this._prefs.putBoolean("warnAboutDuplicatesInInspection", this.inspectionWarnDupli.isSelected());
        String string = this.defOwnerField.getText().trim();
        this._prefs.put("defaultOwner", string);
        this._prefs.WRAPPED_USERNAME = "[" + string + "]";
        this._prefs.put("timeStampFormat", this.timeStampFormat.getText().trim());
        this._prefs.put("timeStampField", this.timeStampField.getText().trim());
        this._prefs.put("defaultEncoding", (String)this.encodings.getSelectedItem());
        boolean bl = false;
        if (!this.bracesAroundCapitalsFields.getText().trim().equals(this._prefs.get("putBracesAroundCapitals"))) {
            this._prefs.put("putBracesAroundCapitals", this.bracesAroundCapitalsFields.getText());
            bl = true;
        }
        if (!this.nonWrappableFields.getText().trim().equals(this._prefs.get("nonWrappableFields"))) {
            this._prefs.put("nonWrappableFields", this.nonWrappableFields.getText());
            bl = true;
        }
        if (bl) {
            this._prefs.updateSpecialFieldHandling();
        }
        boolean bl2 = this._prefs.getBoolean("showSource");
        this._prefs.putBoolean("showSource", this.showSource.isSelected());
        if (bl2 != this.showSource.isSelected()) {
            for (int i = 0; i < this._frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel basePanel = (BasePanel)this._frame.getTabbedPane().getComponentAt(i);
                basePanel.entryEditors.clear();
            }
        }
        if (!GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).equals(this._prefs.get("language"))) {
            this._prefs.put("language", GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString());
            Globals.setLanguage(GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString(), "");
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the language setting. You must restart JabRef for this to come into effect."), Globals.lang("Changed language settings"), 2);
        }
    }

    public boolean readyToClose() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.timeStampFormat.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, Globals.lang("The chosen date format for new entries is not valid"), Globals.lang("Invalid date format"), 0);
            return false;
        }
        return true;
    }
}

