/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;

public class GUIGlobals {
    static int teller = 0;
    public static String frameTitle = "JabRef";
    public static String version = Globals.VERSION;
    public static String stringsTitle = "Strings for database";
    public static String untitledTitle = "untitled";
    public static String helpTitle = "JabRef help";
    public static String TYPE_HEADER = "entrytype";
    public static String NUMBER_COL = "#";
    public static String encPrefix = "Encoding: ";
    public static String linuxDefaultLookAndFeel = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static String windowsDefaultLookAndFeel = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    public static Font CURRENTFONT;
    public static Font typeNameFont;
    public static Font jabRefFont;
    public static Font fieldNameFont;
    public static final String SIGNATURE = "This file was created with JabRef";
    static Dimension helpSize;
    static Dimension aboutSize;
    static Dimension searchPaneSize;
    static Dimension searchFieldSize;
    public static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    public static final int SPLIT_PANE_DIVIDER_LOCATION = 145;
    public static final int TABLE_ROW_PADDING = 4;
    public static final int KEYBIND_COL_0 = 200;
    public static final int KEYBIND_COL_1 = 80;
    public static final int PREVIEW_PANEL_PADDING = 15;
    public static final int PREVIEW_PANEL_HEIGHT = 200;
    public static final int MAX_CONTENT_SELECTOR_WIDTH = 240;
    public static final double VERTICAL_DIVIDER_LOCATION = 0.4;
    public static String backupExt;
    public static String tempExt;
    public static String defaultDir;
    public static String imageSize;
    public static String extension;
    public static String ex;
    public static String pre;
    public static String helpPre;
    public static String fontPath;
    static HashMap tableIcons;
    public static Color activeEditor;
    static HashMap iconMap;
    public static String baseFrameHelp;
    public static String entryEditorHelp;
    public static String stringEditorHelp;
    public static String helpContents;
    public static String searchHelp;
    public static String groupsHelp;
    public static String customEntriesHelp;
    public static String contentSelectorHelp;
    public static String labelPatternHelp;
    public static String ownerHelp;
    public static String timeStampHelp;
    public static String pdfHelp;
    public static String exportCustomizationHelp;
    public static String importCustomizationHelp;
    public static String medlineHelp;
    public static String citeSeerHelp;
    public static String generalFieldsHelp;
    public static String aboutPage;
    public static String shortPlainImport;
    public static String importInspectionHelp;
    public static String shortIntegrityCheck;
    public static String shortAuxImport;
    public static String remoteHelp;
    public static String journalAbbrHelp;
    public static Color lightGray;
    public static Color validFieldColor;
    public static Color nullFieldColor;
    public static Color invalidFieldColor;
    public static Color validFieldBackground;
    public static Color invalidFieldBackground;
    public static Color gradientGray;
    public static Color gradientBlue;
    public static Color activeTabbed;
    public static Color inActiveTabbed;
    public static Color infoField;
    public static String META_FLAG;
    public static String META_FLAG_OLD;
    public static String ENTRYTYPE_FLAG;
    public static final double DEFAULT_FIELD_WEIGHT = 1.0;
    public static final double MAX_FIELD_WEIGHT = 2.0;
    public static final double SMALL_W = 0.3;
    public static final double MEDIUM_W = 0.5;
    public static final double LARGE_W = 1.5;
    public static final double PE_HEIGHT = 2.0;
    public static int[] FORM_WIDTH;
    public static int[] FORM_HEIGHT;
    public static final int INDENT = 4;
    public static final int LINE_LENGTH = 65;
    public static int DEFAULT_FIELD_LENGTH;
    public static int NUMBER_COL_LENGTH;
    public static int WIDTH_ICON_COL;
    public static final int EXPORT_DIALOG_COL_0_WIDTH = 50;
    public static final int EXPORT_DIALOG_COL_1_WIDTH = 200;
    public static final int EXPORT_DIALOG_COL_2_WIDTH = 30;
    public static final int IMPORT_DIALOG_COL_0_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_1_WIDTH = 80;
    public static final int IMPORT_DIALOG_COL_2_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_3_WIDTH = 200;
    public static final Map LANGUAGES;

    public static JLabel getTableIcon(String string) {
        Object v = tableIcons.get(string);
        if (v == null) {
            Globals.logger("Error: no table icon defined for type '" + string + "'.");
            return null;
        }
        return (JLabel)v;
    }

    public static void setUpIconTheme() {
        block7: {
            String string;
            URL uRL;
            String string2;
            String string3 = string2 = "/images/crystal_16/";
            URL uRL2 = uRL = GUIGlobals.class.getResource(string3 + "Icons.properties");
            if (Globals.prefs.getBoolean("useCustomIconTheme") && (string = Globals.prefs.get("customIconThemeFile")) != null) {
                try {
                    File file = new File(string);
                    String string4 = file.getParentFile().getAbsolutePath();
                    string3 = "file://" + string4 + System.getProperty("file.separator");
                    uRL2 = new URL("file://" + file.getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            try {
                iconMap = GUIGlobals.readIconThemeFile(uRL2, string3);
            }
            catch (IOException iOException) {
                System.err.println(Globals.lang("Unable to read icon theme file") + " '" + uRL2.toString() + "'");
                if (uRL2 == uRL) break block7;
                try {
                    iconMap = GUIGlobals.readIconThemeFile(uRL, string2);
                }
                catch (IOException iOException2) {
                    System.err.println(Globals.lang("Unable to read default icon theme."));
                }
            }
        }
    }

    public static URL getIconUrl(String string) {
        if (iconMap.containsKey(string)) {
            String string2;
            URL uRL = GUIGlobals.class.getResource(string2 = (String)iconMap.get(string));
            if (uRL == null) {
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            if (uRL == null) {
                System.err.println(Globals.lang("Could not find image file") + " '" + string2 + "'");
            }
            return uRL;
        }
        return null;
    }

    public static ImageIcon getImage(String string) {
        URL uRL = GUIGlobals.getIconUrl(string);
        return uRL != null ? new ImageIcon(GUIGlobals.getIconUrl(string)) : null;
    }

    private static HashMap readIconThemeFile(URL uRL, String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            int n;
            inputStream = uRL.openStream();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            String[] stringArray = stringBuffer.toString().split("\n");
            Object var7_9 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                int n2 = string2.indexOf("=");
                if (n2 < 0) continue;
                String string3 = string2.substring(0, n2).trim();
                String string4 = string + string2.substring(n2 + 1).trim();
                hashMap.put(string3, string4);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return hashMap;
    }

    public static String getLocaleHelpPath() {
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        String string = jabRefPreferences.get("language") + "/";
        if (string.equals("en/")) {
            string = "";
        }
        return helpPre + string;
    }

    public static void init() {
        typeNameFont = new Font("arial", 3, 24);
        fieldNameFont = new Font("arial", 3, 14);
        JLabel jLabel = new JLabel(GUIGlobals.getImage("pdfSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " PDF");
        tableIcons.put("pdf", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " URL");
        tableIcons.put("url", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("citeseer"));
        jLabel.setToolTipText(Globals.lang("Open") + " CiteSeer URL");
        tableIcons.put("citeseerurl", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("doiSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " DOI " + Globals.lang("web link"));
        tableIcons.put("doi", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("psSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " PS");
        tableIcons.put("ps", jLabel);
    }

    static {
        helpSize = new Dimension(700, 600);
        aboutSize = new Dimension(600, 265);
        searchPaneSize = new Dimension(430, 70);
        searchFieldSize = new Dimension(215, 25);
        backupExt = ".bak";
        tempExt = ".tmp";
        defaultDir = ".";
        imageSize = "24";
        extension = ".gif";
        ex = imageSize + extension;
        pre = "/images/";
        helpPre = "/help/";
        fontPath = "/images/font/";
        tableIcons = new HashMap();
        activeEditor = new Color(230, 230, 255);
        baseFrameHelp = "BaseFrameHelp.html";
        entryEditorHelp = "EntryEditorHelp.html";
        stringEditorHelp = "StringEditorHelp.html";
        helpContents = "Contents.html";
        searchHelp = "SearchHelp.html";
        groupsHelp = "GroupsHelp.html";
        customEntriesHelp = "CustomEntriesHelp.html";
        contentSelectorHelp = "ContentSelectorHelp.html";
        labelPatternHelp = "LabelPatterns.html";
        ownerHelp = "OwnerHelp.html";
        timeStampHelp = "TimeStampHelp.html";
        pdfHelp = "ExternalFiles.html";
        exportCustomizationHelp = "CustomExports.html";
        importCustomizationHelp = "CustomImports.html";
        medlineHelp = "MedlineHelp.html";
        citeSeerHelp = "CiteSeerHelp.html";
        generalFieldsHelp = "GeneralFields.html";
        aboutPage = "About.html";
        shortPlainImport = "ShortPlainImport.html";
        importInspectionHelp = "ImportInspectionDialog.html";
        shortIntegrityCheck = "ShortIntegrityCheck.html";
        shortAuxImport = "ShortAuxImport.html";
        remoteHelp = "RemoteHelp.html";
        journalAbbrHelp = "JournalAbbreviations.html";
        lightGray = new Color(230, 30, 30);
        validFieldColor = new Color(100, 100, 150);
        nullFieldColor = new Color(75, 130, 95);
        invalidFieldColor = new Color(141, 0, 61);
        validFieldBackground = Color.white;
        invalidFieldBackground = new Color(255, 100, 100);
        gradientGray = new Color(112, 121, 165);
        gradientBlue = new Color(0, 27, 102);
        activeTabbed = validFieldColor.darker();
        inActiveTabbed = Color.black;
        infoField = new Color(254, 255, 225);
        META_FLAG = "jabref-meta: ";
        META_FLAG_OLD = "bibkeeper-meta: ";
        ENTRYTYPE_FLAG = "jabref-entrytype: ";
        FORM_WIDTH = new int[]{500, 650, 820};
        FORM_HEIGHT = new int[]{90, 110, 130};
        DEFAULT_FIELD_LENGTH = 100;
        NUMBER_COL_LENGTH = 32;
        WIDTH_ICON_COL = 19;
        LANGUAGES = new HashMap();
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("Fran\u00e7ais", "fr");
        LANGUAGES.put("Italiano", "it");
        LANGUAGES.put("Norsk", "no");
    }
}

