/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.sf.jabref.FontSelectorDialog;

class FontSelector
extends JButton {
    static final String PLAIN = "plain";
    static final String BOLD = "bold";
    static final String BOLD_ITALIC = "bold-italic";
    static final String ITALIC = "italic";

    public FontSelector() {
        this(new Font("SansSerif", 0, 10));
    }

    public FontSelector(Font font) {
        this.setFont(font);
        this.setRequestFocusEnabled(false);
        this.addActionListener(new ActionHandler());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateText();
    }

    private void updateText() {
        String string;
        Font font = this.getFont();
        switch (font.getStyle()) {
            case 0: {
                string = PLAIN;
                break;
            }
            case 1: {
                string = BOLD;
                break;
            }
            case 2: {
                string = ITALIC;
                break;
            }
            case 3: {
                string = BOLD_ITALIC;
                break;
            }
            default: {
                string = "UNKNOWN!!!???";
            }
        }
        this.setText(font.getFamily() + " " + font.getSize() + " " + string);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Font font = new FontSelectorDialog(FontSelector.this, FontSelector.this.getFont()).getSelectedFont();
            if (font != null) {
                FontSelector.this.setFont(font);
            }
        }
    }
}

