/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChangeMenu;

public class FieldTextMenu
implements MouseListener {
    private FieldEditor myFieldName;
    private JPopupMenu inputMenu = new JPopupMenu();
    private CopyAction copyAct = new CopyAction();
    private PasteAction pasteAct = new PasteAction();

    public FieldTextMenu(FieldEditor fieldEditor) {
        this.myFieldName = fieldEditor;
        this.inputMenu.add(this.pasteAct);
        this.inputMenu.add(this.copyAct);
        this.inputMenu.addSeparator();
        this.inputMenu.add(new CaseChangeMenu((JTextComponent)this.myFieldName.getTextComponent()));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.myFieldName != null) {
            this.myFieldName.requestFocus();
            String string = this.myFieldName.getSelectedText();
            boolean bl = false;
            if (string != null && string.length() > 0) {
                bl = true;
            }
            this.copyAct.setEnabled(bl);
            this.inputMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static String generalFixAuthor(String string) {
        int n;
        String[] stringArray = string.split("( |,)and ", -1);
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n].trim();
        }
        String string2 = stringArray[stringArray.length - 1];
        n = string2.indexOf(",") > 0 ? 1 : 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",", -1);
                if (stringArray2.length == 2) {
                    stringArray2[0] = stringArray2[0].trim().replaceAll(" ", "~");
                    stringArray2[1] = stringArray2[1].trim().replaceAll(" ", "~");
                    stringBuffer.append(stringArray2[1] + " " + stringArray2[0]);
                } else {
                    stringBuffer.append(stringArray[i]);
                }
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(" and ");
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray3 = stringArray[i].split(",");
                for (int j = 0; j < stringArray3.length; ++j) {
                    stringArray3[j] = stringArray3[j].trim();
                    String[] stringArray4 = stringArray3[j].split(" ", -1);
                    for (int k = 0; k < stringArray4.length; ++k) {
                        stringBuffer.append(stringArray4[k]);
                        if (k < stringArray4.length - 2) {
                            stringBuffer.append('~');
                            continue;
                        }
                        if (k != stringArray4.length - 2) continue;
                        stringBuffer.append(' ');
                    }
                    if (j >= stringArray3.length - 1 && i >= stringArray.length - 1) continue;
                    stringBuffer.append(" and ");
                }
            }
        }
        return stringBuffer.toString();
    }

    class ReplaceAction
    extends BasicAction {
        public ReplaceAction() {
            super("Replace comma by and where appropriate");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FieldTextMenu.this.myFieldName.getText().equals("")) {
                return;
            }
            String string = FieldTextMenu.this.myFieldName.getText();
            FieldTextMenu.this.myFieldName.setText(FieldTextMenu.generalFixAuthor(string));
        }
    }

    class CopyAction
    extends BasicAction {
        public CopyAction() {
            super("Copy to clipboard", "Copy to clipboard", GUIGlobals.getIconUrl("copy"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                if (FieldTextMenu.this.myFieldName != null && (string = FieldTextMenu.this.myFieldName.getSelectedText()) != null && string.length() > 0) {
                    ClipBoardManager.clipBoard.setClipboardContents(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste from clipboard", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                String string = ClipBoardManager.clipBoard.getClipboardContents();
                if (string != null && string.length() > 0 && FieldTextMenu.this.myFieldName != null) {
                    FieldTextMenu.this.myFieldName.paste(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    abstract class BasicAction
    extends AbstractAction {
        public BasicAction(String string, String string2, URL uRL) {
            super(Globals.lang(string), new ImageIcon(uRL));
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        public BasicAction(String string, String string2, URL uRL, KeyStroke keyStroke) {
            super(Globals.lang(string), new ImageIcon(uRL));
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        public BasicAction(String string) {
            super(Globals.lang(string));
        }

        public BasicAction(String string, KeyStroke keyStroke) {
            super(Globals.lang(string));
            this.putValue("AcceleratorKey", keyStroke);
        }

        public abstract void actionPerformed(ActionEvent var1);
    }
}

