/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;

public class FieldTextField
extends JTextField
implements FieldEditor {
    protected String fieldName;
    protected JLabel label;
    private boolean antialias = Globals.prefs.getBoolean("antialias");

    public FieldTextField(String string, String string2, boolean bl) {
        super(string2);
        this.addFocusListener(Globals.focusListener);
        if (bl) {
            this.addFocusListener(new FieldEditorFocusListener());
        }
        this.fieldName = string;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.label.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(GUIGlobals.validFieldBackground);
        FieldTextMenu fieldTextMenu = new FieldTextMenu(this);
        this.addMouseListener(fieldTextMenu);
        this.label.addMouseListener(fieldTextMenu);
    }

    public void append(String string) {
        this.setText(this.getText() + string);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        throw new NullPointerException("ok");
    }

    public JComponent getPane() {
        return this;
    }

    public JComponent getTextComponent() {
        return this;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
    }

    public void paste(String string) {
        int n = this.getSelectionEnd() - this.getSelectionStart();
        if (n < 1) {
            int n2 = this.getCaretPosition();
            this.select(n2, n2);
        }
        this.replaceSelection(string);
    }
}

