/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;

public class FieldTextArea
extends JTextArea
implements FieldEditor,
KeyListener {
    Dimension PREFERRED_SIZE;
    protected JScrollPane sp;
    protected FieldNameLabel label;
    protected String fieldName;
    static Pattern bull = Pattern.compile("\\s*[-\\*]+.*");
    static Pattern indent = Pattern.compile("\\s+.*");
    private boolean antialias = Globals.prefs.getBoolean("antialias");

    public FieldTextArea(String string, String string2) {
        super(string2);
        this.addFocusListener(Globals.focusListener);
        this.addFocusListener(new FieldEditorFocusListener());
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setMinimumSize(new Dimension(200, 1));
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = string;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.setBackground(GUIGlobals.validFieldBackground);
        FieldTextMenu fieldTextMenu = new FieldTextMenu(this);
        this.addMouseListener(fieldTextMenu);
        this.label.addMouseListener(fieldTextMenu);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.PREFERRED_SIZE;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    public JComponent getPane() {
        return this.sp;
    }

    public JComponent getTextComponent() {
        return this;
    }

    public void paste(String string) {
        int n = this.getSelectionEnd() - this.getSelectionStart();
        if (n > 0) {
            this.replaceSelection(string);
        } else {
            int n2 = this.getCaretPosition();
            this.insert(string, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            keyEvent.consume();
            this.autoWrap();
        }
    }

    private void autoWrap() {
        int n;
        int n2 = this.getCaretPosition();
        int n3 = n2 + 1;
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        stringBuffer.insert(n2, '\n');
        int n4 = stringBuffer.substring(0, n2).lastIndexOf("\n") + 1;
        String string = stringBuffer.substring(n4, n2);
        if (bull.matcher(string).matches()) {
            int n5 = this.findFirstNonWhitespace(string);
            if (n5 >= 0) {
                stringBuffer.insert(n3, string.substring(0, n5));
                n3 += n5;
            }
        } else if (indent.matcher(string).matches() && (n = this.findFirstNonWhitespace(string)) >= 0) {
            stringBuffer.insert(n3, string.substring(0, n));
            n3 += n;
        }
        this.setText(stringBuffer.toString());
        this.setCaretPosition(n3);
    }

    private int findFirstNonWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

