/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;

public class FieldContentSelector
extends JComponent
implements ActionListener {
    protected final String DELIMITER = " ";
    protected final String DELIMITER_2 = "";
    protected final FieldEditor m_editor;
    JComboBox list = new JComboBox(){

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width > 240) {
                dimension.width = 240;
            }
            return dimension;
        }
    };
    JButton manage;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    protected final MetaData m_metaData;
    protected final JabRefFrame m_frame;
    protected final Window m_owner;
    protected final BasePanel m_panel;
    protected final AbstractAction m_action;
    protected final boolean m_horizontalLayout;

    public FieldContentSelector(JabRefFrame jabRefFrame, BasePanel basePanel, Dialog dialog, FieldEditor fieldEditor, MetaData metaData, AbstractAction abstractAction, boolean bl) {
        this.m_editor = fieldEditor;
        this.m_metaData = metaData;
        this.m_action = abstractAction;
        this.m_frame = jabRefFrame;
        this.m_panel = basePanel;
        this.m_owner = dialog;
        this.m_horizontalLayout = bl;
        this.doInit();
    }

    public FieldContentSelector(JabRefFrame jabRefFrame, BasePanel basePanel, Frame frame, FieldEditor fieldEditor, MetaData metaData, AbstractAction abstractAction, boolean bl) {
        this.m_editor = fieldEditor;
        this.m_metaData = metaData;
        this.m_action = abstractAction;
        this.m_frame = jabRefFrame;
        this.m_panel = basePanel;
        this.m_owner = frame;
        this.m_horizontalLayout = bl;
        this.doInit();
    }

    private void doInit() {
        this.setLayout(this.gbl);
        this.list.setMaximumRowCount(35);
        this.list.putClientProperty("ComboBox.popupPrototypeDisplayValue", "The longest text in the combo popup menu. And even longer.");
        this.updateList();
        this.con.gridwidth = this.m_horizontalLayout ? 3 : 0;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.list, this.con);
        this.list.addActionListener(this);
        this.add(this.list);
        if (this.m_horizontalLayout) {
            this.add(Box.createHorizontalStrut(Sizes.dialogUnitXAsPixel(2, this)));
        }
        this.manage = new JButton(Globals.lang("Manage"));
        this.gbl.setConstraints(this.manage, this.con);
        this.add(this.manage);
        this.manage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2 contentSelectorDialog2 = FieldContentSelector.this.m_owner instanceof Frame ? new ContentSelectorDialog2((Frame)FieldContentSelector.this.m_owner, FieldContentSelector.this.m_frame, FieldContentSelector.this.m_panel, true, FieldContentSelector.this.m_metaData, FieldContentSelector.this.m_editor.getFieldName()) : new ContentSelectorDialog2((Dialog)FieldContentSelector.this.m_owner, FieldContentSelector.this.m_frame, FieldContentSelector.this.m_panel, true, FieldContentSelector.this.m_metaData, FieldContentSelector.this.m_editor.getFieldName());
                Util.placeDialog(contentSelectorDialog2, FieldContentSelector.this.m_frame);
                contentSelectorDialog2.setVisible(true);
                FieldContentSelector.this.updateList();
            }
        });
    }

    public void updateList() {
        this.list.removeAllItems();
        this.list.addItem("");
        Vector vector = this.m_metaData.getData("selector_" + this.m_editor.getFieldName());
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                this.list.addItem(vector.elementAt(i));
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxChanged") && actionEvent.getModifiers() == 0) {
            return;
        }
        if (this.list.getSelectedIndex() == 0) {
            return;
        }
        String string = (String)this.list.getSelectedItem();
        if (string == null) {
            return;
        }
        if (this.list.getSelectedIndex() == -1) {
            this.addWord(string);
        }
        if (!this.m_editor.getText().equals("")) {
            this.m_editor.append(" ");
        }
        this.m_editor.append(string + "");
        this.list.setSelectedIndex(0);
        if (this.m_action != null) {
            this.m_action.actionPerformed(new ActionEvent(this.m_editor, 0, ""));
        }
        this.m_editor.requestFocus();
    }

    public void addWord(String string) {
        Vector vector = this.m_metaData.getData("selector_" + this.m_editor.getFieldName());
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            if (string2.toLowerCase().compareTo(string.toLowerCase()) >= 0) continue;
            n = i + 1;
        }
        if (!bl) {
            vector.add(Math.max(0, n), string);
            this.m_panel.markNonUndoableBaseChanged();
            this.m_panel.updateAllContentSelectors();
        }
    }
}

