/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Comparator;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;

public class FieldComparator
implements Comparator {
    private String field;
    private boolean isNameField;
    private boolean isTypeHeader;
    private int multiplier;

    public FieldComparator(String string) {
        this(string, false);
    }

    public FieldComparator(String string, boolean bl) {
        this.field = string;
        this.multiplier = bl ? -1 : 1;
        this.isNameField = string.equals("author") || string.equals("editor");
        this.isTypeHeader = string.equals(GUIGlobals.TYPE_HEADER);
    }

    public int compare(Object object, Object object2) {
        BibtexEntry bibtexEntry = (BibtexEntry)object;
        BibtexEntry bibtexEntry2 = (BibtexEntry)object2;
        Object object3 = bibtexEntry.getField(this.field);
        Object object4 = bibtexEntry2.getField(this.field);
        if (this.isNameField) {
            if (object3 != null) {
                object3 = AuthorList.fixAuthorForAlphabetization((String)object3);
            }
            if (object4 != null) {
                object4 = AuthorList.fixAuthorForAlphabetization((String)object4);
            }
        } else if (this.isTypeHeader) {
            object3 = bibtexEntry.getType().getName();
            object4 = bibtexEntry2.getType().getName();
        }
        if (object3 == null && object4 == null) {
            return 0;
        }
        if (object3 != null && object4 == null) {
            return -1 * this.multiplier;
        }
        if (object3 == null) {
            return this.multiplier;
        }
        int n = 0;
        if (object3 instanceof Integer && object4 instanceof Integer) {
            n = -((Integer)object3).compareTo((Integer)object4);
        } else if (object4 instanceof Integer) {
            Integer n2 = new Integer(object3.toString());
            n = -n2.compareTo((Integer)object4);
        } else if (object3 instanceof Integer) {
            Integer n3 = new Integer(object4.toString());
            n = -((Integer)object3).compareTo(n3);
        } else {
            String string = ((String)object3).toLowerCase();
            String string2 = ((String)object4).toLowerCase();
            n = string.compareTo(string2);
        }
        return n * this.multiplier;
    }
}

