/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

public class EntryEditorTab {
    private JPanel panel = new JPanel();
    private String[] fields;
    private static final Object[] ARRAY = new String[0];
    private EntryEditor parent;
    private HashMap editors = new HashMap();
    private FieldEditor activeField = null;
    private JScrollPane sp = new JScrollPane(this.panel, 20, 31);

    public EntryEditorTab(List list, EntryEditor entryEditor, boolean bl, String string) {
        this.fields = list != null ? (String[])list.toArray(ARRAY) : new String[0];
        this.parent = entryEditor;
        this.setupPanel(bl, string);
        this.panel.setFocusCycleRoot(true);
    }

    private final void setupPanel(boolean bl, String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel.setLayout(gridBagLayout);
        double d = 0.0;
        for (int i = 0; i < this.fields.length; ++i) {
            FieldTextArea fieldTextArea = new FieldTextArea(this.fields[i], null);
            JComponent jComponent = this.parent.getExtra(this.fields[i], fieldTextArea);
            this.setupJTextComponent(fieldTextArea);
            fieldTextArea.addFocusListener(new FieldListener(fieldTextArea));
            this.editors.put(this.fields[i], fieldTextArea);
            if (i == 0) {
                this.activeField = fieldTextArea;
            }
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(fieldTextArea.getLabel(), gridBagConstraints);
            this.panel.add(fieldTextArea.getLabel());
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = BibtexFields.getFieldWeight(this.fields[i]);
            d += gridBagConstraints.weighty;
            gridBagConstraints.gridwidth = jComponent != null ? 1 : 0;
            gridBagLayout.setConstraints(fieldTextArea.getPane(), gridBagConstraints);
            this.panel.add(fieldTextArea.getPane());
            if (jComponent != null) {
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                this.panel.add(jComponent);
            }
            this.panel.setName(string);
        }
        if (bl) {
            gridBagConstraints.insets.top += 25;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 16;
            FieldTextField fieldTextField = new FieldTextField("bibtexkey", (String)this.parent.getEntry().getField("bibtexkey"), true);
            this.editors.put("bibtexkey", fieldTextField);
            if (this.editors.size() == 1) {
                this.activeField = fieldTextField;
            }
            gridBagLayout.setConstraints(fieldTextField.getLabel(), gridBagConstraints);
            this.panel.add(fieldTextField.getLabel());
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.setupJTextComponent(fieldTextField);
            fieldTextField.addFocusListener(new FieldListener(fieldTextField));
            gridBagLayout.setConstraints(fieldTextField, gridBagConstraints);
            this.panel.add(fieldTextField);
        }
    }

    public void setActive(FieldEditor fieldEditor) {
        this.activeField = fieldEditor;
    }

    public FieldEditor getActive() {
        return this.activeField;
    }

    public List getFields() {
        return Arrays.asList(this.fields);
    }

    public void activate() {
        if (this.activeField != null) {
            this.activeField.requestFocus();
        }
    }

    public void updateAll() {
        this.setEntry(this.parent.getEntry());
    }

    public void setEntry(BibtexEntry bibtexEntry) {
        Iterator iterator = this.editors.keySet().iterator();
        while (iterator.hasNext()) {
            FieldEditor fieldEditor;
            String string = (String)iterator.next();
            Object object = bibtexEntry.getField((fieldEditor = (FieldEditor)this.editors.get(string)).getFieldName());
            fieldEditor.setText(object == null ? "" : object.toString());
        }
    }

    public boolean updateField(String string, String string2) {
        if (!this.editors.containsKey(string)) {
            return false;
        }
        FieldEditor fieldEditor = (FieldEditor)this.editors.get(string);
        fieldEditor.setText(string2);
        return true;
    }

    public void validateAllFields() {
        Iterator iterator = this.editors.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FieldEditor fieldEditor = (FieldEditor)this.editors.get(string);
            fieldEditor.setEnabled(true);
            if (((Component)((Object)fieldEditor)).hasFocus()) {
                fieldEditor.setBackground(GUIGlobals.activeEditor);
                continue;
            }
            fieldEditor.setBackground(GUIGlobals.validFieldBackground);
        }
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.editors.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FieldEditor fieldEditor = (FieldEditor)this.editors.get(string);
            fieldEditor.setEnabled(bl);
        }
    }

    public Component getPane() {
        return this.panel;
    }

    public void setupJTextComponent(JTextComponent jTextComponent) {
        InputMap inputMap = jTextComponent.getInputMap(0);
        ActionMap actionMap = jTextComponent.getActionMap();
        inputMap.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.parent.prevEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.parent.nextEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.parent.storeFieldAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("left", this.parent.switchLeftAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("right", this.parent.switchRightAction);
        inputMap.put(Globals.prefs.getKey("Help"), "help");
        actionMap.put("help", this.parent.helpAction);
        inputMap.put(Globals.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.parent.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.parent.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.parent.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(0));
            hashSet.clear();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            jTextComponent.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(1));
            hashSet.clear();
            hashSet.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            jTextComponent.setFocusTraversalKeys(1, hashSet);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldEditor fe;

        public FieldListener(FieldEditor fieldEditor) {
            this.fe = fieldEditor;
        }

        public void focusGained(FocusEvent focusEvent) {
            EntryEditorTab.this.setActive(this.fe);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                EntryEditorTab.this.parent.updateField(this.fe);
            }
        }
    }
}

