/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

class EntryCustomizationDialog
extends JDialog
implements ItemListener {
    BibtexEntryType type;
    JScrollPane reqSP;
    JScrollPane optSP;
    JButton ok;
    JButton cancel;
    JButton helpButton;
    JButton delete;
    JButton importTypes;
    JButton exportTypes;
    JPanel panel = new JPanel();
    JPanel fieldPanel = new JPanel();
    JPanel typePanel = new JPanel();
    int width = 10;
    JLabel messageLabel = new JLabel("", 0);
    JTextField name = new JTextField("", this.width);
    JTextArea req_ta = new JTextArea("", 5, this.width);
    JTextArea opt_ta = new JTextArea("", 5, this.width);
    JComboBox types_cb = new JComboBox();
    HelpAction help;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JPanel buttonPanel = new JPanel();
    JabRefFrame parent;
    EntryCustomizationDialog ths = this;

    public EntryCustomizationDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Customize entry types"), false);
        this.parent = jabRefFrame;
        this.help = new HelpAction(jabRefFrame.helpDiag, GUIGlobals.customEntriesHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.setTypeSelection();
        this.initialize();
        this.makeButtons();
        this.reqSP = new JScrollPane(this.req_ta, 20, 31);
        this.optSP = new JScrollPane(this.opt_ta, 20, 31);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.help);
        this.panel.setLayout(this.gbl);
        this.typePanel.setLayout(this.gbl);
        this.fieldPanel.setLayout(this.gbl);
        this.fieldPanel.setBorder(BorderFactory.createEtchedBorder());
        this.typePanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(Globals.lang("Type") + ": ");
        JLabel jLabel2 = new JLabel(Globals.lang("Name") + ": ");
        this.con.insets = new Insets(5, 5, 5, 5);
        this.gbl.setConstraints(jLabel, this.con);
        this.gbl.setConstraints(jLabel2, this.con);
        this.gbl.setConstraints(this.types_cb, this.con);
        this.con.weightx = 1.0;
        this.con.fill = 2;
        this.gbl.setConstraints(this.name, this.con);
        this.con.fill = 0;
        this.con.gridwidth = 0;
        this.con.weightx = 0.0;
        this.gbl.setConstraints(jToolBar, this.con);
        this.con.gridwidth = 1;
        this.typePanel.add(jLabel);
        this.typePanel.add(this.types_cb);
        this.typePanel.add(jLabel2);
        this.typePanel.add(this.name);
        this.typePanel.add(jToolBar);
        jLabel = new JLabel(Globals.lang("Required fields"));
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(jLabel, this.con);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.reqSP, this.con);
        this.fieldPanel.add(jLabel);
        this.con.gridwidth = 0;
        jLabel = new JLabel(Globals.lang("Optional fields"));
        this.con.weighty = 0.0;
        this.gbl.setConstraints(jLabel, this.con);
        this.fieldPanel.add(jLabel);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.optSP, this.con);
        this.fieldPanel.add(this.reqSP);
        this.fieldPanel.add(this.optSP);
        this.con.gridwidth = 0;
        this.con.weighty = 0.0;
        this.gbl.setConstraints(this.typePanel, this.con);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.fieldPanel, this.con);
        this.con.weighty = 0.0;
        this.gbl.setConstraints(this.messageLabel, this.con);
        this.panel.add(this.typePanel);
        this.panel.add(this.fieldPanel);
        this.panel.add(this.messageLabel);
        ActionMap actionMap = this.panel.getActionMap();
        InputMap inputMap = this.panel.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryCustomizationDialog.this.dispose();
            }
        });
        this.pack();
        this.name.requestFocus();
    }

    public EntryCustomizationDialog(JabRefFrame jabRefFrame, BibtexEntryType bibtexEntryType) {
        this(jabRefFrame);
        this.type = bibtexEntryType;
    }

    void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.panel, "Center");
        this.messageLabel.setForeground(Color.black);
        this.messageLabel.setText(Globals.lang("Delimit fields with semicolon, ex.") + ": author;title;journal");
        this.types_cb.addItemListener(this);
    }

    void save() {
        String string = this.name.getText().trim();
        if (string.indexOf(" ") >= 0) {
            JOptionPane.showMessageDialog(this.ths, Globals.lang("The type name can not contain spaces."), Globals.lang("Illegal type name"), 0);
            return;
        }
        String string2 = this.req_ta.getText().replaceAll("\\s+", "").replaceAll("\\n+", "").trim();
        String string3 = this.opt_ta.getText().replaceAll("\\s+", "").replaceAll("\\n+", "").trim();
        if (!string.equals("")) {
            CustomEntryType customEntryType = new CustomEntryType(Util.nCase(string), string2, string3);
            BibtexEntryType.ALL_TYPES.put(string.toLowerCase(), customEntryType);
            this.updateTypesForEntries(customEntryType.getName());
            this.setTypeSelection();
            this.messageLabel.setText(Globals.lang("Stored definition for type") + " '" + Util.nCase(customEntryType.getName()) + "'.");
        } else {
            this.messageLabel.setText(Globals.lang("You must fill in a name for the entry type."));
        }
    }

    private void setTypeSelection() {
        this.types_cb.removeAllItems();
        this.types_cb.addItem("<new>");
        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (iterator.hasNext()) {
            BibtexEntryType bibtexEntryType = BibtexEntryType.getType((String)iterator.next());
            String string = Util.nCase(bibtexEntryType.getName());
            if (bibtexEntryType instanceof CustomEntryType) {
                string = string + " *";
            }
            this.types_cb.addItem(string);
        }
    }

    void makeButtons() {
        this.ok = new JButton(Globals.lang("Store"));
        this.cancel = new JButton(Globals.lang("Close"));
        this.delete = new JButton(Globals.lang("Delete custom"));
        this.importTypes = new JButton(Globals.lang("Import"));
        this.exportTypes = new JButton(Globals.lang("Export"));
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.delete);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.importTypes);
        this.buttonPanel.add(this.exportTypes);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.cancel);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryCustomizationDialog.this.save();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryCustomizationDialog.this.dispose();
            }
        });
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BibtexEntryType bibtexEntryType = BibtexEntryType.getType(EntryCustomizationDialog.this.name.getText());
                if (bibtexEntryType == null) {
                    EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("There is no entry type") + " '" + Util.nCase(EntryCustomizationDialog.this.name.getText()) + "' " + Globals.lang("defined."));
                } else if (!(bibtexEntryType instanceof CustomEntryType)) {
                    EntryCustomizationDialog.this.messageLabel.setText("'" + bibtexEntryType.getName() + "' " + Globals.lang("is a standard type."));
                } else {
                    int n;
                    String string = EntryCustomizationDialog.this.name.getText();
                    if (BibtexEntryType.getStandardType(string) == null && (n = JOptionPane.showConfirmDialog(EntryCustomizationDialog.this.parent, Globals.lang("All entries of this type will be declared typeless. Continue?"), Globals.lang("Delete custom format") + " '" + Util.nCase(string) + "'", 0, 2)) != 0) {
                        return;
                    }
                    BibtexEntryType.removeType(string);
                    EntryCustomizationDialog.this.setTypeSelection();
                    EntryCustomizationDialog.this.updateTypesForEntries(Util.nCase(string));
                    EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("Removed entry type."));
                }
            }
        });
        this.exportTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getNewFile(EntryCustomizationDialog.this.parent, new File(System.getProperty("user.home")), ".txt", 1, false);
                if (string == null) {
                    return;
                }
                File file = new File(string);
                if (!file.exists() || JOptionPane.showConfirmDialog(EntryCustomizationDialog.this.ths, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export entry types"), 2) == 0) {
                    try {
                        FileWriter fileWriter = new FileWriter(file);
                        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
                        while (iterator.hasNext()) {
                            Object v = BibtexEntryType.ALL_TYPES.get(iterator.next());
                            if (!(v instanceof CustomEntryType)) continue;
                            ((CustomEntryType)v).save(fileWriter);
                        }
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(EntryCustomizationDialog.this.ths, Globals.lang("Could not export entry types") + ": " + iOException.getMessage(), Globals.lang("Export preferences"), 0);
                    }
                }
            }
        });
        this.importTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getNewFile(EntryCustomizationDialog.this.parent, new File(System.getProperty("user.home")), ".txt", 0, false);
                if (string == null) {
                    return;
                }
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
                    int n = 0;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        CustomEntryType customEntryType;
                        if ((string2 = string2.trim()).length() > 9 + GUIGlobals.ENTRYTYPE_FLAG.length() && string2.substring(0, 9 + GUIGlobals.ENTRYTYPE_FLAG.length()).equals("@comment{" + GUIGlobals.ENTRYTYPE_FLAG) && string2.substring(string2.length() - 1).equals("}") && (customEntryType = CustomEntryType.parseEntryType(string2.substring(9, string2.length() - 1))) != null) {
                            BibtexEntryType.ALL_TYPES.put(customEntryType.getName().toLowerCase(), customEntryType);
                            ++n;
                        }
                        if (n <= 0) continue;
                        EntryCustomizationDialog.this.setTypeSelection();
                        EntryCustomizationDialog.this.req_ta.setText("");
                        EntryCustomizationDialog.this.opt_ta.setText("");
                        EntryCustomizationDialog.this.name.setText("");
                        EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("Imported entry types") + ": " + n);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(EntryCustomizationDialog.this.ths, Globals.lang("Could not import entry types") + ": " + iOException.getMessage(), Globals.lang("Import entry types"), 0);
                }
            }
        });
    }

    private void updateTypesForEntries(String string) {
        if (this.parent.tabbedPane.getTabCount() == 0) {
            return;
        }
        this.messageLabel.setText(Globals.lang("Updating entries..."));
        for (int i = 0; i < this.parent.tabbedPane.getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.parent.tabbedPane.getComponentAt(i);
            boolean bl = false;
            basePanel.entryEditors.remove(string);
            BibtexDatabase bibtexDatabase = basePanel.database;
            Iterator iterator = bibtexDatabase.getKeySet().iterator();
            while (iterator.hasNext()) {
                bl |= !bibtexDatabase.getEntryById((String)iterator.next()).updateType();
            }
            if (!bl) continue;
            basePanel.markBaseChanged();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.types_cb.getSelectedIndex() > 0) {
            String string = (String)this.types_cb.getSelectedItem();
            this.updateToType(string.split(" ")[0]);
        } else {
            this.name.setText("");
            this.req_ta.setText("");
            this.opt_ta.setText("");
            this.name.requestFocus();
        }
    }

    public void updateToType(String string) {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
        this.name.setText(bibtexEntryType.getName());
        this.req_ta.setText(Util.stringArrayToDelimited(bibtexEntryType.getRequiredFields(), ";\n"));
        this.opt_ta.setText(Util.stringArrayToDelimited(bibtexEntryType.getOptionalFields(), ";\n"));
        this.req_ta.requestFocus();
    }
}

