/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sf.jabref.ContentSelectorDialog_Close_actionAdapter;
import net.sf.jabref.ContentSelectorDialog_fieldSelector_actionAdapter;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;

public class ContentSelectorDialog
extends JDialog {
    JPanel panel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton Close = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JLabel lab = new JLabel();
    JTextField fieldTf = new JTextField();
    JButton add = new JButton();
    JPanel jPanel3 = new JPanel();
    JButton remove = new JButton();
    JComboBox fieldSelector = new JComboBox();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton help;
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JLabel jLabel1 = new JLabel();
    JComboBox wordSelector = new JComboBox();
    JTextField wordTf = new JTextField();
    JPanel jPanel5 = new JPanel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JButton addWord = new JButton();
    JPanel jPanel6 = new JPanel();
    JButton removeWord = new JButton();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JButton select = new JButton();
    final String WORD_EMPTY_TEXT = Globals.lang("<no field>");
    final String WORD_FIRSTLINE_TEXT = Globals.lang("<select word>");
    final String FIELD_FIRST_LINE = Globals.lang("<field name>");
    MetaData metaData;
    String currentField = null;
    TreeSet fieldSet;
    TreeSet wordSet;
    JabRefFrame frame;

    public ContentSelectorDialog(JabRefFrame jabRefFrame, boolean bl, MetaData metaData) {
        super(jabRefFrame, Globals.lang("Setup selectors"), bl);
        this.metaData = metaData;
        this.frame = jabRefFrame;
        this.help = new JButton(Globals.lang("Help"));
        this.help.addActionListener(new HelpAction(jabRefFrame.helpDiag, GUIGlobals.contentSelectorHelp, "Help"));
        try {
            this.jbInit();
            this.wordSelector.addItem(this.WORD_EMPTY_TEXT);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ContentSelectorDialog(JabRefFrame jabRefFrame, boolean bl, MetaData metaData, String string) {
        this(jabRefFrame, bl, metaData);
        try {
            this.fieldSelector.setSelectedItem(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.panel1.remove(this.jPanel1);
        this.pack();
    }

    private void setupFieldSelector() {
        this.fieldSelector.removeAllItems();
        this.fieldSelector.addItem(this.FIELD_FIRST_LINE);
        Iterator iterator = this.metaData.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("selector_")) continue;
            this.fieldSelector.addItem(string.substring("selector_".length()));
        }
    }

    private void updateWordPanel() {
        if (this.currentField == null) {
            this.titledBorder2.setTitle("");
            this.jPanel3.repaint();
            return;
        }
        this.titledBorder2.setTitle(Globals.lang("Field") + ": " + this.currentField);
        this.jPanel3.repaint();
        this.fillWordSelector();
        this.wordTf.setText("");
    }

    private void fillWordSelector() {
        this.wordSelector.removeAllItems();
        this.wordSelector.addItem(this.WORD_FIRSTLINE_TEXT);
        Vector vector = this.metaData.getData("selector_" + this.currentField);
        if (vector != null) {
            this.wordSet = new TreeSet(vector);
            Iterator iterator = this.wordSet.iterator();
            while (iterator.hasNext()) {
                this.wordSelector.addItem(iterator.next());
            }
        }
    }

    private void addWord() {
        if (this.currentField == null) {
            return;
        }
        String string = this.wordTf.getText().trim();
        if (!this.wordSet.contains(string)) {
            Util.pr("selector_" + this.currentField);
            this.wordSet.add(string);
            this.metaData.putData("selector_" + this.currentField, new Vector(this.wordSet));
            this.fillWordSelector();
            this.frame.basePanel().markNonUndoableBaseChanged();
            this.wordTf.setText("");
            this.wordTf.requestFocus();
        }
    }

    private void addField() {
        this.currentField = this.fieldTf.getText().trim().toLowerCase();
        if (this.metaData.getData("selector_" + this.currentField) == null) {
            this.metaData.putData("selector_" + this.currentField, new Vector());
            this.frame.basePanel().markNonUndoableBaseChanged();
            this.setupFieldSelector();
            this.updateWordPanel();
        }
    }

    private void removeWord() {
        String string = this.wordTf.getText().trim();
        if (this.wordSet.contains(string)) {
            this.wordSet.remove(string);
            this.metaData.putData("selector_" + this.currentField, new Vector(this.wordSet));
            this.fillWordSelector();
            this.frame.basePanel().markNonUndoableBaseChanged();
            this.wordTf.setText("");
            this.wordTf.requestFocus();
        }
    }

    void fieldSelector_actionPerformed(ActionEvent actionEvent) {
        if (this.fieldSelector.getSelectedIndex() > 0) {
            this.currentField = (String)this.fieldSelector.getSelectedItem();
            this.updateWordPanel();
        }
    }

    private void jbInit() {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Globals.lang("Selector enabled fields"));
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Globals.lang("Item list for field"));
        this.panel1.setLayout(this.gridBagLayout1);
        this.Close.setText(Globals.lang("Close"));
        this.Close.addActionListener(new ContentSelectorDialog_Close_actionAdapter(this));
        this.lab.setRequestFocusEnabled(true);
        this.lab.setText(Globals.lang("Field name") + ":");
        this.fieldTf.setSelectionEnd(8);
        this.add.setText(Globals.lang("Add"));
        this.remove.setText(Globals.lang("Remove"));
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jPanel3.setBorder(this.titledBorder2);
        this.jPanel3.setLayout(this.gridBagLayout4);
        this.jPanel4.setLayout(this.gridBagLayout3);
        this.jLabel1.setText(Globals.lang("Word") + ":");
        this.jPanel5.setLayout(this.gridBagLayout5);
        this.addWord.setText(Globals.lang("Add"));
        this.removeWord.setText(Globals.lang("Remove"));
        this.jPanel6.setLayout(this.gridBagLayout6);
        this.select.setText(Globals.lang("Select"));
        this.fieldSelector.addActionListener(new ContentSelectorDialog_fieldSelector_actionAdapter(this));
        this.getContentPane().add(this.panel1);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.help, null);
        this.jPanel2.add((Component)this.Close, null);
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.lab, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.fieldTf, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 1, 0));
        this.panel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.fieldSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.add, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel4.add((Component)this.remove, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.wordSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.wordTf, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jPanel5, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jPanel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.addWord, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel6.add((Component)this.removeWord, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.select, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog.this.addField();
            }
        });
        this.wordTf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog.this.addWord();
            }
        });
        this.addWord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog.this.addWord();
            }
        });
        this.removeWord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog.this.removeWord();
            }
        });
        this.wordSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ContentSelectorDialog.this.wordSelector.getSelectedIndex() > 0) {
                    ContentSelectorDialog.this.wordTf.setText((String)ContentSelectorDialog.this.wordSelector.getSelectedItem());
                    ContentSelectorDialog.this.wordTf.requestFocus();
                }
            }
        });
        this.setupFieldSelector();
    }

    void Close_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

