/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CallBack;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.DuplicateSearch;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.PreambleEditor;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.ReplaceStringDialog;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.StrictDuplicateSearch;
import net.sf.jabref.StringDialog;
import net.sf.jabref.TransferableBibtexEntry;
import net.sf.jabref.Util;
import net.sf.jabref.Worker;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.collab.FileUpdateListener;
import net.sf.jabref.collab.FileUpdatePanel;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.RtfSelection;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.external.AutoSetExternalFileForEntries;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.gui.GlazedEntrySorter;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.gui.MainTableSelectionListener;
import net.sf.jabref.imports.AppendDatabaseAction;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.journals.AbbreviateAction;
import net.sf.jabref.journals.UnabbreviateAction;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.search.NoSearchMatcher;
import net.sf.jabref.search.SearchMatcher;
import net.sf.jabref.undo.CountingUndoManager;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableChangeType;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.wizard.text.gui.TextInputDialog;

public class BasePanel
extends JPanel
implements ClipboardOwner,
FileUpdateListener {
    public static final int SHOWING_NOTHING = 0;
    public static final int SHOWING_PREVIEW = 1;
    public static final int SHOWING_EDITOR = 2;
    public static final int WILL_SHOW_EDITOR = 3;
    private int mode = 0;
    private EntryEditor currentEditor = null;
    private PreviewPanel currentPreview = null;
    boolean tmp = true;
    private MainTableSelectionListener selectionListener = null;
    private ListEventListener groupsHighlightListener;
    UIFSplitPane contentPane = new UIFSplitPane();
    JSplitPane splitPane;
    JabRefFrame frame;
    BibtexDatabase database;
    File file = null;
    File fileToOpen = null;
    String fileMonitorHandle = null;
    boolean saving = false;
    boolean updatedExternally = false;
    private String encoding;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    public CountingUndoManager undoManager = new CountingUndoManager(this);
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    boolean baseChanged = false;
    boolean nonUndoableChange = false;
    public MainTable mainTable = null;
    public FilterList searchFilterList = null;
    public FilterList groupFilterList = null;
    public RightClickMenu rcm;
    BibtexEntry showing = null;
    public HashMap entryEditors = new HashMap();
    PreambleEditor preambleEditor = null;
    StringDialog stringDialog = null;
    public boolean sortingBySearchResults = false;
    public boolean coloringBySearchResults = false;
    public boolean hidingNonHits = false;
    public boolean sortingByGroup = false;
    public boolean sortingByCiteSeerResults = false;
    public boolean coloringByGroup = false;
    int lastSearchHits = -1;
    MetaData metaData;
    HashMap fieldExtras = new HashMap();
    private boolean suppressOutput = false;
    private HashMap actions = new HashMap();
    private SidePaneManager sidePaneManager;

    public BasePanel(JabRefFrame jabRefFrame) {
        this.sidePaneManager = Globals.sidePaneManager;
        this.database = new BibtexDatabase();
        this.metaData = new MetaData();
        this.metaData.initializeNewDatabase();
        this.frame = jabRefFrame;
        this.setupActions();
        this.setupMainPanel();
        this.encoding = Globals.prefs.get("defaultEncoding");
    }

    public BasePanel(JabRefFrame jabRefFrame, BibtexDatabase bibtexDatabase, File file, HashMap hashMap, String string) {
        this.encoding = string;
        this.sidePaneManager = Globals.sidePaneManager;
        this.frame = jabRefFrame;
        this.database = bibtexDatabase;
        if (hashMap != null) {
            this.parseMetaData(hashMap);
        } else {
            this.metaData = new MetaData();
            this.metaData.initializeNewDatabase();
        }
        this.setupActions();
        this.setupMainPanel();
        this.file = file;
        if (file != null) {
            try {
                this.fileMonitorHandle = Globals.fileUpdateMonitor.addUpdateListener(this, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    public BibtexDatabase database() {
        return this.database;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public File file() {
        return this.file;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public JabRefPreferences prefs() {
        return Globals.prefs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void output(String string) {
        if (!this.suppressOutput) {
            this.frame.output(string);
        }
    }

    private void setupActions() {
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("edit", new BaseAction(){

            public void action() {
                BasePanel.this.selectionListener.editSignalled();
            }
        });
        this.actions.put("test", new BaseAction(){

            public void action() throws Throwable {
            }
        });
        this.actions.put("save", new AbstractWorker(){
            private boolean success = false;
            private boolean cancelled = false;

            public void init() throws Throwable {
                this.success = false;
                this.cancelled = false;
                if (BasePanel.this.file == null) {
                    BasePanel.this.runCommand("saveAs");
                } else {
                    if (BasePanel.this.updatedExternally || Globals.fileUpdateMonitor.hasBeenModified(BasePanel.this.fileMonitorHandle)) {
                        Object[] objectArray = new String[]{Globals.lang("Review changes"), Globals.lang("Save"), Globals.lang("Cancel")};
                        int n = JOptionPane.showOptionDialog(BasePanel.this.frame, Globals.lang("File has been updated externally. What do you want to do?"), Globals.lang("File updated externally"), 1, 3, null, objectArray, objectArray[0]);
                        if (n == 2) {
                            return;
                        }
                        if (n == 0) {
                            ChangeScanner changeScanner = new ChangeScanner(BasePanel.this.frame, BasePanel.this);
                            changeScanner.changeScan(BasePanel.this.file());
                            BasePanel.this.setUpdatedExternally(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    BasePanel.this.sidePaneManager.hideAway("fileUpdate");
                                }
                            });
                            return;
                        }
                    }
                    BasePanel.this.frame.output(Globals.lang("Saving database") + "...");
                    BasePanel.this.saving = true;
                }
            }

            public void update() {
                if (this.success) {
                    BasePanel.this.frame.setTabTitle(BasePanel.this, BasePanel.this.file.getName());
                    BasePanel.this.frame.output(Globals.lang("Saved database") + " '" + BasePanel.this.file.getPath() + "'.");
                } else if (!this.cancelled) {
                    BasePanel.this.frame.output(Globals.lang("Save failed"));
                }
            }

            public void run() {
                if (BasePanel.this.file == null) {
                    this.cancelled = true;
                    return;
                }
                try {
                    if (Globals.prefs.getBoolean("generateKeysBeforeSaving")) {
                        NamedCompound namedCompound = new NamedCompound(Globals.lang("autogenerate keys"));
                        boolean bl = false;
                        Iterator iterator = BasePanel.this.database.getKeySet().iterator();
                        while (iterator.hasNext()) {
                            BibtexEntry bibtexEntry = BasePanel.this.database.getEntryById((String)iterator.next());
                            String string = bibtexEntry.getCiteKey();
                            if (string != null && !string.equals("")) continue;
                            LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), BasePanel.this.database, bibtexEntry);
                            namedCompound.addEdit(new UndoableKeyChange(BasePanel.this.database, bibtexEntry.getId(), null, (String)bibtexEntry.getField("bibtexkey")));
                            bl = true;
                        }
                        if (bl) {
                            namedCompound.end();
                            BasePanel.this.undoManager.addEdit(namedCompound);
                        }
                    }
                    this.success = BasePanel.this.saveDatabase(BasePanel.this.file, false, BasePanel.this.encoding);
                    try {
                        Globals.fileUpdateMonitor.updateTimeStamp(BasePanel.this.fileMonitorHandle);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    BasePanel.this.saving = false;
                    if (this.success) {
                        BasePanel.this.undoManager.markUnchanged();
                        BasePanel.this.nonUndoableChange = false;
                        BasePanel.this.baseChanged = false;
                        BasePanel.this.updatedExternally = false;
                    }
                }
                catch (SaveException saveException) {
                    saveException.printStackTrace();
                }
            }
        });
        this.actions.put("saveAs", new BaseAction(){

            public void action() throws Throwable {
                String string = Globals.getNewFile(BasePanel.this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false);
                if (string != null) {
                    BasePanel.this.file = new File(string);
                    if (!BasePanel.this.file.exists() || JOptionPane.showConfirmDialog(BasePanel.this.frame, "'" + BasePanel.this.file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) == 0) {
                        BasePanel.this.runCommand("save");
                        try {
                            BasePanel.this.fileMonitorHandle = Globals.fileUpdateMonitor.addUpdateListener(BasePanel.this, BasePanel.this.file);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        Globals.prefs.put("workingDirectory", BasePanel.this.file.getParent());
                        BasePanel.this.frame.getFileHistory().newFile(BasePanel.this.file.getPath());
                    } else {
                        BasePanel.this.file = null;
                    }
                }
            }
        });
        this.actions.put("saveSelectedAs", new BaseAction(){

            public void action() throws Throwable {
                File file;
                String string = Globals.getNewFile(BasePanel.this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false);
                if (!(string == null || (file = new File(string)).exists() && JOptionPane.showConfirmDialog(BasePanel.this.frame, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) != 0)) {
                    BasePanel.this.saveDatabase(file, true, Globals.prefs.get("defaultEncoding"));
                    BasePanel.this.frame.getFileHistory().newFile(file.getPath());
                    BasePanel.this.frame.output(Globals.lang("Saved selected to") + " '" + file.getPath() + "'.");
                }
            }
        });
        this.actions.put("copy", new BaseAction(){

            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    TransferableBibtexEntry transferableBibtexEntry = new TransferableBibtexEntry(bibtexEntryArray);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableBibtexEntry, BasePanel.this);
                    BasePanel.this.output(Globals.lang("Copied") + " " + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry") + "."));
                } else {
                    Object object;
                    int[] nArray = BasePanel.this.mainTable.getSelectedRows();
                    int[] nArray2 = BasePanel.this.mainTable.getSelectedColumns();
                    if (nArray2.length == 1 && nArray.length == 1 && (object = BasePanel.this.mainTable.getValueAt(nArray[0], nArray2[0])) != null) {
                        StringSelection stringSelection = new StringSelection(object.toString());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                        BasePanel.this.output(Globals.lang("Copied cell contents") + ".");
                    }
                }
            }
        });
        this.actions.put("cut", new BaseAction(){

            public void action() throws Throwable {
                BasePanel.this.runCommand("copy");
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    NamedCompound namedCompound = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "cut entries" : "cut entry"));
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        BasePanel.this.database.removeEntry(bibtexEntryArray[i].getId());
                        BasePanel.this.ensureNotShowing(bibtexEntryArray[i]);
                        namedCompound.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bibtexEntryArray[i], BasePanel.this));
                    }
                    BasePanel.this.frame.output(Globals.lang("Cut_pr") + " " + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("delete", new BaseAction(){

            public void action() {
                boolean bl = false;
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                int n = BasePanel.this.mainTable.getSelectedRow();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    boolean bl2 = BasePanel.this.showDeleteConfirmationDialog(bibtexEntryArray.length);
                    if (!bl2) {
                        return;
                    }
                    NamedCompound namedCompound = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "delete entries" : "delete entry"));
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        BasePanel.this.database.removeEntry(bibtexEntryArray[i].getId());
                        BasePanel.this.ensureNotShowing(bibtexEntryArray[i]);
                        namedCompound.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bibtexEntryArray[i], BasePanel.this));
                    }
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.frame.output(Globals.lang("Deleted") + " " + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                }
            }
        });
        this.actions.put("paste", new BaseAction(){

            public void action() {
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (transferable != null) {
                    Object object;
                    Object object2;
                    BibtexEntry[] bibtexEntryArray = null;
                    if (transferable.isDataFlavorSupported(TransferableBibtexEntry.entryFlavor)) {
                        try {
                            bibtexEntryArray = (BibtexEntry[])transferable.getTransferData(TransferableBibtexEntry.entryFlavor);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        object2 = BasePanel.this.mainTable.getSelectedRows();
                        try {
                            Set set;
                            BibtexParser bibtexParser = new BibtexParser(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor)));
                            object = bibtexParser.parse().getDatabase();
                            Util.pr("Parsed " + ((BibtexDatabase)object).getEntryCount() + " entries from clipboard text");
                            if (((BibtexDatabase)object).getEntryCount() > 0 && (set = ((BibtexDatabase)object).getKeySet()) != null) {
                                bibtexEntryArray = new BibtexEntry[((BibtexDatabase)object).getEntryCount()];
                                Iterator iterator = set.iterator();
                                int n = 0;
                                while (iterator.hasNext()) {
                                    bibtexEntryArray[n] = ((BibtexDatabase)object).getEntryById((String)iterator.next());
                                    ++n;
                                }
                            }
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                        object2 = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "paste entries" : "paste entry"));
                        for (int i = 0; i < bibtexEntryArray.length; ++i) {
                            try {
                                object = (BibtexEntry)bibtexEntryArray[i].clone();
                                Util.setAutomaticFields((BibtexEntry)object);
                                ((BibtexEntry)object).setId(Util.createNeutralId());
                                BasePanel.this.database.insertEntry((BibtexEntry)object);
                                ((CompoundEdit)object2).addEdit(new UndoableInsertEntry(BasePanel.this.database, (BibtexEntry)object, BasePanel.this));
                                continue;
                            }
                            catch (KeyCollisionException keyCollisionException) {
                                Util.pr("KeyCollisionException... this shouldn't happen.");
                            }
                        }
                        ((CompoundEdit)object2).end();
                        BasePanel.this.undoManager.addEdit((UndoableEdit)object2);
                        BasePanel.this.output(Globals.lang("Pasted") + " " + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry")) + ".");
                        BasePanel.this.markBaseChanged();
                    }
                }
            }
        });
        this.actions.put("selectAll", new BaseAction(){

            public void action() {
                BasePanel.this.mainTable.selectAll();
            }
        });
        this.actions.put("editPreamble", new BaseAction(){

            public void action() {
                if (BasePanel.this.preambleEditor == null) {
                    PreambleEditor preambleEditor = new PreambleEditor(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(preambleEditor, BasePanel.this.frame);
                    preambleEditor.setVisible(true);
                    BasePanel.this.preambleEditor = preambleEditor;
                } else {
                    BasePanel.this.preambleEditor.setVisible(true);
                }
            }
        });
        this.actions.put("editStrings", new BaseAction(){

            public void action() {
                if (BasePanel.this.stringDialog == null) {
                    StringDialog stringDialog = new StringDialog(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(stringDialog, BasePanel.this.frame);
                    stringDialog.setVisible(true);
                    BasePanel.this.stringDialog = stringDialog;
                } else {
                    BasePanel.this.stringDialog.setVisible(true);
                }
            }
        });
        this.actions.put("toggleGroups", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.togglePanel("groups");
                BasePanel.this.frame.groupToggle.setSelected(BasePanel.this.sidePaneManager.isPanelVisible("groups"));
            }
        });
        this.actions.put("makeKey", new AbstractWorker(){
            List entries;
            int numSelected;
            boolean cancelled = false;

            public void init() {
                this.entries = new ArrayList<BibtexEntry>(Arrays.asList(BasePanel.this.getSelectedEntries()));
                this.numSelected = this.entries.size();
                if (this.entries.size() == 0) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang("First select the entries you want keys to be generated for."), Globals.lang("Autogenerate BibTeX key"), 1);
                    return;
                }
                BasePanel.this.frame.block();
                BasePanel.this.output(Globals.lang("Generating BibTeX key for") + " " + this.numSelected + " " + (this.numSelected > 1 ? Globals.lang("entries") : Globals.lang("entry")) + "...");
            }

            public void run() {
                Object object;
                BibtexEntry bibtexEntry = null;
                NamedCompound namedCompound = new NamedCompound(Globals.lang("autogenerate keys"));
                boolean bl = false;
                Object object2 = this.entries.iterator();
                while (object2.hasNext()) {
                    bibtexEntry = (BibtexEntry)object2.next();
                    if (bibtexEntry.getField("bibtexkey") == null) continue;
                    if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                        object2.remove();
                        continue;
                    }
                    if (!Globals.prefs.getBoolean("warnBeforeOverwritingKey")) continue;
                    object = new CheckBoxMessage(Globals.lang("One or more keys will be overwritten. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int n = JOptionPane.showConfirmDialog(BasePanel.this.frame, object, Globals.lang("Overwrite keys"), 0);
                    if (((CheckBoxMessage)object).isSelected()) {
                        Globals.prefs.putBoolean("warnBeforeOverwritingKey", false);
                    }
                    if (n != 1) break;
                    this.cancelled = true;
                    return;
                }
                object2 = new HashMap();
                if (!Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    object = this.entries.iterator();
                    while (object.hasNext()) {
                        bibtexEntry = (BibtexEntry)object.next();
                        ((HashMap)object2).put(bibtexEntry, bibtexEntry.getField("bibtexkey"));
                        BasePanel.this.database.setCiteKeyForEntry(bibtexEntry.getId(), null);
                    }
                }
                object = this.entries.iterator();
                while (object.hasNext()) {
                    bibtexEntry = (BibtexEntry)object.next();
                    bibtexEntry = LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), BasePanel.this.database, bibtexEntry);
                    namedCompound.addEdit(new UndoableKeyChange(BasePanel.this.database, bibtexEntry.getId(), (String)((HashMap)object2).get(bibtexEntry), (String)bibtexEntry.getField("bibtexkey")));
                }
                namedCompound.end();
                BasePanel.this.undoManager.addEdit(namedCompound);
            }

            public void update() {
                if (this.cancelled) {
                    BasePanel.this.frame.unblock();
                    return;
                }
                BasePanel.this.markBaseChanged();
                this.numSelected = this.entries.size();
                BasePanel.this.output(Globals.lang("Generated BibTeX key for") + " " + this.numSelected + " " + (this.numSelected != 1 ? Globals.lang("entries") : Globals.lang("entry")));
                BasePanel.this.frame.unblock();
            }
        });
        this.actions.put("search", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.ensureVisible("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.searchManager.startSearch();
            }
        });
        this.actions.put("toggleSearch", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.togglePanel("search");
                boolean bl = BasePanel.this.sidePaneManager.isPanelVisible("search");
                BasePanel.this.frame.searchToggle.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.searchManager.startSearch();
                }
            }
        });
        this.actions.put("incSearch", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.ensureVisible("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.searchManager.startIncrementalSearch();
            }
        });
        this.actions.put("copyKey", new BaseAction(){

            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<Object> vector = new Vector<Object>();
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        if (bibtexEntryArray[i].getField("bibtexkey") == null) continue;
                        vector.add(bibtexEntryArray[i].getField("bibtexkey"));
                    }
                    if (vector.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer stringBuffer = new StringBuffer((String)vector.elementAt(0));
                    for (int i = 1; i < vector.size(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append((String)vector.elementAt(i));
                    }
                    StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                    if (vector.size() == bibtexEntryArray.length) {
                        BasePanel.this.output(Globals.lang(bibtexEntryArray.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bibtexEntryArray.length - vector.size()) + " " + Globals.lang("out of") + " " + bibtexEntryArray.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("copyCiteKey", new BaseAction(){

            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<Object> vector = new Vector<Object>();
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        if (bibtexEntryArray[i].getField("bibtexkey") == null) continue;
                        vector.add(bibtexEntryArray[i].getField("bibtexkey"));
                    }
                    if (vector.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer stringBuffer = new StringBuffer((String)vector.elementAt(0));
                    for (int i = 1; i < vector.size(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append((String)vector.elementAt(i));
                    }
                    StringSelection stringSelection = new StringSelection("\\cite{" + stringBuffer.toString() + "}");
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                    if (vector.size() == bibtexEntryArray.length) {
                        BasePanel.this.output(Globals.lang(bibtexEntryArray.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bibtexEntryArray.length - vector.size()) + " " + Globals.lang("out of") + " " + bibtexEntryArray.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("mergeDatabase", new AppendDatabaseAction(this.frame, this));
        this.actions.put("openFile", new BaseAction(){

            public void action() {
                new Thread(){

                    public void run() {
                        BibtexEntry[] bibtexEntryArray = (this).BasePanel.this.mainTable.getSelectedEntries();
                        String string = "ps";
                        if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                            Object object = bibtexEntryArray[0].getField("ps");
                            if (bibtexEntryArray[0].getField("pdf") != null) {
                                object = bibtexEntryArray[0].getField("pdf");
                                string = "pdf";
                            }
                            String string2 = null;
                            if (object != null) {
                                string2 = object.toString();
                            } else {
                                Object object2 = bibtexEntryArray[0].getField("bibtexkey");
                                if (object2 != null) {
                                    String string3 = object2.toString();
                                    String[] stringArray = new String[]{"pdf", "ps"};
                                    String string4 = System.getProperty("file.separator");
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        String string5;
                                        String string6 = Globals.prefs.get(stringArray[i] + "Directory");
                                        if (string6.endsWith(string4)) {
                                            string6 = string6.substring(0, string6.length() - string4.length());
                                        }
                                        if ((string5 = Util.findPdf(string3, stringArray[i], string6, new OpenFileFilter("." + stringArray[i]))) == null) continue;
                                        string2 = string6 + string4 + string5;
                                        break;
                                    }
                                }
                            }
                            if (string2 != null) {
                                try {
                                    Util.openExternalViewer(BasePanel.this.metaData(), string2, string);
                                    BasePanel.this.output(Globals.lang("External viewer called") + ".");
                                }
                                catch (IOException iOException) {
                                    BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                                }
                            } else {
                                BasePanel.this.output(Globals.lang("No pdf or ps defined, and no file matching Bibtex key found") + ".");
                            }
                        } else {
                            BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                        }
                    }
                }.start();
            }
        });
        this.actions.put("openUrl", new BaseAction(){

            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                String string = "doi";
                if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                    Object object = bibtexEntryArray[0].getField("doi");
                    if (bibtexEntryArray[0].getField("url") != null) {
                        object = bibtexEntryArray[0].getField("url");
                        string = "url";
                    }
                    if (object != null) {
                        try {
                            Util.openExternalViewer(BasePanel.this.metaData(), object.toString(), string);
                            BasePanel.this.output(Globals.lang("External viewer called") + ".");
                        }
                        catch (IOException iOException) {
                            BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No url defined") + ".");
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("replaceAll", new BaseAction(){

            public void action() {
                ReplaceStringDialog replaceStringDialog = new ReplaceStringDialog(BasePanel.this.frame);
                replaceStringDialog.setVisible(true);
                if (!replaceStringDialog.okPressed()) {
                    return;
                }
                int n = 0;
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Replace string"));
                if (!replaceStringDialog.selOnly()) {
                    Iterator iterator = BasePanel.this.database.getKeySet().iterator();
                    while (iterator.hasNext()) {
                        n += replaceStringDialog.replace(BasePanel.this.database.getEntryById((String)iterator.next()), namedCompound);
                    }
                } else {
                    BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        n += replaceStringDialog.replace(bibtexEntryArray[i], namedCompound);
                    }
                }
                BasePanel.this.output(Globals.lang("Replaced") + " " + n + " " + Globals.lang(n == 1 ? "occurence" : "occurences") + ".");
                if (n > 0) {
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("dupliCheck", new BaseAction(){

            public void action() {
                DuplicateSearch duplicateSearch = new DuplicateSearch(BasePanel.this);
                duplicateSearch.start();
            }
        });
        this.actions.put("strictDupliCheck", new BaseAction(){

            public void action() {
                StrictDuplicateSearch strictDuplicateSearch = new StrictDuplicateSearch(BasePanel.this);
                strictDuplicateSearch.start();
            }
        });
        this.actions.put("plainTextImport", new BaseAction(){

            public void action() {
                EntryTypeDialog entryTypeDialog = new EntryTypeDialog(BasePanel.this.frame);
                Util.placeDialog(entryTypeDialog, BasePanel.this);
                entryTypeDialog.setVisible(true);
                BibtexEntryType bibtexEntryType = entryTypeDialog.getChoice();
                if (bibtexEntryType == null) {
                    return;
                }
                String string = Util.createNeutralId();
                BibtexEntry bibtexEntry = new BibtexEntry(string, bibtexEntryType);
                TextInputDialog textInputDialog = new TextInputDialog(BasePanel.this.frame, BasePanel.this, "import", true, bibtexEntry);
                Util.placeDialog(textInputDialog, BasePanel.this);
                textInputDialog.setVisible(true);
                if (textInputDialog.okPressed()) {
                    Util.setAutomaticFields(Arrays.asList(bibtexEntry));
                    BasePanel.this.insertEntry(bibtexEntry);
                }
            }
        });
        this.actions.put("markEntries", new AbstractWorker(){
            private int besLength = -1;

            public void run() {
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Mark entries"));
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                this.besLength = bibtexEntryArray.length;
                if (bibtexEntryArray == null) {
                    return;
                }
                for (int i = 0; i < bibtexEntryArray.length; ++i) {
                    Util.markEntry(bibtexEntryArray[i], namedCompound);
                }
                namedCompound.end();
                BasePanel.this.undoManager.addEdit(namedCompound);
            }

            public void update() {
                BasePanel.this.markBaseChanged();
                BasePanel.this.output(Globals.lang("Marked selected") + " " + Globals.lang(this.besLength > 0 ? "entry" : "entries"));
            }
        });
        this.actions.put("unmarkEntries", new BaseAction(){

            public void action() {
                try {
                    NamedCompound namedCompound = new NamedCompound(Globals.lang("Unmark entries"));
                    BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                    if (bibtexEntryArray == null) {
                        return;
                    }
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        Util.unmarkEntry(bibtexEntryArray[i], BasePanel.this.database, namedCompound);
                    }
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.output(Globals.lang("Unmarked selected") + " " + Globals.lang(bibtexEntryArray.length > 0 ? "entry" : "entries"));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.actions.put("unmarkAll", new BaseAction(){

            public void action() {
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Unmark all"));
                Set set = BasePanel.this.database.getKeySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    BibtexEntry bibtexEntry = BasePanel.this.database.getEntryById((String)iterator.next());
                    Util.unmarkEntry(bibtexEntry, BasePanel.this.database, namedCompound);
                }
                namedCompound.end();
                BasePanel.this.undoManager.addEdit(namedCompound);
                BasePanel.this.markBaseChanged();
            }
        });
        this.actions.put("togglePreview", new BaseAction(){

            public void action() {
                boolean bl = !Globals.prefs.getBoolean("previewEnabled");
                Globals.prefs.putBoolean("previewEnabled", bl);
                BasePanel.this.frame.setPreviewActive(bl);
                BasePanel.this.frame.previewToggle.setSelected(bl);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAny", new BaseAction(){

            public void action() {
                boolean bl = !Globals.prefs.getBoolean("highlightGroupsMatchingAny");
                Globals.prefs.putBoolean("highlightGroupsMatchingAny", bl);
                BasePanel.this.frame.highlightAny.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.highlightAll.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAll", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAll", new BaseAction(){

            public void action() {
                boolean bl = !Globals.prefs.getBoolean("highlightGroupsMatchingAll");
                Globals.prefs.putBoolean("highlightGroupsMatchingAll", bl);
                BasePanel.this.frame.highlightAll.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.highlightAny.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAny", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("switchPreview", new BaseAction(){

            public void action() {
                BasePanel.this.selectionListener.switchPreview();
            }
        });
        this.actions.put("manageSelectors", new BaseAction(){

            public void action() {
                ContentSelectorDialog2 contentSelectorDialog2 = new ContentSelectorDialog2(BasePanel.this.frame, BasePanel.this.frame, BasePanel.this, false, BasePanel.this.metaData, null);
                Util.placeDialog(contentSelectorDialog2, BasePanel.this.frame);
                contentSelectorDialog2.setVisible(true);
            }
        });
        this.actions.put("exportToClipboard", new AbstractWorker(){
            String message = null;

            public void run() {
                Object object;
                Object object2;
                if (BasePanel.this.mainTable.getSelected().size() == 0) {
                    this.message = Globals.lang("No entries selected") + ".";
                    this.getCallBack().update();
                    return;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("BibTeXML", "bibtexml");
                hashMap.put("DocBook", "docbook");
                hashMap.put("HTML", "html");
                hashMap.put("RTF (Harvard)", "harvard/harvard");
                hashMap.put("Simple HTML", "simplehtml");
                for (int i = 0; i < Globals.prefs.customExports.size(); ++i) {
                    object2 = Globals.prefs.customExports.getElementAt(i)[0];
                    hashMap.put((String)object2, (String)object2);
                }
                Object[] objectArray = hashMap.keySet().toArray();
                Arrays.sort(objectArray);
                object2 = new JList<Object>(objectArray);
                ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
                ((JList)object2).setSelectionInterval(0, 0);
                ((JList)object2).setSelectionMode(0);
                int n = JOptionPane.showOptionDialog(BasePanel.this.frame, object2, Globals.lang("Select format"), 0, 3, null, new String[]{Globals.lang("Ok"), Globals.lang("Cancel")}, Globals.lang("Ok"));
                if (n == 1) {
                    return;
                }
                String string = (String)hashMap.get(((JList)object2).getSelectedValue());
                boolean bl = ((JList)object2).getSelectedIndex() >= Globals.STANDARD_EXPORT_COUNT;
                String string2 = null;
                if (bl) {
                    int n2 = ((JList)object2).getSelectedIndex() - Globals.STANDARD_EXPORT_COUNT;
                    string2 = Globals.prefs.customExports.getElementAt(n2)[1];
                    object = new File(string2);
                    string = ((File)object).getName();
                    string = string.substring(0, string.indexOf("."));
                    string2 = ((File)object).getParent() + System.getProperty("file.separator");
                }
                String string3 = string;
                object = string2;
                try {
                    BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                    StringWriter stringWriter = new StringWriter();
                    FileActions.exportEntries(BasePanel.this.database, bibtexEntryArray, string3, bl, (String)object, stringWriter);
                    ClipboardOwner clipboardOwner = new ClipboardOwner(){

                        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                        }
                    };
                    RtfSelection rtfSelection = new RtfSelection(stringWriter.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(rtfSelection, clipboardOwner);
                    this.message = Globals.lang("Entries exported to clipboard") + ": " + bibtexEntryArray.length;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void update() {
                BasePanel.this.output(this.message);
            }
        });
        this.actions.put("abbreviateIso", new AbbreviateAction(this, true));
        this.actions.put("abbreviateMedline", new AbbreviateAction(this, false));
        this.actions.put("unabbreviate", new UnabbreviateAction(this));
        this.actions.put("autoSetPdf", new AutoSetExternalFileForEntries(this, "pdf"));
        this.actions.put("autoSetPs", new AutoSetExternalFileForEntries(this, "ps"));
    }

    public void runCommand(String string) {
        String string2 = string;
        if (this.actions.get(string2) == null) {
            Util.pr("No action defined for'" + string2 + "'");
        } else {
            Object v = this.actions.get(string2);
            try {
                if (v instanceof BaseAction) {
                    ((BaseAction)v).action();
                } else {
                    Worker worker = ((AbstractWorker)v).getWorker();
                    CallBack callBack = ((AbstractWorker)v).getCallBack();
                    ((AbstractWorker)v).init();
                    worker.run();
                    callBack.update();
                }
            }
            catch (Throwable throwable) {
                this.frame.unblock();
                throwable.printStackTrace();
            }
        }
    }

    private boolean saveDatabase(File file, boolean bl, String string) throws SaveException {
        SaveSession saveSession;
        this.frame.block();
        try {
            saveSession = !bl ? FileActions.saveDatabase(this.database, this.metaData, file, Globals.prefs, false, false, string) : FileActions.savePartOfDatabase(this.database, this.metaData, file, Globals.prefs, this.mainTable.getSelectedEntries(), string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file. Character encoding '%0' is not supported.", string), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        catch (SaveException saveException) {
            if (saveException.specificEntry()) {
                int n = this.mainTable.findEntry(saveException.getEntry());
                int n2 = Math.max(0, n - 3);
                this.mainTable.setRowSelectionInterval(n, n);
                this.mainTable.scrollTo(n2);
                this.showEntry(saveException.getEntry());
            } else {
                saveException.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + saveException.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean bl2 = true;
        if (!saveSession.getWriter().couldEncodeAll()) {
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
            JTextArea jTextArea = new JTextArea(saveSession.getWriter().getProblemCharacters());
            jTextArea.setEditable(false);
            defaultFormBuilder.append(Globals.lang("The chosen encoding '%0' could not encode the following characters: ", saveSession.getEncoding()));
            defaultFormBuilder.append(jTextArea);
            defaultFormBuilder.append(Globals.lang("What do you want to do?"));
            String string2 = Globals.lang("Try different encoding");
            int n = JOptionPane.showOptionDialog(this.frame, defaultFormBuilder.getPanel(), Globals.lang("Save database"), 1, 2, null, new String[]{Globals.lang("Save"), string2, Globals.lang("Cancel")}, string2);
            if (n == 1) {
                Object object = JOptionPane.showInputDialog(this.frame, Globals.lang("Select encoding"), Globals.lang("Save database"), 3, null, Globals.ENCODINGS, string);
                if (object != null) {
                    String string3 = (String)object;
                    return this.saveDatabase(file, bl, string3);
                }
                bl2 = false;
            } else if (n == 2) {
                bl2 = false;
            }
        }
        try {
            if (bl2) {
                saveSession.commit();
                this.encoding = string;
            } else {
                saveSession.cancel();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl2;
    }

    public void newEntry(BibtexEntryType bibtexEntryType) {
        Object object;
        if (bibtexEntryType == null) {
            object = new EntryTypeDialog(this.frame);
            Util.placeDialog((Dialog)object, this.frame);
            ((Dialog)object).setVisible(true);
            bibtexEntryType = ((EntryTypeDialog)object).getChoice();
        }
        if (bibtexEntryType != null) {
            object = Util.createNeutralId();
            BibtexEntry bibtexEntry = new BibtexEntry((String)object, bibtexEntryType);
            try {
                this.database.insertEntry(bibtexEntry);
                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
                arrayList.add(bibtexEntry);
                Util.setAutomaticFields(arrayList);
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, bibtexEntry, this));
                this.output(Globals.lang("Added new") + " '" + bibtexEntryType.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                int n = this.mainTable.findEntry(bibtexEntry);
                if (this.mode != 2) {
                    this.mode = 3;
                }
                this.highlightEntry(bibtexEntry);
                this.markBaseChanged();
                new FocusRequester(this.getEntryEditor(bibtexEntry));
            }
            catch (KeyCollisionException keyCollisionException) {
                Util.pr(keyCollisionException.getMessage());
            }
        }
    }

    public void insertEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry != null) {
            try {
                this.database.insertEntry(bibtexEntry);
                if (Globals.prefs.getBoolean("useOwner")) {
                    bibtexEntry.setField("owner", Globals.prefs.get("defaultOwner"));
                }
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, bibtexEntry, this));
                this.output(Globals.lang("Added new") + " '" + bibtexEntry.getType().getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                int n = this.mainTable.findEntry(bibtexEntry);
                this.mainTable.clearSelection();
                this.mainTable.scrollTo(n);
                this.markBaseChanged();
                if (Globals.prefs.getBoolean("autoOpenForm")) {
                    this.showEntry(bibtexEntry);
                }
            }
            catch (KeyCollisionException keyCollisionException) {
                Util.pr(keyCollisionException.getMessage());
            }
        }
    }

    public void createMainTable() {
        GlazedEntrySorter glazedEntrySorter = new GlazedEntrySorter(this.database.getEntryMap(), null);
        this.database.addDatabaseChangeListener(glazedEntrySorter);
        this.groupFilterList = new FilterList(glazedEntrySorter.getTheList(), NoSearchMatcher.INSTANCE);
        this.searchFilterList = new FilterList((EventList)this.groupFilterList, NoSearchMatcher.INSTANCE);
        MainTableFormat mainTableFormat = new MainTableFormat(this);
        mainTableFormat.updateTableFormat();
        this.mainTable = new MainTable(mainTableFormat, this.searchFilterList, this.frame);
        this.selectionListener = new MainTableSelectionListener(this, this.mainTable);
        this.mainTable.updateFont();
        this.mainTable.addSelectionListener(this.selectionListener);
        this.mainTable.addMouseListener(this.selectionListener);
        this.groupsHighlightListener = new ListEventListener(){

            public void listChanged(ListEvent listEvent) {
                if (Globals.prefs.getBoolean("highlightGroupsMatchingAny")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), false);
                } else if (Globals.prefs.getBoolean("highlightGroupsMatchingAll")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), true);
                } else {
                    BasePanel.this.getGroupSelector().showMatchingGroups(null, true);
                }
            }
        };
        this.mainTable.addSelectionListener(this.groupsHighlightListener);
        this.mainTable.getActionMap().put("cut", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("copy", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("paste", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                GroupTreeNode groupTreeNode;
                int n = keyEvent.getKeyCode();
                TreePath treePath = BasePanel.this.frame.groupSelector.getSelectionPath();
                GroupTreeNode groupTreeNode2 = groupTreeNode = treePath == null ? null : (GroupTreeNode)treePath.getLastPathComponent();
                if (keyEvent.isControlDown()) {
                    switch (n) {
                        case 38: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeUp(groupTreeNode, true);
                            break;
                        }
                        case 40: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeDown(groupTreeNode, true);
                            break;
                        }
                        case 37: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeLeft(groupTreeNode, true);
                            break;
                        }
                        case 39: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeRight(groupTreeNode, true);
                            break;
                        }
                        case 34: {
                            BasePanel.this.frame.nextTab.actionPerformed(null);
                            keyEvent.consume();
                            break;
                        }
                        case 33: {
                            BasePanel.this.frame.prevTab.actionPerformed(null);
                            keyEvent.consume();
                        }
                    }
                } else if (n == 10) {
                    keyEvent.consume();
                    try {
                        BasePanel.this.runCommand("edit");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        });
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(4);
        this.createMainTable();
        this.splitPane.setTopComponent(this.mainTable.getPane());
        if (this.mode == 1) {
            this.mode = 0;
            int n = this.mainTable.findEntry(this.currentPreview.entry);
            if (n >= 0) {
                this.mainTable.setRowSelectionInterval(n, n);
            }
        } else if (this.mode == 2) {
            this.mode = 0;
        } else {
            this.splitPane.setBottomComponent(null);
        }
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.splitPane, "Center");
        this.splitPane.revalidate();
        this.revalidate();
        this.repaint();
    }

    public void parseMetaData(HashMap hashMap) {
        this.metaData = new MetaData(hashMap, this.database());
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void updateEntryPreviewToRow(BibtexEntry bibtexEntry) {
    }

    public void adjustSplitter() {
        int n = this.getMode();
        if (n == 1) {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - 200);
        } else {
            this.splitPane.setDividerLocation(0.4);
        }
    }

    public boolean entryEditorAllowsChange() {
        Component component = this.splitPane.getBottomComponent();
        if (component != null && component instanceof EntryEditor) {
            return ((EntryEditor)component).lastSourceAccepted();
        }
        return true;
    }

    public void moveFocusToEntryEditor() {
        Component component = this.splitPane.getBottomComponent();
        if (component != null && component instanceof EntryEditor) {
            new FocusRequester(component);
        }
    }

    public void hidePreview() {
        Globals.prefs.putBoolean("previewEnabled", false);
        Component component = this.splitPane.getBottomComponent();
        if (component != null && !(component instanceof EntryEditor)) {
            this.splitPane.setBottomComponent(null);
        }
    }

    public boolean isShowingEditor() {
        return this.splitPane.getBottomComponent() != null && this.splitPane.getBottomComponent() instanceof EntryEditor;
    }

    public void showEntry(BibtexEntry bibtexEntry) {
        if (this.showing == bibtexEntry) {
            if (this.splitPane.getBottomComponent() == null) {
                this.showing = null;
                this.showEntry(bibtexEntry);
            } else {
                ((EntryEditor)this.splitPane.getBottomComponent()).updateAllFields();
            }
            return;
        }
        int n = -1;
        String string = null;
        if (this.showing != null) {
            string = ((EntryEditor)this.splitPane.getBottomComponent()).getVisiblePanelName();
        }
        if (this.showing != null) {
            n = this.splitPane.getDividerLocation();
        }
        if (this.entryEditors.containsKey(bibtexEntry.getType().getName())) {
            EntryEditor entryEditor = (EntryEditor)this.entryEditors.get(bibtexEntry.getType().getName());
            entryEditor.switchTo(bibtexEntry);
            if (string != null) {
                entryEditor.setVisiblePanel(string);
            }
            this.splitPane.setBottomComponent(entryEditor);
        } else {
            EntryEditor entryEditor = new EntryEditor(this.frame, this, bibtexEntry);
            if (string != null) {
                entryEditor.setVisiblePanel(string);
            }
            this.splitPane.setBottomComponent(entryEditor);
            this.entryEditors.put(bibtexEntry.getType().getName(), entryEditor);
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
        } else {
            this.splitPane.setDividerLocation(0.4);
        }
        this.showing = bibtexEntry;
        this.setEntryEditorEnabled(true);
    }

    public EntryEditor getEntryEditor(BibtexEntry bibtexEntry) {
        EntryEditor entryEditor;
        if (this.entryEditors.containsKey(bibtexEntry.getType().getName())) {
            EntryEditor entryEditor2 = this.currentEditor;
            entryEditor = (EntryEditor)this.entryEditors.get(bibtexEntry.getType().getName());
            entryEditor.switchTo(bibtexEntry);
        } else {
            entryEditor = new EntryEditor(this.frame, this, bibtexEntry);
            this.entryEditors.put(bibtexEntry.getType().getName(), entryEditor);
        }
        return entryEditor;
    }

    public EntryEditor getCurrentEditor() {
        return this.currentEditor;
    }

    public void showEntryEditor(EntryEditor entryEditor) {
        int n = -1;
        if (this.mode == 2) {
            n = this.splitPane.getDividerLocation();
        }
        boolean bl = this.mode == 3;
        this.mode = 2;
        this.currentEditor = entryEditor;
        this.splitPane.setBottomComponent(entryEditor);
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
        }
        if (bl) {
            this.adjustSplitter();
        }
    }

    public void showPreview(PreviewPanel previewPanel) {
        this.mode = 1;
        this.currentPreview = previewPanel;
        this.splitPane.setBottomComponent(previewPanel.getPane());
    }

    public void hideBottomComponent() {
        this.mode = 0;
        this.splitPane.setBottomComponent(null);
    }

    public void highlightEntry(BibtexEntry bibtexEntry) {
        int n = this.mainTable.findEntry(bibtexEntry);
        if (n >= 0) {
            this.mainTable.setRowSelectionInterval(n, n);
            this.mainTable.ensureVisible(n);
        }
    }

    public void entryEditorClosing(EntryEditor entryEditor) {
        this.selectionListener.entryEditorClosing(entryEditor);
    }

    public void ensureNotShowing(BibtexEntry bibtexEntry) {
        if (this.mode == 2 && this.currentEditor.getEntry() == bibtexEntry) {
            this.selectionListener.entryEditorClosing(this.currentEditor);
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == 2) {
            if (this.currentEditor.getType() != this.currentEditor.getEntry().getType()) {
                this.showing = null;
                EntryEditor entryEditor = this.getEntryEditor(this.currentEditor.getEntry());
                this.showEntryEditor(entryEditor);
            } else {
                this.currentEditor.updateAllFields();
                this.currentEditor.updateSource();
            }
        }
    }

    public void storeCurrentEdit() {
        if (this.isShowingEditor()) {
            EntryEditor entryEditor = (EntryEditor)this.splitPane.getBottomComponent();
            entryEditor.storeCurrentEdit();
        }
    }

    public void updateAllContentSelectors() {
        Iterator iterator = this.entryEditors.keySet().iterator();
        while (iterator.hasNext()) {
            EntryEditor entryEditor = (EntryEditor)this.entryEditors.get(iterator.next());
            entryEditor.updateAllContentSelectors();
        }
    }

    public void rebuildAllEntryEditors() {
        Iterator iterator = this.entryEditors.keySet().iterator();
        while (iterator.hasNext()) {
            EntryEditor entryEditor = (EntryEditor)this.entryEditors.get(iterator.next());
            entryEditor.rebuildPanels();
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        String string = this.frame.getTabTitle(this);
        if (!string.endsWith("*")) {
            this.frame.setTabTitle(this, string + "*");
        }
        if (this.frame.statusLine.getText().startsWith("Saved database")) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    public synchronized void markChangedOrUnChanged() {
        if (this.undoManager.hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.file != null) {
                this.frame.setTabTitle(this, this.file.getName());
            } else {
                this.frame.setTabTitle(this, Globals.lang("untitled"));
            }
        }
    }

    public void selectSingleEntry(int n) {
        this.mainTable.clearSelection();
        this.mainTable.addRowSelectionInterval(n, n);
        this.mainTable.scrollToCenter(n, 0);
    }

    public void setSearchMatcher(SearchMatcher searchMatcher) {
        this.searchFilterList.setMatcher(searchMatcher);
    }

    public void setGroupMatcher(Matcher matcher) {
        this.groupFilterList.setMatcher(matcher);
    }

    public void stopShowingSearchResults() {
        this.searchFilterList.setMatcher(NoSearchMatcher.INSTANCE);
    }

    public void stopShowingGroup() {
        this.groupFilterList.setMatcher(NoSearchMatcher.INSTANCE);
    }

    public BibtexDatabase getDatabase() {
        return this.database;
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void changeType(BibtexEntry bibtexEntry, BibtexEntryType bibtexEntryType) {
        this.changeType(new BibtexEntry[]{bibtexEntry}, bibtexEntryType);
    }

    public void changeType(BibtexEntryType bibtexEntryType) {
        BibtexEntry[] bibtexEntryArray = this.mainTable.getSelectedEntries();
        this.changeType(bibtexEntryArray, bibtexEntryType);
    }

    public void changeType(BibtexEntry[] bibtexEntryArray, BibtexEntryType bibtexEntryType) {
        int n;
        if (bibtexEntryArray == null || bibtexEntryArray.length == 0) {
            this.output("First select the entries you wish to change type for.");
            return;
        }
        if (bibtexEntryArray.length > 1 && (n = JOptionPane.showConfirmDialog(this, "Multiple entries selected. Do you want to change\nthe type of all these to '" + bibtexEntryType.getName() + "'?", "Change type", 0, 2)) == 1) {
            return;
        }
        NamedCompound namedCompound = new NamedCompound(Globals.lang("change type"));
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            namedCompound.addEdit(new UndoableChangeType(bibtexEntryArray[i], bibtexEntryArray[i].getType(), bibtexEntryType));
            bibtexEntryArray[i].setType(bibtexEntryType);
        }
        this.output(Globals.lang("Changed type to") + " '" + bibtexEntryType.getName() + "' " + Globals.lang("for") + " " + bibtexEntryArray.length + " " + Globals.lang("entries") + ".");
        namedCompound.end();
        this.undoManager.addEdit(namedCompound);
        this.markBaseChanged();
        this.updateEntryEditorIfShowing();
    }

    public boolean showDeleteConfirmationDialog(int n) {
        if (Globals.prefs.getBoolean("confirmDelete")) {
            String string = Globals.lang("Really delete the selected") + " " + Globals.lang("entry") + "?";
            String string2 = Globals.lang("Delete entry");
            if (n > 1) {
                string = Globals.lang("Really delete the selected") + " " + n + " " + Globals.lang("entries") + "?";
                string2 = Globals.lang("Delete multiple entries");
            }
            CheckBoxMessage checkBoxMessage = new CheckBoxMessage(string, Globals.lang("Disable this confirmation dialog"), false);
            int n2 = JOptionPane.showConfirmDialog(this.frame, checkBoxMessage, string2, 0, 3);
            if (checkBoxMessage.isSelected()) {
                Globals.prefs.putBoolean("confirmDelete", false);
            }
            return n2 == 0;
        }
        return true;
    }

    public void setPreviewActive(boolean bl) {
        this.selectionListener.setPreviewActive(bl);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setEntryEditorEnabled(boolean bl) {
        EntryEditor entryEditor;
        if (this.showing != null && this.splitPane.getBottomComponent() instanceof EntryEditor && (entryEditor = (EntryEditor)this.splitPane.getBottomComponent()).isEnabled() != bl) {
            entryEditor.setEnabled(bl);
        }
    }

    public String fileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    public void fileUpdated() {
        if (this.saving) {
            return;
        }
        this.updatedExternally = true;
        Thread thread = new Thread(){

            public void run() {
                ChangeScanner changeScanner = new ChangeScanner(BasePanel.this.frame, BasePanel.this);
                changeScanner.changeScan(BasePanel.this.file());
                try {
                    changeScanner.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (changeScanner.changesFound()) {
                    FileUpdatePanel fileUpdatePanel = new FileUpdatePanel(BasePanel.this.frame, BasePanel.this, BasePanel.this.sidePaneManager, BasePanel.this.file, changeScanner);
                    BasePanel.this.sidePaneManager.add("fileUpdate", fileUpdatePanel);
                    BasePanel.this.setUpdatedExternally(false);
                } else {
                    BasePanel.this.setUpdatedExternally(false);
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    public void fileRemoved() {
        Util.pr("File '" + this.file.getPath() + "' has been deleted.");
    }

    public void cleanUp() {
        if (this.fileMonitorHandle != null) {
            Globals.fileUpdateMonitor.removeUpdateListener(this.fileMonitorHandle);
        }
    }

    public void setUpdatedExternally(boolean bl) {
        this.updatedExternally = bl;
    }

    public BibtexEntry[] getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public String getKeysForSelection() {
        EventList eventList = this.mainTable.getSelected();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        boolean bl = true;
        Iterator iterator = eventList.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            string = (String)bibtexEntry.getField("bibtexkey");
            if (string == null || string.equals("")) continue;
            if (bl) {
                stringBuffer.append(string);
                bl = false;
                continue;
            }
            stringBuffer.append(",").append(string);
        }
        return stringBuffer.toString();
    }

    public GroupSelector getGroupSelector() {
        return this.frame.groupSelector;
    }

    class RedoAction
    extends BaseAction {
        RedoAction() {
        }

        public void action() {
            try {
                String string = BasePanel.this.undoManager.getRedoPresentationName();
                BasePanel.this.undoManager.redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(string);
            }
            catch (CannotRedoException cannotRedoException) {
                BasePanel.this.frame.output(Globals.lang("Nothing to redo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    class UndoAction
    extends BaseAction {
        UndoAction() {
        }

        public void action() {
            try {
                String string = BasePanel.this.undoManager.getUndoPresentationName();
                BasePanel.this.undoManager.undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(string);
            }
            catch (CannotUndoException cannotUndoException) {
                BasePanel.this.frame.output(Globals.lang("Nothing to undo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }
}

