/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class LongOption
extends Option {
    private long value;

    public LongOption() {
        this(0L);
    }

    public LongOption(LongOption longOption) {
        super(longOption);
        longOption.value = longOption.getValue();
    }

    public LongOption(long l) {
        this(l, null);
    }

    public LongOption(long l, String string) {
        this(l, string, '\u0000');
    }

    public LongOption(long l, char c) {
        this(l, null, c);
    }

    public LongOption(long l, String string, char c) {
        super(string, c);
        this.value = l;
    }

    public Object getObject() {
        return new Long(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. A long must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(long l) {
        this.value = l;
    }

    public long getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Long.toString(this.value);
    }

    public String getTypeName() {
        return "LONG";
    }

    public String toString() {
        return this.getStringValue();
    }
}

