/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class DoubleOption
extends Option {
    private double value;

    public DoubleOption() {
        this(0.0);
    }

    public DoubleOption(DoubleOption doubleOption) {
        super(doubleOption);
        doubleOption.value = doubleOption.getValue();
    }

    public DoubleOption(double d) {
        this(d, null);
    }

    public DoubleOption(double d, String string) {
        this(d, string, '\u0000');
    }

    public DoubleOption(double d, char c) {
        this(d, null, c);
    }

    public DoubleOption(double d, String string, char c) {
        super(string, c);
        this.value = d;
    }

    public Object getObject() {
        return new Double(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. A double must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Double.toString(this.value);
    }

    public String getTypeName() {
        return "DOUBLE";
    }

    public String toString() {
        return this.getStringValue();
    }
}

