/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class BooleanOption
extends Option {
    private boolean value;

    public BooleanOption() {
        this(false);
    }

    public BooleanOption(BooleanOption booleanOption) {
        super(booleanOption);
        booleanOption.value = booleanOption.getValue();
    }

    public BooleanOption(boolean bl) {
        this(bl, null);
    }

    public BooleanOption(boolean bl, String string) {
        this(bl, string, '\u0000');
    }

    public BooleanOption(boolean bl, char c) {
        this(bl, null, c);
    }

    public BooleanOption(boolean bl, String string, char c) {
        super(string, c);
        this.value = bl;
    }

    public Object getObject() {
        return this.value;
    }

    public void modify(String string) throws OptionModificationException {
        String string2 = string.toUpperCase();
        this.value = false;
        if (string2.equals("+") || string2.equals("TRUE") || string2.equals("YES") || string2.equals("ON") || string2.equals("ACTIVATED") || string2.equals("ACTIVE")) {
            this.value = true;
        } else if (string2.equals("-") || string2.equals("FALSE") || string2.equals("NO") || string2.equals("OFF") || string2.equals("NOT ACTIVATED") || string2.equals("INACTIVE")) {
            this.value = false;
        } else {
            throw new OptionModificationException("Error. A boolean value of\n+/-/true/false/yes/no/on/off/activated/not activated/active/inactive must be\nspecified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value ? "TRUE" : "FALSE";
    }

    public String getTypeName() {
        return "BOOLEAN";
    }

    public String toString() {
        return this.getStringValue();
    }
}

