/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.List;

public final class FreezableList
extends TransformedList {
    private boolean frozen = false;
    private List frozenData = new ArrayList();

    public FreezableList(EventList source) {
        super(source);
        source.addListEventListener(this);
    }

    public Object get(int index) {
        if (this.frozen) {
            return this.frozenData.get(index);
        }
        return this.source.get(index);
    }

    public int size() {
        if (this.frozen) {
            return this.frozenData.size();
        }
        return this.source.size();
    }

    protected boolean isWritable() {
        return !this.frozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot freeze a list that is already frozen");
        }
        this.source.removeListEventListener(this);
        this.frozenData.addAll(this.source);
        this.frozen = true;
    }

    public void thaw() {
        if (!this.frozen) {
            throw new IllegalStateException("Cannot thaw a list that is not frozen");
        }
        this.frozen = false;
        int frozenDataSize = this.frozenData.size();
        this.frozenData.clear();
        this.updates.beginEvent();
        if (frozenDataSize > 0) {
            this.updates.addDelete(0, frozenDataSize - 1);
        }
        if (this.source.size() > 0) {
            this.updates.addInsert(0, this.source.size() - 1);
        }
        this.updates.commitEvent();
        this.source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        if (!this.frozen) {
            this.updates.forwardEvent(listChanges);
        }
    }
}

