/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui.table;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.schmunk.gui.table.ColumnGroup;
import net.schmunk.gui.table.GroupableTableHeaderUI;

public class GroupableTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public Enumeration getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration enumx = this.columnGroups.elements();
        while (enumx.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumx.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration enumx = this.columnGroups.elements();
        while (enumx.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumx.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

