/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer r, String t) {
        this.renderer = r == null ? new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : r;
        this.text = t;
        this.v = new Vector();
    }

    public void add(Object o) {
        if (o == null) {
            return;
        }
        this.v.addElement(o);
    }

    public Vector getColumnGroups(TableColumn c, Vector g) {
        g.addElement(this);
        if (this.v.contains(c)) {
            return g;
        }
        Enumeration enumx = this.v.elements();
        while (enumx.hasMoreElements()) {
            Vector groups;
            Object o = enumx.nextElement();
            if (!(o instanceof ColumnGroup) || (groups = ((ColumnGroup)o).getColumnGroups(c, (Vector)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer r) {
        if (r != null) {
            this.renderer = r;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration enumx = this.v.elements();
        while (enumx.hasMoreElements()) {
            Object obj = enumx.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration enumx = this.v.elements();
        while (enumx.hasMoreElements()) {
            Object o = enumx.nextElement();
            if (!(o instanceof ColumnGroup)) continue;
            ((ColumnGroup)o).setColumnMargin(margin);
        }
    }
}

