/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class JPlusMinus
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PLUS = 2000;
    public static final int MINUS = 2001;
    private static ImageIcon plusIcon;
    private static ImageIcon minusIcon;
    private static Insets noMargin;
    private Action plusAction;
    private Action minusAction;
    private boolean plusEnabled = true;
    private boolean minusEnabled = true;
    private EventListenerList listenerList = new EventListenerList();

    public JPlusMinus() {
        this(0, 2, null);
    }

    public JPlusMinus(String name) {
        this(0, 2, name);
    }

    private JPlusMinus(int axis, int gap) {
        this(axis, gap, null);
    }

    private JPlusMinus(int axis, int gap, String name) {
        this.setLayout(new BoxLayout(this, axis));
        if (plusIcon == null) {
            plusIcon = new ImageIcon(JPlusMinus.class.getResource("gfx/plusbutton.png"));
            minusIcon = new ImageIcon(JPlusMinus.class.getResource("gfx/minusbutton.png"));
            noMargin = new Insets(0, 0, 0, 0);
        }
        this.plusAction = new PlusAction();
        this.minusAction = new MinusAction();
        JButton plusButton = new JButton();
        plusButton.setAction(this.plusAction);
        plusButton.setIcon(plusIcon);
        plusButton.setText(null);
        plusButton.setRolloverEnabled(true);
        plusButton.setMargin(noMargin);
        plusButton.setBorderPainted(false);
        plusButton.setContentAreaFilled(false);
        JButton minusButton = new JButton();
        minusButton.setAction(this.minusAction);
        minusButton.setIcon(minusIcon);
        minusButton.setText(null);
        minusButton.setRolloverEnabled(true);
        minusButton.setMargin(noMargin);
        minusButton.setBorderPainted(false);
        minusButton.setContentAreaFilled(false);
        if (axis == 1) {
            this.add(Box.createVerticalGlue());
            this.add(plusButton);
            this.add(Box.createVerticalStrut(gap));
            this.add(minusButton);
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(plusButton);
            this.add(Box.createHorizontalStrut(gap));
            if (name != null) {
                this.add(new JLabel(name));
                this.add(Box.createHorizontalStrut(gap));
            }
            this.add(minusButton);
            this.add(Box.createHorizontalGlue());
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.plusAction.setEnabled(this.plusEnabled);
            this.plusAction.setEnabled(this.minusEnabled);
        } else {
            this.plusAction.setEnabled(false);
            this.plusAction.setEnabled(false);
        }
    }

    public boolean isIconEnabled(int iconID) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            return this.plusEnabled;
        }
        if (iconID == 2001) {
            return this.minusEnabled;
        }
        return false;
    }

    public void setIconEnabled(int iconID, boolean enabled) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            this.plusEnabled = enabled;
            this.plusAction.setEnabled(this.plusEnabled);
        } else if (iconID == 2001) {
            this.minusEnabled = enabled;
            this.minusAction.setEnabled(this.minusEnabled);
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireAction(int iconID) {
        ActionEvent e;
        if (iconID == 2000) {
            e = new ActionEvent(this, 2000, "plus");
        } else if (iconID == 2001) {
            e = new ActionEvent(this, 2001, "minus");
        } else {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        EventListener[] listeners = this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    class MinusAction
    extends AbstractAction {
        MinusAction() {
            super("Subtract");
        }

        public void actionPerformed(ActionEvent e) {
            JPlusMinus.this.fireAction(2001);
        }
    }

    class PlusAction
    extends AbstractAction {
        PlusAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            JPlusMinus.this.fireAction(2000);
        }
    }
}

