/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.EventListenerList;
import net.schmunk.gui.PositiveDoubleVerifier;

public class JMeasurementField
extends JPanel
implements SwingConstants,
ActionListener,
FocusListener,
ItemListener {
    private EventListenerList listenerList = new EventListenerList();
    private JTextField valueTF;
    private JComboBox unitsCB;
    private int hAlignment = 2;
    private int vAlignment = 1;

    public JMeasurementField() {
        this(new JTextField(), new JComboBox());
    }

    public JMeasurementField(String value, String[] unitsArray) {
        this(new JTextField(value), new JComboBox<String>(unitsArray));
    }

    public JMeasurementField(String value, int columns, String[] unitsArray) {
        this(new JTextField(value, columns), new JComboBox<String>(unitsArray));
    }

    public JMeasurementField(JTextField tf, JComboBox cb) {
        this.setLayout(new BoxLayout(this, 0));
        this.valueTF = tf;
        this.unitsCB = cb;
        this.valueTF.setInputVerifier(new PositiveDoubleVerifier());
        this.valueTF.addActionListener(this);
        this.valueTF.addFocusListener(this);
        this.unitsCB.addItemListener(this);
        this.valueTF.setMinimumSize(this.valueTF.getPreferredSize());
        this.valueTF.setMaximumSize(this.valueTF.getPreferredSize());
        this.valueTF.setAlignmentY(0.5f);
        this.unitsCB.setAlignmentY(0.5f);
        this.add(this.valueTF);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.unitsCB);
        this.add(Box.createHorizontalGlue());
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.valueTF.setEnabled(enabled);
        this.unitsCB.setEnabled(enabled);
    }

    public String getValue() {
        return this.valueTF.getText();
    }

    public void setValue(String value) {
        this.valueTF.setText(value);
    }

    public Font getValueFont() {
        return this.valueTF.getFont();
    }

    public void setValueFont(Font font) {
        this.valueTF.setFont(font);
    }

    public int getUnitsCount() {
        return this.unitsCB.getItemCount();
    }

    public int getUnitsIndex() {
        return this.unitsCB.getSelectedIndex();
    }

    public String getUnits() {
        return (String)this.unitsCB.getSelectedItem();
    }

    public void setUnits(String units) {
        this.unitsCB.setSelectedItem(units);
    }

    public void addUnits(String units) {
        this.unitsCB.addItem(units);
    }

    public void insertUnitsAt(String units, int index) {
        this.unitsCB.insertItemAt(units, index);
    }

    public Font getUnitsFont() {
        return this.unitsCB.getFont();
    }

    public void setUnitsFont(Font font) {
        this.unitsCB.setFont(font);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void fireAction() {
        ActionEvent e = new ActionEvent(this, 0, null);
        EventListener[] listeners = this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireAction();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.fireAction();
    }

    public void itemStateChanged(ItemEvent e) {
        this.fireAction();
    }
}

