/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import net.schmunk.gui.FGConstraint;

public class FlexingGridLayout
implements LayoutManager2 {
    private Dimension gridsize;
    private int hGap;
    private int vGap;
    private boolean hRigid = false;
    private boolean vRigid = false;
    private Hashtable compTable;
    private float[] colWeight;
    private float[] rowWeight;
    private int[] prefWidths;
    private int[] prefHeights;

    public FlexingGridLayout() {
        this(new Dimension(1, 1));
    }

    public FlexingGridLayout(Dimension size) {
        this(size, 0, 0);
    }

    public FlexingGridLayout(Dimension size, int hGap, int vGap) {
        this.setGridsize(size);
        this.hGap = hGap;
        this.vGap = vGap;
        this.compTable = new Hashtable();
    }

    public Dimension getGridsize() {
        return new Dimension(this.gridsize);
    }

    public void setGridsize(Dimension size) {
        this.setGridsize(size.width, size.height);
    }

    public void setGridsize(int w, int h) {
        int i;
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("Dimensions must be greater than zero");
        }
        this.gridsize = new Dimension(w, h);
        this.prefWidths = new int[w];
        this.prefHeights = new int[h];
        this.colWeight = new float[w];
        this.rowWeight = new float[h];
        for (i = 0; i < w; ++i) {
            this.colWeight[i] = 1.0f;
        }
        for (i = 0; i < h; ++i) {
            this.rowWeight[i] = 1.0f;
        }
    }

    public void setRigidWidth(boolean b) {
        this.hRigid = b;
    }

    public void setRigidHeight(boolean b) {
        this.vRigid = b;
    }

    public void setRowWeight(int row, float weight) {
        if (row < 0 || row >= this.gridsize.height) {
            throw new IllegalArgumentException("Invalid row index: " + row + " (" + this.gridsize.height + ")");
        }
        this.rowWeight[row] = weight < 0.0f ? 0.0f : weight;
    }

    public void setColumnWeight(int col, float weight) {
        if (col < 0 || col >= this.gridsize.width) {
            throw new IllegalArgumentException("Invalid column index: " + col + " (" + this.gridsize.width + ")");
        }
        this.colWeight[col] = weight < 0.0f ? 0.0f : weight;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.setConstraints(comp, constraints);
    }

    public void setConstraints(Component comp, Object constraints) {
        FGConstraint fgc;
        if (constraints instanceof FGConstraint) {
            fgc = (FGConstraint)constraints;
        } else if (constraints instanceof Rectangle) {
            fgc = new FGConstraint((Rectangle)constraints);
        } else if (constraints instanceof Point) {
            fgc = new FGConstraint((Point)constraints);
        } else {
            throw new IllegalArgumentException("Invalid constraints for FG");
        }
        Rectangle r = fgc.getLocation();
        if (r.x < 0 || r.y < 0) {
            throw new IllegalArgumentException("Cannot add to layout: Location rect x and y must be >= 0");
        }
        if (r.width < 1 || r.height < 1) {
            throw new IllegalArgumentException("Cannot add to layout: Location rect width and height must be > 0");
        }
        this.compTable.put(comp, fgc);
    }

    public void removeLayoutComponent(Component comp) {
        this.compTable.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateCellSizes(parent, true);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateCellSizes(parent, false);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private Dimension calculateCellSizes(Container parent, boolean isPreferred) {
        int i;
        Dimension csize;
        Rectangle r;
        Object o;
        Component c;
        int i2;
        Dimension size = new Dimension(0, 0);
        int ccount = parent.getComponentCount();
        if (ccount == 0) {
            return size;
        }
        for (i2 = 0; i2 < this.gridsize.width; ++i2) {
            this.prefWidths[i2] = 0;
        }
        for (i2 = 0; i2 < this.gridsize.height; ++i2) {
            this.prefHeights[i2] = 0;
        }
        for (i2 = 0; i2 < ccount; ++i2) {
            c = parent.getComponent(i2);
            if (c == null || !((o = this.compTable.get(c)) instanceof FGConstraint) || (r = ((FGConstraint)o).getLocation()) == null) continue;
            csize = c.getPreferredSize();
            if (r.width == 1) {
                this.prefWidths[r.x] = Math.max(this.prefWidths[r.x], csize.width);
            }
            if (r.height != 1) continue;
            this.prefHeights[r.y] = Math.max(this.prefHeights[r.y], csize.height);
        }
        for (i2 = 0; i2 < ccount; ++i2) {
            int j;
            int allocated;
            c = parent.getComponent(i2);
            if (c == null) continue;
            o = this.compTable.get(c);
            if (o instanceof FGConstraint) {
                r = ((FGConstraint)o).getLocation();
            } else if (o instanceof Rectangle) {
                r = (Rectangle)o;
            } else {
                if (!(o instanceof Point)) continue;
                Point p = (Point)o;
                r = new Rectangle(p.x, p.y, 1, 1);
            }
            if (r == null) continue;
            csize = c.getPreferredSize();
            if (r.width > 1) {
                int excess;
                allocated = (r.width - 1) * this.hGap;
                float weight = 0.0f;
                for (j = 0; j < r.width; ++j) {
                    int x = r.x + j;
                    weight += this.colWeight[x];
                    if (x < this.gridsize.width) {
                        allocated += this.prefWidths[x];
                        continue;
                    }
                    allocated = Short.MAX_VALUE;
                    break;
                }
                if ((excess = csize.width - allocated) > 0) {
                    int j2;
                    if ((double)weight > 0.0) {
                        float distribute = (float)excess / weight;
                        for (j2 = 0; j2 < r.width; ++j2) {
                            int n = r.x + j2;
                            this.prefWidths[n] = this.prefWidths[n] + (int)(this.colWeight[r.x + j2] * distribute);
                        }
                    } else {
                        int distribute = excess / r.width;
                        for (j2 = 0; j2 < r.width; ++j2) {
                            int n = r.x + j2;
                            this.prefWidths[n] = this.prefWidths[n] + distribute;
                        }
                    }
                }
            }
            if (r.height <= 1) continue;
            allocated = (r.height - 1) * this.vGap;
            for (int j3 = 0; j3 < r.height; ++j3) {
                int y = r.y + j3;
                if (y < this.gridsize.height) {
                    allocated += this.prefHeights[y];
                    continue;
                }
                allocated = Short.MAX_VALUE;
                break;
            }
            if (allocated >= csize.height) continue;
            int distribute = (csize.height - allocated) / r.height;
            for (j = 0; j < r.height; ++j) {
                int n = r.y + j;
                this.prefHeights[n] = this.prefHeights[n] + distribute;
            }
        }
        if (this.hRigid) {
            int i3;
            int maxwidth = 0;
            for (i3 = 0; i3 < this.gridsize.width; ++i3) {
                maxwidth = Math.max(maxwidth, this.prefWidths[i3]);
            }
            for (i3 = 0; i3 < this.gridsize.width; ++i3) {
                this.prefWidths[i3] = maxwidth;
            }
        }
        if (this.vRigid) {
            int i4;
            int maxheight = 0;
            for (i4 = 0; i4 < this.gridsize.height; ++i4) {
                maxheight = Math.max(maxheight, this.prefHeights[i4]);
            }
            for (i4 = 0; i4 < this.gridsize.height; ++i4) {
                this.prefHeights[i4] = maxheight;
            }
        }
        Insets ins = parent.getInsets();
        for (i = 0; i < this.gridsize.width; ++i) {
            size.width += this.prefWidths[i];
        }
        for (i = 0; i < this.gridsize.height; ++i) {
            size.height += this.prefHeights[i];
        }
        size.width += this.hGap * (this.gridsize.width - 1) + ins.left + ins.right;
        size.height += this.vGap * (this.gridsize.height - 1) + ins.top + ins.bottom;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int addHere;
            int i;
            int prevAdded;
            int i2;
            float weight;
            int i3;
            int ccount = parent.getComponentCount();
            if (ccount == 0) {
                return;
            }
            Dimension psize = parent.getSize();
            Insets insets = parent.getInsets();
            Dimension minsize = this.calculateCellSizes(parent, false);
            int[] leftEdge = new int[this.gridsize.width + 1];
            int[] topEdge = new int[this.gridsize.height + 1];
            int[] rightEdge = new int[this.gridsize.width + 1];
            int[] bottomEdge = new int[this.gridsize.height + 1];
            leftEdge[0] = insets.left;
            topEdge[0] = insets.top;
            for (i3 = 0; i3 < this.gridsize.width; ++i3) {
                rightEdge[i3] = leftEdge[i3] + this.prefWidths[i3];
                leftEdge[i3 + 1] = rightEdge[i3] + this.hGap;
            }
            for (i3 = 0; i3 < this.gridsize.height; ++i3) {
                bottomEdge[i3] = topEdge[i3] + this.prefHeights[i3];
                topEdge[i3 + 1] = bottomEdge[i3] + this.vGap;
            }
            int xExcess = psize.width - minsize.width;
            int yExcess = psize.height - minsize.height;
            if (xExcess != 0) {
                weight = 0.0f;
                for (i2 = 0; i2 < this.gridsize.width; ++i2) {
                    weight += this.colWeight[i2];
                }
                if ((double)weight > 0.0) {
                    prevAdded = 0;
                    for (i = 0; i < this.gridsize.width; ++i) {
                        addHere = (int)(this.colWeight[i] / weight * (float)xExcess);
                        int n = i;
                        rightEdge[n] = rightEdge[n] + (addHere + prevAdded);
                        int n2 = i + 1;
                        leftEdge[n2] = leftEdge[n2] + (addHere + prevAdded);
                        prevAdded += addHere;
                    }
                }
            }
            if (yExcess != 0) {
                weight = 0.0f;
                for (i2 = 0; i2 < this.gridsize.height; ++i2) {
                    weight += this.rowWeight[i2];
                }
                if ((double)weight > 0.0) {
                    prevAdded = 0;
                    for (i = 0; i < this.gridsize.height; ++i) {
                        addHere = (int)(this.rowWeight[i] / weight * (float)yExcess);
                        int n = i;
                        bottomEdge[n] = bottomEdge[n] + (addHere + prevAdded);
                        int n3 = i + 1;
                        topEdge[n3] = topEdge[n3] + (addHere + prevAdded);
                        prevAdded += addHere;
                    }
                }
            }
            for (int i4 = 0; i4 < ccount; ++i4) {
                int dy;
                int dx;
                double vAlignment;
                double hAlignment;
                Rectangle r;
                Component c = parent.getComponent(i4);
                if (c == null) continue;
                Object o = this.compTable.get(c);
                if (o instanceof FGConstraint) {
                    r = ((FGConstraint)o).getLocation();
                    hAlignment = ((FGConstraint)o).getHAlignment();
                    vAlignment = ((FGConstraint)o).getVAlignment();
                } else {
                    if (!(o instanceof Rectangle)) continue;
                    r = (Rectangle)o;
                    try {
                        hAlignment = c.getAlignmentX();
                        vAlignment = c.getAlignmentY();
                    }
                    catch (Exception ignore) {
                        continue;
                    }
                }
                if (r == null || r.x >= this.gridsize.width || r.y >= this.gridsize.height) continue;
                int left = leftEdge[r.x];
                int top = topEdge[r.y];
                int right = r.x + r.width <= this.gridsize.width ? rightEdge[r.x + r.width - 1] : rightEdge[this.gridsize.width - 1];
                int bottom = r.y + r.height <= this.gridsize.height ? bottomEdge[r.y + r.height - 1] : bottomEdge[this.gridsize.height - 1];
                int w = right - left;
                int h = bottom - top;
                Dimension prefSize = c.getPreferredSize();
                Dimension maxSize = c.getMaximumSize();
                if (w > prefSize.width && prefSize.width > 0) {
                    w = prefSize.width;
                }
                if (w > maxSize.width && maxSize.width > 0) {
                    w = maxSize.width;
                }
                if (h > prefSize.height && prefSize.height > 0) {
                    h = prefSize.height;
                }
                if (h > maxSize.height && maxSize.height > 0) {
                    h = maxSize.height;
                }
                if ((dx = right - left - w) > 0) {
                    int shift;
                    if (hAlignment != -9999.0) {
                        shift = (int)(hAlignment * (double)dx);
                        left += shift;
                    } else if (!((double)c.getAlignmentX() < 0.0) && !((double)c.getAlignmentX() > 1.0)) {
                        shift = (int)(c.getAlignmentX() * (float)dx);
                        left += shift;
                    }
                }
                if ((dy = bottom - top - h) > 0) {
                    int shift;
                    if (vAlignment != -9999.0) {
                        shift = (int)(vAlignment * (double)dy);
                        top += shift;
                    } else if (!((double)c.getAlignmentY() < 0.0) && !((double)c.getAlignmentY() > 1.0)) {
                        shift = (int)(c.getAlignmentY() * (float)dy);
                        top += shift;
                    }
                }
                c.setBounds(left, top, w, h);
            }
        }
    }

    public void invalidateLayout(Container target) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }
}

