/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.xml;

import gov.nasa.giss.xml.EasyParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XmlPropertiesBundle {
    private Class tclass;
    private Hashtable phash;

    public XmlPropertiesBundle(String bname) {
        this(bname, Locale.getDefault());
    }

    public XmlPropertiesBundle(String bname, Locale locale) {
        if (bname == null) {
            throw new IllegalArgumentException("Bundle name must be specified");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must be specified");
        }
        String s2 = "/" + bname.replace('.', '/');
        this.tclass = this.getClass();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        String s = s2 + "_" + language + "_" + country + "_" + variant + ".properties";
        InputStream is = this.tclass.getResourceAsStream(s);
        if (is == null) {
            s = s2 + "_" + language + "_" + country + ".properties";
            is = this.tclass.getResourceAsStream(s);
        }
        if (is == null) {
            s = s2 + "_" + language + ".properties";
            is = this.tclass.getResourceAsStream(s);
        }
        if (is == null) {
            s = s2 + ".properties";
            is = this.tclass.getResourceAsStream(s);
        }
        if (is == null) {
            System.out.println("WARNING: No match for property bundle " + s2);
        } else {
            try {
                this.parse(is);
            }
            catch (Exception exc) {
                System.out.println("ERROR: Could not parse property bundle");
                exc.printStackTrace();
            }
        }
    }

    public XmlPropertiesBundle(URL url) throws FileNotFoundException, IOException, JDOMException {
        this(url.openStream());
    }

    public XmlPropertiesBundle(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        this.parse(is);
    }

    private synchronized void parse(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        if (this.phash == null) {
            this.phash = new Hashtable(root.getChildren().size());
        }
        Iterator iter1 = root.getChildren().iterator();
        while (iter1.hasNext()) {
            Element node = (Element)iter1.next();
            String nodeName = node.getName();
            if (!nodeName.equals("property") || node.getAttribute("name") == null) continue;
            Iterator iter2 = node.getAttributes().iterator();
            Hashtable<String, String> ahash = new Hashtable<String, String>(node.getAttributes().size());
            while (iter2.hasNext()) {
                Attribute a = (Attribute)iter2.next();
                if (a == null) continue;
                ahash.put(a.getName().toLowerCase(), a.getValue());
            }
            this.phash.put(node.getAttribute("name").getValue().toLowerCase(), new Object[]{node.getText(), ahash});
        }
    }

    public String getString(String pname) {
        Object[] prop = (Object[])this.phash.get(pname.toLowerCase());
        if (prop == null || prop[0] == null) {
            return null;
        }
        return (String)prop[0];
    }

    public String getAttribute(String pname, String aname) {
        Object[] prop = (Object[])this.phash.get(pname.toLowerCase());
        if (prop == null || prop[1] == null) {
            return null;
        }
        Hashtable ahash = (Hashtable)prop[1];
        Object o = ahash.get(aname.toLowerCase());
        if (o != null) {
            return (String)o;
        }
        return null;
    }
}

