/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MissionTime;
import gov.nasa.giss.time.PlanetTime;
import java.awt.geom.Point2D;

public class TitanTime
extends AbstractPlanetTime {
    private static final double HOUR_PER_DEG = 0.06666666666666667;
    private static final double DEG_PER_HOUR = 15.0;
    public static final double TIME_RATIO = 15.96913;
    private static final long HUY_LAUNCH = 1055267927000L;
    double eccentricityP;
    double meanAnomalyP;
    double equationOfCenterP;
    double subprimaryLon;
    double subprimaryLat;
    double rPrimaryKm;
    protected PlanetTime saturnTime;

    public TitanTime() {
        this(System.currentTimeMillis());
    }

    public TitanTime(long t) {
        super(t);
        this.pmTimeSuffix = "TMT";
        this.saturnTime = new PlanetTime(6, t);
    }

    public void setTime(long t) {
        super.setTime(t);
        if (this.saturnTime != null) {
            this.saturnTime.setTime(t);
        }
    }

    protected void calculate() {
        double jcent2 = this.jcent * this.jcent;
        double jcent3 = this.jcent * jcent2;
        this.meanAnomaly = 316.914 + 1222.081 * this.jcent + 0.021 * jcent2 - 0.04 * jcent3;
        this.meanAnomalyRad = this.meanAnomaly * (Math.PI / 180);
        double sin1M = Math.sin(this.meanAnomalyRad);
        double sin2M = Math.sin(2.0 * this.meanAnomalyRad);
        double sin3M = Math.sin(3.0 * this.meanAnomalyRad);
        double sin4M = Math.sin(4.0 * this.meanAnomalyRad);
        double sin5M = Math.sin(5.0 * this.meanAnomalyRad);
        this.alphaFMS = 236.638 + 1223.222 * this.jcent - 0.062 * jcent2 - 0.125 * jcent3;
        this.obliquity = 26.401 - 0.069 * this.jcent - 0.123 * jcent2 + 0.011 * jcent3;
        double obliquityRad = this.obliquity * (Math.PI / 180);
        double sinObliquity = Math.sin(obliquityRad);
        double tanHalfObliq = Math.tan(obliquityRad * 0.5);
        this.veeM = 321.178 + 824624.549 * this.jcent - 0.075 * jcent2 - 0.076 * jcent3;
        this.ellSP = 279.724 + 1.141 * this.jcent - 0.083 * jcent2 - 0.085 * jcent3;
        double equationOfCenter = (6.36 - 0.04 * this.jcent) * sin1M + 0.22 * sin2M + 0.01 * sin3M + 0.19 * Math.cos(Math.PI / 180 * (24.1 + 1182.4 * this.jcent)) + 0.12 * Math.cos(Math.PI / 180 * (13.9 + 591.2 * this.jcent)) + 0.04 * Math.sin(Math.PI / 180 * (this.veeM - this.alphaFMS));
        this.ellS = this.alphaFMS + equationOfCenter;
        this.ellSRad = this.ellS * (Math.PI / 180);
        this.cosEllS = Math.cos(this.ellSRad);
        this.sinEllS = Math.sin(this.ellSRad);
        double alphaS = this.ellS - 3.152 * Math.sin(2.0 * this.ellSRad) + 0.087 * Math.sin(4.0 * this.ellSRad) - 0.003 * Math.sin(6.0 * this.ellSRad);
        this.eotDegrees = 0.0;
        this.eotHours = this.eotDegrees / 15.0;
        this.declinSPG = this.declinSPC = 57.29577951308232 * Math.asin(sinObliquity * this.sinEllS);
        this.subsolarLonPG = (this.veeM - alphaS) % 360.0;
        this.subsolarLonPC = -this.subsolarLonPG;
        this.tst0 = this.subsolarLonPG * 0.06666666666666667 + 12.0;
        this.mst0 = (this.veeM - this.alphaFMS) % 360.0 * 0.06666666666666667 + 12.0;
        this.tst0 %= 24.0;
        this.mst0 %= 24.0;
        if (this.tst0 < 0.0) {
            this.tst0 += 24.0;
        }
        if (this.mst0 < 0.0) {
            this.mst0 += 24.0;
        }
        this.eotHours = this.tst0 - this.mst0;
        this.eotDegrees = this.eotHours * 15.0;
        this.gotOrbitParams = false;
        this.gotEarthParams = false;
    }

    protected void calculateOrbitParams() {
        this.lambdaRot = 79.385 - 0.012 * this.jcent + 0.63 * Math.sin(Math.PI / 180 * (344.2 - 52.1 * this.jcent));
        this.betaRot = 62.557 - 0.022 * this.jcent + 0.29 * Math.sin(Math.PI / 180 * (344.2 - 52.1 * this.jcent));
        double semimajorAxisKm = 1221850.0;
        this.eccentricityP = 0.028815 - 1.84E-4 * Math.cos(Math.PI / 180 * (319.8 + 104.38 * this.jcent)) + 7.3E-5 * Math.cos(Math.PI / 180 * (153.7 + 2340.94 * this.jcent));
        this.meanAnomalyP = 163.145 + 824571.78 * this.jcent - 0.36 * Math.sin(Math.PI / 180 * (319.8 + 104.38 * this.jcent)) - 0.14 * Math.sin(Math.PI / 180 * (153.7 + 2340.94 * this.jcent)) + 0.07 * Math.sin(Math.PI / 180 * (343.9 - 52.19 * this.jcent));
        double eP1 = this.eccentricityP;
        double eP2 = eP1 * eP1;
        double eP3 = eP1 * eP2;
        double eP4 = eP1 * eP3;
        double eP5 = eP1 * eP4;
        double eP6 = eP1 * eP5;
        double meanAnomalyPRad = this.meanAnomalyP * (Math.PI / 180);
        double sin1MP = Math.sin(meanAnomalyPRad);
        double sin2MP = Math.sin(2.0 * meanAnomalyPRad);
        double sin3MP = Math.sin(3.0 * meanAnomalyPRad);
        double sin4MP = Math.sin(4.0 * meanAnomalyPRad);
        double sin5MP = Math.sin(5.0 * meanAnomalyPRad);
        double sin6MP = Math.sin(6.0 * meanAnomalyPRad);
        this.equationOfCenterP = 57.29577951308232 * (sin1MP * (2.0 * eP1 - 0.25 * eP3 + 0.052083333333333336 * eP5) + sin2MP * (1.25 * eP2 - 0.4583333333333333 * eP4 + 0.08854166666666667 * eP6) + sin3MP * (1.0833333333333333 * eP3 - 0.6825396825396826 * eP5) + sin4MP * (1.0729166666666667 * eP4 - 0.9395833333333333 * eP6) + sin5MP * (1.1427083333333334 * eP5) + sin6MP * (1.2739583333333333 * eP6));
        this.subprimaryLon = -2.067 - this.equationOfCenterP;
        while (this.subprimaryLon < 360.0) {
            this.subprimaryLon += 360.0;
        }
        this.subprimaryLon %= 360.0;
        this.subprimaryLat = 0.0;
        this.rPrimaryKm = semimajorAxisKm * (1.0 - eP2) / (1.0 + eP1 * Math.cos(Math.PI / 180 * (this.meanAnomalyP + this.equationOfCenterP)));
        this.lonEcliptic = this.saturnTime.getHeliocentricLongitude();
        this.latEcliptic = this.saturnTime.getHeliocentricLatitude();
        double cosDthetaDiff = Math.cos(Math.PI / 180 * (this.subsolarLonPG - this.subprimaryLon));
        double cosDiff = Math.cos(Math.PI / 180 * (90.0 - this.declinSPG)) * Math.cos(Math.PI / 180 * (90.0 - this.subprimaryLat)) + Math.sin(Math.PI / 180 * (90.0 - this.declinSPG)) * Math.sin(Math.PI / 180 * (90.0 - this.subprimaryLat)) * cosDthetaDiff;
        double rHeliocentricKm = this.saturnTime.getDistanceToSun(4);
        this.rHeliocentricAU = (rHeliocentricKm += cosDiff * this.rPrimaryKm) / 1.49597870691E8;
        this.gotOrbitParams = true;
    }

    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        return 0.0;
    }

    public double getVernalEquinox() {
        return 0.0;
    }

    public double getDistanceToPrimary(int units) {
        if (!this.gotOrbitParams) {
            this.calculateOrbitParams();
        }
        if (units == 4) {
            return this.rPrimaryKm;
        }
        throw new IllegalArgumentException("Unknown distance units.");
    }

    public Point2D.Double getSubprimaryPoint(int how) {
        if (!this.gotOrbitParams) {
            this.calculateOrbitParams();
        }
        return new Point2D.Double(this.subprimaryLon, this.subprimaryLat);
    }

    public Point2D.Double getPrimaryAngleAt(double lon, double lat) {
        double azimuthAngle;
        if (!this.gotOrbitParams) {
            this.calculateOrbitParams();
        }
        double latRad = Math.PI / 180 * lat;
        double cosDec = Math.cos(Math.PI / 180 * this.subprimaryLat);
        double sinDec = Math.sin(Math.PI / 180 * this.subprimaryLat);
        double tanDec = Math.tan(Math.PI / 180 * this.subprimaryLat);
        double hourAngle = lon - this.subprimaryLon;
        if (hourAngle > 180.0) {
            hourAngle -= 360.0;
        }
        if (hourAngle < -180.0) {
            hourAngle += 360.0;
        }
        double cosHourAngle = Math.cos(Math.PI / 180 * hourAngle);
        double zenithAngle = 57.29577951308232 * Math.acos(sinDec * Math.sin(latRad) + cosDec * Math.cos(latRad) * cosHourAngle);
        double cosLat = Math.cos(latRad);
        double sinLat = Math.sin(latRad);
        for (azimuthAngle = 57.29577951308232 * Math.atan2(Math.sin(Math.PI / 180 * hourAngle), cosLat * tanDec - sinLat * cosHourAngle); azimuthAngle < 0.0; azimuthAngle += 360.0) {
        }
        while (azimuthAngle >= 360.0) {
            azimuthAngle -= 360.0;
        }
        return new Point2D.Double(azimuthAngle, zenithAngle);
    }

    public double getPrimaryZenithAngle(double lon, double lat) {
        return this.getPrimaryAngleAt(lon, lat).getY();
    }

    public double getPrimaryAzimuthAngle(double lon, double lat) {
        return this.getPrimaryAngleAt(lon, lat).getX();
    }

    public double getSolDate() {
        return (this.jdTT - 2400000.5 - 51549.0) / 15.96913 + 44796.0 - 9.6E-4;
    }

    public MissionTime getMissionTime(String landerID) {
        if (landerID == null) {
            throw new IllegalArgumentException("Null lander ID");
        }
        if (landerID.equals("HUY")) {
            double fraction = this.getTimeHours(198.6, 1) / 24.0;
            return new MissionTime(0L, fraction);
        }
        throw new IllegalArgumentException("Unknown lander ID " + landerID);
    }
}

