/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeConstants;
import java.text.DecimalFormat;

public class TimeFormat
implements TimeConstants {
    protected static final DecimalFormat FORMAT_10 = new DecimalFormat("0");
    protected static final DecimalFormat FORMAT_20 = new DecimalFormat("00");

    private TimeFormat() {
    }

    public static String format24Hours(double hours, int smallest, String prefix, String suffix) {
        StringBuffer result = new StringBuffer().append(FORMAT_20.format((long)hours));
        if (smallest != 1) {
            double m = (hours - Math.floor(hours)) * 60.0;
            result.append(":").append(FORMAT_20.format((long)m));
            if (smallest != 2) {
                double s = (m - Math.floor(m)) * 60.0;
                result.append(":").append(FORMAT_20.format((long)s));
                if (smallest == 4) {
                    double t = (s - Math.floor(s)) * 10.0;
                    result.append(".").append(FORMAT_10.format((long)t));
                } else if (smallest == 5) {
                    double t = (s - Math.floor(s)) * 100.0;
                    result.append(".").append(FORMAT_20.format((long)t));
                } else if (smallest == 6) {
                    double t = (s - Math.floor(s)) * 1000.0;
                    result.append(".").append(FORMAT_20.format((long)t));
                }
            }
        }
        if (prefix != null) {
            result.insert(0, " ").insert(0, prefix);
        }
        if (suffix != null) {
            result.append(" ").append(suffix);
        }
        return result.toString();
    }
}

