/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MissionTime;

public class PlanetTime
extends AbstractPlanetTime {
    public static final int MERCURY = 1;
    public static final int VENUS = 2;
    public static final int EARTH = 3;
    public static final int MARS = 4;
    public static final int JUPITER = 5;
    public static final int SATURN = 6;
    public static final int URANUS = 7;
    public static final int NEPTUNE = 8;
    public static final int PLUTO = 9;
    private static final double HOUR_PER_DEG = 0.06666666666666667;
    private static final double DEG_PER_HOUR = 15.0;
    private static final double DEG_DAY = 0.9856262833675564;
    private static final double[] MARS_PBS_A = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] MARS_PBS_PHI = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double[] MARS_PBS_TAU_INV = new double[]{0.9856262833675564, 0.4409369137778179, 0.3578500102993706, 0.8818343771741581, 0.062434361000313965, 0.4615651790613264, 0.399135937218578, 0.03000448360749107};
    private static final double[] SATURN_PBS_A = new double[]{0.0, 0.015, 0.012, 0.008, 0.005, 0.002, 0.001};
    private static final double[] SATURN_PBS_PHI = new double[]{0.0, 294.2, 180.0, 342.7, 288.6, 168.1, 328.4};
    private static final double[] SATURN_PBS_N = new double[]{0.0, 1182.43, 0.0, 1812.79, 591.22, 3913.98, 362558.36};
    private double alphaS;
    private double lambdaPole;
    private double betaPole;
    private double e1;
    private double e2;
    private double e3;
    private double e4;
    private double e5;
    private double e6;
    private int planetID;

    public PlanetTime() {
        throw new IllegalArgumentException("Use another constructor.");
    }

    public PlanetTime(long t) {
        throw new IllegalArgumentException("Use another constructor.");
    }

    public PlanetTime(int id) {
        this(id, System.currentTimeMillis());
    }

    public PlanetTime(int id, long t) {
        if (id < 1 || id > 9) {
            throw new IllegalArgumentException("Invalid planet ID.");
        }
        this.planetID = id;
        switch (this.planetID) {
            case 1: {
                this.semimajorAxisAU = 0.387098;
                this.pgFactor = 0.0;
                break;
            }
            case 2: {
                this.semimajorAxisAU = 0.72333;
                this.pgFactor = 0.0;
                break;
            }
            case 3: {
                this.semimajorAxisAU = 1.000001;
                this.pgFactor = 0.0;
                break;
            }
            case 4: {
                this.semimajorAxisAU = 1.523679;
                this.pgFactor = 0.0064763;
                break;
            }
            case 5: {
                this.semimajorAxisAU = 5.202603;
                this.pgFactor = 0.065;
                break;
            }
            case 6: {
                this.semimajorAxisAU = 9.554909;
                this.pgFactor = 0.09796;
                break;
            }
            case 7: {
                this.semimajorAxisAU = 19.218446;
                this.pgFactor = 0.023;
                break;
            }
            case 8: {
                this.semimajorAxisAU = 30.110387;
                this.pgFactor = 0.017;
                break;
            }
            case 9: {
                this.semimajorAxisAU = 39.543;
                this.pgFactor = 0.0;
            }
        }
        this.setTime(t);
    }

    protected void calculate() {
        double jcent2 = this.jcent * this.jcent;
        double jcent3 = this.jcent * jcent2;
        double jmil2 = this.jmil * this.jmil;
        double jmil3 = this.jmil * jmil2;
        switch (this.planetID) {
            case 1: {
                this.obliquity = 0.011;
                break;
            }
            case 2: {
                this.obliquity = 2.638 + 0.045 * this.jmil;
                break;
            }
            case 3: {
                this.obliquity = 23.4393 - 0.13 * this.jmil + 6.0E-4 * jmil2;
                break;
            }
            case 4: {
                this.obliquity = 25.1919 + 0.127 * this.jmil + 0.006 * jmil2;
                break;
            }
            case 5: {
                this.obliquity = 3.125 + 0.011 * this.jmil + 0.003 * jmil2;
                break;
            }
            case 6: {
                this.obliquity = 26.728 + 0.084 * this.jmil + 0.005 * jmil2;
                break;
            }
            case 7: {
                this.obliquity = 82.23 + 0.011 * this.jmil + 4.0E-4 * jmil2;
                break;
            }
            case 8: {
                this.obliquity = 27.85 - 0.002 * this.jmil + 9.51 * Math.cos(Math.PI / 180 * (336.7 + 523.16 * this.jmil));
                break;
            }
            case 9: {
                this.obliquity = 57.465 - 0.025 * this.jmil + 1.0E-5 * jmil2;
            }
        }
        double obliquityRad = this.obliquity * (Math.PI / 180);
        double cosObliquity = Math.cos(obliquityRad);
        double sinObliquity = Math.sin(obliquityRad);
        double tanHalfObliq = Math.tan(obliquityRad * 0.5);
        switch (this.planetID) {
            case 1: {
                this.eccentricity = 0.205632 + 2.0E-4 * this.jmil;
                break;
            }
            case 2: {
                this.eccentricity = 0.006722 - 4.8E-4 * this.jmil;
                break;
            }
            case 3: {
                this.eccentricity = 0.016709 - 4.2E-4 * this.jmil;
                break;
            }
            case 4: {
                this.eccentricity = 0.093401 + 9.0E-4 * this.jmil;
                break;
            }
            case 5: {
                this.eccentricity = 0.048498 + 0.00163 * this.jmil;
                break;
            }
            case 6: {
                this.eccentricity = 0.055548 - 0.00347 * this.jmil;
                break;
            }
            case 7: {
                this.eccentricity = 0.046381 - 2.7E-4 * this.jmil;
                break;
            }
            case 8: {
                this.eccentricity = 0.009456 + 6.0E-5 * this.jmil;
                break;
            }
            case 9: {
                this.eccentricity = 0.249 - 2.0E-5 * this.jmil;
            }
        }
        this.e1 = this.eccentricity;
        this.e2 = this.e1 * this.e1;
        this.e3 = this.e1 * this.e2;
        this.e4 = this.e1 * this.e3;
        this.e5 = this.e1 * this.e4;
        this.e6 = this.e1 * this.e5;
        switch (this.planetID) {
            case 1: {
                this.meanAnomaly = 174.795 + 1494725.158 * this.jmil + 0.001 * jmil2;
                break;
            }
            case 2: {
                this.meanAnomaly = 50.416 + 585178.108 * this.jmil + 0.139 * jmil2 + 0.001 * Math.cos(Math.PI / 180 * (297.1 + 1504.0 * this.jmil));
                break;
            }
            case 3: {
                this.meanAnomaly = 357.529 + 359990.503 * this.jmil - 0.015 * jmil2 + 0.002 * Math.cos(Math.PI / 180 * (162.1 + 206.0 * this.jmil));
                break;
            }
            case 4: {
                this.meanAnomaly = 19.373 + 191398.554 * this.jmil + 0.018 * jmil2 + 0.014 * Math.cos(Math.PI / 180 * (339.4 + 193.7 * this.jmil));
                break;
            }
            case 5: {
                this.meanAnomaly = 20.02 + 30346.901 * this.jmil - 0.081 * jmil2 + (0.329 - 0.017 * this.jmil) * Math.cos(Math.PI / 180 * (82.4 + 384.9 * this.jmil));
                break;
            }
            case 6: {
                this.meanAnomaly = 317.02 + 12215.473 * this.jmil - 0.032 * jmil2 + (0.801 - 0.041 * this.jmil) * Math.cos(Math.PI / 180 * (262.4 + 384.9 * this.jmil));
                break;
            }
            case 7: {
                this.meanAnomaly = 141.05 + 4283.777 * this.jmil + 0.0 * jmil2 + (0.876 - 0.005 * this.jmil) * Math.cos(Math.PI / 180 * (207.8 + 84.2 * this.jmil));
                break;
            }
            case 8: {
                this.meanAnomaly = 256.228 + 2184.57 * this.jmil - 0.008 * jmil2 + (0.583 - 0.003 * this.jmil) * Math.cos(Math.PI / 180 * (27.9 + 84.2 * this.jmil));
                break;
            }
            case 9: {
                this.meanAnomaly = 14.885 + 1449.6 * this.jmil;
            }
        }
        this.meanAnomalyRad = this.meanAnomaly * (Math.PI / 180);
        double sin1M = Math.sin(this.meanAnomalyRad);
        double sin2M = Math.sin(2.0 * this.meanAnomalyRad);
        double sin3M = Math.sin(3.0 * this.meanAnomalyRad);
        double sin4M = Math.sin(4.0 * this.meanAnomalyRad);
        double sin5M = Math.sin(5.0 * this.meanAnomalyRad);
        double sin6M = Math.sin(6.0 * this.meanAnomalyRad);
        switch (this.planetID) {
            case 1: {
                this.veeM = 47.762 + 6.1385216 * this.delta2000;
                break;
            }
            case 2: {
                this.veeM = 104.907 - 1.4813594 * this.delta2000;
                break;
            }
            case 3: {
                this.veeM = 280.461 + 360.9856474 * this.delta2000;
                break;
            }
            case 4: {
                this.veeM = 313.383 + 350.8919849 * this.delta2000;
                break;
            }
            case 5: {
                this.veeM = 145.942 + 870.536642 * this.delta2000;
                break;
            }
            case 6: {
                this.veeM = 174.351 + 810.7939009 * this.delta2000;
                break;
            }
            case 7: {
                this.veeM = 29.647 - 501.1600928 * this.delta2000;
                break;
            }
            case 8: {
                this.veeM = 52.785 + 536.3128492 * this.delta2000;
                break;
            }
            case 9: {
                this.veeM = 57.23 - 56.3623195 * this.delta2000;
            }
        }
        switch (this.planetID) {
            case 1: {
                this.ellSP = 325.749 + 8.86 * this.jmil;
                break;
            }
            case 2: {
                this.ellSP = 253.751 + 3.495 * this.jmil - 0.138 * jmil2;
                break;
            }
            case 3: {
                this.ellSP = 282.932 + 17.195 * this.jmil + 0.046 * jmil2;
                break;
            }
            case 4: {
                this.ellSP = 251.0 + 6.452 * this.jmil - 0.009 * jmil2;
                break;
            }
            case 5: {
                this.ellSP = 57.074 + 2.245 * this.jmil + 0.08 * jmil2;
                break;
            }
            case 6: {
                this.ellSP = 279.457 + 5.64 * this.jmil + 0.064 * jmil2;
                break;
            }
            case 7: {
                this.ellSP = 185.462 + 0.891 * this.jmil - 0.009 * jmil2;
                break;
            }
            case 8: {
                this.ellSP = 2.203 + 0.296 * this.jmil + 1.087 * Math.cos(Math.PI / 180 * (67.15 + 523.16 * this.jmil));
                break;
            }
            case 9: {
                this.ellSP = 184.544 - 0.135 * this.jmil - 2.0E-5 * jmil2;
            }
        }
        double pbs = 0.0;
        switch (this.planetID) {
            case 4: {
                for (int k = 1; k < 8; ++k) {
                    pbs += MARS_PBS_A[k] * Math.cos(Math.PI / 180 * (MARS_PBS_TAU_INV[k] * this.delta2000 + MARS_PBS_PHI[k]));
                }
                break;
            }
        }
        double equationOfCenter = 57.29577951308232 * (sin1M * (2.0 * this.e1 - 0.25 * this.e3 + 0.052083333333333336 * this.e5) + sin2M * (1.25 * this.e2 - 0.4583333333333333 * this.e4 + 0.08854166666666667 * this.e6) + sin3M * (1.0833333333333333 * this.e3 - 0.6825396825396826 * this.e5) + sin4M * (1.0729166666666667 * this.e4 - 0.9395833333333333 * this.e6) + sin5M * (1.1427083333333334 * this.e5) + sin6M * (1.2739583333333333 * this.e6)) + pbs;
        this.trueAnomaly = equationOfCenter + this.meanAnomaly;
        this.ellS = this.meanAnomaly + this.ellSP + equationOfCenter;
        this.ellSRad = this.ellS * (Math.PI / 180);
        this.cosEllS = Math.cos(this.ellSRad);
        this.sinEllS = Math.sin(this.ellSRad);
        this.alphaFMS = this.ellS - equationOfCenter;
        this.alphaS = 57.29577951308232 * Math.atan(cosObliquity * Math.tan(this.ellSRad));
        this.declinSPC = 57.29577951308232 * Math.asin(sinObliquity * this.sinEllS);
        this.declinSPG = this.transformLatitudePC2PG(this.declinSPC);
        this.subsolarLonPG = (this.veeM - this.alphaS) % 360.0;
        this.subsolarLonPC = -this.subsolarLonPG;
        this.tst0 = this.subsolarLonPG * 0.06666666666666667 + 12.0;
        this.mst0 = (this.veeM - this.alphaFMS) % 360.0 * 0.06666666666666667 + 12.0;
        this.tst0 %= 24.0;
        this.mst0 %= 24.0;
        if (this.tst0 < 0.0) {
            this.tst0 += 24.0;
        }
        if (this.mst0 < 0.0) {
            this.mst0 += 24.0;
        }
        this.eotHours = this.tst0 - this.mst0;
        this.eotDegrees = this.eotHours * 15.0;
        this.gotOrbitParams = false;
        this.gotEarthParams = false;
    }

    protected void calculateOrbitParams() {
        double jmil2 = this.jmil * this.jmil;
        double jmil3 = jmil2 * this.jmil;
        switch (this.planetID) {
            case 1: {
                this.lambdaPole = 318.3309 - 1.2542 * this.jmil - 0.0088 * jmil2 - 2.0E-4 * jmil3;
                this.betaPole = 82.995 + 0.0595 * this.jmil - 1.0E-4 * jmil2 - 4.0E-5 * jmil3;
                this.lambdaRot = 318.41 - 1.2665 * this.jmil - 0.0102 * jmil2 + 4.0E-5 * jmil3;
                this.betaRot = 82.99 + 0.059 * this.jmil - 0.0012 * jmil2 - 1.0E-5 * jmil3;
                break;
            }
            case 2: {
                this.lambdaPole = 346.6799 - 2.7801 * this.jmil - 0.0143 * jmil2 - 2.0E-4 * jmil3;
                this.betaPole = 86.6053 + 0.0086 * this.jmil + 0.0032 * jmil2 - 9.0E-6 * jmil3;
                this.lambdaRot = 30.186;
                this.betaRot = 88.761;
                break;
            }
            case 3: {
                this.lambdaPole = 84.8372 - 2.4109 * this.jmil + 0.0043 * jmil2 + 1.0E-6 * jmil3;
                this.betaPole = 90.0 - 0.1305 * this.jmil + 9.0E-4 * jmil2 + 3.0E-5 * jmil3;
                this.lambdaRot = 90.0 - 13.9958 * this.jmil + 0.0298 * jmil2 + 3.0E-4 * jmil3;
                this.betaRot = 66.5607 + 7.0E-5 * this.jmil - 0.0014 * jmil2 + 0.0021 * jmil3;
                break;
            }
            case 4: {
                this.lambdaPole = 319.5581 - 2.9503 * this.jmil - 0.064 * jmil2 + 0.002 * jmil3;
                this.betaPole = 88.1503 + 0.0815 * this.jmil + 0.0023 * jmil2 + 3.0E-5 * jmil3;
                this.lambdaRot = 352.9076 - 1.9631 * this.jmil - 0.0054 * jmil2 + 1.0E-4 * jmil3;
                this.betaRot = 63.282 - 0.0418 * this.jmil - 0.004 * jmil2 - 8.0E-5 * jmil3;
                break;
            }
            case 5: {
                this.lambdaPole = 10.4644 + 1.7672 * this.jmil + 0.0907 * jmil2 - 0.0073 * jmil3;
                this.betaPole = 88.6967 + 0.0199 * this.jmil - 0.0033 * jmil2 - 1.0E-4 * jmil3;
                this.lambdaRot = 247.797 - 1.2607 * this.jmil - 0.0071 * jmil2 + 1.0E-4 * jmil3;
                this.betaRot = 87.778 + 0.0146 * this.jmil + 5.0E-4 * jmil2 + 3.0E-6 * jmil3;
                break;
            }
            case 6: {
                this.lambdaPole = 23.6655 - 2.5667 * this.jmil - 0.0184 * jmil2 + 5.0E-4 * jmil3;
                this.betaPole = 87.5111 - 0.0255 * this.jmil + 0.0049 * jmil2 - 2.0E-5 * jmil3;
                this.lambdaRot = 79.5275 - 0.1207 * this.jmil - 2.0E-4 * jmil2 + 7.0E-7 * jmil3;
                this.betaRot = 61.9478 - 0.0046 * this.jmil + 2.0E-4 * jmil2 + 2.0E-7 * jmil3;
                break;
            }
            case 7: {
                this.lambdaRot = 257.6467;
                this.betaRot = 7.7218;
                break;
            }
            case 8: {
                break;
            }
        }
        double inclination = 90.0 - this.betaPole;
        this.rHeliocentricAU = this.semimajorAxisAU * (1.0 + 0.5 * this.e2 - (this.e1 - 0.375 * this.e3) * Math.cos(this.meanAnomalyRad) - (0.5 * this.e2 - 0.3333333333333333 * this.e4) * Math.cos(2.0 * this.meanAnomalyRad) - 0.375 * this.e3 * Math.cos(3.0 * this.meanAnomalyRad) - 0.3333333333333333 * this.e4 * Math.cos(4.0 * this.meanAnomalyRad));
        switch (this.planetID) {
            case 6: {
                for (int k = 1; k < 7; ++k) {
                    this.rHeliocentricAU += SATURN_PBS_A[k] * Math.cos(Math.PI / 180 * (SATURN_PBS_N[k] * this.jcent + SATURN_PBS_PHI[k]));
                }
                break;
            }
        }
        double myChi = 0.0;
        double myOmega = 0.0;
        switch (this.planetID) {
            case 1: {
                myChi = 116.633 + 6.017 * this.jmil + 6.49 * jmil2;
                myOmega = 77.456 + 1.589 * this.jmil - 0.001 * jmil2;
                break;
            }
            case 2: {
                myChi = 18.874 + 0.666 * this.jmil - 0.014 * jmil2;
                myOmega = 131.564 + 0.049 * this.jmil - 0.138 * jmil2;
                break;
            }
            case 3: {
                myChi = 174.873 + 11.937 * this.jmil + 0.035 * jmil2;
                myOmega = 102.937 + 3.226 * this.jmil + 0.015 * jmil2;
                break;
            }
            case 4: {
                myChi = 144.502 - 0.937 * this.jmil - 0.056 * jmil2;
                myOmega = 336.06 + 4.439 * this.jmil - 0.017 * jmil2;
                break;
            }
            case 5: {
                myChi = 323.21 + 1.857 * this.jmil + 0.098 * jmil2;
                myOmega = 14.331 + 2.155 * this.jmil + 0.072 * jmil2;
                break;
            }
            case 6: {
                myChi = 120.067 - 2.592 * this.jmil - 0.007 * jmil2;
                myOmega = 93.057 + 5.665 * this.jmil + 0.053 * jmil2;
                break;
            }
            case 7: {
                myChi = 266.464 + 0.739 * this.jmil + 0.041 * jmil2;
                myOmega = 173.005 + 0.893 * this.jmil - 0.009 * jmil2;
                break;
            }
            case 8: {
                break;
            }
        }
        double tanTerm = Math.tan(Math.PI / 360 * inclination);
        this.lonEcliptic = this.ellS - this.ellSP + myOmega - 57.29577951308232 * tanTerm * tanTerm * Math.sin(Math.PI / 90 * (this.ellS - myChi));
        while (this.lonEcliptic < 0.0) {
            this.lonEcliptic += 360.0;
        }
        while (this.lonEcliptic > 360.0) {
            this.lonEcliptic -= 360.0;
        }
        this.latEcliptic = -57.29577951308232 * Math.asin(Math.sin(Math.PI / 180 * inclination) * Math.sin(Math.PI / 180 * (this.ellS - myChi)));
        this.gotOrbitParams = true;
    }

    public double getVernalEquinox() {
        return this.getHeliocentricLongitude() + 180.0 - this.getSolarLongitude();
    }

    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        if (b) {
            return this.ellSP + this.getVernalEquinox();
        }
        return this.ellSP;
    }

    public MissionTime getMissionTime(String landerID) {
        throw new IllegalArgumentException("Unknown lander ID " + landerID);
    }
}

