/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

public class MissionTime {
    public static final int TO_BE_LAUNCHED = 0;
    public static final int IN_FLIGHT = 1;
    public static final int IN_PROGRESS = 2;
    public static final int COMPLETE = 3;
    private long year;
    private long yearSol;
    private long runningSol;
    private double fraction;

    public MissionTime() {
        this.runningSol = Long.MIN_VALUE;
        this.fraction = 0.0;
    }

    public MissionTime(long runningSol, double d) {
        this.runningSol = runningSol;
        this.fraction = d;
    }

    public long getSol() {
        return this.runningSol;
    }

    public void setSol(long runningSol) {
        this.runningSol = runningSol;
    }

    public double getSolFraction() {
        return this.fraction;
    }

    public void setSolFraction(double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Day fraction must be 0. <= x < 1.");
        }
        this.fraction = d;
    }

    public double getSolHours() {
        return this.fraction * 24.0;
    }

    public void setSolHours(double h) {
        if (h < 0.0 || h >= 1.0) {
            throw new IllegalArgumentException("Hour of day must be 0. <= x < 24.");
        }
        this.fraction = h / 24.0;
    }
}

