/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MissionTime;

public class MarsTime
extends AbstractPlanetTime {
    public static final double TIME_RATIO = 1.027491252;
    private static final double[] PBS_A = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] PBS_PHI = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double DEG_DAY = 0.9856262833675564;
    private static final double[] PBS_TAU_INV = new double[]{0.9856262833675564, 0.4409369137778179, 0.3578500102993706, 0.8818343771741581, 0.062434361000313965, 0.4615651790613264, 0.399135937218578, 0.03000448360749107};
    private static final long MERA_LAUNCH = 1055267927000L;
    private static final long MERB_LAUNCH = 1057634295000L;
    private static final long BEAGLE_LAUNCH = 1054579526000L;

    public MarsTime() {
        this(System.currentTimeMillis());
    }

    public MarsTime(long t) {
        super(t);
        this.pmTimeSuffix = "MTC";
    }

    public void setTime(long t) {
        super.setTime(t);
    }

    protected void calculate() {
        this.semimajorAxisAU = 1.523679;
        this.pgFactor = 0.0064763;
        this.obliquity = 25.1919 + 0.0126 * this.jcent;
        double sinObliquity = Math.sin(this.obliquity * (Math.PI / 180));
        this.eccentricity = 0.0934 + 9.0E-5 * this.jcent;
        this.meanAnomaly = 19.387 + 0.52402075 * this.delta2000;
        this.meanAnomalyRad = MarsTime.toRadians(this.meanAnomaly);
        double sin1MeanAnom = Math.sin(this.meanAnomalyRad);
        double sin2MeanAnom = Math.sin(2.0 * this.meanAnomalyRad);
        double sin3MeanAnom = Math.sin(3.0 * this.meanAnomalyRad);
        double sin4MeanAnom = Math.sin(4.0 * this.meanAnomalyRad);
        double sin5MeanAnom = Math.sin(5.0 * this.meanAnomalyRad);
        this.alphaFMS = 270.3863 + 0.5240384 * this.delta2000;
        double pbs = 0.0;
        for (int k = 1; k < 8; ++k) {
            pbs += PBS_A[k] * Math.cos((PBS_TAU_INV[k] * this.delta2000 + PBS_PHI[k]) * (Math.PI / 180));
        }
        double equationOfCenter = (10.691 + 3.0E-7 * this.delta2000) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs;
        this.trueAnomaly = equationOfCenter + this.meanAnomaly;
        this.ellS = this.alphaFMS + equationOfCenter;
        this.ellSRad = MarsTime.toRadians(this.ellS);
        this.cosEllS = Math.cos(this.ellSRad);
        this.sinEllS = Math.sin(this.ellSRad);
        this.ellSP = this.ellS - this.trueAnomaly;
        this.eotDegrees = 2.861 * Math.sin(2.0 * this.ellSRad) - 0.071 * Math.sin(4.0 * this.ellSRad) + 0.002 * Math.sin(6.0 * this.ellSRad) - equationOfCenter;
        this.eotHours = this.eotDegrees / 15.0;
        this.mst0 = 24.0 * ((this.jdTT - 2451549.5) / 1.027491252 + 44796.0 - 9.6E-4);
        while (this.mst0 < 0.0) {
            this.mst0 += 24.0;
        }
        this.mst0 %= 24.0;
        this.tst0 = this.mst0 + this.eotHours;
        while (this.tst0 < 0.0) {
            this.tst0 += 24.0;
        }
        this.tst0 %= 24.0;
        this.declinSPC = MarsTime.toDegrees(Math.asin(sinObliquity * this.sinEllS));
        this.declinSPG = this.declinSPC + 0.25 * this.sinEllS;
        this.subsolarLonPG = 15.0 * this.tst0 + 180.0;
        while (this.subsolarLonPG < 0.0) {
            this.subsolarLonPG += 360.0;
        }
        while (this.subsolarLonPG > 360.0) {
            this.subsolarLonPG -= 360.0;
        }
        this.subsolarLonPC = -this.subsolarLonPG;
        this.gotOrbitParams = false;
        this.gotEarthParams = false;
    }

    protected void calculateOrbitParams() {
        this.rHeliocentricAU = this.semimajorAxisAU * (1.00436 - 0.09309 * Math.cos(this.meanAnomalyRad) - 0.004336 * Math.cos(2.0 * this.meanAnomalyRad) - 3.1E-4 * Math.cos(3.0 * this.meanAnomalyRad) - 3.0E-5 * Math.cos(4.0 * this.meanAnomalyRad));
        this.lonEcliptic = this.ellS + 85.061 - 5.5E-6 * this.delta2000 - 0.015 * Math.sin(MarsTime.toRadians(2.0 * this.ellS + 71.0));
        while (this.lonEcliptic < 0.0) {
            this.lonEcliptic += 360.0;
        }
        while (this.lonEcliptic > 360.0) {
            this.lonEcliptic -= 360.0;
        }
        this.latEcliptic = -(1.8497 - 2.23E-5 * this.delta2000) * Math.sin(MarsTime.toRadians(this.ellS - 144.5 + 2.57E-6 * this.delta2000));
        double jdmil = this.delta2000 / 365250.0;
        double jdmil2 = jdmil * jdmil;
        double jdmil3 = jdmil2 * jdmil;
        this.lambdaRot = 352.9076 - 1.9631 * jdmil - 0.0054 * jdmil2 + 1.0E-4 * jdmil3;
        this.betaRot = 63.282 - 0.0418 * jdmil - 0.004 * jdmil2 - 8.0E-5 * jdmil3;
        this.gotOrbitParams = true;
    }

    public double getVernalEquinox() {
        return this.getHeliocentricLongitude() + 180.0 - this.getSolarLongitude();
    }

    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        if (b) {
            return 250.999 + this.delta2000 * 1.765E-5 + this.getVernalEquinox();
        }
        return 250.999 + this.delta2000 * 1.765E-5;
    }

    public double getSolDate() {
        return (this.jdTT - 2400000.5 - 51549.0) / 1.027491252 + 44796.0 - 9.6E-4;
    }

    public MissionTime getMissionTime(String landerID) {
        if (landerID == null) {
            throw new IllegalArgumentException("Null lander ID");
        }
        if (landerID.equals("MERA") || landerID.equals("MERB")) {
            double offset;
            double t0;
            if (landerID.equals("MERA")) {
                if (this.unixMillis < 1055267927000L) {
                    return new MissionTime();
                }
                t0 = 1.264096557E8;
                offset = 600.0;
            } else {
                if (this.unixMillis < 1057634295000L) {
                    return new MissionTime();
                }
                t0 = 1.282298048E8;
                offset = 780.0;
            }
            double lltSec = offset + (this.j2000Secs - t0) / 1.027491252;
            double llt = lltSec * 1.1574074074074073E-5;
            if (llt > 0.0) {
                llt += 1.0;
            }
            long sol = (long)Math.floor(llt);
            return new MissionTime(sol, llt - (double)sol);
        }
        if (landerID.equals("BEA")) {
            long sx;
            if (this.unixMillis < 1054579526000L) {
                return new MissionTime();
            }
            double fraction = this.getTimeHours(269.5, 2) / 24.0;
            long sol = (long)Math.floor((this.jdTT - 2452998.083046) / 1.027491252);
            if (fraction < 0.1) {
                long sx2 = (long)Math.floor((this.jdTT - 2452998.083046 - 0.5) / 1.027491252);
                if (sx2 == sol) {
                    ++sol;
                }
            } else if (fraction > 0.9 && (sx = (long)Math.floor((this.jdTT - 2452998.083046 + 0.5) / 1.027491252)) == sol) {
                --sol;
            }
            if (sol >= 0L) {
                ++sol;
            }
            return new MissionTime(sol, fraction);
        }
        if (landerID.equals("MPF")) {
            long solz;
            double ltst = this.getTimeHours(33.52, 2);
            long ltsthr = (long)ltst;
            long ltstmi = (long)((ltst - (double)ltsthr) * 60.0);
            long ltstse = (long)(((ltst - (double)ltsthr) * 60.0 - (double)ltstmi) * 60.0);
            double solx = 1.0 + (this.jdUTC - 2450634.10046) / 1.027491252;
            long sol = (long)solx;
            if ((double)ltsthr < 1.0) {
                long solz2 = 1L + (long)((this.jdUTC - 0.5 - 2450634.10046) / 1.027491252);
                if (solz2 == sol) {
                    ++sol;
                }
            } else if (ltst > 23.0 && (solz = 1L + (long)((this.jdUTC + 0.5 - 2450634.10046) / 1.027491252)) == sol) {
                --sol;
            }
            return new MissionTime(sol, ltst / 24.0);
        }
        throw new IllegalArgumentException("Unknown lander ID " + landerID);
    }
}

