/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeConstants;
import java.text.DecimalFormat;

public class JulianDay
implements TimeConstants {
    private static final double[][] TAI_MINUS_UTC = new double[][]{{2441317.5, 10.0}, {2441499.5, 11.0}, {2441683.5, 12.0}, {2442048.5, 13.0}, {2442413.5, 14.0}, {2442778.5, 15.0}, {2443144.5, 16.0}, {2443509.5, 17.0}, {2443874.5, 18.0}, {2444239.5, 19.0}, {2444786.5, 20.0}, {2445151.5, 21.0}, {2445516.5, 22.0}, {2446247.5, 23.0}, {2447161.5, 24.0}, {2447892.5, 25.0}, {2448257.5, 26.0}, {2448804.5, 27.0}, {2449169.5, 28.0}, {2449534.5, 29.0}, {2450083.5, 30.0}, {2450630.5, 31.0}, {2451179.5, 32.0}, {2453736.5, 33.0}};
    private static final double TT_MINUS_TAI = 32.184;
    public static final int JPLAIN = 0;
    public static final int J2000 = 1;
    public static final int JMODIFIED = 2;
    protected static final DecimalFormat FORMAT_06 = new DecimalFormat("0.000000");
    protected static final DecimalFormat FORMAT_10 = new DecimalFormat("0");
    protected static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    public static final double MJD_0 = 2400000.5;
    public static final double JD_1972 = 2441317.5;
    public static final double JD_2000 = 2451545.0;
    public static final double JD_UNIX = 2440587.5;
    public static final long SECS_PER_DAY = 86400L;
    public static final double DAYS_PER_SEC = 1.1574074074074073E-5;
    protected static final boolean ECHO_DEBUG = false;
    protected long unixMillis;
    protected double j2000Secs;
    protected double jdUTC;
    protected double jdTT;
    protected double delta2000;
    protected double jcent;
    protected double jmil;

    public JulianDay() {
        this.calculate(System.currentTimeMillis());
    }

    public JulianDay(long millis) {
        this.setTime(millis);
    }

    public void setTime(long millis) {
        this.calculate(millis);
    }

    private void calculate(long millis) {
        double utc2tt;
        double utc2000Secs;
        block2: {
            block1: {
                this.unixMillis = millis;
                utc2000Secs = (double)this.unixMillis * 0.001 - 9.46728E8;
                this.jdUTC = 2440587.5 + (double)millis * 1.1574074074074074E-8;
                utc2tt = 0.0;
                if (!(this.jdUTC < TAI_MINUS_UTC[0][0])) break block1;
                double d2000 = this.jdUTC - 2451545.0;
                double c = d2000 / 36525.0;
                double c2 = c * c;
                utc2tt = 64.184 + 59.0 * c - 51.2 * c2 - 67.1 * c * c2 - 16.4 * c2 * c2;
                if (!(utc2tt > 32.184 + TAI_MINUS_UTC[0][1])) break block2;
                utc2tt = 32.184 + TAI_MINUS_UTC[0][1];
                break block2;
            }
            for (int i = TAI_MINUS_UTC.length - 1; i >= 0; --i) {
                if (!(this.jdUTC >= TAI_MINUS_UTC[i][0])) continue;
                utc2tt = 32.184 + TAI_MINUS_UTC[i][1];
                break;
            }
        }
        this.jdTT = this.jdUTC + utc2tt * 1.1574074074074073E-5;
        this.delta2000 = this.jdTT - 2451545.0;
        this.j2000Secs = utc2000Secs + utc2tt;
        this.jcent = this.delta2000 / 36525.0;
        this.jmil = this.delta2000 / 365250.0;
    }

    public long getMillis() {
        return this.unixMillis;
    }

    public double getDelta2000() {
        return this.delta2000;
    }

    public double getDay() {
        return this.jdUTC;
    }

    public double getDay(int offset) {
        if (offset == 1) {
            return this.jdUTC - 2451545.0;
        }
        if (offset == 2) {
            return this.jdUTC - 2400000.5;
        }
        return this.jdUTC;
    }
}

