/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MissionTime;
import gov.nasa.giss.time.TimeFormat;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class EarthTime
extends AbstractPlanetTime {
    private static final DecimalFormat FORMAT_30 = new DecimalFormat("000");
    private double rE = 0.0;
    private double lambdaE = 0.0;
    private GregorianCalendar calendar = new GregorianCalendar();
    private Date date = new Date();
    private static TimeZone localZone = TimeZone.getDefault();
    private static SimpleTimeZone utcZone = new SimpleTimeZone(0, "GMT+0:00");

    public EarthTime() {
        this(System.currentTimeMillis());
    }

    public EarthTime(long t) {
        super(t);
        this.calculate();
    }

    public void setTime(long t) {
        super.setTime(t);
        this.calculate();
    }

    protected void calculate() {
        this.semimajorAxisAU = 1.0;
        this.pgFactor = 0.0;
        this.obliquity = 23.4393;
        this.eccentricity = 0.01671;
        double g = 357.528 + 0.9856003 * this.delta2000;
        double gRad = g * (Math.PI / 180);
        this.rE = 1.00014 - 0.01671 * Math.cos(gRad) - 1.4E-4 * Math.cos(2.0 * gRad);
        this.lambdaE = 102.944 + g + 1.915 * Math.sin(gRad) + 0.02 * Math.sin(2.0 * gRad);
        while (this.lambdaE < 0.0) {
            this.lambdaE += 360.0;
        }
        while (this.lambdaE > 360.0) {
            this.lambdaE -= 360.0;
        }
    }

    protected void calculateOrbitParams() {
    }

    protected void calculateEarthParams() {
    }

    public double getVernalEquinox() {
        return -4.6E-5 * this.getDelta2000();
    }

    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        if (b) {
            return 282.9317 + 4.7076E-5 * this.delta2000 + this.getVernalEquinox();
        }
        return 282.9317 + 4.7076E-5 * this.delta2000;
    }

    public double getHeliocentricLongitude() {
        return this.lambdaE;
    }

    public double getHeliocentricLatitude() {
        return 0.0;
    }

    public double getDistanceToSun(int units) {
        if (units == 3) {
            return this.rE;
        }
        if (units == 4) {
            return this.rE * 1.49597870691E8;
        }
        if (units == 2) {
            return this.rE * 499.0047838061357;
        }
        if (units == 1) {
            return this.rE * 499.0047838061357 / 60.0;
        }
        throw new IllegalArgumentException("Unknown distance units.");
    }

    public double getEarthDistance(int units) {
        return 0.0;
    }

    public Point2D.Double getSubEarthPoint(int how) {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double getEarthAngleAt(double lon, double lat) {
        return new Point2D.Double(0.0, 0.0);
    }

    public double getTimeHours(double lon, int timeType) {
        return 0.0;
    }

    public String getTimeString(double lon, int timeType, boolean appendSuffix) {
        return "";
    }

    public String getTimeStringMinutes(boolean getLocal) {
        String append;
        this.date.setTime(this.unixMillis);
        this.calendar.setTime(this.date);
        if (getLocal) {
            this.calendar.setTimeZone(localZone);
            append = localZone.getDisplayName(localZone.inDaylightTime(this.date), 0);
        } else {
            this.calendar.setTimeZone(utcZone);
            append = "UTC";
        }
        double hours = (double)this.calendar.get(11) + (double)this.calendar.get(12) / 60.0 + (double)this.calendar.get(13) / 3600.0 + (double)this.calendar.get(14) / 3600.0 / 1000.0;
        return TimeFormat.format24Hours(hours, 2, null, append);
    }

    public String getTimeStringSeconds(boolean getLocal) {
        String append;
        this.date.setTime(this.unixMillis);
        this.calendar.setTime(this.date);
        if (getLocal) {
            this.calendar.setTimeZone(localZone);
            append = localZone.getDisplayName(localZone.inDaylightTime(this.date), 0);
        } else {
            this.calendar.setTimeZone(utcZone);
            append = "UTC";
        }
        double hours = (double)this.calendar.get(11) + (double)this.calendar.get(12) / 60.0 + (double)this.calendar.get(13) / 3600.0 + (double)this.calendar.get(14) / 3600.0 / 1000.0;
        return TimeFormat.format24Hours(hours, 3, null, append);
    }

    public String getDateString(boolean getLocal, boolean asDOY) {
        this.date.setTime(this.unixMillis);
        this.calendar.setTime(this.date);
        if (getLocal) {
            this.calendar.setTimeZone(localZone);
        } else {
            this.calendar.setTimeZone(utcZone);
        }
        if (asDOY) {
            return this.calendar.get(1) + "-" + FORMAT_30.format(this.calendar.get(6));
        }
        return this.calendar.get(1) + "-" + FORMAT_20.format(this.calendar.get(2) + 1) + "-" + FORMAT_20.format(this.calendar.get(5));
    }

    public MissionTime getMissionTime(String landerID) {
        throw new IllegalArgumentException("No missions for EarthTime.");
    }
}

