/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LongitudeDocument
extends PlainDocument {
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            double d = newValue.equals("-") || newValue.equals(".") ? 0.0 : Double.parseDouble(newValue);
            if (d > 360.0 || d < -360.0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, string, attributes);
        }
        catch (NumberFormatException exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

