/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleDocument
extends PlainDocument {
    private boolean nonNegativeOnly = false;

    public DoubleDocument() {
        this(false);
    }

    public DoubleDocument(boolean b) {
        this.nonNegativeOnly = b;
    }

    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            if (string.equals("-") && this.nonNegativeOnly) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (newValue.equals("-") || newValue.equals(".")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Double.parseDouble(newValue);
            super.insertString(offset, string, attributes);
        }
        catch (NumberFormatException exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public double getValue() {
        try {
            String content = this.getText(0, this.getLength());
            if (content == null || content.length() == 0 || content.equals(".")) {
                return 0.0;
            }
            return Double.parseDouble(content);
        }
        catch (Exception exc) {
            return 0.0;
        }
    }
}

