/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.prefs;

import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jdom.JDOMException;

public abstract class AbstractPreferences {
    protected File prefsFile = null;
    protected File settingsFile = null;
    protected String appName;
    protected boolean isApplicationContext = false;
    protected boolean isMacOS = false;
    protected boolean showErrorDialogs = false;
    protected boolean resettingAll = false;
    protected TreeMap prefs = new TreeMap();
    private EventListenerList listenerList = new EventListenerList();

    protected AbstractPreferences() {
        this(false, null, false);
    }

    protected AbstractPreferences(boolean isApp, String fnameRoot, boolean show) {
        this.isApplicationContext = isApp;
        this.showErrorDialogs = show;
        this.appName = fnameRoot;
        try {
            if (System.getProperty("mrj.version") != null) {
                this.isMacOS = true;
            }
        }
        catch (Exception exc) {
            this.isMacOS = false;
        }
        this.restoreDefaults();
        if (this.isApplicationContext && fnameRoot != null) {
            this.findAndReadFile(fnameRoot);
        }
    }

    private void findAndReadFile(String fnameRoot) {
        String homeDir = System.getProperty("user.home");
        String pathSep = System.getProperty("file.separator");
        String prefsDname = null;
        String prefsFname = null;
        if (this.isMacOS) {
            prefsDname = homeDir + pathSep + "Library" + pathSep + "Preferences";
            prefsFname = "gov.nasa.giss." + fnameRoot + ".prefs.xml";
        } else {
            prefsDname = homeDir + pathSep + ".gissjava";
            prefsFname = fnameRoot.toLowerCase() + ".xml";
        }
        File prefsDir = null;
        try {
            prefsDir = new File(prefsDname);
            this.prefsFile = new File(prefsDname, prefsFname);
        }
        catch (Exception exc) {
            System.err.println("WARNING: Unable to find preferences directory (0).");
        }
        if (prefsDir == null || this.prefsFile == null) {
            System.err.println("WARNING: Unable to find preferences directory (1).");
            return;
        }
        boolean dirExists = false;
        dirExists = prefsDir.exists() ? true : prefsDir.mkdirs();
        if (!dirExists) {
            System.err.println("WARNING: Unable to find preferences directory (2).");
        }
        if (this.prefsFile.exists()) {
            this.read(null, this.prefsFile);
        } else if (this.prefsFile != null) {
            try {
                this.save(this.prefsFile);
            }
            catch (Exception exc) {
                System.err.println("WARNING: Unable to create preferences file (1).");
                this.prefsFile = null;
            }
        }
    }

    public void read(Component parent, File f) {
        this.settingsFile = f;
        try {
            this.readStream(new FileInputStream(this.settingsFile));
        }
        catch (Exception exc) {
            this.showError(parent, "File Error", "I encountered a preferences file error (1).", exc.toString());
        }
    }

    protected abstract void readStream(InputStream var1) throws IOException, JDOMException;

    public void savePrefs() {
        if (!this.isApplicationContext) {
            return;
        }
        if (this.prefsFile == null) {
            return;
        }
        try {
            this.save(this.prefsFile);
        }
        catch (Exception exc) {
            System.out.println("WARNING: Error trying to save preferences.");
        }
    }

    public Object get(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        return this.prefs.get(pname);
    }

    public boolean getBoolean(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        Object o = this.prefs.get(pname);
        if (o == null || !(o instanceof Boolean)) {
            throw new IllegalArgumentException("Not a boolean property.");
        }
        try {
            return (Boolean)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a boolean property.");
        }
    }

    public Color getColor(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null.");
        }
        if (!this.prefs.containsKey(pname)) {
            throw new IllegalArgumentException("No property called " + pname);
        }
        Object o = this.prefs.get(pname);
        if (o == null || !(o instanceof Color)) {
            throw new IllegalArgumentException("Not a color property.");
        }
        return (Color)o;
    }

    public double getDouble(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        Object o = this.prefs.get(pname);
        if (o == null || !(o instanceof Double)) {
            throw new IllegalArgumentException("Not a double property.");
        }
        try {
            return (Double)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a double property.");
        }
    }

    public int getInt(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        Object o = this.prefs.get(pname);
        if (o == null || !(o instanceof Integer)) {
            throw new IllegalArgumentException("Not an integer property.");
        }
        try {
            return (Integer)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not an integer property.");
        }
    }

    public String getString(String pname) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        try {
            return this.prefs.get(pname).toString();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a string property.");
        }
    }

    public void set(String pname, Object pvalue) {
        if (this.resettingAll) {
            return;
        }
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        Object oldValue = this.prefs.get(pname);
        if (oldValue != null) {
            if (pvalue instanceof String && ((String)pvalue).equals((String)oldValue)) {
                return;
            }
            if (pvalue instanceof Double && ((Double)pvalue).equals((Double)oldValue)) {
                return;
            }
            if (pvalue instanceof Integer && ((Integer)pvalue).equals((Integer)oldValue)) {
                return;
            }
            if (pvalue instanceof Boolean && ((Boolean)pvalue).equals((Boolean)oldValue)) {
                return;
            }
        }
        this.prefs.put(pname, pvalue);
        this.fireSettingChanged(pname);
    }

    public void setBoolean(String pname, boolean pvalue) {
        Object oldValue = this.prefs.get(pname);
        if (oldValue == null) {
            throw new IllegalArgumentException("No setting called " + pname);
        }
        if (!(oldValue instanceof Boolean)) {
            throw new IllegalArgumentException("Setting " + pname + " not a boolean.");
        }
        this.prefs.put(pname, new Boolean(pvalue));
        this.fireSettingChanged(pname);
    }

    public void setColor(String pname, Color pvalue) {
        if (pname == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (!this.prefs.containsKey(pname)) {
            throw new IllegalArgumentException("No property called " + pname);
        }
        Object oldValue = this.prefs.get(pname);
        if (!(oldValue instanceof Color)) {
            throw new IllegalArgumentException("Property " + pname + " not a color.");
        }
        this.prefs.put(pname, pvalue);
        this.fireSettingChanged(pname);
    }

    public void setDouble(String pname, double pvalue) {
        Object oldValue = this.prefs.get(pname);
        if (oldValue == null) {
            throw new IllegalArgumentException("No setting called " + pname);
        }
        if (!(oldValue instanceof Double)) {
            throw new IllegalArgumentException("Setting " + pname + " not a double.");
        }
        this.prefs.put(pname, new Double(pvalue));
        this.fireSettingChanged(pname);
    }

    public void setDouble(String pname, String pvalue) {
        Object oldValue = this.prefs.get(pname);
        if (oldValue == null) {
            throw new IllegalArgumentException("No setting called " + pname);
        }
        if (!(oldValue instanceof Double)) {
            throw new IllegalArgumentException("Setting " + pname + " not a double.");
        }
        if (pvalue.length() == 0) {
            pvalue = "0.";
        }
        try {
            this.prefs.put(pname, new Double(pvalue));
        }
        catch (Exception exc) {
            this.set(pname, oldValue);
            this.showError(null, "File Error", "I could not parse the preferences input;", pvalue + " is not a double.");
            return;
        }
        this.fireSettingChanged(pname);
    }

    public void setInt(String pname, int pvalue) {
        Object oldValue = this.prefs.get(pname);
        if (oldValue == null) {
            throw new IllegalArgumentException("No setting called " + pname);
        }
        if (!(oldValue instanceof Integer)) {
            throw new IllegalArgumentException("Setting " + pname + " not an integer.");
        }
        this.prefs.put(pname, new Integer(pvalue));
        this.fireSettingChanged(pname);
    }

    public void setInt(String pname, String pvalue) {
        Object oldValue = this.prefs.get(pname);
        if (oldValue == null) {
            throw new IllegalArgumentException("No setting called " + pname);
        }
        if (!(oldValue instanceof Integer)) {
            throw new IllegalArgumentException("Setting " + pname + " not an integer.");
        }
        if (pvalue.length() == 0) {
            pvalue = "0";
        }
        try {
            this.prefs.put(pname, new Integer(pvalue));
        }
        catch (Exception exc) {
            this.set(pname, oldValue);
            this.showError(null, "File Error", "I could not parse the preferences input;", pvalue + " is not an integer.");
            return;
        }
        this.fireSettingChanged(pname);
    }

    public void revert() {
        if (this.settingsFile != null) {
            this.read(null, this.settingsFile);
        } else if (this.prefsFile != null) {
            this.read(null, this.prefsFile);
        } else {
            this.restoreDefaults();
        }
    }

    public abstract void restoreDefaults();

    public void saveSettings(File f) {
        if (!this.isApplicationContext) {
            return;
        }
        try {
            this.save(f);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.showError(null, "File Error", "I encountered a preferences file error (2).", exc.toString());
        }
    }

    protected abstract void save(File var1) throws IOException;

    protected void showError(final Component parent, final String title, final String message1, final String message2) {
        if (!this.showErrorDialogs) {
            if (message1 != null) {
                System.out.println(message1);
            }
            if (message2 != null) {
                System.out.println(message2);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (message2 == null) {
                    JOptionPane.showMessageDialog(parent, message1, title, 0);
                } else {
                    int colon = message2.indexOf(": ");
                    String messageX = colon > -1 ? message2.substring(colon + 2) : message2;
                    JOptionPane.showMessageDialog(parent, message1 + "\n" + messageX, title, 0);
                }
            }
        });
    }

    public synchronized void addSettingsListener(PreferencesListener l) {
        this.listenerList.add(PreferencesListener.class, l);
    }

    public synchronized void removeSettingsListener(PreferencesListener l) {
        this.listenerList.remove(PreferencesListener.class, l);
    }

    protected void fireSettingChanged(String pname) {
        PreferencesEvent e = new PreferencesEvent(pname, this.get(pname));
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof PreferencesListener)) continue;
            ((PreferencesListener)list[i]).settingChanged(e);
        }
    }

    protected static Color createColor(String s) {
        if (!s.startsWith("java.awt.Color[") || !s.endsWith("]")) {
            return null;
        }
        s = s.substring(15, s.length() - 1);
        try {
            StringTokenizer t = new StringTokenizer(s, ",");
            int[] rgb = new int[3];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = Integer.parseInt(t.nextToken().substring(2));
                rgb[i] = Math.max(rgb[i], 0);
                rgb[i] = Math.min(rgb[i], 255);
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

