/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.img.GifIO;
import gov.nasa.giss.mars24.M24DisplayFrame;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;

class SaveImageAsAction
extends AbstractAction {
    public static final String GIF = ".gif";
    public static final String PNG = ".png";
    private String fnameRoot;
    private String fnameExtension = null;
    private File outputFile;
    private M24DisplayFrame parent;

    SaveImageAsAction(M24DisplayFrame jf) {
        super("Save Image as\u2026");
        this.parent = jf;
        this.fnameRoot = this.parent.getTitle();
    }

    public String getFname() {
        return this.fnameRoot;
    }

    public void setFname(String s) {
        this.fnameRoot = s;
    }

    public String getFext() {
        return this.fnameExtension;
    }

    public void setFext(String s) {
        this.fnameExtension = s;
    }

    public File getFile() {
        return this.outputFile;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fnameExtension == null) {
            this.fnameExtension = PNG;
        }
        String plotname = this.fnameRoot + this.fnameExtension;
        FileDialog fd = new FileDialog((Frame)this.parent, "Save plot (GIF or PNG) as\u2026", 1);
        fd.setFile(plotname);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null || fname.lastIndexOf(".") == 0) {
            return;
        }
        if (fname.toLowerCase().endsWith(PNG)) {
            this.fnameRoot = fname.substring(0, fname.lastIndexOf("."));
            this.fnameExtension = PNG;
        } else if (fname.toLowerCase().endsWith(GIF)) {
            this.fnameRoot = fname.substring(0, fname.lastIndexOf("."));
            this.fnameExtension = GIF;
        } else {
            this.fnameRoot = fname;
        }
        fname = this.fnameRoot + this.fnameExtension;
        try {
            this.outputFile = new File(fd.getDirectory(), fname);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.outputFile != null) {
            SaveImageAsAction.saveImage(this.outputFile, this.parent);
        }
    }

    public static void saveImage(File f, M24DisplayFrame df) {
        try {
            if (f.getName().toLowerCase().endsWith(GIF)) {
                SaveImageAsAction.saveAsGif(f, df);
            } else {
                SaveImageAsAction.saveAsPng(f, df);
            }
        }
        catch (Exception exc) {
            System.out.println("ERROR: Could not save image to a file.");
            exc.printStackTrace();
        }
    }

    public static void saveAsGif(File f, M24DisplayFrame df) throws FileNotFoundException, IOException {
        BufferedImage img = df.getImage();
        GifIO.write(img, f);
    }

    public static void saveAsPng(File f, M24DisplayFrame df) throws FileNotFoundException, IOException {
        BufferedImage img = df.getImage();
        ImageIO.write((RenderedImage)img, "png", f);
    }
}

