/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24AllInOnePanel;
import gov.nasa.giss.mars24.M24ControlsPanel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.xml.XmlPropertiesBundle;
import java.awt.Font;
import java.awt.Image;
import javax.swing.JApplet;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Mars24Applet
extends JApplet
implements Runnable {
    private Thread mThread = null;
    private Image img;
    private LandmarkList ll;

    public String getAppletInfo() {
        try {
            XmlPropertiesBundle resbundle = new XmlPropertiesBundle("gov.nasa.giss.mars24.resources.AboutMars24");
            return resbundle.getString("appName") + " " + resbundle.getString("version") + " / " + resbundle.getString("build") + "\n" + "\n" + resbundle.getString("credits") + "\n";
        }
        catch (Exception exc) {
            return "Mars24";
        }
    }

    public void start() {
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void run() {
        while (this.mThread != null) {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isVisible()) continue;
            this.repaint();
        }
        this.mThread = null;
    }

    public void stop() {
        this.mThread = null;
    }

    public void init() {
        M24Globals.setAppletContext(this.getAppletContext());
        System.out.println(this.getAppletInfo());
        UIDefaults uid = UIManager.getDefaults();
        this.reduceFont(uid, "Button", 2);
        this.reduceFont(uid, "CheckBox", 2);
        this.reduceFont(uid, "ComboBox", 2);
        this.reduceFont(uid, "Label", 2);
        this.reduceFont(uid, "RadioButton", 2);
        this.reduceFont(uid, "TextArea", 2);
        this.reduceFont(uid, "TextField", 2);
        this.reduceFont(uid, "TitledBorder", 2);
        try {
            this.img = M24Globals.loadImage(this.getClass().getResourceAsStream("resources/marsmap.jpg"));
        }
        catch (Exception exc) {
            System.out.println("ERROR: Could not load marsmap.jpg");
            exc.printStackTrace();
            System.exit(0);
        }
        try {
            this.ll = new LandmarkList(this.getClass().getResourceAsStream("resources/marslandmarks.xml"));
        }
        catch (Exception exc) {
            System.out.println("ERROR: Could not load marslandmarks.xml");
            exc.printStackTrace();
            System.exit(0);
        }
        if (this.ll == null) {
            this.ll = new LandmarkList();
        }
        M24Globals.setLandmarks(this.ll);
        M24Globals.setSettings(new M24Preferences(false));
        M24Timekeeper tk = new M24Timekeeper();
        M24Globals.setTimekeeper(tk);
        M24PlotPanel plot = new M24PlotPanel(this.img);
        M24TimePanel time = new M24TimePanel(1);
        M24ControlsPanel controls = new M24ControlsPanel(plot, time);
        M24AllInOnePanel allPanel = new M24AllInOnePanel(plot, time, controls, 700, 1000);
        this.getContentPane().add(allPanel);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void reduceFont(UIDefaults uid, String pname, int amount) {
        Font f = uid.getFont(pname + ".font");
        if (f != null) {
            uid.put(pname + ".font", f.deriveFont((float)((double)f.getSize() - (double)amount)));
        }
    }
}

