/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24AboutFrame;
import gov.nasa.giss.mars24.M24ControlsFrame;
import gov.nasa.giss.mars24.M24ControlsPanel;
import gov.nasa.giss.mars24.M24DisplayFrame;
import gov.nasa.giss.mars24.M24ForMac;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24HelpFrame;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Mars24 {
    private static final boolean MULTIPLE_WINDOWS = true;
    private static boolean DEBUG = false;
    private static final String MAP_FILE = "marsmap.jpg";
    private static final String LANDMARK_FILE = "marslandmarks.xml";
    private static M24Preferences prefs;
    private static boolean amQuitting;
    private static boolean isMacOS;
    private Thread splashThread = null;
    private boolean splashDone = false;
    private Image mapImage;

    public static void main(String[] args) {
        new Mars24();
    }

    public Mars24() {
        File f;
        ImageIcon ii;
        File f2;
        String sep;
        String path;
        int isep;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("WARNING: Unable to load native look and feel");
        }
        M24Globals.setApplicationContext();
        if (M24Globals.isMacintosh()) {
            isMacOS = true;
            M24ForMac.register();
        }
        M24AboutFrame aboutFrame = M24AboutFrame.find();
        aboutFrame.setVisible(true);
        this.splashThread = new Thread("splash thread"){

            public void run() {
                try {
                    1.sleep(1500L);
                    Mars24.this.splashDone = true;
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                    Mars24.this.splashDone = true;
                }
            }
        };
        this.splashThread.start();
        if (DEBUG) {
            M24Globals.debugAppend("user.home = " + System.getProperty("user.home"));
            M24Globals.debugAppend("user.dir  = " + System.getProperty("user.dir"));
        }
        path = (isep = (path = System.getProperty("java.class.path")).lastIndexOf(sep = System.getProperty("file.separator"))) > -1 ? path.substring(0, isep) : ".";
        try {
            f2 = new File(path, MAP_FILE);
            if (f2.exists()) {
                ii = new ImageIcon(path + sep + MAP_FILE);
                this.mapImage = ii.getImage();
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (isMacOS && this.mapImage == null) {
            path = System.getProperty("user.dir");
            try {
                f2 = new File(path, MAP_FILE);
                if (f2.exists()) {
                    ii = new ImageIcon(path + sep + MAP_FILE);
                    this.mapImage = ii.getImage();
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (this.mapImage == null) {
            try {
                ImageIcon ii2 = new ImageIcon(this.getClass().getResource("resources/marsmap.jpg"));
                this.mapImage = ii2.getImage();
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Using blank map because Mars map image is missing.", "Launch Error", 0);
            }
        }
        LandmarkList landmarks = null;
        try {
            f = new File(path, LANDMARK_FILE);
            if (f.exists()) {
                landmarks = new LandmarkList(f);
            }
        }
        catch (Exception exc) {
            landmarks = null;
        }
        if (isMacOS && landmarks == null) {
            path = System.getProperty("user.dir");
            try {
                f = new File(path, LANDMARK_FILE);
                if (f.exists()) {
                    landmarks = new LandmarkList(f);
                }
            }
            catch (Exception exc) {
                landmarks = null;
            }
        }
        if (landmarks == null) {
            try {
                landmarks = new LandmarkList(this.getClass().getResource("resources/marslandmarks.xml"));
            }
            catch (Exception exc) {
                System.err.println(exc.toString());
                exc.printStackTrace();
                JOptionPane.showMessageDialog(null, "Unable to start because the landmarks file is missing.", "Launch Error", 0);
                System.exit(0);
            }
        }
        if (landmarks == null) {
            landmarks = new LandmarkList();
        }
        M24Globals.setLandmarks(landmarks);
        prefs = new M24Preferences(true);
        M24Globals.setSettings(prefs);
        M24Timekeeper tk = new M24Timekeeper();
        M24Globals.setTimekeeper(tk);
        M24PlotPanel plotDisplay = new M24PlotPanel(this.mapImage);
        M24TimePanel timeDisplay = new M24TimePanel(1);
        M24ControlsPanel controlsPanel = new M24ControlsPanel(plotDisplay, timeDisplay);
        if (isMacOS && !DEBUG) {
            M24HelpFrame.findFrame("guide");
        }
        if (prefs.getBoolean("help_faqVisible")) {
            M24HelpFrame.findFrame("faq").setVisible(true);
        }
        if (prefs.getBoolean("help_notesVisible")) {
            M24HelpFrame.findFrame("notes").setVisible(true);
        }
        if (prefs.getBoolean("help_guideVisible")) {
            M24HelpFrame.findFrame("guide").setVisible(true);
        }
        aboutFrame.setVisible(false);
        aboutFrame.setLaunched(true);
        M24DisplayFrame plotFrame = new M24DisplayFrame(plotDisplay);
        M24DisplayFrame timeFrame = new M24DisplayFrame(timeDisplay);
        M24ControlsFrame controlsFrame = new M24ControlsFrame(controlsPanel);
        plotFrame.setResizable(true);
        timeFrame.setResizable(true);
        ((Window)plotFrame).setVisible(prefs.getBoolean("plotFrame_visible"));
        ((Window)timeFrame).setVisible(prefs.getBoolean("timeFrame_visible"));
        ((Window)controlsFrame).setVisible(prefs.getBoolean("controlsFrame_visible"));
        if (!Mars24.isAFrameVisible()) {
            ((Window)plotFrame).setVisible(true);
            ((Window)timeFrame).setVisible(true);
            timeFrame.toFront();
        }
        if (controlsFrame.isVisible()) {
            controlsFrame.toFront();
        }
        if (isMacOS) {
            return;
        }
        M24TimekeeperListener l = new M24TimekeeperListener(){

            public void timeChanged(M24TimekeeperEvent e) {
                if (!Mars24.isAFrameVisible()) {
                    Mars24.quit();
                }
            }

            public void timeReset(M24TimekeeperEvent e) {
            }

            public void siteChanged(M24TimekeeperEvent e) {
            }

            public void formatChanged(M24TimekeeperEvent e) {
            }
        };
    }

    public static boolean isAFrameVisible() {
        Frame[] flist = Frame.getFrames();
        for (int i = 0; i < flist.length; ++i) {
            if (!flist[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public static void quit() {
        if (amQuitting) {
            return;
        }
        amQuitting = true;
        try {
            if (prefs != null) {
                prefs.savePrefs();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.exit(0);
    }

    static {
        amQuitting = false;
        isMacOS = false;
    }
}

