/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.JMenuItem2;
import gov.nasa.giss.mars24.M24AboutFrame;
import gov.nasa.giss.mars24.M24AbstractMenu;
import gov.nasa.giss.mars24.M24ControlsFrame;
import gov.nasa.giss.mars24.M24DisplayFrame;
import gov.nasa.giss.mars24.M24ForMac;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24HelpFrame;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class M24WindowMenu
extends M24AbstractMenu {
    private static final boolean DEBUG = false;
    private JRadioButtonMenuItem miShowControls;
    private JRadioButtonMenuItem miShowTime;
    private JRadioButtonMenuItem miShowPlot;
    private JRadioButtonMenuItem miShowGuide;
    private JRadioButtonMenuItem miShowNotes;
    private JRadioButtonMenuItem miShowFAQ;
    private JRadioButtonMenuItem miShowAlgorithm;
    private Frame frame;

    public M24WindowMenu(Frame f) {
        super("Window");
        this.frame = f;
        AbstractAction a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.frame.setState(1);
            }
        };
        JMenuItem2 jmi = this.makeSimpleMenuItem("minimize-window", "Minimize", "meta M", a);
        this.add(jmi);
        if (M24Globals.isMacintosh()) {
            jmi.setEnabled(M24Globals.isApplicationContext() && !(this.frame instanceof M24ForMac));
        } else {
            jmi.setEnabled(true);
        }
        this.addSeparator();
        Object radioIcon = UIManager.get("RadioButtonMenuItem.checkIcon");
        UIManager.put("RadioButtonMenuItem.checkIcon", UIManager.get("CheckBoxMenuItem.checkIcon"));
        this.miShowControls = new JRadioButtonMenuItem("Settings");
        if (M24Globals.isApplicationContext()) {
            this.miShowControls.setAccelerator(KeyStroke.getKeyStroke(49, SHORTCUT_MASK));
        }
        this.miShowControls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                for (int i = 0; i < flist.length; ++i) {
                    if (!(flist[i] instanceof M24ControlsFrame)) continue;
                    M24WindowMenu.this.selectFrame(flist[i]);
                }
            }
        });
        this.add(this.miShowControls).setEnabled(true);
        this.miShowTime = new JRadioButtonMenuItem("Numeric Time");
        if (M24Globals.isApplicationContext()) {
            this.miShowTime.setAccelerator(KeyStroke.getKeyStroke(50, SHORTCUT_MASK));
        }
        this.miShowTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                for (int i = 0; i < flist.length; ++i) {
                    if (flist[i].getName().indexOf("time") <= -1) continue;
                    M24WindowMenu.this.selectFrame(flist[i]);
                    return;
                }
            }
        });
        this.add(this.miShowTime).setEnabled(true);
        this.miShowPlot = new JRadioButtonMenuItem("Graphic Display");
        if (M24Globals.isApplicationContext()) {
            this.miShowPlot.setAccelerator(KeyStroke.getKeyStroke(51, SHORTCUT_MASK));
        }
        this.miShowPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                for (int i = 0; i < flist.length; ++i) {
                    if (flist[i].getName().indexOf("plot") <= -1) continue;
                    M24WindowMenu.this.selectFrame(flist[i]);
                    return;
                }
            }
        });
        this.add(this.miShowPlot).setEnabled(true);
        this.addSeparator();
        this.miShowGuide = new JRadioButtonMenuItem("User's Guide");
        if (M24Globals.isApplicationContext()) {
            this.miShowGuide.setAccelerator(KeyStroke.getKeyStroke(52, SHORTCUT_MASK));
        }
        this.miShowGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.selectFrame(M24HelpFrame.findFrame("guide"));
            }
        });
        this.add(this.miShowGuide).setEnabled(true);
        this.miShowNotes = new JRadioButtonMenuItem("About Mars Time");
        if (M24Globals.isApplicationContext()) {
            this.miShowNotes.setAccelerator(KeyStroke.getKeyStroke(53, SHORTCUT_MASK));
        }
        this.miShowNotes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.selectFrame(M24HelpFrame.findFrame("notes"));
            }
        });
        this.add(this.miShowNotes).setEnabled(true);
        this.miShowFAQ = new JRadioButtonMenuItem("Mars24 FAQ");
        if (M24Globals.isApplicationContext()) {
            this.miShowFAQ.setAccelerator(KeyStroke.getKeyStroke(54, SHORTCUT_MASK));
        }
        this.miShowFAQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.selectFrame(M24HelpFrame.findFrame("faq"));
            }
        });
        this.add(this.miShowFAQ).setEnabled(true);
        if (!M24Globals.isMacintosh() || M24Globals.isAppletContext()) {
            this.addSeparator();
            AbstractAction a2 = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    M24AboutFrame.reveal();
                }
            };
            this.add(this.makeSimpleMenuItem("about", "About Mars24\u2026", null, a2)).setEnabled(true);
        }
        UIManager.put("RadioButtonMenuItem.checkIcon", radioIcon);
        this.update();
    }

    public void selectFrame(Frame f) {
        if (f == null) {
            return;
        }
        f.setState(0);
        f.toFront();
        f.setVisible(true);
    }

    public void update() {
        Object radioIcon = UIManager.get("RadioButtonMenuItem.checkIcon");
        UIManager.put("RadioButtonMenuItem.checkIcon", UIManager.get("CheckBoxMenuItem.checkIcon"));
        if (this.frame instanceof M24ControlsFrame) {
            this.miShowControls.setSelected(true);
        } else {
            this.miShowControls.setSelected(false);
        }
        if (this.frame instanceof M24DisplayFrame) {
            if (this.frame.getName().equals("time")) {
                this.miShowPlot.setSelected(false);
                this.miShowTime.setSelected(true);
            } else if (this.frame.getName().equals("plot")) {
                this.miShowPlot.setSelected(true);
                this.miShowTime.setSelected(false);
            } else {
                this.miShowPlot.setSelected(false);
                this.miShowTime.setSelected(false);
            }
        } else {
            this.miShowPlot.setSelected(false);
            this.miShowTime.setSelected(false);
        }
        if (this.frame instanceof M24HelpFrame) {
            if (this.frame.getName().equals("notes")) {
                this.miShowGuide.setSelected(false);
                this.miShowNotes.setSelected(true);
                this.miShowFAQ.setSelected(false);
                if (this.miShowAlgorithm != null) {
                    this.miShowAlgorithm.setSelected(false);
                }
            } else if (this.frame.getName().equals("guide")) {
                this.miShowGuide.setSelected(true);
                this.miShowNotes.setSelected(false);
                this.miShowFAQ.setSelected(false);
                if (this.miShowAlgorithm != null) {
                    this.miShowAlgorithm.setSelected(false);
                }
            } else if (this.frame.getName().equals("faq")) {
                this.miShowGuide.setSelected(false);
                this.miShowNotes.setSelected(false);
                this.miShowFAQ.setSelected(true);
                if (this.miShowAlgorithm != null) {
                    this.miShowAlgorithm.setSelected(false);
                }
            } else {
                this.miShowGuide.setSelected(false);
                this.miShowNotes.setSelected(false);
                this.miShowFAQ.setSelected(false);
                if (this.miShowAlgorithm != null) {
                    this.miShowAlgorithm.setSelected(false);
                }
            }
        } else {
            this.miShowGuide.setSelected(false);
            this.miShowNotes.setSelected(false);
            this.miShowFAQ.setSelected(false);
            if (this.miShowAlgorithm != null) {
                this.miShowAlgorithm.setSelected(false);
            }
        }
        UIManager.put("RadioButtonMenuItem.checkIcon", radioIcon);
    }
}

