/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.Landmark;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.JulianDay;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.PlanetTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public class M24Timekeeper
implements PreferencesListener {
    public static final int CURRENT = 1;
    public static final int OFFSET = 2;
    public static final int FIXED = 3;
    public static final int SHOW_LTST = 10;
    public static final int SHOW_LMST = 20;
    public static final int SHOW_LMZT = 30;
    public static final int SHOW_MTC = 40;
    public static final int SHOW_VIK1 = 101;
    public static final int SHOW_VIK2 = 102;
    public static final int SHOW_MPF = 103;
    public static final int SHOW_MERA = 105;
    public static final int SHOW_MERB = 106;
    public static final int SHOW_MERA_MERB = 1001;
    public static final int MERCURY = 1;
    public static final int VENUS = 2;
    public static final int EARTH = 3;
    public static final int MARS = 4;
    public static final int JUPITER = 5;
    public static final int SATURN = 6;
    public static final long BAD_OFFSET = Long.MIN_VALUE;
    private int earthMethod = 1;
    private int timeForm = 20;
    private double siteLon = 0.0;
    private double siteLat = 0.0;
    private JulianDay julianTime = new JulianDay(0L);
    private MarsTime marsTime = new MarsTime(0L);
    private EarthTime earthTime = new EarthTime(0L);
    private PlanetTime mercuryTime = new PlanetTime(1);
    private PlanetTime venusTime = new PlanetTime(2);
    private PlanetTime jupiterTime = new PlanetTime(5);
    private PlanetTime saturnTime = new PlanetTime(6);
    private long millis;
    private long nowMillis;
    private long offsetMillis;
    private boolean badTime = false;
    private boolean showDateAsDOY = false;
    private LandmarkList landmarks;
    private M24Preferences prefs;
    protected EventListenerList listenerList = new EventListenerList();
    private Thread clockThread = null;
    private boolean clockPaused = true;
    private Calendar fixedCal;

    public M24Timekeeper() {
        this.prefs = M24Globals.getSettings();
        this.landmarks = M24Globals.getLandmarks();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        tz.setRawOffset(0);
        this.fixedCal = new GregorianCalendar(tz);
        this.updateSetting("all");
        this.prefs.addSettingsListener(this);
        this.startClock();
    }

    public AbstractPlanetTime getTimeObject(int id) {
        switch (id) {
            case 1: {
                this.mercuryTime.setTime(this.millis);
                return this.mercuryTime;
            }
            case 2: {
                this.venusTime.setTime(this.millis);
                return this.venusTime;
            }
            case 3: {
                this.earthTime.setTime(this.millis);
                return this.earthTime;
            }
            case 4: {
                this.marsTime.setTime(this.millis);
                return this.marsTime;
            }
            case 5: {
                this.jupiterTime.setTime(this.millis);
                return this.jupiterTime;
            }
            case 6: {
                this.saturnTime.setTime(this.millis);
                return this.jupiterTime;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startClock() {
        this.clockPaused = false;
        if (this.clockThread == null) {
            this.clockThread = new Thread("ticker: landmark data"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        Thread thread = M24Timekeeper.this.clockThread;
                        synchronized (thread) {
                            while (M24Timekeeper.this.clockPaused) {
                                try {
                                    this.wait();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        M24Timekeeper.this.update();
                        try {
                            1.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException exc) {
                            exc.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.clockThread.start();
        } else {
            Thread thread = this.clockThread;
            synchronized (thread) {
                this.clockThread.notify();
            }
        }
    }

    private void pauseClock() {
        this.clockPaused = true;
    }

    private void update() {
        if (this.earthMethod == 3) {
            this.millis = this.badTime ? 0L : this.fixedCal.getTimeInMillis();
            return;
        }
        this.nowMillis = System.currentTimeMillis();
        this.millis = this.earthMethod == 2 ? this.nowMillis + this.offsetMillis : this.nowMillis;
        this.fireTimeChanged();
    }

    public int getMarsTimeFormat() {
        return this.timeForm;
    }

    public double getSiteLongitude() {
        return this.siteLon;
    }

    public double getSiteLatitude() {
        return this.siteLat;
    }

    public long getMillis() {
        if (this.badTime) {
            return 0L;
        }
        return this.millis;
    }

    public JulianDay getJulianDay() {
        this.julianTime.setTime(this.millis);
        return this.julianTime;
    }

    public synchronized void addTimekeeperListener(M24TimekeeperListener l) {
        this.listenerList.add(M24TimekeeperListener.class, l);
    }

    public synchronized void removeTimekeeperListener(M24TimekeeperListener l) {
        this.listenerList.remove(M24TimekeeperListener.class, l);
    }

    protected void fireTimeChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this);
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof M24TimekeeperListener)) continue;
            ((M24TimekeeperListener)list[i]).timeChanged(e);
        }
    }

    protected void fireTimeReset() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this);
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof M24TimekeeperListener)) continue;
            ((M24TimekeeperListener)list[i]).timeReset(e);
        }
    }

    protected void fireSiteChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this);
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof M24TimekeeperListener)) continue;
            ((M24TimekeeperListener)list[i]).siteChanged(e);
        }
    }

    protected void fireFormatChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this);
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof M24TimekeeperListener)) continue;
            ((M24TimekeeperListener)list[i]).timeReset(e);
        }
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        String method;
        boolean changeAll;
        if (pname == null) {
            pname = "all";
        }
        if ((changeAll = pname.equals("all")) || pname.startsWith("mars")) {
            method = this.prefs.getString("marsTime_method");
            if (method == null || method.equals("local")) {
                String type = this.prefs.getString("marsTime_spotType");
                if (type == null) {
                    type = "lonlat";
                }
                if (type.equals("landmark")) {
                    this.setLandmark(this.prefs.getString("marsTime_spotLandmark"));
                } else {
                    this.setLonLat(this.prefs.getDouble("marsTime_spotLon"), this.prefs.getDouble("marsTime_spotLat"));
                }
                this.setDisplayFormat(this.prefs.getString("marsTime_format"));
            } else if (method.equals("MERA")) {
                this.setDisplayFormat(105);
                this.setLandmark("MERA");
            } else if (method.equals("MERB")) {
                this.setDisplayFormat(106);
                this.setLandmark("MERB");
            } else if (method.equals("MERA_MERB")) {
                this.setDisplayFormat(1001);
                this.setLandmark("MERA");
            } else if (method.equals("MPF")) {
                this.setDisplayFormat(103);
                this.setLandmark("MPF");
            }
        }
        if (changeAll || pname.startsWith("earthTime")) {
            block37: {
                method = this.prefs.getString("earthTime_method");
                if (method == null) {
                    method = "current";
                }
                if (method.equals("offset")) {
                    double y = this.prefs.getDouble("earthTime_offsetYear");
                    double d = this.prefs.getDouble("earthTime_offsetDay");
                    double h = this.prefs.getDouble("earthTime_offsetHour");
                    double m = this.prefs.getDouble("earthTime_offsetMin");
                    double s = this.prefs.getDouble("earthTime_offsetSec");
                    long o = (long)(((y * 365.0 + d) * 86400.0 + h * 3600.0 + m * 60.0 + s) * 1000.0);
                    this.earthMethod = 2;
                    this.badTime = false;
                    if (o == Long.MIN_VALUE) {
                        this.badTime = true;
                    } else {
                        this.offsetMillis = o;
                    }
                } else if (method.equals("fixed")) {
                    this.earthMethod = 3;
                    this.badTime = false;
                    try {
                        Date date = new Date(this.prefs.getString("earthTime_fixedDate") + " " + this.prefs.getString("earthTime_fixedTime") + " GMT");
                        int year = date.getYear() + 1900;
                        if (year < 1750 || year > 2250) {
                            this.badTime = true;
                            break block37;
                        }
                        this.fixedCal.setTime(date);
                    }
                    catch (Exception exc) {
                        this.badTime = true;
                    }
                } else if (method.equals("jd") || method.equals("mjd")) {
                    this.earthMethod = 3;
                    this.badTime = false;
                    String jdtype = this.prefs.getString("earthTime_jdtype").toLowerCase();
                    double jd = 0.0;
                    jd = jdtype.equals("mjd") ? this.prefs.getDouble("earthTime_jdval") + 2400000.5 : this.prefs.getDouble("earthTime_jdval");
                    double j = Math.floor(jd);
                    double f = jd - j;
                    if ((f += 0.5) >= 1.0) {
                        f -= 1.0;
                        j += 1.0;
                    }
                    double a1 = Math.floor(j / 36524.25 - 51.12264);
                    double a = j + 1.0 + a1 - Math.floor(a1 / 4.0);
                    double b = a + 1524.0;
                    double c = Math.floor(b / 365.25 - 0.3343);
                    double d = Math.floor(365.25 * c);
                    double e = Math.floor((b - d) / 30.61);
                    d = b - d - Math.floor(30.61 * e) + f;
                    double mon = e - 1.0;
                    int yr = (int)(c - 4716.0);
                    if (e > 13.5) {
                        mon -= 12.0;
                    }
                    if (mon < 2.5) {
                        ++yr;
                    }
                    int dd = (int)d;
                    d = (d - (double)dd) * 24.0;
                    int hh = (int)Math.floor(d);
                    d = (d - (double)hh) * 60.0;
                    int mm = (int)Math.floor(d);
                    d = (d - (double)mm) * 60.0;
                    int ss = (int)Math.floor(d);
                    if (yr < 1750 || yr > 2250) {
                        System.out.println("Fixed time is out of valid range");
                        this.badTime = true;
                    } else {
                        try {
                            this.fixedCal.set(yr, (int)(mon - 1.0), dd, hh, mm, ss);
                            this.fixedCal.set(14, 0);
                        }
                        catch (Exception exc) {
                            System.out.println("Error trying to set via Calendar class");
                            exc.printStackTrace();
                            this.badTime = true;
                        }
                    }
                } else {
                    this.earthMethod = 1;
                    this.offsetMillis = 0L;
                    this.badTime = false;
                }
            }
            this.update();
            this.fireTimeReset();
        }
        if (changeAll || pname.equals("earthTime_dateAsDOY")) {
            try {
                this.showDateAsDOY = this.prefs.getBoolean("earthTime_dateAsDOY");
            }
            catch (Exception exc) {
                this.showDateAsDOY = false;
            }
        }
    }

    private void setDisplayFormat(String form) {
        String lc = form == null ? "mean solar" : form.toLowerCase();
        if (lc.toLowerCase().indexOf("mean solar") > -1) {
            this.setDisplayFormat(20);
        } else if (lc.indexOf("true solar") > -1) {
            this.setDisplayFormat(10);
        } else if (lc.indexOf("zonal") > -1) {
            this.setDisplayFormat(30);
        }
    }

    private void setDisplayFormat(int id) {
        if (id == this.timeForm) {
            return;
        }
        this.timeForm = id;
        this.fireFormatChanged();
    }

    private void setLonLat(double lon, double lat) {
        if (lon == this.siteLon && lat == this.siteLat) {
            return;
        }
        this.siteLon = lon;
        this.siteLat = lat;
        this.fireSiteChanged();
    }

    private void setLandmark(String lcode) {
        Landmark l = this.landmarks.findByCode(lcode);
        if (l == null) {
            l = this.landmarks.findByName(lcode);
        }
        if (l == null) {
            System.out.println("Unknown landmark code/name " + lcode);
        } else {
            this.setLonLat(l.getLongitude(), l.getLatitude());
        }
    }
}

