/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24DisplayPanel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.JulianDay;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.MissionTime;
import gov.nasa.giss.time.TimeConstants;
import gov.nasa.giss.time.TimeFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class M24TimePanel
extends JPanel
implements M24DisplayPanel,
PreferencesListener,
M24TimekeeperListener,
SwingConstants,
TimeConstants {
    private static final long REFRESH_INTERVAL = 50L;
    private static final int DISTANCE_LIGHTMIN = 1;
    private static final int DISTANCE_LIGHTSEC = 2;
    private static final int DISTANCE_AU = 3;
    private static final int DISTANCE_KM = 4;
    private static final int FONT_WEIGHT = 0;
    private static final int COLUMN1 = 1;
    private static final int COLUMN2 = 2;
    private static final int CENTERED = 0;
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private MissionTime merACount;
    private MissionTime merBCount;
    private MissionTime mpfCount;
    private int distanceUnits = 1;
    private boolean showDateAsDOY = false;
    private int orientation = 1;
    private float col1center;
    private float col2center;
    private int lineGap;
    private int fhLarge;
    private int fhMedium;
    private int fhSmall;
    private Font fontLarge;
    private Font fontMedium;
    private Font fontSmall;
    private FontMetrics fm;
    private Color color0 = Color.black;
    private Color color1 = Color.white;
    private Color color2 = Color.white;
    private Color color3 = Color.white;
    private AbstractPlanetTime mTime;
    private AbstractPlanetTime eTime;
    private JulianDay jTime;
    private JComponent mpanel;
    private JComponent epanel;
    private long lastUpdate = 0L;
    private boolean noResize = false;

    public M24TimePanel(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unknown orientation.");
        }
        this.orientation = orientation;
        this.prefs = M24Globals.getSettings();
        this.timekeeper = M24Globals.getTimekeeper();
        this.setBackground(Color.black);
        this.setBorder(null);
        this.setOpaque(true);
        this.setLayout(null);
        this.setDoubleBuffered(true);
        this.mpanel = new MarsPanel();
        this.epanel = new EarthPanel();
        this.add(this.mpanel);
        this.add(this.epanel);
        if (orientation == 1) {
            this.setMinimumSize(new Dimension(350, 171));
            this.setMaximumSize(new Dimension(1600, 685));
        } else {
            this.setMinimumSize(new Dimension(350, 95));
            this.setMaximumSize(new Dimension(1600, 378));
        }
        this.updateSetting("all");
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
    }

    public void setBackground(Color c) {
        if (c.equals(Color.black)) {
            this.color0 = Color.black;
            this.color1 = Color.white;
            this.color2 = Color.green;
            this.color3 = Color.red;
        } else {
            this.color0 = Color.white;
            this.color1 = Color.black;
            this.color2 = Color.red;
            this.color3 = Color.darkGray;
        }
        super.setBackground(this.color0);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        int lheight;
        super.setSize(w, h);
        Insets ins = this.getInsets();
        int useHeight = h - ins.top - ins.bottom;
        int useWidth = w - ins.left - ins.right;
        if (this.orientation == 1) {
            lheight = (int)((double)(useHeight - 8) / 9.5);
        } else {
            lheight = (int)((double)(useHeight - 8) / 5.5);
            useWidth /= 2;
        }
        this.lineGap = Math.max(2, (int)(0.1 * (double)lheight));
        this.fhMedium = Math.min(lheight - this.lineGap, (useWidth - 4 * this.lineGap) / 22);
        this.fhLarge = (int)(1.25 * (double)this.fhMedium);
        this.fhSmall = (int)(0.67 * (double)this.fhLarge);
        this.fontLarge = new Font("Courier", 0, this.fhLarge);
        this.fontMedium = new Font("Courier", 0, this.fhMedium);
        this.fontSmall = new Font("Courier", 0, this.fhSmall);
        if (this.orientation == 1) {
            int h1 = useHeight * 5 / 9;
            int h2 = useHeight * 4 / 9;
            this.mpanel.setLocation(ins.left, ins.top);
            this.mpanel.setSize(useWidth, h1);
            this.epanel.setLocation(ins.left, ins.top + h1);
            this.epanel.setSize(useWidth, h2);
        } else {
            this.mpanel.setLocation(ins.left, ins.top);
            this.mpanel.setSize(useWidth, useHeight);
            this.epanel.setLocation(ins.left + useWidth, ins.top);
            this.epanel.setSize(useWidth, useHeight);
        }
        this.col1center = 0.25f * (float)useWidth;
        this.col2center = (float)useWidth - this.col1center;
        this.revalidate();
        this.repaint();
        this.noResize = true;
        this.prefs.setInt("timeFrame_width", w);
        this.prefs.setInt("timeFrame_height", h);
        this.noResize = false;
    }

    public void paintComponent(Graphics g) {
        this.mTime = this.timekeeper.getTimeObject(4);
        this.eTime = this.timekeeper.getTimeObject(3);
        this.jTime = this.timekeeper.getJulianDay();
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        this.lastUpdate = System.currentTimeMillis();
    }

    private void drawText(Graphics2D g2d, String text, int col, int y) {
        int w = g2d.getFontMetrics().stringWidth(text);
        switch (col) {
            case 0: {
                g2d.drawString(text, 0.5f * (this.col1center + this.col2center - (float)w), (float)y);
                return;
            }
            case 1: {
                g2d.drawString(text, this.col1center - 0.5f * (float)w, (float)y);
                return;
            }
            case 2: {
                g2d.drawString(text, this.col2center - 0.5f * (float)w, (float)y);
                return;
            }
        }
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.getSize().width, this.getSize().height, 1);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintComponent(g2d);
        this.paintChildren(g2d);
        g2d.dispose();
        return img;
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("earthTime_dateAsDOY");
            this.updateSetting("earthTime_distanceUnits");
            this.updateSetting("timeFrame_width");
        }
        if (pname.equals("earthTime_dateAsDOY")) {
            this.showDateAsDOY = this.prefs.getBoolean("earthTime_dateAsDOY");
        } else if (pname.equals("earthTime_distanceUnits")) {
            String units = this.prefs.getString("earthTime_distanceUnits").toLowerCase();
            this.distanceUnits = units.equals("kilometers") || units.equals("km") ? 4 : (units.equals("au") || units.indexOf("astronomical") > -1 ? 3 : (units.indexOf("light sec") > -1 ? 2 : 1));
        } else if ((pname.equals("timeFrame_width") || pname.equals("timeFrame_height")) && !this.noResize) {
            Dimension d = new Dimension(this.prefs.getInt("timeFrame_width"), this.prefs.getInt("timeFrame_height"));
            this.setPreferredSize(d);
            this.setSize(d);
            try {
                ((JFrame)this.getTopLevelAncestor()).pack();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate < 50L) {
            return;
        }
        this.repaint();
        this.lastUpdate = now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void formatChanged(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    class EarthPanel
    extends JComponent {
        public EarthPanel() {
            this.setBackground(M24TimePanel.this.color0);
            this.setBorder(null);
            this.setOpaque(true);
            this.setDoubleBuffered(true);
        }

        public void paintComponent(Graphics g) {
            if (!this.isVisible()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int pWidth = this.getSize().width;
            int pHeight = this.getSize().height;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, pWidth, pHeight);
            g2d.setColor(M24TimePanel.this.color1);
            g2d.setFont(M24TimePanel.this.fontMedium);
            int y = M24TimePanel.this.fhMedium;
            M24TimePanel.this.drawText(g2d, "\u00b7 EARTH \u00b7", 0, y);
            g2d.setColor(M24TimePanel.this.color2);
            g2d.setFont(M24TimePanel.this.fontLarge);
            M24TimePanel.this.drawText(g2d, ((EarthTime)M24TimePanel.this.eTime).getTimeStringSeconds(false), 1, y += M24TimePanel.this.fhLarge + M24TimePanel.this.lineGap);
            M24TimePanel.this.drawText(g2d, ((EarthTime)M24TimePanel.this.eTime).getTimeStringSeconds(true), 2, y);
            g2d.setColor(M24TimePanel.this.color3);
            g2d.setFont(M24TimePanel.this.fontMedium);
            M24TimePanel.this.drawText(g2d, ((EarthTime)M24TimePanel.this.eTime).getDateString(false, M24TimePanel.this.showDateAsDOY), 1, y += M24TimePanel.this.fhMedium + M24TimePanel.this.lineGap);
            M24TimePanel.this.drawText(g2d, ((EarthTime)M24TimePanel.this.eTime).getDateString(true, M24TimePanel.this.showDateAsDOY), 2, y);
            y += M24TimePanel.this.fhSmall + M24TimePanel.this.lineGap;
            g2d.setColor(M24TimePanel.this.color3);
            g2d.setFont(M24TimePanel.this.fontSmall);
            StringBuffer stringBuffer = new StringBuffer().append("MJD ");
            JulianDay julianDay = M24TimePanel.this.jTime;
            M24TimePanel.this.jTime;
            M24TimePanel.this.drawText(g2d, stringBuffer.append(M24Globals.FORMAT_X3.format(julianDay.getDay(2))).toString(), 1, y);
            M24TimePanel.this.drawText(g2d, this.getDistance(M24TimePanel.this.mTime), 2, y);
        }

        private String getDistance(AbstractPlanetTime t) {
            double distAU = t.getEarthDistance(3);
            if (M24TimePanel.this.distanceUnits == 3) {
                return "Dist. " + M24Globals.FORMAT_X3.format(distAU) + " AU";
            }
            if (M24TimePanel.this.distanceUnits == 4) {
                return "Dist. " + M24Globals.FORMAT_X1.format(distAU * 1.49597870691E8 / 1000000.0) + " Mkm";
            }
            if (M24TimePanel.this.distanceUnits == 2) {
                return "OWLT " + M24Globals.FORMAT_X0.format(distAU * 499.0047838061357) + " s";
            }
            double distLight = distAU * 499.0047838061357;
            int isec = (int)Math.round(distLight);
            int isecX = isec % 60;
            int iminX = (isec - isecX) / 60;
            return "OWLT " + iminX + ":" + M24Globals.FORMAT_20.format(isecX) + " min";
        }
    }

    class MarsPanel
    extends JComponent {
        public MarsPanel() {
            this.setBackground(M24TimePanel.this.color0);
            this.setBorder(null);
            this.setOpaque(true);
            this.setDoubleBuffered(true);
        }

        public void paintComponent(Graphics g) {
            if (!this.isVisible()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int pWidth = this.getSize().width;
            int pHeight = this.getSize().height;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, pWidth, pHeight);
            g2d.setColor(M24TimePanel.this.color1);
            g2d.setFont(M24TimePanel.this.fontMedium);
            int y = M24TimePanel.this.fhMedium;
            M24TimePanel.this.drawText(g2d, "\u00b7 MARS \u00b7", 0, y);
            if (M24TimePanel.this.mTime == null) {
                y += M24TimePanel.this.fhLarge + M24TimePanel.this.lineGap;
                g2d.setColor(M24TimePanel.this.color3);
                g2d.setFont(M24TimePanel.this.fontLarge);
                M24TimePanel.this.fm = g2d.getFontMetrics();
                String message1 = "Time/date out of valid range or not";
                String message2 = "well-formatted. Please re-enter.";
                g2d.drawString(message1, (pWidth - M24TimePanel.this.fm.stringWidth(message1)) / 2, y);
                g2d.drawString(message2, (pWidth - M24TimePanel.this.fm.stringWidth(message2)) / 2, y);
                return;
            }
            double lon = M24TimePanel.this.timekeeper.getSiteLongitude();
            double lat = M24TimePanel.this.timekeeper.getSiteLatitude();
            AbstractPlanetTime abstractPlanetTime = M24TimePanel.this.mTime;
            M24TimePanel.this.mTime;
            String primeMeanTime = abstractPlanetTime.getTimeStringSeconds(0.0, 1, false);
            StringBuffer mTimestrBuffer = new StringBuffer("");
            switch (M24TimePanel.this.timekeeper.getMarsTimeFormat()) {
                case 10: {
                    AbstractPlanetTime abstractPlanetTime2 = M24TimePanel.this.mTime;
                    M24TimePanel.this.mTime;
                    mTimestrBuffer.append(abstractPlanetTime2.getTimeStringSeconds(lon, 2, true));
                    break;
                }
                case 30: {
                    AbstractPlanetTime abstractPlanetTime3 = M24TimePanel.this.mTime;
                    M24TimePanel.this.mTime;
                    mTimestrBuffer.append(abstractPlanetTime3.getTimeStringSeconds(lon, 3, true));
                    break;
                }
                case 40: {
                    mTimestrBuffer.append(primeMeanTime).append(" MTC");
                    break;
                }
                default: {
                    AbstractPlanetTime abstractPlanetTime4 = M24TimePanel.this.mTime;
                    M24TimePanel.this.mTime;
                    mTimestrBuffer.append(abstractPlanetTime4.getTimeStringSeconds(lon, 1, true));
                }
            }
            double zenithAngle = M24TimePanel.this.mTime.getSolarZenithAngle(lon, lat);
            double azimuthAngle = M24TimePanel.this.mTime.getSolarAzimuthAngle(lon, lat);
            if (azimuthAngle < 0.0) {
                azimuthAngle += 360.0;
            }
            Point2D.Double earthAngle = M24TimePanel.this.mTime.getEarthAngleAt(lon, lat);
            if (earthAngle.x < 0.0) {
                earthAngle.x += 360.0;
            }
            String elevationString = "Solar Elev. " + M24Globals.FORMAT_X1.format(90.0 - zenithAngle) + "\u00b0";
            String azimuthString = "Solar Azim. " + M24Globals.FORMAT_X1.format(azimuthAngle) + "\u00b0";
            y += M24TimePanel.this.fhLarge + M24TimePanel.this.lineGap;
            g2d.setColor(M24TimePanel.this.color2);
            switch (M24TimePanel.this.timekeeper.getMarsTimeFormat()) {
                case 105: {
                    M24TimePanel.this.merACount = M24TimePanel.this.mTime.getMissionTime("MERA");
                    if (M24TimePanel.this.merACount.getSol() == Long.MIN_VALUE) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-A Not Launched", 0, y);
                        break;
                    }
                    if (M24TimePanel.this.merACount.getSol() < 0L) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-A In Flight", 0, y);
                        break;
                    }
                    g2d.setFont(M24TimePanel.this.fontLarge);
                    M24TimePanel.this.drawText(g2d, TimeFormat.format24Hours(24.0 * M24TimePanel.this.merACount.getSolFraction(), 3, "MER-A", null), 0, y);
                    break;
                }
                case 106: {
                    M24TimePanel.this.merBCount = M24TimePanel.this.mTime.getMissionTime("MERB");
                    if (M24TimePanel.this.merBCount.getSol() == Long.MIN_VALUE) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-B Not Launched", 0, y);
                        break;
                    }
                    if (M24TimePanel.this.merBCount.getSol() < 0L) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-B In Flight", 0, y);
                        break;
                    }
                    g2d.setFont(M24TimePanel.this.fontLarge);
                    M24TimePanel.this.drawText(g2d, TimeFormat.format24Hours(24.0 * M24TimePanel.this.merBCount.getSolFraction(), 3, "MER-B", null), 0, y);
                    break;
                }
                case 1001: {
                    M24TimePanel.this.merACount = M24TimePanel.this.mTime.getMissionTime("MERA");
                    if (M24TimePanel.this.merACount.getSol() == Long.MIN_VALUE) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-A Not Launched", 1, y);
                    } else if (M24TimePanel.this.merACount.getSol() < 0L) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-A In Flight", 1, y);
                    } else {
                        g2d.setFont(M24TimePanel.this.fontLarge);
                        M24TimePanel.this.drawText(g2d, TimeFormat.format24Hours(24.0 * M24TimePanel.this.merACount.getSolFraction(), 3, "MER-A", null), 1, y);
                    }
                    M24TimePanel.this.merBCount = M24TimePanel.this.mTime.getMissionTime("MERB");
                    if (M24TimePanel.this.merBCount.getSol() == Long.MIN_VALUE) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-B Not Launched", 2, y);
                        break;
                    }
                    if (M24TimePanel.this.merBCount.getSol() < 0L) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MER-B In Flight", 2, y);
                        break;
                    }
                    g2d.setFont(M24TimePanel.this.fontLarge);
                    M24TimePanel.this.drawText(g2d, TimeFormat.format24Hours(24.0 * M24TimePanel.this.merBCount.getSolFraction(), 3, "MER-B", null), 2, y);
                    break;
                }
                case 103: {
                    M24TimePanel.this.mpfCount = M24TimePanel.this.mTime.getMissionTime("MPF");
                    if (M24TimePanel.this.mpfCount.getSol() == Long.MIN_VALUE) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MPF Not Launched", 0, y);
                        break;
                    }
                    if (M24TimePanel.this.mpfCount.getSol() < 0L) {
                        g2d.setFont(M24TimePanel.this.fontMedium);
                        M24TimePanel.this.drawText(g2d, "MPF In Flight", 0, y);
                        break;
                    }
                    g2d.setFont(M24TimePanel.this.fontLarge);
                    M24TimePanel.this.drawText(g2d, TimeFormat.format24Hours(24.0 * M24TimePanel.this.mpfCount.getSolFraction(), 3, "MPF", null), 0, y);
                    break;
                }
                default: {
                    g2d.setFont(M24TimePanel.this.fontLarge);
                    M24TimePanel.this.drawText(g2d, primeMeanTime + " MTC", 1, y);
                    M24TimePanel.this.drawText(g2d, mTimestrBuffer.toString(), 2, y);
                }
            }
            y += M24TimePanel.this.fhMedium + M24TimePanel.this.lineGap;
            g2d.setColor(M24TimePanel.this.color3);
            g2d.setFont(M24TimePanel.this.fontMedium);
            switch (M24TimePanel.this.timekeeper.getMarsTimeFormat()) {
                case 105: {
                    if (M24TimePanel.this.merACount.getSol() == Long.MIN_VALUE) break;
                    M24TimePanel.this.drawText(g2d, "Sol " + M24TimePanel.this.merACount.getSol(), 0, y);
                    break;
                }
                case 106: {
                    if (M24TimePanel.this.merBCount.getSol() == Long.MIN_VALUE) break;
                    M24TimePanel.this.drawText(g2d, "Sol " + M24TimePanel.this.merBCount.getSol(), 0, y);
                    break;
                }
                case 1001: {
                    if (M24TimePanel.this.merACount.getSol() != Long.MIN_VALUE) {
                        M24TimePanel.this.drawText(g2d, "Sol " + M24TimePanel.this.merACount.getSol(), 1, y);
                    }
                    if (M24TimePanel.this.merBCount.getSol() == Long.MIN_VALUE) break;
                    M24TimePanel.this.drawText(g2d, "Sol " + M24TimePanel.this.merBCount.getSol(), 2, y);
                    break;
                }
                case 103: {
                    if (M24TimePanel.this.mpfCount.getSol() == Long.MIN_VALUE) break;
                    M24TimePanel.this.drawText(g2d, "Sol " + M24TimePanel.this.mpfCount.getSol(), 0, y);
                    break;
                }
                default: {
                    M24TimePanel.this.drawText(g2d, "MSD " + M24Globals.FORMAT_X3.format(((MarsTime)M24TimePanel.this.mTime).getSolDate()), 1, y);
                    M24TimePanel.this.drawText(g2d, "at " + M24Globals.FORMAT_X2.format(lon) + "\u00b0W " + M24Globals.FORMAT_X2.format(M24TimePanel.this.timekeeper.getSiteLatitude()) + "\u00b0N", 2, y);
                }
            }
            y += M24TimePanel.this.fhSmall + M24TimePanel.this.lineGap;
            g2d.setColor(M24TimePanel.this.color3);
            g2d.setFont(M24TimePanel.this.fontSmall);
            switch (M24TimePanel.this.timekeeper.getMarsTimeFormat()) {
                case 103: 
                case 105: 
                case 106: 
                case 1001: {
                    M24TimePanel.this.drawText(g2d, "MSD " + M24Globals.FORMAT_X3.format(((MarsTime)M24TimePanel.this.mTime).getSolDate()), 1, y);
                    M24TimePanel.this.drawText(g2d, "Ls " + M24Globals.FORMAT_X2.format(M24TimePanel.this.mTime.getSolarLongitude()) + "\u00b0", 2, y);
                    break;
                }
                default: {
                    M24TimePanel.this.drawText(g2d, "Ls " + M24Globals.FORMAT_X2.format(M24TimePanel.this.mTime.getSolarLongitude()) + "\u00b0", 1, y);
                    M24TimePanel.this.drawText(g2d, elevationString, 2, y);
                }
            }
            y += M24TimePanel.this.fhSmall + M24TimePanel.this.lineGap;
            g2d.setColor(M24TimePanel.this.color3);
            g2d.setFont(M24TimePanel.this.fontSmall);
            switch (M24TimePanel.this.timekeeper.getMarsTimeFormat()) {
                case 103: 
                case 105: 
                case 106: 
                case 1001: {
                    M24TimePanel.this.drawText(g2d, primeMeanTime + " MTC", 1, y);
                    M24TimePanel.this.drawText(g2d, M24TimePanel.this.mTime.getSeason(lat >= 0.0), 2, y);
                    break;
                }
                default: {
                    M24TimePanel.this.drawText(g2d, M24TimePanel.this.mTime.getSeason(lat >= 0.0), 1, y);
                    M24TimePanel.this.drawText(g2d, azimuthString, 2, y);
                }
            }
        }
    }
}

