/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.DayNightMap;
import gov.nasa.giss.mapping.landmarks.Landmark;
import gov.nasa.giss.mapping.landmarks.LandmarkEvent;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mapping.landmarks.LandmarkListener;
import gov.nasa.giss.mapping.proj.AbstractProjection;
import gov.nasa.giss.mapping.proj.ProjectionFactory;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class M24SunclockPanel
extends JComponent
implements LandmarkListener,
PreferencesListener,
M24TimekeeperListener {
    private static final boolean DEBUG = false;
    private static final long REFRESH_INTERVAL = 20000L;
    private static final int COP_FIXED_POINT = 1;
    private static final int COP_SUBEARTH = 2;
    private static final int COP_SUBSOLAR = 3;
    private static final double DEFAULT_DARKNESS = 0.8;
    private static final int CROSS = 0;
    private static final int CIRCLE = 1;
    public static final Object[] PROJECTION_CHOICES = new Object[]{ProjectionFactory.getID("Aitoff"), ProjectionFactory.getID("Eckert VI"), ProjectionFactory.getID("Equirectangular"), ProjectionFactory.getID("Hammer"), ProjectionFactory.getID("Mollweide"), ProjectionFactory.getID("Orthographic"), ProjectionFactory.getID("Parabolic"), ProjectionFactory.getID("Wagner IV"), ProjectionFactory.getID("Wagner V"), ProjectionFactory.getID("Wagner VIII"), ProjectionFactory.getID("Winkel Tripel")};
    private static final float[] DASH_PATTERN = new float[]{12.0f, 8.0f, 8.0f, 8.0f};
    private static final BasicStroke GRID_STROKE = new BasicStroke(1.0f, 0, 1, 0.0f, DASH_PATTERN, 4.0f);
    private static final Color GRID_COLOR = new Color(204, 255, 204, 102);
    private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
    private static final Color BORDER_COLOR = new Color(102, 102, 102);
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private LandmarkList landmarks;
    private AbstractProjection projection;
    private boolean projectionChanged = true;
    private Image sourceMap;
    private DayNightMap shadowMap;
    private BufferedImage projectedMap;
    private BufferedImage finalMap;
    private boolean smapNeedsUpdate = true;
    private boolean pmapNeedsUpdate = true;
    private boolean fmapNeedsUpdate = true;
    private long now = System.currentTimeMillis();
    private long lastUpdate;
    private long lastShadowUpdate;
    private long lastCOPUpdate;
    private int fHeightError;
    private int fheightNotes;
    private Font fontError;
    private Font fontNotes;
    private FontMetrics fm;
    private double darkness = 0.8;
    private boolean markSubsolar = false;
    private boolean markSubEarth = false;
    private boolean markLLGrid = false;
    private double gridOpacity = 0.5;
    private int copType = 1;
    private double copLon;
    private double copLat;
    private int pWidth;
    private int pHeight;
    private int maxWidth;
    private int maxHeight;

    public M24SunclockPanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24SunclockPanel(Dimension max, Image src) {
        this.timekeeper = M24Globals.getTimekeeper();
        this.landmarks = M24Globals.getLandmarks();
        this.sourceMap = src;
        this.maxWidth = max.width;
        this.maxHeight = max.height;
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.setMaximumSize(max);
        this.setDoubleBuffered(true);
        this.prefs = M24Globals.getSettings();
        this.updateSetting("all");
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
        for (int i = 0; i < this.landmarks.count(); ++i) {
            this.landmarks.get(i).addLandmarkListener(this);
        }
    }

    public String getName() {
        if (this.projection == null) {
            return "Sunclock";
        }
        StringBuffer sb = new StringBuffer("Sunclock (").append(this.projection.getName()).append(")").append(" Centered on ").append(M24Globals.FORMAT_X2.format(this.copLon) + "\u00b0W");
        if (ProjectionFactory.isAzimuthal(this.projection.getName())) {
            sb.append(", ").append(M24Globals.FORMAT_X2.format(this.copLat) + "\u00b0N");
        }
        return sb.toString();
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.pWidth = w;
        this.pHeight = h;
        if (w >= 1000) {
            this.fHeightError = w / 40;
            this.fheightNotes = 2 * this.fHeightError / 3;
        } else {
            this.fHeightError = 20;
            this.fheightNotes = 13;
        }
        this.fontError = new Font("Courier", 0, this.fHeightError);
        this.fontNotes = new Font("Courier", 0, this.fheightNotes);
        if (this.projection == null) {
            this.projection = ProjectionFactory.create(ProjectionFactory.getID("Equirectangular"), this.pWidth, this.pHeight);
            this.projection.setCenter(46.0, 0.0);
        } else {
            this.projection.setSize(this.pWidth, this.pHeight, 0, 0);
        }
        this.pmapNeedsUpdate = true;
        this.fmapNeedsUpdate = true;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.pWidth, this.pHeight);
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        AbstractPlanetTime eTime = this.timekeeper.getTimeObject(3);
        if (mTime == null) {
            g2d.setColor(Color.red);
            g2d.setFont(this.fontError);
            FontMetrics fm = g2d.getFontMetrics();
            String message1 = "Time/date out of valid range or not";
            String message2 = "well-formatted. Please re-enter.";
            g2d.drawString(message1, (this.pWidth - fm.stringWidth(message1)) / 2, (this.pHeight - this.fHeightError) / 2 - 2);
            g2d.drawString(message2, (this.pWidth - fm.stringWidth(message2)) / 2, (this.pHeight + this.fHeightError) / 2 + 2);
            return;
        }
        if (this.shadowMap == null) {
            this.shadowMap = new DayNightMap(this.sourceMap, 720, 360);
            this.smapNeedsUpdate = false;
        }
        if (this.smapNeedsUpdate || this.now - this.lastShadowUpdate > 40000L) {
            this.shadowMap.setDarkness(this.darkness);
            this.shadowMap.setSubsolarPoint(mTime.getSubsolarLongitude(2), mTime.getSolarDeclination(2));
            this.smapNeedsUpdate = false;
            this.lastShadowUpdate = this.now;
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
        }
        if ((this.copType == 2 || this.copType == 3) && this.now - this.lastCOPUpdate > 20000L) {
            Point2D.Double a;
            if (this.copType == 2) {
                a = mTime.getSubEarthPoint(1);
                this.copLon = a.getX();
                this.copLat = a.getY();
            } else {
                a = mTime.getSubsolarPoint(1);
                this.copLon = a.getX();
                this.copLat = a.getY();
            }
            if (this.projection != null) {
                this.projection.setCenter(-this.copLon, this.copLat);
            }
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
            this.lastCOPUpdate = this.now;
        }
        if (this.projectedMap == null) {
            this.projectedMap = new BufferedImage(this.maxWidth, this.maxHeight, 2);
            this.projectionChanged = true;
            this.pmapNeedsUpdate = true;
        }
        if (this.finalMap == null) {
            this.finalMap = new BufferedImage(this.maxWidth, this.maxHeight, 2);
            this.fmapNeedsUpdate = true;
        }
        if (this.projectionChanged) {
            String s = this.prefs.getString("sunclock_projection");
            this.projection = ProjectionFactory.create(ProjectionFactory.getID(s), this.pWidth, this.pHeight);
            this.projection.setCenter(-this.copLon, this.copLat);
            this.projection.setBackground(Color.black);
            this.projection.setGridStroke(GRID_STROKE);
            this.projection.setGridLabeled(true);
            this.projectionChanged = false;
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
        }
        if (this.pmapNeedsUpdate) {
            Graphics2D mapG2D = (Graphics2D)this.projectedMap.getGraphics();
            mapG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            mapG2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            mapG2D.setColor(this.getBackground());
            mapG2D.fillRect(0, 0, this.maxWidth, this.maxHeight);
            this.projection.setSourceMap(this.shadowMap.getMap());
            this.projection.drawMap(mapG2D);
            if (this.markLLGrid) {
                this.projection.setGridColor(new Color(GRID_COLOR.getRed(), GRID_COLOR.getGreen(), GRID_COLOR.getBlue(), (int)(this.gridOpacity * 255.0)));
                this.projection.drawGrid(mapG2D);
            }
            this.pmapNeedsUpdate = false;
            this.fmapNeedsUpdate = true;
            mapG2D.dispose();
        }
        if (this.fmapNeedsUpdate) {
            Point2D.Double a;
            Graphics2D mg2d = (Graphics2D)this.finalMap.getGraphics();
            mg2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            mg2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            mg2d.setColor(this.getBackground());
            mg2d.fillRect(0, 0, this.maxWidth, this.maxHeight);
            mg2d.drawImage((Image)this.projectedMap, 0, 0, this);
            if (this.markSubsolar) {
                this.markSpot(mg2d, -this.timekeeper.getSiteLongitude(), this.timekeeper.getSiteLatitude(), 0, Color.white);
                a = mTime.getSubsolarPoint(1);
                this.markSpot((Graphics)mg2d, -a.getX(), a.getY(), 1, Color.white, Color.yellow);
            }
            if (this.markSubEarth) {
                a = mTime.getSubEarthPoint(1);
                this.markSpot((Graphics)mg2d, -a.getX(), a.getY(), 1, Color.white, Color.blue);
            }
            for (int i = 0; i < this.landmarks.count(); ++i) {
                Landmark l = this.landmarks.get(i);
                if (!l.isMarked()) continue;
                if (l.getType() == 6) {
                    this.markSpot((Graphics)mg2d, -l.getLongitude(), l.getLatitude(), 1, l.getColor(), l.getCode());
                    continue;
                }
                this.markSpot((Graphics)mg2d, -l.getLongitude(), l.getLatitude(), 0, l.getColor(), l.getCode());
            }
            mg2d.dispose();
        }
        g2d.drawImage((Image)this.finalMap, 0, 0, this);
        this.fmapNeedsUpdate = false;
        this.lastUpdate = this.now;
    }

    private void markSpot(Graphics g, double lon, double lat) {
        this.markSpot(g, lon, lat, 0, Color.white, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, Color lineColor) {
        this.markSpot(g, lon, lat, 0, lineColor, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor) {
        this.markSpot(g, lon, lat, shape, lineColor, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor) {
        this.markSpot(g, lon, lat, shape, lineColor, fillColor, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, String label) {
        this.markSpot(g, lon, lat, shape, lineColor, null, label);
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor, String label) {
        if (this.projection == null) {
            return;
        }
        Point xy = this.projection.transformLL2XYInt(lon, lat);
        if (xy == null) {
            return;
        }
        int x = xy.x;
        int y = xy.y;
        int xsize = 3;
        int xradius = Math.max(xsize + 1, 4);
        int xdiam = xradius + xradius;
        int xtext = xsize;
        if (shape == 0) {
            g.setColor(lineColor);
            g.drawLine(x - xsize, y, x + xsize, y);
            g.drawLine(x, y - xsize, x, y + xsize);
        } else if (shape == 1) {
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fillOval(x - xradius, y - xradius, xdiam, xdiam);
            }
            g.setColor(lineColor);
            g.drawOval(x - xradius, y - xradius, xdiam, xdiam);
            xtext = xradius;
        }
        if (label.length() < 1) {
            return;
        }
        g.setColor(lineColor);
        g.setFont(this.fontNotes);
        this.fm = g.getFontMetrics();
        x = x + xradius + this.fm.stringWidth(label) > this.pWidth ? (x -= xtext + this.fm.stringWidth(label)) : (x += xtext);
        y = y - xtext - this.fheightNotes < 0 ? (y += this.fheightNotes) : (y -= xtext);
        g.drawString(label, x, y);
    }

    public Point2D.Double transformXY2LL(int x, int y) {
        if (this.projection == null || x < 0 || y < 0) {
            return null;
        }
        Point2D.Double p = this.projection.transformXY2LL(x, y);
        if (p != null) {
            p.x = -p.x;
        }
        return p;
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.now = System.currentTimeMillis();
        if (this.now - this.lastUpdate < 20000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = this.now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.pmapNeedsUpdate = true;
        this.fmapNeedsUpdate = true;
        this.smapNeedsUpdate = true;
        this.lastCOPUpdate = 0L;
        this.lastUpdate = 0L;
        this.lastShadowUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
    }

    public void formatChanged(M24TimekeeperEvent e) {
    }

    public void landmarkChanged(LandmarkEvent e) {
        this.fmapNeedsUpdate = true;
        this.lastUpdate = 0L;
        this.repaint();
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("sunclock_projection");
            this.updateSetting("sunclock_sourcemap");
            this.updateSetting("sunclock_darkness");
            this.updateSetting("sunclock_copLandmark");
            this.updateSetting("sunclock_copLon");
            this.updateSetting("sunclock_copLat");
            this.updateSetting("sunclock_copLonlat");
            this.updateSetting("sunclock_copType");
            this.updateSetting("sunclock_markSun");
            this.updateSetting("sunclock_markEarth");
            this.updateSetting("sunclock_markGrid");
            this.updateSetting("sunclock_gridOpacity");
        }
        if (pname.indexOf("sunclock_") == -1) {
            return;
        }
        if (pname.equals("sunclock_darkness")) {
            this.darkness = this.prefs.getDouble("sunclock_darkness");
            if (this.darkness < 0.0) {
                this.darkness = 0.0;
            } else if (this.darkness > 100.0) {
                this.darkness = 1.0;
            } else if (this.darkness > 1.0) {
                this.darkness *= 0.1;
            }
            this.smapNeedsUpdate = true;
        } else if (pname.equals("sunclock_projection")) {
            this.projectionChanged = true;
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
            this.lastCOPUpdate = 0L;
            this.lastUpdate = 0L;
        } else if (pname.equals("sunclock_copType")) {
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
            this.updateCenterOfProjection();
        } else if (pname.equals("sunclock_copLandmark")) {
            if (this.prefs.getString("sunclock_copType").equals("landmark")) {
                this.updateCenterOfProjection();
            }
        } else if (pname.equals("sunclock_copLon") || pname.equals("sunclock_copLat") || pname.equals("sunclock_copLonlat")) {
            if (this.prefs.getString("sunclock_copType").equals("lonlat")) {
                this.updateCenterOfProjection();
            }
        } else if (pname.equals("sunclock_markSun")) {
            try {
                this.markSubsolar = this.prefs.getBoolean("sunclock_markSun");
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.fmapNeedsUpdate = true;
        } else if (pname.equals("sunclock_markEarth")) {
            try {
                this.markSubEarth = this.prefs.getBoolean("sunclock_markEarth");
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.fmapNeedsUpdate = true;
        } else if (pname.equals("sunclock_markGrid")) {
            try {
                this.markLLGrid = this.prefs.getBoolean("sunclock_markGrid");
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
        } else if (pname.equals("sunclock_gridOpacity")) {
            try {
                this.gridOpacity = this.prefs.getDouble("sunclock_gridOpacity");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
        }
        this.lastUpdate = 0L;
        this.repaint();
    }

    private void updateCenterOfProjection() {
        String cop = this.prefs.getString("sunclock_copType");
        if (cop.equals("landmark")) {
            String lname = this.prefs.getString("sunclock_copLandmark");
            if (lname.toLowerCase().equals("sub-earth point") || lname.toLowerCase().equals("subsolar point")) {
                if (lname.toLowerCase().equals("sub-earth point")) {
                    this.copType = 2;
                    Point2D.Double a = this.timekeeper.getTimeObject(4).getSubEarthPoint(1);
                } else {
                    this.copType = 3;
                    Point2D.Double a = this.timekeeper.getTimeObject(4).getSubsolarPoint(1);
                }
                if (this.projection != null) {
                    this.projection.setCenter(-this.copLon, this.copLat);
                }
                this.pmapNeedsUpdate = true;
                this.fmapNeedsUpdate = true;
                this.lastCOPUpdate = 0L;
            } else {
                this.copType = 1;
                Landmark l = this.landmarks.findByName(lname);
                if (l != null) {
                    this.copLon = l.getLongitude();
                    this.copLat = l.getLatitude();
                    if (this.projection != null) {
                        this.projection.setCenter(-this.copLon, this.copLat);
                    }
                    this.pmapNeedsUpdate = true;
                    this.fmapNeedsUpdate = true;
                }
            }
        } else if (cop.equals("lonlat")) {
            this.copType = 1;
            double oldLon = this.copLon;
            double oldLat = this.copLat;
            try {
                this.copLon = this.prefs.getDouble("sunclock_copLon");
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.copLat = this.prefs.getDouble("sunclock_copLat");
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (this.projection != null) {
                this.projection.setCenter(-this.copLon, this.copLat);
            }
            this.pmapNeedsUpdate = true;
            this.fmapNeedsUpdate = true;
        }
    }
}

