/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mapping.proj.ProjectionFactory;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24LandmarkMenu;
import gov.nasa.giss.mars24.M24LandmarkTable;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24SunclockPanel;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.LatitudeDocument;
import gov.nasa.giss.text.LongitudeDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class M24SunclockControls
extends JPanel {
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private M24PlotPanel plotDisplay;
    private M24TimePanel timeDisplay;
    private LandmarkList landmarks;
    private JComboBox mapMenu;
    private JRadioButton useLonlatCOPButton;
    private JRadioButton useLandmarkCOPButton;
    private JComboBox copLandmarkMenu;
    private JTextField darknessTF;
    private JTextField gridOpacityTF;
    private JTextField copLonTF;
    private JTextField copLatTF;
    private JLabel copLabel3 = new JLabel(", Lat. ");
    private JLabel copLabel4 = new JLabel("\u00b0N ");
    private JCheckBox markGridCB = new JCheckBox("Show Lon-Lat grid");

    public M24SunclockControls(M24PlotPanel p1, M24TimePanel p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.plotDisplay = p1;
        this.timeDisplay = p2;
        this.prefs = M24Globals.getSettings();
        this.timekeeper = M24Globals.getTimekeeper();
        this.landmarks = M24Globals.getLandmarks();
        this.darknessTF = new JTextField("100", 5);
        this.darknessTF.setDocument(new DoubleDocument(true));
        this.darknessTF.setMaximumSize(this.darknessTF.getPreferredSize());
        this.darknessTF.setText("" + 100.0 * this.prefs.getDouble("sunclock_darkness"));
        QuickBox darknessBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Nightside Darkness: "), this.darknessTF, new JLabel("%")});
        this.gridOpacityTF = new JTextField("100", 5);
        this.gridOpacityTF.setDocument(new DoubleDocument(true));
        this.gridOpacityTF.setMaximumSize(this.gridOpacityTF.getPreferredSize());
        this.gridOpacityTF.setText("" + 100.0 * this.prefs.getDouble("sunclock_gridOpacity"));
        QuickBox gridBox = QuickBox.createHorizontalBox(2, new Component[]{this.markGridCB, new JLabel(", Opacity: "), this.gridOpacityTF, new JLabel("%")});
        this.mapMenu = new JComboBox<Object>(M24SunclockPanel.PROJECTION_CHOICES);
        this.mapMenu.setMaximumSize(this.mapMenu.getPreferredSize());
        QuickBox projectionBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Map Projection: "), this.mapMenu});
        JPanel copPanel = this.makeSunclockCOPPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(3, 9), 2, 4);
        fgl.setColumnWeight(2, 100.0f);
        fgl.setRowWeight(8, 100.0f);
        this.setLayout(fgl);
        this.setBorder(M24Globals.createPaddedTitleBorder("Sunclock Options"));
        this.add((Component)projectionBox, new FGConstraint(new Rectangle(0, 0, 3, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Center of Map:"), new FGConstraint(new Rectangle(0, 1, 3, 1), 0.0, 0.5));
        this.add((Component)copPanel, new FGConstraint(new Rectangle(0, 2, 3, 1), 0.0, 0.0));
        this.add((Component)darknessBox, new FGConstraint(new Rectangle(0, 3, 3, 1), 0.0, 0.5));
        this.add((Component)gridBox, new FGConstraint(new Rectangle(0, 4, 3, 1), 0.0, 0.5));
        this.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 5, 3, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Points of Interest: ", 2), new FGConstraint(new Rectangle(0, 6, 3, 1), 0.0, 0.5));
        this.add((Component)new M24LandmarkTable(), new FGConstraint(new Rectangle(0, 7, 3, 1), 0.0, 0.5));
        this.addListeners();
    }

    private JPanel makeSunclockCOPPanel() {
        this.useLandmarkCOPButton = new JRadioButton("");
        this.useLonlatCOPButton = new JRadioButton("");
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.useLandmarkCOPButton);
        methodGroup.add(this.useLonlatCOPButton);
        this.copLandmarkMenu = new M24LandmarkMenu(true);
        this.copLonTF = new JTextField("-179.0", 6);
        this.copLatTF = new JTextField("-90.0", 5);
        this.copLonTF.setDocument(new LongitudeDocument());
        this.copLatTF.setDocument(new LatitudeDocument());
        this.copLonTF.setMaximumSize(this.copLonTF.getPreferredSize());
        this.copLatTF.setMaximumSize(this.copLatTF.getPreferredSize());
        QuickBox landmarkBox = QuickBox.createHorizontalBox(2, new Component[]{this.useLandmarkCOPButton, new JLabel("Landmark: "), this.copLandmarkMenu});
        QuickBox lonlatBox = QuickBox.createHorizontalBox(2, new Component[]{this.useLonlatCOPButton, new JLabel("Lon. "), this.copLonTF, new JLabel("\u00b0W"), this.copLabel3, this.copLatTF, this.copLabel4});
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(lonlatBox);
        panel.add(Box.createVerticalStrut(6));
        panel.add(landmarkBox);
        return panel;
    }

    public void setAll() {
        String projectionName = this.prefs.getString("sunclock_projection");
        if (projectionName != null) {
            for (int i = 0; i < this.mapMenu.getItemCount(); ++i) {
                if (!projectionName.equals(this.mapMenu.getItemAt(i).toString())) continue;
                this.mapMenu.setSelectedIndex(i);
            }
        }
        this.darknessTF.setText("" + 100.0 * this.prefs.getDouble("sunclock_darkness"));
        String copMethod = this.prefs.getString("sunclock_copType");
        if (copMethod == null) {
            copMethod = "lonlat";
        }
        this.useLandmarkCOPButton.setSelected(!copMethod.equals("lonlat"));
        this.useLonlatCOPButton.setSelected(copMethod.equals("lonlat"));
        this.copLandmarkMenu.setSelectedItem(this.prefs.getString("sunclock_copLandmark"));
        try {
            double lon;
            for (lon = this.prefs.getDouble("sunclock_copLon"); lon < 0.0; lon += 360.0) {
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            this.copLonTF.setText(M24Globals.FORMAT_X2.format(lon));
        }
        catch (Exception exc) {
            this.copLonTF.setText("0.0");
        }
        try {
            double lat = this.prefs.getDouble("sunclock_copLat");
            if (lat < -90.0) {
                lat = -90.0;
            }
            if (lat > -90.0) {
                lat = 90.0;
            }
            this.copLatTF.setText(M24Globals.FORMAT_X2.format(lat));
        }
        catch (Exception exc) {
            this.copLatTF.setText("0.0");
        }
        boolean azimuthal = ProjectionFactory.isAzimuthal(projectionName);
        this.copLatTF.setVisible(azimuthal);
        this.copLatTF.setEnabled(azimuthal);
        this.copLabel3.setVisible(azimuthal);
        this.copLabel4.setVisible(azimuthal);
        try {
            this.markGridCB.setSelected(this.prefs.getBoolean("sunclock_markGrid"));
        }
        catch (Exception exc) {
            this.markGridCB.setSelected(false);
        }
        this.gridOpacityTF.setText("" + 100.0 * this.prefs.getDouble("sunclock_gridOpacity"));
    }

    private void addListeners() {
        this.mapMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String choice = M24SunclockControls.this.mapMenu.getSelectedItem().toString();
                M24SunclockControls.this.prefs.set("sunclock_projection", choice);
                boolean azimuthal = ProjectionFactory.isAzimuthal(choice);
                M24SunclockControls.this.copLatTF.setVisible(azimuthal);
                M24SunclockControls.this.copLatTF.setEnabled(azimuthal);
                M24SunclockControls.this.copLabel3.setVisible(azimuthal);
                M24SunclockControls.this.copLabel4.setVisible(azimuthal);
            }
        });
        this.darknessTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double dx = 0.0;
                try {
                    String val = M24SunclockControls.this.darknessTF.getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    return;
                }
                M24SunclockControls.this.prefs.setDouble("sunclock_darkness", dx * 0.01);
            }
        });
        this.darknessTF.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double dx = 0.0;
                try {
                    String val = M24SunclockControls.this.darknessTF.getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    return;
                }
                M24SunclockControls.this.prefs.setDouble("sunclock_darkness", dx * 0.01);
            }
        });
        ActionListener copButtonAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24SunclockControls.this.useLandmarkCOPButton.isSelected()) {
                    M24SunclockControls.this.prefs.set("sunclock_copType", "landmark");
                } else {
                    M24SunclockControls.this.prefs.set("sunclock_copType", "lonlat");
                }
            }
        };
        this.useLandmarkCOPButton.addActionListener(copButtonAL);
        this.useLonlatCOPButton.addActionListener(copButtonAL);
        this.copLandmarkMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24SunclockControls.this.prefs.set("sunclock_copLandmark", (String)M24SunclockControls.this.copLandmarkMenu.getSelectedItem());
            }
        });
        ActionListener copFieldAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24SunclockControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24SunclockControls.this.copLonTF) {
                    M24SunclockControls.this.prefs.setDouble("sunclock_copLon", dx);
                } else if (e.getSource() == M24SunclockControls.this.copLatTF) {
                    M24SunclockControls.this.prefs.setDouble("sunclock_copLat", dx);
                }
            }
        };
        FocusListener copFieldFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24SunclockControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24SunclockControls.this.copLonTF) {
                    M24SunclockControls.this.prefs.setDouble("sunclock_copLon", dx);
                } else if (e.getSource() == M24SunclockControls.this.copLatTF) {
                    M24SunclockControls.this.prefs.setDouble("sunclock_copLat", dx);
                }
            }
        };
        this.copLonTF.addActionListener(copFieldAL);
        this.copLatTF.addActionListener(copFieldAL);
        this.copLonTF.addFocusListener(copFieldFL);
        this.copLatTF.addFocusListener(copFieldFL);
        this.markGridCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                M24SunclockControls.this.prefs.set("sunclock_markGrid", new Boolean(M24SunclockControls.this.markGridCB.isSelected()));
            }
        });
        this.gridOpacityTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double dx = 0.0;
                try {
                    String val = M24SunclockControls.this.gridOpacityTF.getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    return;
                }
                M24SunclockControls.this.prefs.setDouble("sunclock_gridOpacity", dx * 0.01);
            }
        });
        this.gridOpacityTF.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double dx = 0.0;
                try {
                    String val = M24SunclockControls.this.gridOpacityTF.getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    return;
                }
                M24SunclockControls.this.prefs.setDouble("sunclock_gridOpacity", dx * 0.01);
            }
        });
    }

    public void setCenterOfProjection(double lon, double lat) {
        while (lon < 0.0) {
            lon += 360.0;
        }
        while (lon > 360.0) {
            lon -= 360.0;
        }
        if (lat < -90.0) {
            lat = -90.0;
        }
        if (lat > 90.0) {
            lat = 90.0;
        }
        this.copLonTF.setText(M24Globals.FORMAT_X2.format(lon));
        this.copLatTF.setText(M24Globals.FORMAT_X2.format(lat));
        this.useLandmarkCOPButton.setSelected(false);
        this.useLonlatCOPButton.setSelected(true);
    }
}

