/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.Landmark;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24ForMac;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.prefs.AbstractPreferences;
import gov.nasa.giss.xml.EasyParser;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class M24Preferences
extends AbstractPreferences {
    private LandmarkList landmarks;
    private String lastFrameClosed = "plot";
    private static final String[][] PREF_TRANSLATIONS = new String[][]{{"showControlsWindow", "controlsFrame_visible"}, {"controlsWindowX", "controlsFrame_leftEdge"}, {"controlsWindowY", "controlsFrame_topEdge"}, {"showTimeWindow", "timeFrame_visible"}, {"timeWindowSize", "timeFrame_sizeIndex"}, {"timeWindowX", "timeFrame_leftEdge"}, {"timeWindowY", "timeFrame_topEdge"}, {"showPlotWindow", "plotFrame_visible"}, {"plotWindowSize", "plotFrame_sizeIndex"}, {"plotWindowX", "plotFrame_leftEdge"}, {"plotWindowY", "plotFrame_topEdge"}, {"displayChoice", "plotFrame_content"}, {"showHelpGuide", "help_guideVisible"}, {"showHelpNotes", "help_notesVisible"}, {"showHelpFAQ", "help_faqVisible"}, {"earthTimeMethod", "earthTime_method"}, {"earthTimeOffsetYear", "earthTime_offsetYear"}, {"earthTimeOffsetDay", "earthTime_offsetDay"}, {"earthTimeOffsetHour", "earthTime_offsetHour"}, {"earthTimeOffsetMin", "earthTime_offsetMin"}, {"earthTimeOffsetSec", "earthTime_offsetSec"}, {"earthTimeFixedDate", "earthTime_fixedDate"}, {"earthTimeFixedTime", "earthTime_fixedTime"}, {"earthDateAsDOY", "earthTime_dateAsDOY"}, {"earthDistanceUnits", "earthTime_distanceUnits"}, {"marsTimeMethod", "marsTime_method"}, {"marsTimeFormat", "marsTime_format"}, {"marsTimeSpotType", "marsTime_spotType"}, {"marsTimeSpotLandmark", "marsTime_spotLandmark"}, {"marsTimeSpotLon", "marsTime_spotLon"}, {"marsTimeSpotLat", "marsTime_spotLat"}, {"sunclockProjection", "sunclock_projection"}, {"sunclockCOPType", "sunclock_copType"}, {"sunclockCOPLandmark", "sunclock_copLandmark"}, {"sunclockCOPLon", "sunclock_copLon"}, {"sunclockCOPLat", "sunclock_copLat"}, {"sunclockMarkSun", "sunclock_markSun"}, {"sunclockMarkEarth", "sunclock_markEarth"}, {"sunclockMarkGrid", "sunclock_markGrid"}, {"pathViewParts", "panorama_layout"}, {"pathViewAngle", "panorama_azimuth"}, {"pathViewSun", "panorama_markSun"}, {"pathViewEarth", "panorama_markEarth"}};

    M24Preferences(boolean isApp) {
        super(isApp, "Mars24", false);
    }

    public void restoreDefaults() {
        this.resettingAll = true;
        this.prefs.put("controlsFrame_visible", Boolean.TRUE);
        this.prefs.put("controlsFrame_leftEdge", new Integer(-9999));
        this.prefs.put("controlsFrame_topEdge", new Integer(-9999));
        this.prefs.put("timeFrame_visible", Boolean.TRUE);
        this.prefs.put("timeFrame_width", new Integer(600));
        this.prefs.put("timeFrame_height", new Integer(300));
        this.prefs.put("timeFrame_leftEdge", new Integer(-9999));
        this.prefs.put("timeFrame_topEdge", new Integer(-9999));
        this.prefs.put("plotFrame_visible", Boolean.TRUE);
        this.prefs.put("plotFrame_width", new Integer(1220));
        this.prefs.put("plotFrame_height", new Integer(610));
        this.prefs.put("plotFrame_leftEdge", new Integer(-9999));
        this.prefs.put("plotFrame_topEdge", new Integer(-9999));
        this.prefs.put("plotFrame_content", "Sunclock Map");
        this.prefs.put("help_guideVisible", Boolean.FALSE);
        this.prefs.put("help_notesVisible", Boolean.FALSE);
        this.prefs.put("help_faqVisible", Boolean.FALSE);
        this.prefs.put("earthTime_method", "current");
        this.prefs.put("earthTime_offsetYear", new Double(0.0));
        this.prefs.put("earthTime_offsetDay", new Double(0.0));
        this.prefs.put("earthTime_offsetHour", new Double(0.0));
        this.prefs.put("earthTime_offsetMin", new Double(0.0));
        this.prefs.put("earthTime_offsetSec", new Double(0.0));
        this.prefs.put("earthTime_fixedDate", "Jan 4, 2004");
        this.prefs.put("earthTime_fixedTime", "04:35:00");
        this.prefs.put("earthTime_jdtype", "MJD");
        this.prefs.put("earthTime_jdval", new Double("51544."));
        this.prefs.put("earthTime_dateAsDOY", Boolean.FALSE);
        this.prefs.put("earthTime_distanceUnits", "Light Minutes");
        this.prefs.put("marsTime_method", "MERA_MERB");
        this.prefs.put("marsTime_format", "Local Mean Zonal Time");
        this.prefs.put("marsTime_spotType", "lonlat");
        this.prefs.put("marsTime_spotLandmark", "MER-A Spirit site");
        this.prefs.put("marsTime_spotLon", new Double(0.0));
        this.prefs.put("marsTime_spotLat", new Double(0.0));
        this.prefs.put("sunclock_projection", "Orthographic");
        this.prefs.put("sunclock_darkness", new Double(0.7));
        this.prefs.put("sunclock_copType", "lonlat");
        this.prefs.put("sunclock_copLandmark", "Airy Crater");
        this.prefs.put("sunclock_copLon", new Double(0.0));
        this.prefs.put("sunclock_copLat", new Double(30.0));
        this.prefs.put("sunclock_markSun", Boolean.TRUE);
        this.prefs.put("sunclock_markEarth", Boolean.TRUE);
        this.prefs.put("sunclock_markGrid", Boolean.TRUE);
        this.prefs.put("sunclock_gridOpacity", new Double(0.5));
        this.prefs.put("panorama_layout", "Graphic and Data");
        this.prefs.put("panorama_azimuth", "South");
        this.prefs.put("panorama_markSun", "Plain Path");
        this.prefs.put("panorama_markEarth", "Plain Path");
        this.prefs.put("analemma_lsLabels", Boolean.TRUE);
        this.landmarks = M24Globals.getLandmarks();
        for (int i = 0; i < this.landmarks.count(); ++i) {
            this.landmarks.get(i).setMarked(false);
        }
        try {
            this.landmarks.findByName("MER-A Spirit site").setMarked(true);
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.landmarks.findByName("MER-B Opportunity site").setMarked(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireSettingChanged("all");
        this.resettingAll = false;
    }

    protected void readStream(InputStream is) throws IOException, JDOMException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        if (!root.getName().equals(this.appName.toLowerCase())) {
            throw new IOException("File does not contain " + this.appName + " prefs.");
        }
        int version = 52;
        try {
            String versionString = root.getAttribute("version").getValue();
            if (versionString == null) {
                version = 50;
            } else if (!versionString.equals("5.2") && versionString.equals("5.1")) {
                version = 51;
            }
        }
        catch (Exception exc) {
            throw new IOException("Settings are apparently of a version than I cannot read.");
        }
        this.resettingAll = true;
        for (int i = 0; i < this.landmarks.count(); ++i) {
            this.landmarks.get(i).setMarked(false);
        }
        Iterator rootIter = root.getChildren().iterator();
        while (rootIter.hasNext()) {
            Element child = (Element)rootIter.next();
            String childName = child.getName();
            if (version == 51 || version == 50) {
                childName = this.translateOldPrefName(childName);
            }
            if (childName.equals("landmarkList")) {
                Iterator lmIter = child.getChildren().iterator();
                while (lmIter.hasNext()) {
                    Element lchild = (Element)lmIter.next();
                    String lchildName = lchild.getName();
                    if (lchildName.equals("landmark")) {
                        Landmark l;
                        String lname = lchild.getAttribute("name").getValue();
                        String mark = lchild.getAttribute("mark").getValue();
                        if (lname == null || mark == null || lname.equals("") || new Boolean(mark).equals(Boolean.FALSE) || (l = this.landmarks.findByName(lname)) == null) continue;
                        l.setMarked(true);
                        continue;
                    }
                    System.err.println("WARNING: Unknown landmark setting '" + lchildName + "'.");
                }
                continue;
            }
            Object already = this.prefs.get(childName);
            if (already == null) {
                System.err.println("WARNING: Unknown setting '" + childName + "'.");
                continue;
            }
            try {
                String value = child.getAttribute("value").getValue();
                if (childName.equals("plotFrame_content") && value.equals("Solar Path")) {
                    value = "Local Panorama";
                }
                if (already instanceof Double) {
                    this.prefs.put(childName, new Double(value));
                    continue;
                }
                if (already instanceof Integer) {
                    this.prefs.put(childName, new Integer(value));
                    continue;
                }
                if (already instanceof Boolean) {
                    this.prefs.put(childName, new Boolean(value));
                    continue;
                }
                if (already instanceof String) {
                    this.prefs.put(childName, value);
                    continue;
                }
                throw new IllegalArgumentException("Unknown setting class.");
            }
            catch (Exception exc) {
                System.err.println("WARNING: Unable to parse setting '" + childName + "'.");
            }
        }
        this.fireSettingChanged("all");
        this.resettingAll = false;
    }

    private String translateOldPrefName(String old) {
        for (int i = 0; i < PREF_TRANSLATIONS.length; ++i) {
            if (!old.equals(PREF_TRANSLATIONS[i][0])) continue;
            return PREF_TRANSLATIONS[i][1];
        }
        return old;
    }

    public void setLastFrameClosed(String fname) {
        this.lastFrameClosed = fname;
    }

    public void savePrefs() {
        if (!this.isApplicationContext) {
            return;
        }
        if (this.prefsFile == null) {
            return;
        }
        Frame[] flist = Frame.getFrames();
        boolean oneIsOpen = false;
        for (int i = 0; i < flist.length; ++i) {
            if (!flist[i].isVisible() || this.isMacOS && flist[i] instanceof M24ForMac) continue;
            oneIsOpen = true;
            break;
        }
        if (!oneIsOpen) {
            if (this.lastFrameClosed.equals("controls")) {
                this.setBoolean("controlsFrame_visible", true);
            } else if (this.lastFrameClosed.equals("time")) {
                this.setBoolean("timeFrame_visible", true);
            } else if (this.lastFrameClosed.equals("plot")) {
                this.setBoolean("plotFrame_visible", true);
            } else if (this.lastFrameClosed.equals("guide")) {
                this.setBoolean("help_guideVisible", false);
            } else if (this.lastFrameClosed.equals("notes")) {
                this.setBoolean("help_notesVisible", false);
            } else if (this.lastFrameClosed.equals("faq")) {
                this.setBoolean("help_faqVisible", false);
            }
        }
        try {
            this.save(this.prefsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void save(File f) throws IOException {
        if (!this.isApplicationContext) {
            return;
        }
        if (f == null) {
            throw new IllegalArgumentException("Null output file.");
        }
        FileOutputStream oStream = new FileOutputStream(f);
        Element root = new Element(this.appName.toLowerCase());
        root.setAttribute("version", "5.2");
        Iterator iter = this.prefs.keySet().iterator();
        while (iter.hasNext()) {
            String pname = (String)iter.next();
            Object pvalue = this.prefs.get(pname);
            if (pvalue == null) continue;
            Element ex = new Element(pname);
            ex.setAttribute("value", pvalue.toString());
            root.addContent(ex);
        }
        Element llex = new Element("landmarkList");
        for (int i = 0; i < this.landmarks.count(); ++i) {
            Landmark l = this.landmarks.get(i);
            if (!l.isMarked()) continue;
            Element lex = new Element("landmark");
            lex.setAttribute("name", l.getName());
            lex.setAttribute("code", l.getCode());
            lex.setAttribute("mark", "true");
            llex.addContent(lex);
        }
        root.addContent(llex);
        Document d = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(d, (OutputStream)oStream);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(0);
        }
        oStream.close();
    }
}

