/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24AnalemmaPanel;
import gov.nasa.giss.mars24.M24DisplayPanel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24OrbitPanel;
import gov.nasa.giss.mars24.M24PanoramaPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24SunclockPanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.xml.XmlPropertiesBundle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class M24PlotPanel
extends JPanel
implements M24DisplayPanel,
PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 300000L;
    private static final int MIN_X_MARGIN = 16;
    private static final int MIN_Y_MARGIN = 24;
    public static final int SHOW_SUNCLOCK = 1;
    public static final int SHOW_ORBIT = 2;
    public static final int SHOW_PANORAMA = 3;
    public static final int SHOW_ANALEMMA = 4;
    public static final String SUNCLOCK_DISPLAY = "Sunclock Map";
    public static final String ORBIT_DISPLAY = "Orbital Position";
    public static final String PANORAMA_DISPLAY = "Local Panorama";
    public static final String ANALEMMA_DISPLAY = "Analemma";
    public static final String[] DISPLAY_CHOICES = new String[]{"Sunclock Map", "Orbital Position", "Local Panorama", "Analemma"};
    private int displayChoice = 1;
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private String version;
    private int fHeightError = 20;
    private int fheightNotes = 20;
    private Font fontError = new Font("Courier", 1, this.fHeightError);
    private Font fontNotes = new Font("Courier", 0, this.fheightNotes);
    private M24SunclockPanel sunclockPanel;
    private M24OrbitPanel orbitPanel;
    private M24PanoramaPanel panoramaPanel;
    private M24AnalemmaPanel analemmaPanel;
    private LandmarkList landmarks;
    private int xMargin = 16;
    private int yMargin = 24;
    private long lastUpdate;
    private boolean noResize = false;

    public M24PlotPanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24PlotPanel(Image src) {
        this.prefs = M24Globals.getSettings();
        this.timekeeper = M24Globals.getTimekeeper();
        this.landmarks = M24Globals.getLandmarks();
        this.setBackground(Color.black);
        this.setBorder(new LineBorder(Color.gray, 1));
        this.setOpaque(true);
        this.setLayout(null);
        this.setDoubleBuffered(true);
        try {
            XmlPropertiesBundle resbundle = new XmlPropertiesBundle("gov.nasa.giss.mars24.resources.AboutMars24");
            this.version = resbundle.getString("appName") + " " + resbundle.getString("version");
        }
        catch (Exception exc) {
            // empty catch block
        }
        int subwidth = 1620;
        int subheight = 810;
        Dimension submax = new Dimension(1620, 810);
        this.sunclockPanel = new M24SunclockPanel(submax, src);
        this.orbitPanel = new M24OrbitPanel(submax);
        this.analemmaPanel = new M24AnalemmaPanel(submax);
        this.panoramaPanel = new M24PanoramaPanel(submax);
        this.add(this.sunclockPanel);
        this.add(this.orbitPanel);
        this.add(this.analemmaPanel);
        this.add(this.panoramaPanel);
        int maxwidth = 1652;
        int maxheight = 858;
        int minwidth = 572;
        int minheight = 318;
        this.setMinimumSize(new Dimension(572, 318));
        this.setMaximumSize(new Dimension(1652, 858));
        this.updateSetting("all");
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        int mWidth = w - 32;
        int mHeight = h - 48;
        int useWidth = mWidth;
        int useHeight = useWidth / 2;
        if (useHeight > mHeight) {
            useHeight = mHeight;
            useWidth = useHeight * 2;
        }
        this.xMargin = (w - useWidth) / 2;
        this.yMargin = (h - useHeight) / 2;
        if (this.sunclockPanel != null) {
            this.sunclockPanel.setSize(useWidth, useHeight);
            this.sunclockPanel.setLocation(this.xMargin, this.yMargin);
            this.orbitPanel.setSize(mWidth, useHeight);
            this.orbitPanel.setLocation(16, this.yMargin);
            this.panoramaPanel.setSize(useWidth, mHeight - 4);
            this.panoramaPanel.setLocation(this.xMargin, 26);
            this.analemmaPanel.setSize(mWidth, mHeight);
            this.analemmaPanel.setLocation(16, 24);
        }
        this.fHeightError = h / 30;
        this.fheightNotes = Math.min(h / 40, this.yMargin - 4);
        this.fontError = new Font("Courier", 1, this.fHeightError);
        this.fontNotes = new Font("Courier", 0, this.fheightNotes);
        this.revalidate();
        this.repaint();
        this.noResize = true;
        this.prefs.setInt("plotFrame_width", w);
        this.prefs.setInt("plotFrame_height", h);
        this.noResize = false;
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        int pWidth = this.getSize().width;
        int pHeight = this.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, pWidth, pHeight);
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        if (mTime == null) {
            g.setColor(Color.red);
            g.setFont(this.fontError);
            FontMetrics fm = g.getFontMetrics();
            String message1 = "Time/date out of valid range or not";
            String message2 = "well-formatted. Please re-enter.";
            g.drawString(message1, (pWidth - fm.stringWidth(message1)) / 2, (pHeight - this.fHeightError) / 2 - 2);
            g.drawString(message2, (pWidth - fm.stringWidth(message2)) / 2, (pHeight + this.fHeightError) / 2 + 2);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(Color.green);
        g2d.setFont(this.fontNotes);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.drawString("NASA GISS", 18, this.fheightNotes + 1);
        g2d.drawString(this.version, pWidth - 16 - 2 - fm.stringWidth(this.version), this.fheightNotes + 1);
        String description = null;
        if (this.displayChoice == 1) {
            description = this.sunclockPanel.getName();
        } else if (this.displayChoice == 2) {
            description = this.orbitPanel.getName();
        } else if (this.displayChoice == 4) {
            description = this.analemmaPanel.getName();
        }
        if (description != null) {
            g2d.drawString(description, (pWidth - fm.stringWidth(description)) / 2, pHeight - 4);
        }
    }

    public Point2D.Double transformXY2LL(int x, int y) {
        if (this.displayChoice != 1) {
            return null;
        }
        return this.sunclockPanel.transformXY2LL(x - this.xMargin, y - this.yMargin);
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.getSize().width, this.getSize().height, 1);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintComponent(g2d);
        this.paintChildren(g2d);
        g2d.dispose();
        return img;
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate < 300000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void formatChanged(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void settingChanged(PreferencesEvent e) {
        this.lastUpdate = 0L;
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("plotFrame_content");
            this.updateSetting("plotFrame_width");
        }
        if (pname.equals("plotFrame_content")) {
            String choice = this.prefs.getString("plotFrame_content");
            if (choice.equals(ORBIT_DISPLAY)) {
                this.displayChoice = 2;
                if (!this.isAncestorOf(this.orbitPanel)) {
                    this.add(this.orbitPanel);
                }
            } else if (choice.equals(ANALEMMA_DISPLAY)) {
                this.displayChoice = 4;
                if (!this.isAncestorOf(this.analemmaPanel)) {
                    this.add(this.analemmaPanel);
                }
            } else if (choice.equals(PANORAMA_DISPLAY)) {
                this.displayChoice = 3;
                if (!this.isAncestorOf(this.panoramaPanel)) {
                    this.add(this.panoramaPanel);
                }
            } else {
                this.displayChoice = 1;
                if (!this.isAncestorOf(this.sunclockPanel)) {
                    this.add(this.sunclockPanel);
                }
            }
            this.sunclockPanel.setVisible(choice.equals(SUNCLOCK_DISPLAY));
            this.orbitPanel.setVisible(choice.equals(ORBIT_DISPLAY));
            this.analemmaPanel.setVisible(choice.equals(ANALEMMA_DISPLAY));
            this.panoramaPanel.setVisible(choice.equals(PANORAMA_DISPLAY));
        } else if ((pname.equals("plotFrame_width") || pname.equals("plotFrame_height")) && !this.noResize) {
            Dimension d = new Dimension(this.prefs.getInt("plotFrame_width"), this.prefs.getInt("plotFrame_height"));
            this.setPreferredSize(d);
            this.setSize(d);
            try {
                ((JFrame)this.getTopLevelAncestor()).pack();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }
}

