/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24PanoramaDataPanel;
import gov.nasa.giss.mars24.M24PanoramaGraphicPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class M24PanoramaPanel
extends JPanel
implements PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 300000L;
    private M24Timekeeper timekeeper;
    private M24Preferences prefs;
    private PanoramaLabel label;
    private M24PanoramaGraphicPanel graphicPanel;
    private M24PanoramaDataPanel dataPanel;
    private int pWidth;
    private int pHeight;
    private int fHeight;
    private Font fontNotes;

    private M24PanoramaPanel() {
    }

    public M24PanoramaPanel(Dimension d) {
        this.timekeeper = M24Globals.getTimekeeper();
        this.setBackground(Color.black);
        this.setBorder(null);
        this.setOpaque(true);
        this.setLayout(null);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setDoubleBuffered(true);
        this.graphicPanel = new M24PanoramaGraphicPanel(d);
        this.label = new PanoramaLabel();
        this.dataPanel = new M24PanoramaDataPanel(d);
        this.add(this.graphicPanel);
        this.add(this.label);
        this.add(this.dataPanel);
        this.prefs = M24Globals.getSettings();
        this.updateSetting("all");
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.pWidth = w;
        this.pHeight = h;
        String parts = this.prefs.getString("panorama_layout").toLowerCase();
        this.fHeight = this.pWidth / 40 * 2 / 3 + 1;
        this.fontNotes = new Font("Courier", 0, this.fHeight);
        int labelHeight = (int)((double)this.fHeight * 1.25);
        int graphicHeight = 0;
        int dataHeight = 0;
        if (parts.equals("data only")) {
            dataHeight = this.pHeight - labelHeight - 2;
            graphicHeight = 0;
            this.graphicPanel.setVisible(false);
            this.dataPanel.setVisible(true);
        } else if (parts.equals("graphic only")) {
            dataHeight = 0;
            graphicHeight = this.pHeight - labelHeight - 2;
            this.graphicPanel.setVisible(true);
            this.dataPanel.setVisible(false);
        } else {
            graphicHeight = Math.min(this.pWidth / 2, this.pHeight * 6 / 10 - 10);
            dataHeight = this.pHeight - graphicHeight - labelHeight;
            this.graphicPanel.setVisible(true);
            this.dataPanel.setVisible(true);
        }
        this.label.setSize(this.pWidth, labelHeight);
        if (this.graphicPanel.isVisible()) {
            this.graphicPanel.setSize(this.pWidth, graphicHeight);
        }
        if (this.dataPanel.isVisible()) {
            this.dataPanel.setSize(this.pWidth, dataHeight);
        }
        this.graphicPanel.setLocation(0, 0);
        this.label.setLocation(0, graphicHeight);
        this.dataPanel.setLocation(0, graphicHeight + labelHeight);
        this.revalidate();
    }

    public void setVisible(boolean b) {
        if (b) {
            String parts = this.prefs.getString("panorama_layout").toLowerCase();
            if (parts.equals("data only")) {
                this.graphicPanel.setVisible(false);
                this.dataPanel.setVisible(true);
            } else if (parts.equals("graphic only")) {
                this.graphicPanel.setVisible(true);
                this.dataPanel.setVisible(false);
            } else {
                this.graphicPanel.setVisible(true);
                this.dataPanel.setVisible(true);
            }
        } else {
            this.graphicPanel.setVisible(false);
            this.dataPanel.setVisible(false);
        }
        super.setVisible(b);
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void timeReset(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void formatChanged(M24TimekeeperEvent e) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("panorama_layout");
        }
        if (pname.equals("panorama_layout")) {
            this.setSize(this.getSize());
            if (this.isVisible()) {
                this.repaint();
            }
        }
    }

    class PanoramaLabel
    extends JComponent {
        PanoramaLabel() {
            this.setBackground(Color.black);
            this.setOpaque(true);
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.green);
            g.setFont(M24PanoramaPanel.this.fontNotes);
            FontMetrics fm = g.getFontMetrics();
            String description = "Local Panorama as Seen from " + M24Globals.FORMAT_X2.format(M24PanoramaPanel.this.timekeeper.getSiteLongitude()) + "\u00b0W " + M24Globals.FORMAT_X2.format(M24PanoramaPanel.this.timekeeper.getSiteLatitude()) + "\u00b0N";
            g.drawString(description, (this.getSize().width - fm.stringWidth(description)) / 2, M24PanoramaPanel.this.fHeight);
        }
    }
}

