/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.NatCubic;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MarsTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JComponent;

public class M24PanoramaGraphicPanel
extends JComponent
implements PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 15000L;
    private static final int HIDE_POSITION = 1;
    private static final int SHOW_POSITION_ONLY = 2;
    private static final int SHOW_PLAIN_PATH = 3;
    private static final int SHOW_TICK_PATH = 4;
    private static final BasicStroke PATH_STROKE = new BasicStroke(1.25f);
    private static final BasicStroke SOLID_STROKE = new BasicStroke(1.0f);
    private static final float[] DASH_PATTERN = new float[]{12.0f, 8.0f, 8.0f, 8.0f};
    private static final BasicStroke BROKEN_STROKE = new BasicStroke(1.0f, 0, 1, 0.0f, DASH_PATTERN, 4.0f);
    private static final long MARS_HOUR = 3698968L;
    private static final long HALF_SOL = 44387616L;
    private static final long MAJOR_INTERVAL = 3698968L;
    private static final long MINOR_INTERVAL = 1232989L;
    private static final long TINY_INTERVAL = 246597L;
    private static final Color GRID_COLOR_1 = Color.white;
    private static final Color GRID_COLOR_2 = new Color(255, 255, 255, 102);
    private static final Color LABEL_COLOR = new Color(204, 255, 204, 204);
    private static final Color BORDER_COLOR = Color.gray;
    private static final Color NIGHTSKY_COLOR = Color.black;
    private static final Color DAYSKY_COLOR = new Color(238, 170, 136);
    private static final Color GROUND_COLOR = new Color(153, 51, 0);
    private static final Color SUN_COLOR = Color.yellow;
    private static final Color SOLARPATH_COLOR = Color.white;
    private static final Color EARTH_COLOR = Color.blue;
    private static final Color EARTHPATH_COLOR = new Color(153, 153, 255);
    private static final Font PLAIN12 = new Font("Courier", 0, 12);
    private static final Font PLAIN16 = new Font("Courier", 0, 16);
    private static final String MERA_FNAME = "resources/panoramas/mera_sol0000.png";
    private static final String MERB_FNAME = "resources/panoramas/merb_sol0000.png";
    private M24Timekeeper timekeeper;
    private M24Preferences prefs;
    private int showSunHow = 4;
    private int showEarthHow = 4;
    private int centerAzimuth = 0;
    private long lastUpdate;
    private int useWidth;
    private int useHeight;
    private int xMargin;
    private int yMargin;
    private double pixPerDeg;
    private int pix90;
    private int pix180;
    private int pix270;
    private int pix360;
    private MarsTime txTime = new MarsTime();
    private Image meraImage = null;
    private Image merbImage = null;
    private Image panorama = null;
    private static boolean showMERA = false;
    private static boolean showMERB = false;
    private Font fontNotes;
    private long now = System.currentTimeMillis();

    public M24PanoramaGraphicPanel(Dimension max) {
        this.timekeeper = M24Globals.getTimekeeper();
        this.prefs = M24Globals.getSettings();
        this.setOpaque(true);
        this.setMaximumSize(max);
        this.setBackground(Color.black);
        this.setDoubleBuffered(true);
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
        this.updateSetting("all");
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        int fheight = Math.max(18, h / 20) - 4;
        this.fontNotes = new Font("Courier", 0, fheight);
        this.useWidth = w;
        this.useHeight = h;
        if (this.useWidth < this.useHeight * 2) {
            this.useHeight = this.useWidth / 2;
        }
        if (this.useWidth > this.useHeight * 2) {
            this.useWidth = this.useHeight * 2;
        }
        this.xMargin = (w - this.useWidth) / 2;
        this.yMargin = 0;
        this.pixPerDeg = (double)this.useWidth / 360.0;
        this.pix90 = (int)(this.pixPerDeg * 90.0);
        this.pix180 = (int)(this.pixPerDeg * 180.0);
        this.pix270 = (int)(this.pixPerDeg * 270.0);
        this.pix360 = this.useWidth;
    }

    public void paintComponent(Graphics g) {
        long interval;
        double lastaziPixel;
        Vector<Point2D.Double> current;
        Vector collect;
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int pWidth = this.getSize().width;
        int pHeight = this.getSize().height;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, pWidth, pHeight);
        g2d.setStroke(SOLID_STROKE);
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        double lon = this.timekeeper.getSiteLongitude();
        double lat = this.timekeeper.getSiteLatitude();
        long millis = this.timekeeper.getMillis();
        double zenith = mTime.getSolarZenithAngle(lon, lat);
        double azimuth = mTime.getSolarAzimuthAngle(lon, lat);
        g2d.setColor(GROUND_COLOR);
        g2d.fillRect(this.xMargin, this.yMargin, this.useWidth, this.useHeight);
        if (zenith < 90.0) {
            g2d.setColor(DAYSKY_COLOR);
        } else if (zenith > 91.0) {
            g2d.setColor(NIGHTSKY_COLOR);
        } else {
            double howdark = 91.0 - zenith;
            g2d.setColor(new Color((int)((double)DAYSKY_COLOR.getRed() * howdark), (int)((double)DAYSKY_COLOR.getGreen() * howdark), (int)((double)DAYSKY_COLOR.getBlue() * howdark)));
        }
        g2d.fillRect(this.xMargin, this.yMargin, this.useWidth, this.pix90);
        this.panorama = null;
        if (showMERA) {
            if (this.meraImage == null) {
                try {
                    this.meraImage = M24Globals.loadImage(this.getClass().getResourceAsStream(MERA_FNAME));
                }
                catch (Exception exc) {
                    System.out.println("Couldn't find MER-A image.");
                    exc.printStackTrace();
                }
            }
            this.panorama = this.meraImage;
        } else if (showMERB) {
            if (this.merbImage == null) {
                try {
                    this.merbImage = M24Globals.loadImage(this.getClass().getResourceAsStream(MERB_FNAME));
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            this.panorama = this.merbImage;
        } else {
            this.panorama = null;
        }
        if (this.panorama != null) {
            int srcWidth = this.panorama.getWidth(this);
            int srcHeight = this.panorama.getHeight(this);
            int shiftSrc = 0;
            int shiftDst = 0;
            if (this.centerAzimuth == 0) {
                shiftSrc = srcWidth / 2;
                shiftDst = this.useWidth / 2;
            } else if (this.centerAzimuth == 90) {
                shiftSrc = srcWidth / 4;
                shiftDst = this.useWidth / 4;
            } else if (this.centerAzimuth != 180 && this.centerAzimuth == 270) {
                shiftSrc = 3 * srcWidth / 4;
                shiftDst = 3 * this.useWidth / 4;
            }
            if (shiftDst != 0) {
                g2d.drawImage(this.panorama, this.xMargin, this.yMargin, this.xMargin + shiftDst, this.yMargin + this.useHeight, srcWidth - shiftSrc, 0, srcWidth, srcHeight, this);
                g2d.drawImage(this.panorama, this.xMargin + shiftDst, this.yMargin, pWidth - this.xMargin, this.yMargin + this.useHeight, 0, 0, srcWidth - shiftSrc, srcHeight, this);
            } else {
                g2d.drawImage(this.panorama, this.xMargin, this.yMargin, this.xMargin + this.useWidth, this.yMargin + this.useHeight, 0, 0, srcWidth, srcHeight, this);
            }
        }
        if (this.panorama == null) {
            g2d.setColor(GRID_COLOR_1);
        } else {
            g2d.setColor(GRID_COLOR_2);
        }
        for (int j = 0; j < 180; j += 45) {
            if (j == 0) continue;
            if (j % 90 == 0) {
                g2d.setStroke(SOLID_STROKE);
            } else {
                g2d.setStroke(BROKEN_STROKE);
            }
            int y = (int)((double)j * this.pixPerDeg);
            g2d.drawLine(this.xMargin, this.yMargin + y, this.xMargin + this.useWidth - 1, this.yMargin + y);
        }
        for (int i = 0; i < 360; i += 45) {
            if (i == 0) continue;
            if (i % 90 == 0) {
                g2d.setStroke(SOLID_STROKE);
            } else {
                g2d.setStroke(BROKEN_STROKE);
            }
            int x = (int)((double)i * this.pixPerDeg);
            g2d.drawLine(this.xMargin + x, this.yMargin, this.xMargin + x, this.yMargin + this.useHeight - 1);
        }
        g2d.setColor(LABEL_COLOR);
        g2d.setFont(PLAIN16);
        if (this.centerAzimuth == 0) {
            g2d.drawString("S", this.xMargin + 2, this.yMargin + 36);
            g2d.drawString("W", this.xMargin + this.pix90 + 2, this.yMargin + 36);
            g2d.drawString("N", this.xMargin + this.pix180 + 2, this.yMargin + 36);
            g2d.drawString("E", this.xMargin + this.pix270 + 2, this.yMargin + 36);
        } else if (this.centerAzimuth == 90) {
            g2d.drawString("W", this.xMargin + 2, this.yMargin + 36);
            g2d.drawString("N", this.xMargin + this.pix90 + 2, this.yMargin + 36);
            g2d.drawString("E", this.xMargin + this.pix180 + 2, this.yMargin + 36);
            g2d.drawString("S", this.xMargin + this.pix270 + 2, this.yMargin + 36);
        } else if (this.centerAzimuth == 180) {
            g2d.drawString("N", this.xMargin + 2, this.yMargin + 36);
            g2d.drawString("E", this.xMargin + this.pix90 + 2, this.yMargin + 36);
            g2d.drawString("S", this.xMargin + this.pix180 + 2, this.yMargin + 36);
            g2d.drawString("W", this.xMargin + this.pix270 + 2, this.yMargin + 36);
        } else if (this.centerAzimuth == 270) {
            g2d.drawString("E", this.xMargin + 2, this.yMargin + 36);
            g2d.drawString("S", this.xMargin + this.pix90 + 2, this.yMargin + 36);
            g2d.drawString("W", this.xMargin + this.pix180 + 2, this.yMargin + 36);
            g2d.drawString("N", this.xMargin + this.pix270 + 2, this.yMargin + 36);
        }
        if (this.showSunHow == 3 || this.showSunHow == 4) {
            collect = new Vector(12);
            current = new Vector<Point2D.Double>(100);
            lastaziPixel = this.pix180;
            interval = 1232989L;
            boolean pathComplete = false;
            for (long k = -44387616L; k < 48086584L; k += interval) {
                if (k > 44387616L) {
                    k = 44387616L;
                    pathComplete = true;
                }
                this.txTime.setTime(millis + k);
                double aziPixel = this.getAzimuthPixel(this.txTime.getSolarAzimuthAngle(lon, lat));
                double zenPixel = this.txTime.getSolarZenithAngle(lon, lat) * this.pixPerDeg;
                if (Math.abs(aziPixel - lastaziPixel) > (double)this.pix180) {
                    collect.add(current);
                    current = new Vector(100);
                    current.add(new Point2D.Double((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel));
                } else if (zenPixel < 2.0 || zenPixel > (double)(this.useHeight - 2)) {
                    collect.add(current);
                    current = new Vector(100);
                } else {
                    current.add(new Point2D.Double((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel));
                }
                if (pathComplete) break;
                lastaziPixel = aziPixel;
                interval = aziPixel < 40.0 || aziPixel > (double)(this.useWidth - 40) || zenPixel < 20.0 || zenPixel > (double)(this.useHeight - 20) ? 246597L : 1232989L;
            }
            collect.add(current);
            g2d.setStroke(PATH_STROKE);
            g2d.setColor(SOLARPATH_COLOR);
            for (int i = collect.size() - 1; i >= 0; --i) {
                Vector v = (Vector)collect.get(i);
                if (v.size() < 2) continue;
                Point2D.Double first = (Point2D.Double)v.firstElement();
                Point2D.Double last = (Point2D.Double)v.lastElement();
                Bezier curves = new Bezier(false, v);
                curves.paint(g2d);
            }
        }
        if (this.showEarthHow == 3 || this.showEarthHow == 4) {
            collect = new Vector(12);
            current = new Vector(100);
            NatCubic earthPath = new NatCubic();
            lastaziPixel = this.pix180;
            interval = 1232989L;
            boolean pathComplete = false;
            for (long k = -44387616L; k < 48086584L; k += interval) {
                if (k > 44387616L) {
                    k = 44387616L;
                    pathComplete = true;
                }
                this.txTime.setTime(millis + k);
                Point2D.Double eAngle = this.txTime.getEarthAngleAt(lon, lat);
                double aziPixel = this.getAzimuthPixel(eAngle.getX());
                double zenPixel = eAngle.getY() * this.pixPerDeg;
                if (Math.abs(aziPixel - lastaziPixel) > (double)this.pix180) {
                    collect.add(current);
                    current = new Vector(100);
                    current.add(new Point2D.Double((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel));
                } else if (zenPixel < 2.0 || zenPixel > (double)(this.useHeight - 2)) {
                    collect.add(current);
                    current = new Vector(100);
                } else {
                    current.add(new Point2D.Double((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel));
                }
                if (pathComplete) break;
                lastaziPixel = aziPixel;
                interval = aziPixel < 40.0 || aziPixel > (double)(this.useWidth - 40) || zenPixel < 20.0 || zenPixel > (double)(this.useHeight - 20) ? 246597L : 1232989L;
            }
            collect.add(current);
            g2d.setStroke(PATH_STROKE);
            g2d.setColor(EARTHPATH_COLOR);
            for (int i = collect.size() - 1; i >= 0; --i) {
                Vector v = (Vector)collect.get(i);
                if (v.size() < 2) continue;
                Point2D.Double first = (Point2D.Double)v.firstElement();
                Point2D.Double last = (Point2D.Double)v.lastElement();
                Bezier curves = new Bezier(false, v);
                curves.paint(g2d);
            }
        }
        if (this.showSunHow == 4 || this.showEarthHow == 4) {
            for (long k = -12L; k < 12L; ++k) {
                this.txTime.setTime(millis + k * 3698968L);
                if (this.showSunHow == 4) {
                    double aziPixel = this.getAzimuthPixel(this.txTime.getSolarAzimuthAngle(lon, lat));
                    double zenPixel = this.txTime.getSolarZenithAngle(lon, lat) * this.pixPerDeg;
                    g2d.setColor(SOLARPATH_COLOR);
                    g2d.drawOval((int)((double)this.xMargin + aziPixel - 2.0), (int)((double)this.yMargin + zenPixel - 2.0), 4, 4);
                }
                if (this.showEarthHow != 4) continue;
                Point2D.Double eAngle = this.txTime.getEarthAngleAt(lon, lat);
                double zenPixel = eAngle.getY() * this.pixPerDeg;
                double aziPixel = this.getAzimuthPixel(eAngle.getX());
                g2d.setColor(EARTHPATH_COLOR);
                g2d.drawOval((int)((double)this.xMargin + aziPixel - 2.0), (int)((double)this.yMargin + zenPixel - 2.0), 4, 4);
            }
        }
        this.txTime.setTime(millis);
        if (this.showSunHow != 1) {
            double aziPixel = this.getAzimuthPixel(this.txTime.getSolarAzimuthAngle(lon, lat));
            double zenPixel = this.txTime.getSolarZenithAngle(lon, lat) * this.pixPerDeg;
            g2d.translate((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel);
            int radius = 4;
            g2d.setColor(SOLARPATH_COLOR);
            g2d.fillOval(-radius, -radius, radius * 2, radius * 2);
            g2d.setColor(SUN_COLOR);
            g2d.fillOval(-(--radius), -radius, radius * 2, radius * 2);
            g2d.translate(-((double)this.xMargin + aziPixel), -((double)this.yMargin + zenPixel));
        }
        if (this.showEarthHow != 1) {
            Point2D.Double eAngle = this.txTime.getEarthAngleAt(lon, lat);
            double zenPixel = eAngle.getY() * this.pixPerDeg;
            double aziPixel = this.getAzimuthPixel(eAngle.getX());
            g2d.translate((double)this.xMargin + aziPixel, (double)this.yMargin + zenPixel);
            int radius = 3;
            g2d.setColor(EARTHPATH_COLOR);
            g2d.fillOval(-radius, -radius, radius * 2, radius * 2);
            g2d.setColor(EARTH_COLOR);
            g2d.fillOval(-(--radius), -radius, radius * 2, radius * 2);
            g2d.translate(-((double)this.xMargin + aziPixel), -((double)this.yMargin + zenPixel));
        }
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(this.xMargin, this.yMargin, this.useWidth - 1, this.yMargin + this.useHeight - 1);
        this.lastUpdate = this.now;
    }

    private double getAzimuthPixel(double azim) {
        double pixel = azim;
        if (this.centerAzimuth == 0) {
            pixel += 180.0;
        } else if (this.centerAzimuth == 90) {
            pixel += 90.0;
        } else if (this.centerAzimuth == 180) {
            pixel += 0.0;
        } else if (this.centerAzimuth == 270) {
            pixel += 270.0;
        }
        while (pixel >= 360.0) {
            pixel -= 360.0;
        }
        while (pixel < 0.0) {
            pixel += 360.0;
        }
        return pixel * this.pixPerDeg;
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.now = System.currentTimeMillis();
        if (this.now - this.lastUpdate < 15000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = this.now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void formatChanged(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("marsTime_method");
            this.updateSetting("panorama_azimuth");
            this.updateSetting("panorama_markSun");
            this.updateSetting("panorama_markEarth");
        }
        if (pname.indexOf("panorama_") == -1 && pname.indexOf("marsTime_") == -1) {
            return;
        }
        if (pname.equals("panorama_azimuth")) {
            String look = this.prefs.getString("panorama_azimuth").toLowerCase();
            this.centerAzimuth = look.indexOf("north") > -1 ? 0 : (look.indexOf("east") > -1 ? 90 : (look.indexOf("south") > -1 ? 180 : (look.indexOf("west") > -1 ? 270 : 180)));
        } else if (pname.equals("panorama_markSun")) {
            String how = this.prefs.getString("panorama_markSun").toLowerCase();
            this.showSunHow = how.indexOf("tick") > -1 ? 4 : (how.indexOf("path") > -1 ? 3 : 2);
        } else if (pname.equals("panorama_markEarth")) {
            String how = this.prefs.getString("panorama_markEarth").toLowerCase();
            this.showEarthHow = how.indexOf("tick") > -1 ? 4 : (how.indexOf("path") > -1 ? 3 : (how.indexOf("hide") > -1 ? 1 : 2));
        } else if (pname.indexOf("marsTime_") > -1) {
            String s = this.landerSiteID();
            if (s == null) {
                showMERA = false;
                showMERB = false;
            } else if (s.equals("MERA")) {
                showMERA = true;
                showMERB = false;
            } else if (s.equals("MERB")) {
                showMERA = false;
                showMERB = true;
            } else {
                showMERA = false;
                showMERB = false;
            }
        }
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private String landerSiteID() {
        if (this.prefs.getString("marsTime_method").toLowerCase().equals("mera") || this.prefs.getString("marsTime_method").toLowerCase().equals("mera_merb") || this.prefs.getString("marsTime_method").toLowerCase().equals("local") && this.prefs.getString("marsTime_spotType").toLowerCase().indexOf("landmark") > -1 && this.prefs.getString("marsTime_spotLandmark").toLowerCase().indexOf("mer-a") > -1) {
            return "MERA";
        }
        if (this.prefs.getString("marsTime_method").toLowerCase().equals("merb") || this.prefs.getString("marsTime_method").toLowerCase().equals("local") && this.prefs.getString("marsTime_spotType").toLowerCase().indexOf("landmark") > -1 && this.prefs.getString("marsTime_spotLandmark").toLowerCase().indexOf("mer-b") > -1) {
            return "MERB";
        }
        return null;
    }
}

