/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.border.LineBorder2;
import gov.nasa.giss.gui.table.JTableKeystrokeAdapter;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.MissionTime;
import gov.nasa.giss.time.TimeConstants;
import gov.nasa.giss.time.TimeFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class M24PanoramaDataPanel
extends JPanel
implements TimeConstants,
PreferencesListener,
M24TimekeeperListener {
    private static final boolean DEBUG_SECS = false;
    private static final boolean DEBUG_ITER = false;
    private static final long REFRESH_INTERVAL = 5000L;
    private static final int HIDE_DATA = 0;
    private static final int SHOW_SUN = 1;
    private static final int SHOW_EARTH = 2;
    private static final long HALF_SOL_MILLIS = 44387622L;
    private static final long MARS_HOUR_MILLIS = 3698968L;
    private static final long MARS_DEG_MILLIS = 246597L;
    private static final double EPSILON_HOURS = 5.0E-7;
    private static final double EPSILON_DEGREES = 1.0E-4;
    private static final LineBorder2 CELL_BORDER = new LineBorder2(Color.black, 6, 0, 6, 0);
    private static final int PANEL_BORDER_WIDTH = 4;
    private static final long LONG_AGO = -7884000000000L;
    private int maxWidth;
    private int maxHeight;
    private int pWidth;
    private int pHeight;
    private int fontSize = 12;
    private Font tableFont;
    private MarsTime tmTime = new MarsTime();
    private EarthTime teTime = new EarthTime();
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private boolean showDateAsDOY = false;
    private static PrintfFormat formatAngle;
    private static double roundoff;
    private long nextSolarNadir = -7884000000000L;
    private long nextEarthNadir = -7884000000000L;
    private JScrollPane scrollpane;
    private JTable table;
    private DefaultTableModel tableModel;
    private String[][] tableData = new String[][]{{"Sun", "Current", null, null, null, null, null}, {"Sun", "Midnight", null, null, null, null, null}, {"Sun", "Rise", null, null, null, null, null}, {"Sun", "Noon", null, null, null, null, null}, {"Sun", "Set", null, null, null, null, null}, {"Sun", "Midnight", null, null, null, null, null}, {"Earth", "Current", null, null, null, null, null}, {"Earth", "Nadir", null, null, null, null, null}, {"Earth", "Rise", null, null, null, null, null}, {"Earth", "Zenith", null, null, null, null, null}, {"Earth", "Set", null, null, null, null, null}, {"Earth", "Nadir", null, null, null, null, null}};
    private long lastUpdate;
    static /* synthetic */ Class class$java$lang$String;

    public M24PanoramaDataPanel(Dimension max) {
        this.timekeeper = M24Globals.getTimekeeper();
        this.prefs = M24Globals.getSettings();
        this.maxWidth = max.width;
        this.maxHeight = max.height;
        this.setBorder(null);
        this.setMaximumSize(max);
        this.setDoubleBuffered(true);
        this.setBackground(Color.black);
        formatAngle = new PrintfFormat("%5.1f\u00b0");
        roundoff = 0.05;
        this.updateSetting("all");
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
        this.tableData[0][2] = "XXXXX 01:01 ";
        this.tableData[0][3] = "2000-01-01 01:01 UTC ";
        this.tableData[0][4] = formatAngle.sprintf(358.99);
        this.tableData[0][5] = formatAngle.sprintf(-88.99);
        this.tableData[0][6] = "00";
        this.tableModel = new DefaultTableModel(){

            public int getColumnCount() {
                return 6;
            }

            public int getRowCount() {
                return 12;
            }

            public Class getColumnClass(int col) {
                return class$java$lang$String == null ? (class$java$lang$String = M24PanoramaDataPanel.class$("java.lang.String")) : class$java$lang$String;
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Object";
                    }
                    case 1: {
                        return "Event";
                    }
                    case 2: {
                        return "Local Time";
                    }
                    case 3: {
                        return "Earth Time";
                    }
                    case 4: {
                        return "Azim.";
                    }
                    case 5: {
                        return "Elev.";
                    }
                    case 6: {
                        return "Iter";
                    }
                }
                return "";
            }

            public Object getValueAt(int row, int col) {
                if (M24PanoramaDataPanel.this.tableData[row][col] != null) {
                    return M24PanoramaDataPanel.this.tableData[row][col];
                }
                return "";
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public void setValueAt(Object value, int row, int col) {
            }
        };
        this.table = new JTable(this.tableModel);
        DataCellRenderer leftRenderer = new DataCellRenderer(2);
        DataCellRenderer centerRenderer = new DataCellRenderer(0);
        DataCellRenderer rightRenderer = new DataCellRenderer(4);
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(0).setCellRenderer(leftRenderer);
        tcm.getColumn(1).setCellRenderer(leftRenderer);
        tcm.getColumn(2).setCellRenderer(centerRenderer);
        tcm.getColumn(3).setCellRenderer(centerRenderer);
        tcm.getColumn(4).setCellRenderer(rightRenderer);
        tcm.getColumn(5).setCellRenderer(rightRenderer);
        this.table.setAutoResizeMode(2);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.black);
        if (M24Globals.isApplicationContext()) {
            JTableKeystrokeAdapter tkeyAdapter = new JTableKeystrokeAdapter(this.table);
        }
        JTableHeader jth = this.table.getTableHeader();
        jth.setReorderingAllowed(false);
        jth.setBackground(Color.black);
        jth.setDefaultRenderer(new DataHeaderRenderer());
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setBackground(Color.black);
        this.scrollpane.setBorder(new LineBorder(Color.black, 4));
        this.scrollpane.setVerticalScrollBarPolicy(20);
        this.scrollpane.setHorizontalScrollBarPolicy(30);
        this.scrollpane.getViewport().setBackground(Color.black);
        this.scrollpane.setViewportBorder(new LineBorder(Color.black, 1));
        this.add(this.scrollpane);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.pWidth = w;
        this.pHeight = h;
        int lHeight = Math.max(8, (this.pHeight - 8) / 7);
        this.fontSize = lHeight - 3;
        int maxChars = 67;
        if (this.fontSize * maxChars * 2 / 3 > this.pWidth) {
            this.fontSize = this.pWidth * 3 / (2 * maxChars);
            lHeight = this.fontSize + 3;
        }
        this.tableFont = new Font("Courier", 0, this.fontSize);
        this.table.setRowHeight(lHeight);
        TableColumnModel tcm = this.table.getColumnModel();
        JTableHeader jth = this.table.getTableHeader();
        int tWidth = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn col = tcm.getColumn(i);
            int width = 0;
            TableCellRenderer tcr = col.getHeaderRenderer();
            if (tcr == null) {
                tcr = jth.getDefaultRenderer();
            }
            Component c = tcr.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = c.getPreferredSize().width;
            for (int r = 0; r < this.table.getRowCount(); ++r) {
                tcr = this.table.getCellRenderer(r, i);
                c = tcr.getTableCellRendererComponent(this.table, this.table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            col.setMinWidth(width + 6);
            col.setPreferredWidth(width + 16);
            tWidth += width + 16;
        }
        int spwidth = Math.min(this.pWidth - 8, tWidth += 20);
        int spheight = Math.min(this.pHeight - 8, this.scrollpane.getPreferredSize().height);
        this.scrollpane.setMaximumSize(new Dimension(this.pWidth - 8, this.pHeight - 8));
        this.scrollpane.setPreferredSize(new Dimension(spwidth, this.pHeight - 8));
        this.revalidate();
    }

    public void paintChildren(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        this.updateSolarData();
        this.updateEarthData();
        this.tableModel.fireTableDataChanged();
        super.paintChildren(g);
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
    }

    public void updateSolarData() {
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        double lon = this.timekeeper.getSiteLongitude();
        double lat = this.timekeeper.getSiteLatitude();
        long millis = this.timekeeper.getMillis();
        double r = mTime.getDistanceToSun(3);
        double solarRadiusDeg = Math.asin(0.004652472637378737 / r) * 57.29577951308232;
        this.tmTime.setTime(millis + 1L);
        this.teTime.setTime(millis + 1L);
        this.tableData[0][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[0][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[0][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
        this.tableData[0][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
        this.tableData[0][6] = "-";
        if (millis < this.nextSolarNadir) {
            return;
        }
        long highMillis = 0L;
        long nadir1Millis = 0L;
        long nadir2Millis = 0L;
        long setMillis = 0L;
        long riseMillis = 0L;
        int highIter = 0;
        highMillis = millis;
        while (highIter < 25) {
            double dHours;
            ++highIter;
            this.tmTime.setTime(highMillis);
            for (dHours = 12.0 - this.tmTime.getTimeHours(lon, 2); dHours > 12.0; dHours -= 24.0) {
            }
            while (dHours <= -12.0) {
                dHours += 24.0;
            }
            if (Math.abs(dHours) < 5.0E-7) break;
            highMillis += (long)(3698968.0 * dHours);
        }
        double highElevation = 90.0 - this.tmTime.getSolarZenithAngle(lon, lat);
        this.teTime.setTime(highMillis + 1L);
        this.tmTime.setTime(highMillis + 1L);
        this.tableData[3][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[3][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[3][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
        this.tableData[3][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
        this.tableData[3][6] = "" + highIter;
        int nadir1Iter = 0;
        nadir1Millis = highMillis - 44387622L;
        while (nadir1Iter < 25) {
            this.tmTime.setTime(nadir1Millis);
            double dHours = -this.tmTime.getTimeHours(lon, 2);
            if (dHours < -12.0) {
                dHours += 24.0;
            }
            if (Math.abs(dHours) < 5.0E-7) break;
            ++nadir1Iter;
            nadir1Millis += (long)(3698968.0 * dHours);
        }
        double nadir1Elevation = 90.0 - this.tmTime.getSolarZenithAngle(lon, lat);
        this.teTime.setTime(nadir1Millis + 1L);
        this.tmTime.setTime(nadir1Millis + 1L);
        this.tableData[1][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[1][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[1][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
        this.tableData[1][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
        this.tableData[1][6] = "" + nadir1Iter;
        int nadir2Iter = 0;
        nadir2Millis = highMillis + 44387622L;
        while (nadir2Iter < 25) {
            this.tmTime.setTime(nadir2Millis);
            double dHours = -this.tmTime.getTimeHours(lon, 2);
            if (dHours < -12.0) {
                dHours += 24.0;
            }
            if (Math.abs(dHours) < 5.0E-7) break;
            ++nadir2Iter;
            nadir2Millis += (long)(3698968.0 * dHours);
        }
        double nadir2Elevation = 90.0 - this.tmTime.getSolarZenithAngle(lon, lat);
        this.nextSolarNadir = nadir2Millis;
        this.teTime.setTime(nadir2Millis + 1L);
        this.tmTime.setTime(nadir2Millis + 1L);
        this.tableData[5][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[5][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[5][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
        this.tableData[5][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
        this.tableData[5][6] = "" + nadir2Iter;
        int setIter = 0;
        if (highElevation > -solarRadiusDeg && nadir2Elevation < -solarRadiusDeg) {
            double estDelta = Math.acos(-(highElevation + nadir2Elevation) / (highElevation - nadir2Elevation)) * 3.819718634205488;
            setMillis = highElevation < 2.0 ? highMillis + 1849484L : highMillis + (long)(estDelta * 3698968.0);
            double prevDeltaDeg = 0.0;
            double prevDeltaMil = 0.0;
            while (setIter < 25) {
                this.tmTime.setTime(setMillis);
                double setZenith = this.tmTime.getSolarZenithAngle(lon, lat);
                double deltaDeg = 90.0 + solarRadiusDeg - setZenith;
                if (Math.abs(deltaDeg) < 1.0E-4) break;
                if (++setIter < 2) {
                    double deltaMil = (long)(deltaDeg * 3698968.0 / 10.0);
                    setMillis = (long)((double)setMillis + deltaMil);
                    prevDeltaDeg = deltaDeg;
                    prevDeltaMil = deltaMil;
                    continue;
                }
                double frac = deltaDeg / prevDeltaDeg;
                double invFrac = 1.0 / frac;
                double deltaMil = (long)(prevDeltaMil / (invFrac - 1.0));
                deltaMil = Math.min(deltaMil, 3698968.0);
                if ((double)setMillis + (deltaMil = Math.max(deltaMil, -3698968.0)) > (double)nadir2Millis) {
                    deltaMil = nadir2Millis - setMillis - 1000L;
                }
                setMillis = (long)((double)setMillis + deltaMil);
                prevDeltaDeg = deltaDeg;
                prevDeltaMil = deltaMil;
            }
            this.teTime.setTime(setMillis + 1L);
            this.tmTime.setTime(setMillis + 1L);
            this.tableData[4][2] = this.makeMarsTimeString(this.tmTime);
            this.tableData[4][3] = this.makeEarthTimeString(this.teTime);
            this.tableData[4][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
            this.tableData[4][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
            this.tableData[4][6] = "" + setIter;
        } else {
            this.tableData[4][2] = "N/A";
            this.tableData[4][3] = "N/A";
            this.tableData[4][4] = "N/A";
            this.tableData[4][5] = "N/A";
            this.tableData[4][6] = "-";
        }
        int riseIter = 0;
        double riseZenith = 0.0;
        if (highElevation > -solarRadiusDeg && nadir1Elevation < -solarRadiusDeg) {
            if ((double)setMillis != 0.0) {
                riseMillis = highMillis - (setMillis - highMillis);
            } else {
                double estDelta = Math.acos(-(highElevation + nadir1Elevation) / (highElevation - nadir1Elevation)) * 3.819718634205488;
                riseMillis = highElevation < 2.0 ? highMillis - 1849484L : highMillis - (long)(estDelta * 3698968.0);
            }
            double prevDeltaDeg = 0.0;
            double prevDeltaMil = 0.0;
            while (riseIter < 25) {
                this.tmTime.setTime(riseMillis);
                riseZenith = this.tmTime.getSolarZenithAngle(lon, lat);
                double deltaDeg = riseZenith - (90.0 + solarRadiusDeg);
                if (Math.abs(deltaDeg) < 1.0E-4) break;
                if (++riseIter < 2) {
                    double deltaMil = (long)(deltaDeg * 3698968.0 / 10.0);
                    riseMillis = (long)((double)riseMillis + deltaMil);
                    prevDeltaDeg = deltaDeg;
                    prevDeltaMil = deltaMil;
                    continue;
                }
                double frac = deltaDeg / prevDeltaDeg;
                double invFrac = 1.0 / frac;
                double deltaMil = (long)(prevDeltaMil / (invFrac - 1.0));
                deltaMil = Math.min(deltaMil, 3698968.0);
                if ((double)riseMillis + (deltaMil = Math.max(deltaMil, -3698968.0)) <= (double)nadir1Millis) {
                    deltaMil = nadir1Millis - riseMillis + 1000L;
                }
                riseMillis = (long)((double)riseMillis + deltaMil);
                prevDeltaDeg = deltaDeg;
                prevDeltaMil = deltaMil;
            }
            this.teTime.setTime(riseMillis + 1L);
            this.tmTime.setTime(riseMillis + 1L);
            this.tableData[2][2] = this.makeMarsTimeString(this.tmTime);
            this.tableData[2][3] = this.makeEarthTimeString(this.teTime);
            this.tableData[2][4] = this.formatAzimuth(this.tmTime.getSolarAzimuthAngle(lon, lat));
            this.tableData[2][5] = this.formatZenAsElev(this.tmTime.getSolarZenithAngle(lon, lat));
            this.tableData[2][6] = "" + riseIter;
        } else {
            this.tableData[2][2] = "N/A";
            this.tableData[2][3] = "N/A";
            this.tableData[2][4] = "N/A";
            this.tableData[2][5] = "N/A";
            this.tableData[2][6] = "-";
        }
    }

    public void updateEarthData() {
        Point2D.Double sep;
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        double lon = this.timekeeper.getSiteLongitude();
        double lat = this.timekeeper.getSiteLatitude();
        long millis = this.timekeeper.getMillis();
        this.teTime.setTime(millis + 1L);
        this.tmTime.setTime(millis + 1L);
        Point2D.Double ea = this.tmTime.getEarthAngleAt(lon, lat);
        this.tableData[6][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[6][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[6][4] = this.formatAzimuth(ea.getX());
        this.tableData[6][5] = this.formatZenAsElev(ea.getY());
        this.tableData[6][6] = "-";
        if (millis < this.nextEarthNadir) {
            return;
        }
        long highMillis = 0L;
        long nadir1Millis = 0L;
        long nadir2Millis = 0L;
        long setMillis = 0L;
        long riseMillis = 0L;
        int highIter = 0;
        highMillis = millis;
        while (highIter < 25) {
            double dDeg;
            ++highIter;
            this.tmTime.setTime(highMillis);
            sep = this.tmTime.getSubEarthPoint(1);
            for (dDeg = sep.getX() - lon; dDeg > 180.0; dDeg -= 360.0) {
            }
            while (dDeg <= -180.0) {
                dDeg += 360.0;
            }
            if (Math.abs(dDeg) < 1.0E-4) break;
            highMillis -= (long)(246597.0 * dDeg);
        }
        this.teTime.setTime(highMillis + 1L);
        this.tmTime.setTime(highMillis + 1L);
        ea = this.tmTime.getEarthAngleAt(lon, lat);
        double highElevation = 90.0 - ea.getY();
        this.tableData[9][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[9][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[9][4] = this.formatAzimuth(ea.getX());
        this.tableData[9][5] = this.formatZenAsElev(ea.getY());
        this.tableData[9][6] = "" + highIter;
        int nadir1Iter = 0;
        nadir1Millis = highMillis - 44387622L;
        while (nadir1Iter < 25) {
            double dDeg;
            ++nadir1Iter;
            this.tmTime.setTime(nadir1Millis);
            sep = this.tmTime.getSubEarthPoint(1);
            for (dDeg = sep.getX() + 180.0 - lon; dDeg > 180.0; dDeg -= 360.0) {
            }
            while (dDeg <= -180.0) {
                dDeg += 360.0;
            }
            if (Math.abs(dDeg) < 1.0E-4) break;
            nadir1Millis -= (long)(246597.0 * dDeg);
        }
        this.teTime.setTime(nadir1Millis + 1L);
        this.tmTime.setTime(nadir1Millis + 1L);
        ea = this.tmTime.getEarthAngleAt(lon, lat);
        double nadir1Elevation = 90.0 - ea.getY();
        this.tableData[7][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[7][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[7][4] = this.formatAzimuth(ea.getX());
        this.tableData[7][5] = this.formatZenAsElev(ea.getY());
        this.tableData[7][6] = "" + nadir1Iter;
        int nadir2Iter = 0;
        nadir2Millis = highMillis + 44387622L;
        while (nadir2Iter < 25) {
            double dDeg;
            ++nadir2Iter;
            this.tmTime.setTime(nadir2Millis);
            sep = this.tmTime.getSubEarthPoint(1);
            for (dDeg = sep.getX() + 180.0 - lon; dDeg > 180.0; dDeg -= 360.0) {
            }
            while (dDeg <= -180.0) {
                dDeg += 360.0;
            }
            if (Math.abs(dDeg) < 1.0E-4) break;
            nadir2Millis -= (long)(246597.0 * dDeg);
        }
        this.teTime.setTime(nadir2Millis + 1L);
        this.tmTime.setTime(nadir2Millis + 1L);
        ea = this.tmTime.getEarthAngleAt(lon, lat);
        double nadir2Elevation = 90.0 - ea.getY();
        this.tableData[11][2] = this.makeMarsTimeString(this.tmTime);
        this.tableData[11][3] = this.makeEarthTimeString(this.teTime);
        this.tableData[11][4] = this.formatAzimuth(ea.getX());
        this.tableData[11][5] = this.formatZenAsElev(ea.getY());
        this.tableData[11][6] = "" + nadir2Iter;
        if (highElevation > 0.0 && nadir2Elevation < 0.0) {
            double estDelta = Math.acos(-(highElevation + nadir2Elevation) / (highElevation - nadir2Elevation)) * 3.819718634205488;
            int setIter = 0;
            double setZenith = 0.0;
            setMillis = highElevation < 2.0 ? highMillis + 1849484L : highMillis + (long)(estDelta * 3698968.0);
            double prevDeltaDeg = 0.0;
            double prevDeltaMil = 0.0;
            while (setIter < 25) {
                this.tmTime.setTime(setMillis);
                setZenith = this.tmTime.getEarthAngleAt(lon, lat).getY();
                double deltaDeg = 90.0 - setZenith;
                if (Math.abs(deltaDeg) < 1.0E-4) break;
                if (++setIter < 2) {
                    double deltaMil = (long)(deltaDeg * 3698968.0 / 10.0);
                    setMillis = (long)((double)setMillis + deltaMil);
                    prevDeltaDeg = deltaDeg;
                    prevDeltaMil = deltaMil;
                    continue;
                }
                double frac = deltaDeg / prevDeltaDeg;
                double invFrac = 1.0 / frac;
                double deltaMil = (long)(prevDeltaMil / (invFrac - 1.0));
                deltaMil = Math.min(deltaMil, 3698968.0);
                if ((double)setMillis + (deltaMil = Math.max(deltaMil, -3698968.0)) > (double)nadir2Millis) {
                    deltaMil = nadir2Millis - setMillis - 1000L;
                }
                setMillis = (long)((double)setMillis + deltaMil);
                prevDeltaDeg = deltaDeg;
                prevDeltaMil = deltaMil;
            }
            this.teTime.setTime(setMillis + 1L);
            this.tmTime.setTime(setMillis + 1L);
            ea = this.tmTime.getEarthAngleAt(lon, lat);
            this.tableData[10][2] = this.makeMarsTimeString(this.tmTime);
            this.tableData[10][3] = this.makeEarthTimeString(this.teTime);
            this.tableData[10][4] = this.formatAzimuth(ea.getX());
            this.tableData[10][5] = this.formatZenAsElev(ea.getY());
            this.tableData[10][6] = "" + setIter;
        } else {
            this.tableData[10][2] = "N/A";
            this.tableData[10][3] = "N/A";
            this.tableData[10][4] = "N/A";
            this.tableData[10][5] = "N/A";
            this.tableData[10][6] = "-";
        }
        if (highElevation > 0.0 && nadir1Elevation < 0.0) {
            int riseIter = 0;
            if ((double)setMillis != 0.0) {
                riseMillis = highMillis - (setMillis - highMillis);
            } else {
                double estDelta = Math.acos(-(highElevation + nadir1Elevation) / (highElevation - nadir1Elevation)) * 3.819718634205488;
                riseMillis = highElevation < 2.0 ? highMillis - 1849484L : highMillis - (long)(estDelta * 3698968.0);
            }
            double prevDeltaDeg = 0.0;
            double prevDeltaMil = 0.0;
            while (riseIter < 25) {
                this.tmTime.setTime(riseMillis);
                double riseZenith = this.tmTime.getEarthAngleAt(lon, lat).getY();
                double deltaDeg = riseZenith - 90.0;
                if (Math.abs(deltaDeg) < 1.0E-4) break;
                if (++riseIter < 2) {
                    double deltaMil = (long)(deltaDeg * 3698968.0 / 10.0);
                    riseMillis = (long)((double)riseMillis + deltaMil);
                    prevDeltaDeg = deltaDeg;
                    prevDeltaMil = deltaMil;
                    continue;
                }
                double frac = deltaDeg / prevDeltaDeg;
                double invFrac = 1.0 / frac;
                double deltaMil = (long)(prevDeltaMil / (invFrac - 1.0));
                deltaMil = Math.min(deltaMil, 3698968.0);
                if ((double)riseMillis + (deltaMil = Math.max(deltaMil, -3698968.0)) <= (double)nadir1Millis) {
                    deltaMil = nadir1Millis - riseMillis + 1000L;
                }
                riseMillis = (long)((double)riseMillis + deltaMil);
                prevDeltaDeg = deltaDeg;
                prevDeltaMil = deltaMil;
            }
            this.teTime.setTime(riseMillis + 1L);
            this.tmTime.setTime(riseMillis + 1L);
            ea = this.tmTime.getEarthAngleAt(lon, lat);
            this.tableData[8][2] = this.makeMarsTimeString(this.tmTime);
            this.tableData[8][3] = this.makeEarthTimeString(this.teTime);
            this.tableData[8][4] = this.formatAzimuth(ea.getX());
            this.tableData[8][5] = this.formatZenAsElev(ea.getY());
            this.tableData[8][6] = "" + riseIter;
        } else {
            this.tableData[8][2] = "N/A";
            this.tableData[8][3] = "N/A";
            this.tableData[8][4] = "N/A";
            this.tableData[8][5] = "N/A";
            this.tableData[8][6] = "-";
        }
    }

    private String formatAzimuth(double azimuth) {
        if (azimuth + roundoff >= 360.0) {
            return formatAngle.sprintf(0.0);
        }
        return formatAngle.sprintf(azimuth);
    }

    private String formatZenAsElev(double zenithAngle) {
        return formatAngle.sprintf(90.0 - zenithAngle);
    }

    private String makeEarthTimeString(EarthTime t) {
        return t.getDateString(false, this.showDateAsDOY) + " " + t.getTimeStringMinutes(false);
    }

    private String makeMarsTimeString(MarsTime t) {
        StringBuffer sb = new StringBuffer("");
        switch (this.timekeeper.getMarsTimeFormat()) {
            case 10: {
                sb.append(t.getTimeStringMinutes(this.timekeeper.getSiteLongitude(), 2, true));
                break;
            }
            case 30: {
                sb.append(t.getTimeStringMinutes(this.timekeeper.getSiteLongitude(), 3, true));
                break;
            }
            case 105: 
            case 1001: {
                MissionTime mera = t.getMissionTime("MERA");
                sb.append(TimeFormat.format24Hours(24.0 * mera.getSolFraction(), 2, "MER-A", null));
                break;
            }
            case 106: {
                MissionTime merb = t.getMissionTime("MERB");
                sb.append(TimeFormat.format24Hours(24.0 * merb.getSolFraction(), 2, "MER-B", null));
                break;
            }
            default: {
                sb.append(t.getTimeStringMinutes(this.timekeeper.getSiteLongitude(), 1, true));
            }
        }
        return sb.toString();
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate < 5000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.nextSolarNadir = -7884000000000L;
        this.nextEarthNadir = -7884000000000L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
        this.nextSolarNadir = -7884000000000L;
        this.nextEarthNadir = -7884000000000L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void formatChanged(M24TimekeeperEvent e) {
        this.nextSolarNadir = -7884000000000L;
        this.nextEarthNadir = -7884000000000L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        if (pname == null || pname.equals("all")) {
            this.updateSetting("earthTime_dateAsDOY");
            this.updateSetting("plotFrame_content");
        }
        if (pname.equals("earthTime_dateAsDOY")) {
            try {
                this.showDateAsDOY = this.prefs.getBoolean("earthTime_dateAsDOY");
            }
            catch (Exception exc) {}
        } else if (pname.equals("plotFrame_content")) {
            String string = this.prefs.getString("plotFrame_content");
        }
        this.nextSolarNadir = -7884000000000L;
        this.nextEarthNadir = -7884000000000L;
    }

    static {
        roundoff = 0.005;
    }

    class DataHeaderRenderer
    extends DefaultTableCellRenderer {
        DataHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, 0, 0);
            this.setFont(M24PanoramaDataPanel.this.tableFont);
            this.setHorizontalAlignment(0);
            this.setBorder(CELL_BORDER);
            this.setForeground(Color.red);
            if (isSelected) {
                this.setBackground(Color.darkGray);
            } else {
                this.setBackground(Color.black);
            }
            return this;
        }
    }

    class DataCellRenderer
    extends DefaultTableCellRenderer {
        private int alignment;

        public DataCellRenderer(int a) {
            this.alignment = a;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, 0, 0);
            this.setFont(M24PanoramaDataPanel.this.tableFont);
            this.setHorizontalAlignment(this.alignment);
            this.setBorder(CELL_BORDER);
            this.setForeground(Color.green);
            if (isSelected) {
                this.setBackground(Color.darkGray);
            } else {
                this.setBackground(Color.black);
            }
            return this;
        }
    }
}

